'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var FeedbackList;
var FeedbackPage;
var FeedbackInstance;

/* jshint ignore:start */
/**
 * Initialize the FeedbackList
 *
 * @constructor Twilio.Api.V2010.AccountContext.MessageContext.FeedbackList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created the resource
 * @param {string} messageSid -
 *          The SID of the Message resource for which the feedback was provided
 */
/* jshint ignore:end */
FeedbackList = function FeedbackList(version, accountSid, messageSid) {
  /* jshint ignore:start */
  /**
   * @function feedback
   * @memberof Twilio.Api.V2010.AccountContext.MessageContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.MessageContext.FeedbackContext}
   */
  /* jshint ignore:end */
  function FeedbackListInstance(sid) {
    return FeedbackListInstance.get(sid);
  }

  FeedbackListInstance._version = version;
  // Path Solution
  FeedbackListInstance._solution = {accountSid: accountSid, messageSid: messageSid};
  FeedbackListInstance._uri = `/Accounts/${accountSid}/Messages/${messageSid}/Feedback.json`;
  /* jshint ignore:start */
  /**
   * create a FeedbackInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.MessageContext.FeedbackList#
   *
   * @param {object} [opts] - Options for request
   * @param {feedback.outcome} [opts.outcome] - Whether the feedback has arrived
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed FeedbackInstance
   */
  /* jshint ignore:end */
  FeedbackListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({'Outcome': _.get(opts, 'outcome')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FeedbackInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.MessageContext.FeedbackList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FeedbackListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FeedbackListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FeedbackListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FeedbackPage
 *
 * @constructor Twilio.Api.V2010.AccountContext.MessageContext.FeedbackPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FeedbackSolution} solution - Path solution
 *
 * @returns FeedbackPage
 */
/* jshint ignore:end */
FeedbackPage = function FeedbackPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FeedbackPage.prototype, Page.prototype);
FeedbackPage.prototype.constructor = FeedbackPage;

/* jshint ignore:start */
/**
 * Build an instance of FeedbackInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.MessageContext.FeedbackPage#
 *
 * @param {FeedbackPayload} payload - Payload response from the API
 *
 * @returns FeedbackInstance
 */
/* jshint ignore:end */
FeedbackPage.prototype.getInstance = function getInstance(payload) {
  return new FeedbackInstance(
    this._version,
    payload,
    this._solution.accountSid,
    this._solution.messageSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.MessageContext.FeedbackPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FeedbackPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FeedbackPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FeedbackContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.MessageContext.FeedbackInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} messageSid -
 *          The SID of the Message resource for which the feedback was provided
 * @property {feedback.outcome} outcome - Whether the feedback has arrived
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 *
 * @param {V2010} version - Version of the resource
 * @param {FeedbackPayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created the resource
 * @param {sid} messageSid -
 *          The SID of the Message resource for which the feedback was provided
 */
/* jshint ignore:end */
FeedbackInstance = function FeedbackInstance(version, payload, accountSid,
                                              messageSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.messageSid = payload.message_sid; // jshint ignore:line
  this.outcome = payload.outcome; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, messageSid: messageSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.MessageContext.FeedbackInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FeedbackInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FeedbackInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FeedbackList: FeedbackList,
  FeedbackPage: FeedbackPage,
  FeedbackInstance: FeedbackInstance
};
