### Contributing ###

Thank you for your interest in `strong-soap`, an open source project as part of LoopBack.

Contributing to `strong-soap` is easy. In a few simple steps:

  * Ensure that your effort is aligned with the project's roadmap by
    talking to the maintainers, especially if you are going to spend a
    lot of time on it.

  * Make something better or fix a bug.

  * Adhere to code style outlined in the [Google C++ Style Guide][] and
    [Google Javascript Style Guide][].

  * Sign the [Developer Certificate of Origin](#developer-certificate-of-origin)

  * Submit a pull request through Github.


### Developer Certificate of Origin

This project uses [DCO](https://developercertificate.org/). Be sure to sign off
your commits using the `-s` flag or adding `Signed-off-By: Name<Email>` in the
commit message.

**Example**

```
git commit -s -m "feat: my commit message"
```

[Google C++ Style Guide]: https://google.github.io/styleguide/cppguide.html
[Google Javascript Style Guide]: https://google.github.io/styleguide/javascriptguide.xml
