"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageBrokerModels = exports.MessageBrokerNames = exports.MessageBrokerConstants = exports.ServerToDeviceRPCMessageType = exports.DeviceToServerMessageTypes = exports.ServerToDeviceMessageType = void 0;
const dal_constants_1 = require("../dal/dal.constants");
exports.ServerToDeviceMessageType = dal_constants_1.DalConstants.ServerToDeviceMessageType;
exports.DeviceToServerMessageTypes = dal_constants_1.DalConstants.DeviceToServerMessageTypes;
exports.ServerToDeviceRPCMessageType = dal_constants_1.DalConstants.ServerToDeviceRPCMessageType;
var MessageBrokerConstants;
(function (MessageBrokerConstants) {
    MessageBrokerConstants.delayTime = {
        time: 5000,
    };
})(MessageBrokerConstants = exports.MessageBrokerConstants || (exports.MessageBrokerConstants = {}));
var MessageBrokerNames;
(function (MessageBrokerNames) {
    MessageBrokerNames.serverToPacs = {
        exchange: "pacslive",
        bindingKey: "#",
    };
    MessageBrokerNames.deviceToServer = {
        exchange: "server-to-device",
        queue: "device-to-server",
        queueWithDeadLetter: "device-to-server2",
    };
    MessageBrokerNames.serverToReport = {
        queue: "server-to-report",
        exchange: "server-to-report",
        reportBindingKey: "report.#",
        reportRoutingKey: "report",
    };
    MessageBrokerNames.deadLetter = {
        exchange: "dlx",
        emailQueue: "dlEmailQ",
        emailBindingKey: "email",
        deviceQueue: "dlDeviceQ",
        deviceBindingKey: "device",
        notificationQueue: "notificationQ",
        notificationBindingKey: "notification",
    };
    MessageBrokerNames.serverToServer = {
        delayedExchangeName: "scheduledexchange",
        scheduledQueue: "scheduledqueue",
        scheduledBindingKey: "schedule",
    };
    MessageBrokerNames.serverToTablet = {
        exchangeName: "server-to-tablet",
    };
    MessageBrokerNames.serverToPgMaintenance = {
        queue: "server-to-pgmaintenance-queue",
        exchange: "server-to-pgmaintenance-exchange",
        bindingKey: "partition",
    };
    MessageBrokerNames.event = {
        exchange: "amq.rabbitmq.event",
        queue: "event-queue",
    };
    MessageBrokerNames.serviceToNotification = {
        queue: "notification-queue",
        exchange: "notification-exchange",
        bindingKey: "notification",
    };
    MessageBrokerNames.notificationReAttempt = {
        exchange: "notification-delayed-exhange",
        queue: "notification-delayed-queue",
        bindingKey: "notification-delay",
    };
})(MessageBrokerNames = exports.MessageBrokerNames || (exports.MessageBrokerNames = {}));
var MessageBrokerModels;
(function (MessageBrokerModels) {
    let ServerToTabletMessageTypes;
    (function (ServerToTabletMessageTypes) {
        ServerToTabletMessageTypes[ServerToTabletMessageTypes["RequestApproval"] = 1] = "RequestApproval";
        ServerToTabletMessageTypes[ServerToTabletMessageTypes["ConfigChanged"] = 2] = "ConfigChanged";
        ServerToTabletMessageTypes[ServerToTabletMessageTypes["QrCodeRequired"] = 3] = "QrCodeRequired";
        ServerToTabletMessageTypes[ServerToTabletMessageTypes["EndVisitByQr"] = 4] = "EndVisitByQr";
    })(ServerToTabletMessageTypes = MessageBrokerModels.ServerToTabletMessageTypes || (MessageBrokerModels.ServerToTabletMessageTypes = {}));
    let TabletToServerMessageTypes;
    (function (TabletToServerMessageTypes) {
        TabletToServerMessageTypes[TabletToServerMessageTypes["Approved"] = 1] = "Approved";
        TabletToServerMessageTypes[TabletToServerMessageTypes["Rejected"] = 2] = "Rejected";
        TabletToServerMessageTypes[TabletToServerMessageTypes["ApprovalTimeout"] = 3] = "ApprovalTimeout";
        TabletToServerMessageTypes[TabletToServerMessageTypes["QrCodeData"] = 4] = "QrCodeData";
        TabletToServerMessageTypes[TabletToServerMessageTypes["QrCodeClosed"] = 5] = "QrCodeClosed";
        TabletToServerMessageTypes[TabletToServerMessageTypes["QrCodeTimeout"] = 6] = "QrCodeTimeout";
    })(TabletToServerMessageTypes = MessageBrokerModels.TabletToServerMessageTypes || (MessageBrokerModels.TabletToServerMessageTypes = {}));
})(MessageBrokerModels = exports.MessageBrokerModels || (exports.MessageBrokerModels = {}));
