"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.amqpServerToPgMaintenanceSub = exports.amqpServerToPGMaintenanceSubEventNames = void 0;
const app_logs_1 = require("../app.logs");
const messagebroker_models_1 = require("./messagebroker.models");
exports.amqpServerToPGMaintenanceSubEventNames = {
    backwardPartitioning: "backwardPartitioning",
};
class AmqpServerToPgMaintenanceSub {
    constructor() { }
    async init(connection, cb) {
        return new Promise((resolve, reject) => {
            this._connection = connection;
            this._channel = this._connection.createChannel({
                json: true,
                name: "server-to-pgmaintenance.sub",
                setup: async (channel) => {
                    app_logs_1.logger.debug("[server-to-pgmaintenance.sub] channel is establishing...");
                    await Promise.all([
                        channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.exchange, "topic", {
                            durable: true,
                        }),
                        channel.assertQueue(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.queue, {
                            durable: true,
                        }),
                        channel.prefetch(1),
                    ]);
                    await channel.bindQueue(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.queue, messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.exchange, messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.bindingKey);
                    await channel.consume(messagebroker_models_1.MessageBrokerNames.serverToPgMaintenance.queue, cb.bind(null, channel), { noAck: false });
                },
            });
            this._channel.on("error", (err) => app_logs_1.logger.error("[server-to-pgmaintenance.sub] error while creating channel: ", err));
            this._channel.on("connect", () => app_logs_1.logger.info("[server-to-pgmaintenance.sub] channel created"));
            this._channel.on("close", () => app_logs_1.logger.info("[server-to-pgmaintenance.sub] channel closed"));
            this._channel.once("connect", () => resolve());
        });
    }
}
exports.amqpServerToPgMaintenanceSub = new AmqpServerToPgMaintenanceSub();
