"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendToPacsRpcQueue = exports.initServerToPacsPubChannel = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
const messagebroker_models_1 = require("./messagebroker.models");
const uuid = __importStar(require("uuid"));
const _rpcCallbackRegistry = {};
let connection;
let channel;
let rpcCallbackQueue;
const appTag = "[service-to-pacs.pub.ts]";
async function initServerToPacsPubChannel() {
    return new Promise((resolve, reject) => {
        connection = messageBroker_manager_1.messageBrokerManager.connection;
        channel = connection.createChannel({
            json: true,
            name: "service-to-pacs.pub",
            setup: async (channel) => {
                await channel.assertExchange(messagebroker_models_1.MessageBrokerNames.serverToPacs.exchange, "topic", { durable: true }),
                    rpcCallbackQueue = await channel.assertQueue(undefined, { exclusive: true });
                app_logs_1.logger.debug("rpcCallbackQueue queue ready: " + rpcCallbackQueue.queue);
                await channel.consume(rpcCallbackQueue.queue, onRpcMessage, { noAck: true });
            },
        });
        channel.on("error", (err) => app_logs_1.logger.error("error while creating channel: ", err));
        channel.on("connect", () => app_logs_1.logger.info("%schannel has been created", appTag));
        channel.on("close", () => app_logs_1.logger.info("%schannel closed", appTag));
        channel.once("connect", () => resolve());
    });
}
exports.initServerToPacsPubChannel = initServerToPacsPubChannel;
async function sendToPacsRpcQueue(params) {
    const correlationId = uuid.v4();
    _rpcCallbackRegistry[correlationId] = params.callback;
    setTimeout(() => {
        if (_rpcCallbackRegistry[correlationId]) {
            _rpcCallbackRegistry[correlationId](new Error("Message expired"), null);
            _rpcCallbackRegistry[correlationId] = undefined;
        }
    }, params.expiration);
    await channel.publish(messagebroker_models_1.MessageBrokerNames.serverToPacs.exchange, params.message.o, params.message, {
        correlationId: correlationId,
        replyTo: rpcCallbackQueue.queue,
        expiration: params.expiration,
    });
}
exports.sendToPacsRpcQueue = sendToPacsRpcQueue;
const onRpcMessage = async (msg) => {
    if (_rpcCallbackRegistry[msg.properties.correlationId]) {
        _rpcCallbackRegistry[msg.properties.correlationId](null, msg.content.toString());
        _rpcCallbackRegistry[msg.properties.correlationId] = undefined;
    }
};
