"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.amqpServerToAppPub = void 0;
const app_logs_1 = require("../app.logs");
const messageBroker_manager_1 = require("./messageBroker.manager");
class AmqpServerToAppPub {
    constructor() {
        this._exchangeName = "server-to-app";
        this._channel = null;
        this._connection = null;
    }
    async init() {
        return new Promise((resolve, reject) => {
            this._connection = messageBroker_manager_1.messageBrokerManager.connection;
            this._channel = this._connection.createChannel({
                json: true,
                name: "server-to-app.pub",
                setup: async (channel) => {
                    app_logs_1.logger.debug("[server-to-app.pub] channel is establishing...");
                    await channel.assertExchange(this._exchangeName, "topic", { durable: true });
                },
            });
            this._channel.on("error", (err) => app_logs_1.logger.error("[server-to-app.pub] error while creating channel: ", err));
            this._channel.on("connect", () => app_logs_1.logger.info("[server-to-app.pub] channel created"));
            this._channel.on("close", () => app_logs_1.logger.info("[server-to-app.pub] channel closed"));
            this._channel.once("connect", () => resolve());
        });
    }
    async sendToExchange(routingKey, packet) {
        return new Promise((resolve, reject) => {
            this._channel.publish(this._exchangeName, routingKey, packet, {
                persistent: true,
                contentType: "application/json",
                expiration: 10000,
            }, (err) => {
                if (err) {
                    app_logs_1.logger.error("[server-to-app.pub] Broker rejected message error: ", err);
                    reject();
                }
                else {
                    resolve();
                }
            });
        });
    }
}
exports.amqpServerToAppPub = new AmqpServerToAppPub();
