"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.messageBrokerManager = void 0;
const amqp_connection_manager_1 = __importDefault(require("amqp-connection-manager"));
const amqplib = __importStar(require("amqplib"));
const fs = __importStar(require("fs"));
const app_config_1 = require("../app.config");
const app_logs_1 = require("../app.logs");
const messageBroker_device_to_server_sub_1 = require("./messageBroker.device-to-server.sub");
const messageBroker_event_sub_1 = require("./messageBroker.event.sub");
const messageBroker_notification_pub_1 = require("./messageBroker.notification.pub");
const messageBroker_notification_sub_1 = require("./messageBroker.notification.sub");
const messageBroker_server_to_app_pub_1 = require("./messageBroker.server-to-app.pub");
const messageBroker_server_to_device_pub_1 = require("./messageBroker.server-to-device.pub");
const messageBroker_server_to_pacs_pub_1 = require("./messageBroker.server-to-pacs.pub");
const messageBroker_server_to_pacs_sub_1 = require("./messageBroker.server-to-pacs.sub");
const messageBroker_server_to_pgmaintenance_pub_1 = require("./messageBroker.server-to-pgmaintenance.pub");
const messageBroker_server_to_report_pub_1 = require("./messageBroker.server-to-report.pub");
const messageBroker_server_to_report_sub_1 = require("./messageBroker.server-to-report.sub");
const messageBroker_server_to_server_pub_1 = require("./messageBroker.server-to-server.pub");
const messageBroker_server_to_server_sub_1 = require("./messageBroker.server-to-server.sub");
const messageBroker_server_to_tablet_pub_1 = require("./messageBroker.server-to-tablet.pub");
const messageBroker_server_to_pgmaintenance_sub_1 = require("./messageBroker.server-to-pgmaintenance.sub");
const common_utils_1 = require("../components/common.utils");
class MessageBrokerManager {
    constructor() {
        this._connection = null;
    }
    async initForPgRabbitService() {
        try {
            app_logs_1.logger.info("Starting AMQP publisher/subscribers for app-pgrabbit");
            await this.connect();
            await messageBroker_server_to_server_pub_1.amqpServerToServerPub.init();
            await messageBroker_server_to_app_pub_1.amqpServerToAppPub.init();
            app_logs_1.logger.info("Finished AMQP publisher/subscribers for app-pgrabbit");
        }
        catch (error) {
            app_logs_1.logger.error("AMQP publisher/subscribers for app-pgrabbit has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initForPgRedisService() {
        try {
            app_logs_1.logger.info("Starting AMQP publisher/subscribers for app-pgredis");
            await this.connect();
            await messageBroker_server_to_app_pub_1.amqpServerToAppPub.init();
            app_logs_1.logger.info("Finished AMQP publisher/subscribers for app-pgredis");
        }
        catch (error) {
            app_logs_1.logger.error("AMQP publisher/subscribers for app-pgredis has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initForPacs2Server(onMessage) {
        try {
            await this.connect();
            await (0, messageBroker_server_to_pacs_sub_1.initServerToPacsSubChannel)(onMessage);
        }
        catch (error) {
            app_logs_1.logger.error("AMQP publisher/subscribers for app-pgrabbit has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initForReportServerChild() {
        try {
            app_logs_1.logger.info("Starting AMQP subscriber for report server");
            await this.connect();
            await Promise.all([messageBroker_server_to_report_sub_1.amqpServerToReportSub.init(), messageBroker_server_to_app_pub_1.amqpServerToAppPub.init(), (0, messageBroker_notification_pub_1.initServerToNotificationPubChannel)(), (0, messageBroker_server_to_pacs_pub_1.initServerToPacsPubChannel)()]);
            app_logs_1.logger.info("Finished AMQP subscriber for report server");
        }
        catch (error) {
            app_logs_1.logger.error("AMQP AMQP subscriber for report server has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initAmqpForPgMaintenanceService(pgMaintenanceConfig, cb) {
        try {
            app_logs_1.logger.info("Starting AMQP for pgmaintenance service");
            let connection;
            connection = await (0, common_utils_1.connectAmqpWithProcessEnv)(pgMaintenanceConfig, "pgmaintenance.messageBroker.ts");
            await messageBroker_server_to_pgmaintenance_sub_1.amqpServerToPgMaintenanceSub.init(connection, cb);
            app_logs_1.logger.info("Finished AMQP subscriber for pgmaintenance server");
        }
        catch (error) {
            app_logs_1.logger.error(`Amqp for pgmaintenance service could not initialized` + error);
            process.exit(1);
        }
    }
    async initForMaster() {
        try {
            await this.connect();
            await this.socketConnection();
            await Promise.all([
                messageBroker_server_to_app_pub_1.amqpServerToAppPub.init(),
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.init(),
                messageBroker_server_to_report_pub_1.amqpServerToReportPub.init(),
                messageBroker_event_sub_1.amqpEventSub.init(),
                messageBroker_server_to_tablet_pub_1.amqpServerToTabletPub.init(),
                messageBroker_server_to_pgmaintenance_pub_1.amqpServerToPgMaintenancePub.init(),
                (0, messageBroker_server_to_pacs_pub_1.initServerToPacsPubChannel)(),
                (0, messageBroker_notification_pub_1.initServerToNotificationPubChannel)(),
            ]);
            app_logs_1.logger.info("Starting AMQP publisher/subscribers for master");
            app_logs_1.logger.info("Finished AMQP publisher/subscribers for master");
        }
        catch (error) {
            app_logs_1.logger.error("AMQP publisher/subscribers for master has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initForNotificationService() {
        try {
            await this.connect();
            await Promise.all([messageBroker_server_to_app_pub_1.amqpServerToAppPub.init(), (0, messageBroker_notification_sub_1.initServerToNotificationSubChannel)()]);
            app_logs_1.logger.debug("[Notification Server] AMQP connection connected!");
        }
        catch (error) {
            app_logs_1.logger.error("AMQP publisher/subscribers for notificaiton-service has encountered an error %s", error);
            process.exit(1);
        }
    }
    async initForChild() {
        app_logs_1.logger.info("Starting AMQP publisher/subscribers for child");
        try {
            await this.connect();
            await this.socketConnection();
            await Promise.all([
                messageBroker_server_to_app_pub_1.amqpServerToAppPub.init(),
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.init(),
                messageBroker_server_to_report_pub_1.amqpServerToReportPub.init(),
                messageBroker_server_to_server_sub_1.amqpServerToServerSub.init(),
                messageBroker_device_to_server_sub_1.amqpDeviceToServerSub.init(),
                messageBroker_server_to_tablet_pub_1.amqpServerToTabletPub.init(),
                messageBroker_server_to_pgmaintenance_pub_1.amqpServerToPgMaintenancePub.init(),
                (0, messageBroker_server_to_pacs_pub_1.initServerToPacsPubChannel)(),
                (0, messageBroker_notification_pub_1.initServerToNotificationPubChannel)(),
            ]);
        }
        catch (error) {
            let errorMessage = "AMQP publisher/subscribers for child process has encountered an error %s";
            +"AMQP child initialization will  retry in 10 secs";
            app_logs_1.logger.error(errorMessage, error);
            setTimeout(() => this.initForChild(), 10000, this);
        }
    }
    async connect() {
        return new Promise((resolve, reject) => {
            try {
                this._connection = amqp_connection_manager_1.default.connect([`${app_config_1.appConfig.amqpClient.ssl ? "amqps" : "amqp"}://${app_config_1.appConfig.amqpClient.hostname}:${app_config_1.appConfig.amqpClient.port}${app_config_1.appConfig.amqpClient.vhost}`], {
                    heartbeatIntervalInSeconds: app_config_1.appConfig.amqpClient.heartbeat,
                    reconnectTimeInSeconds: app_config_1.appConfig.amqpClient.heartbeat,
                    connectionOptions: {
                        servername: app_config_1.appConfig.amqpClient.hostname,
                        keepAlive: true,
                        credentials: {
                            password: null,
                            username: null,
                            mechanism: "EXTERNAL",
                            response: () => {
                                return Buffer.from("");
                            },
                        },
                        timeout: app_config_1.appConfig.amqpClient.heartbeat * 1000,
                        cert: fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.certFileName),
                        key: fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.keyFileName),
                        ca: [fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.caFileName)],
                    },
                });
                this._connection.once("connect", () => resolve());
                this._connection.on("disconnect", async ({ err }) => app_logs_1.logger.info(`[messageBroker.manager.ts] lost the connection. Retry in ${app_config_1.appConfig.amqpClient.heartbeat} secs. ${err}`));
                this._connection.on("blocked", () => app_logs_1.logger.info("[messageBroker.manager.ts] RabbitMQ connection has been blocked disk full!!"));
                this._connection.on("connect", () => app_logs_1.logger.info("[messageBroker.manager.ts] RabbitMQ connection has been established"));
                this._connection.on("unblocked", () => app_logs_1.logger.info("[messageBroker.manager.ts] RabbitMQ connection has been ublocked!"));
            }
            catch (error) {
                app_logs_1.logger.error("Error while connecting to rabbitmq %s", error.message);
            }
        });
    }
    async socketConnection() {
        try {
            this._socketConnection = await amqplib.connect({
                hostname: app_config_1.appConfig.amqpClient.hostname,
                heartbeat: app_config_1.appConfig.amqpClient.heartbeat,
                port: app_config_1.appConfig.amqpClient.port,
                vhost: app_config_1.appConfig.amqpClient.vhost,
                protocol: app_config_1.appConfig.amqpClient.ssl ? "amqps" : "amqp",
            }, app_config_1.appConfig.amqpClient.ssl
                ? {
                    cert: fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.certFileName),
                    key: fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.keyFileName),
                    credentials: amqplib.credentials.external(),
                    servername: app_config_1.appConfig.amqpClient.hostname,
                    ca: [fs.readFileSync(app_config_1.appConfig.amqpClient.ssl.caFileName)],
                }
                : undefined);
            this._socketConnection.on("close", () => {
                app_logs_1.logger.error("Rabbit socket disconnected... retry in 10 secs %s");
                setTimeout(() => this.socketConnection(), 10000, this);
            });
        }
        catch (error) {
            app_logs_1.logger.error("Error while RabbitMQ socket connecting creating  %s", error.message);
            setTimeout(() => this.socketConnection(), 10000, this);
        }
    }
    get connection() {
        return this._connection;
    }
    get socketAmqpConnection() {
        return this._socketConnection;
    }
}
exports.messageBrokerManager = new MessageBrokerManager();
