"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogLevel = exports.BatteryState = exports.SnapshotResult = exports.OpenClosedSensorLogReason = exports.HubDifferenceFromTerminalItemType = exports.amqpConfigSchema = exports.hubConfigSchema = exports.initialConfigSchema = exports.tlsVersionSchema = exports.OpenClosedState = exports.ActiveState = exports.RelayMode = exports.ContactSensorType = exports.CredentialDataFormat = exports.CredentialTypeNewHub = exports.CredentialType = exports.AccessDirection = exports.SoftwareUpdateType = exports.HttpStatusCode = void 0;
const joi_1 = __importDefault(require("joi"));
var HttpStatusCode;
(function (HttpStatusCode) {
    HttpStatusCode[HttpStatusCode["OK"] = 200] = "OK";
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
})(HttpStatusCode = exports.HttpStatusCode || (exports.HttpStatusCode = {}));
var SoftwareUpdateType;
(function (SoftwareUpdateType) {
    SoftwareUpdateType[SoftwareUpdateType["Terminal"] = 1] = "Terminal";
    SoftwareUpdateType[SoftwareUpdateType["Hardware"] = 2] = "Hardware";
    SoftwareUpdateType[SoftwareUpdateType["OS"] = 3] = "OS";
})(SoftwareUpdateType = exports.SoftwareUpdateType || (exports.SoftwareUpdateType = {}));
var AccessDirection;
(function (AccessDirection) {
    AccessDirection[AccessDirection["Entrance"] = 1] = "Entrance";
    AccessDirection[AccessDirection["Exit"] = 2] = "Exit";
})(AccessDirection = exports.AccessDirection || (exports.AccessDirection = {}));
var CredentialType;
(function (CredentialType) {
    CredentialType[CredentialType["ProximityCard"] = 0] = "ProximityCard";
    CredentialType[CredentialType["BLE"] = 2] = "BLE";
    CredentialType[CredentialType["MiFare"] = 3] = "MiFare";
    CredentialType[CredentialType["AccessToken"] = 4] = "AccessToken";
    CredentialType[CredentialType["UHFRfid"] = 5] = "UHFRfid";
    CredentialType[CredentialType["VehiclePlate"] = 6] = "VehiclePlate";
    CredentialType[CredentialType["NFC"] = 8] = "NFC";
    CredentialType[CredentialType["FingerPrintISO19794"] = 9] = "FingerPrintISO19794";
    CredentialType[CredentialType["QrCode"] = 12] = "QrCode";
    CredentialType[CredentialType["MRZ"] = 16] = "MRZ";
})(CredentialType = exports.CredentialType || (exports.CredentialType = {}));
var CredentialTypeNewHub;
(function (CredentialTypeNewHub) {
    CredentialTypeNewHub[CredentialTypeNewHub["RfTag"] = 1] = "RfTag";
    CredentialTypeNewHub[CredentialTypeNewHub["FingerPrint"] = 2] = "FingerPrint";
    CredentialTypeNewHub[CredentialTypeNewHub["MobileApp"] = 3] = "MobileApp";
    CredentialTypeNewHub[CredentialTypeNewHub["RemoteAccessToken"] = 4] = "RemoteAccessToken";
    CredentialTypeNewHub[CredentialTypeNewHub["LicencePlate"] = 5] = "LicencePlate";
    CredentialTypeNewHub[CredentialTypeNewHub["Mrz"] = 6] = "Mrz";
    CredentialTypeNewHub[CredentialTypeNewHub["BarCode"] = 7] = "BarCode";
    CredentialTypeNewHub[CredentialTypeNewHub["EntranceCode"] = 8] = "EntranceCode";
    CredentialTypeNewHub[CredentialTypeNewHub["FingerPrintOnRfTag"] = 9] = "FingerPrintOnRfTag";
})(CredentialTypeNewHub = exports.CredentialTypeNewHub || (exports.CredentialTypeNewHub = {}));
var CredentialDataFormat;
(function (CredentialDataFormat) {
    CredentialDataFormat[CredentialDataFormat["FpISO"] = 1] = "FpISO";
    CredentialDataFormat[CredentialDataFormat["FpANSI"] = 2] = "FpANSI";
    CredentialDataFormat[CredentialDataFormat["Code128"] = 3] = "Code128";
    CredentialDataFormat[CredentialDataFormat["QrModel1"] = 4] = "QrModel1";
    CredentialDataFormat[CredentialDataFormat["QrModel2"] = 5] = "QrModel2";
    CredentialDataFormat[CredentialDataFormat["MicroQr"] = 6] = "MicroQr";
    CredentialDataFormat[CredentialDataFormat["IQr"] = 7] = "IQr";
    CredentialDataFormat[CredentialDataFormat["SQrc"] = 8] = "SQrc";
    CredentialDataFormat[CredentialDataFormat["FrameQr"] = 9] = "FrameQr";
    CredentialDataFormat[CredentialDataFormat["Mrz"] = 10] = "Mrz";
    CredentialDataFormat[CredentialDataFormat["W26"] = 11] = "W26";
    CredentialDataFormat[CredentialDataFormat["W26a"] = 12] = "W26a";
    CredentialDataFormat[CredentialDataFormat["W34"] = 13] = "W34";
    CredentialDataFormat[CredentialDataFormat["W34a"] = 14] = "W34a";
    CredentialDataFormat[CredentialDataFormat["W36"] = 15] = "W36";
    CredentialDataFormat[CredentialDataFormat["W36a"] = 16] = "W36a";
    CredentialDataFormat[CredentialDataFormat["W37"] = 17] = "W37";
    CredentialDataFormat[CredentialDataFormat["W37a"] = 18] = "W37a";
    CredentialDataFormat[CredentialDataFormat["W50"] = 19] = "W50";
    CredentialDataFormat[CredentialDataFormat["W54"] = 20] = "W54";
    CredentialDataFormat[CredentialDataFormat["String"] = 21] = "String";
    CredentialDataFormat[CredentialDataFormat["Number"] = 22] = "Number";
})(CredentialDataFormat = exports.CredentialDataFormat || (exports.CredentialDataFormat = {}));
var ContactSensorType;
(function (ContactSensorType) {
    ContactSensorType[ContactSensorType["OpenClosed"] = 1] = "OpenClosed";
    ContactSensorType[ContactSensorType["Emergency"] = 2] = "Emergency";
    ContactSensorType[ContactSensorType["Counter"] = 3] = "Counter";
    ContactSensorType[ContactSensorType["Button"] = 4] = "Button";
    ContactSensorType[ContactSensorType["Tamper"] = 5] = "Tamper";
    ContactSensorType[ContactSensorType["LoopDetector"] = 6] = "LoopDetector";
    ContactSensorType[ContactSensorType["BatteryLow"] = 7] = "BatteryLow";
    ContactSensorType[ContactSensorType["ACOK"] = 8] = "ACOK";
    ContactSensorType[ContactSensorType["DCOK"] = 9] = "DCOK";
})(ContactSensorType = exports.ContactSensorType || (exports.ContactSensorType = {}));
var RelayMode;
(function (RelayMode) {
    RelayMode[RelayMode["Monostable"] = 1] = "Monostable";
    RelayMode[RelayMode["Bistable"] = 2] = "Bistable";
})(RelayMode = exports.RelayMode || (exports.RelayMode = {}));
var ActiveState;
(function (ActiveState) {
    ActiveState[ActiveState["Active"] = 1] = "Active";
    ActiveState[ActiveState["Inactive"] = 2] = "Inactive";
})(ActiveState = exports.ActiveState || (exports.ActiveState = {}));
var OpenClosedState;
(function (OpenClosedState) {
    OpenClosedState[OpenClosedState["Openned"] = 1] = "Openned";
    OpenClosedState[OpenClosedState["Closed"] = 2] = "Closed";
})(OpenClosedState = exports.OpenClosedState || (exports.OpenClosedState = {}));
exports.tlsVersionSchema = joi_1.default.alternatives([joi_1.default.string().equal("TLSv1.2"), joi_1.default.string().equal("TLSv1.3")]).optional();
exports.initialConfigSchema = joi_1.default.object({
    network: joi_1.default.object({
        tlsMaxVersion: exports.tlsVersionSchema,
    }),
});
exports.hubConfigSchema = joi_1.default.object({
    url: joi_1.default.string()
        .uri({
        scheme: "https",
        allowRelative: false,
        domain: {
            allowUnicode: true,
            tlds: {
                allow: false,
            },
        },
    })
        .default("https://hub.armongate.com:8443"),
    timeout: joi_1.default.number().positive().max(120).default(20),
});
exports.amqpConfigSchema = joi_1.default.object({
    url: joi_1.default.string()
        .uri({
        scheme: "amqps",
        allowRelative: false,
        domain: {
            allowUnicode: true,
            tlds: {
                allow: false,
            },
        },
    })
        .default("amqps://hub.armongate.com:5671/"),
    heartbeat: joi_1.default.number().positive().max(100).default(10),
});
var HubDifferenceFromTerminalItemType;
(function (HubDifferenceFromTerminalItemType) {
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["EmergencyState"] = 1] = "EmergencyState";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["RelayStatus"] = 2] = "RelayStatus";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UpdateSoftware"] = 3] = "UpdateSoftware";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["TerminalConfig"] = 4] = "TerminalConfig";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["InitialConfig"] = 5] = "InitialConfig";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserRemove"] = 6] = "UserRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UnitRemove"] = 7] = "UnitRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["CredentialRemove"] = 8] = "CredentialRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserGroupRemove"] = 9] = "UserGroupRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserGroupMappingRemove"] = 10] = "UserGroupMappingRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserUpsert"] = 11] = "UserUpsert";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UnitUpsert"] = 12] = "UnitUpsert";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["CredentialUpsert"] = 13] = "CredentialUpsert";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserGroupMapping"] = 14] = "UserGroupMapping";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserUnitMapping"] = 15] = "UserUnitMapping";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserUnitMappingRemove"] = 16] = "UserUnitMappingRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserZoneState"] = 17] = "UserZoneState";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserBalanceChange"] = 18] = "UserBalanceChange";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserCredentialMapping"] = 19] = "UserCredentialMapping";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserCredentialMappingRemove"] = 20] = "UserCredentialMappingRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserForbiddenUpsert"] = 21] = "UserForbiddenUpsert";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["UserForbiddenRemove"] = 22] = "UserForbiddenRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["CredentialForbiddenUpsert"] = 23] = "CredentialForbiddenUpsert";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["CredentialForbiddenRemove"] = 24] = "CredentialForbiddenRemove";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["AmqpGetDiffItemsRequired"] = 25] = "AmqpGetDiffItemsRequired";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["RpcRemoteAccess"] = 26] = "RpcRemoteAccess";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["RpcReboot"] = 27] = "RpcReboot";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["SyncError"] = 29] = "SyncError";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["RpcCredentialRegistration"] = 30] = "RpcCredentialRegistration";
    HubDifferenceFromTerminalItemType[HubDifferenceFromTerminalItemType["RpcTakeSnapshot"] = 31] = "RpcTakeSnapshot";
})(HubDifferenceFromTerminalItemType = exports.HubDifferenceFromTerminalItemType || (exports.HubDifferenceFromTerminalItemType = {}));
var OpenClosedSensorLogReason;
(function (OpenClosedSensorLogReason) {
    OpenClosedSensorLogReason[OpenClosedSensorLogReason["OpennedNormally"] = 1] = "OpennedNormally";
    OpenClosedSensorLogReason[OpenClosedSensorLogReason["Closed"] = 2] = "Closed";
    OpenClosedSensorLogReason[OpenClosedSensorLogReason["Timeout"] = 3] = "Timeout";
    OpenClosedSensorLogReason[OpenClosedSensorLogReason["OpennedForced"] = 4] = "OpennedForced";
})(OpenClosedSensorLogReason = exports.OpenClosedSensorLogReason || (exports.OpenClosedSensorLogReason = {}));
var SnapshotResult;
(function (SnapshotResult) {
    SnapshotResult[SnapshotResult["Success"] = 1] = "Success";
    SnapshotResult[SnapshotResult["Timeout"] = 2] = "Timeout";
    SnapshotResult[SnapshotResult["Error"] = 3] = "Error";
})(SnapshotResult = exports.SnapshotResult || (exports.SnapshotResult = {}));
var BatteryState;
(function (BatteryState) {
    BatteryState[BatteryState["OK"] = 1] = "OK";
    BatteryState[BatteryState["Low"] = 2] = "Low";
    BatteryState[BatteryState["Empty"] = 3] = "Empty";
})(BatteryState = exports.BatteryState || (exports.BatteryState = {}));
var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Warn"] = 1] = "Warn";
    LogLevel[LogLevel["Info"] = 2] = "Info";
    LogLevel[LogLevel["Error"] = 3] = "Error";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
