"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilsV3 = void 0;
const enums_1 = require("./enums");
var UtilsV3;
(function (UtilsV3) {
    function generateHashForAccessNotification(entropy) {
        let key = "";
        key = entropy.regionId;
        if (entropy.targetUserId) {
            key += entropy.targetUserId;
        }
        if (entropy.success) {
            key += entropy.success;
        }
        key += entropy.direction;
        return generateHash(key);
    }
    UtilsV3.generateHashForAccessNotification = generateHashForAccessNotification;
    function generateHashForStatusSensorNotification(entropy) {
        const states = [];
        if (entropy.closed) {
            states.push(enums_1.EnumsV3.StatusSensorReason.Closed);
        }
        if (entropy.closedAfterLeavedOpennedTimeout) {
            states.push(enums_1.EnumsV3.StatusSensorReason.ClosedAfterLeavedOpennedTimeout);
        }
        if (entropy.exitButtonTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.StatusSensorReason.ExitButtonTriggeredRelayDrive);
        }
        if (entropy.leavedOpenned) {
            states.push(enums_1.EnumsV3.StatusSensorReason.LeavedOpenned);
        }
        if (entropy.remoteAccessTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.StatusSensorReason.RemoteAccessTriggeredRelayDrive);
        }
        if (entropy.unknownReasonOpenAlthoughRelayIsMapped) {
            states.push(enums_1.EnumsV3.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped);
        }
        if (entropy.unknownReasonOpenRelayIsNotMapped) {
            states.push(enums_1.EnumsV3.StatusSensorReason.UnknownReasonOpenRelayIsNotMapped);
        }
        if (entropy.wiegandReaderTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.StatusSensorReason.WiegandReaderTriggeredRelayDrive);
        }
        return generateHash(states.join(",") +
            entropy.accessControlPointId +
            entropy.statusSensorId);
    }
    UtilsV3.generateHashForStatusSensorNotification = generateHashForStatusSensorNotification;
    function generateHashForCounterSensorNotification(entropy) {
        let states = [];
        if (entropy.exitButtonTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.ExitButtonTriggeredRelayDrive);
        }
        if (entropy.remoteAccessTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.RemoteAccessTriggeredRelayDrive);
        }
        if (entropy.unknownReasonCounterAlthoughRelayIsMapped) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.UnknownReasonCounterAlthoughRelayIsMapped);
        }
        if (entropy.unknownReasonCounterRelayIsNotMapped) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.UnknownReasonCounterRelayIsNotMapped);
        }
        if (entropy.wiegandReaderTriggeredRelayDrive) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.WiegandReaderTriggeredRelayDrive);
        }
        if (entropy.moreAccessThanGranted) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.MoreAccessThanGranted);
        }
        if (entropy.lessAccessThanGranted) {
            states.push(enums_1.EnumsV3.CounterSensorEventReason.LessAccessThanGranted);
        }
        return generateHash(states.join(",") +
            entropy.accessControlPointId +
            entropy.counterSensorId);
    }
    UtilsV3.generateHashForCounterSensorNotification = generateHashForCounterSensorNotification;
    function generateHash(value) {
        let h = 5831 << 2;
        let i = 0;
        for (i = 0; i < value.length; i++) {
            let ascii = value.charCodeAt(i);
            h = (h << 3) ^ h ^ ascii;
        }
        return (h & 0xffffffffff).toString(16);
    }
})(UtilsV3 = exports.UtilsV3 || (exports.UtilsV3 = {}));
