"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumsV3 = void 0;
var EnumsV3;
(function (EnumsV3) {
    let UpdateType;
    (function (UpdateType) {
        UpdateType[UpdateType["OSUpdate"] = 1] = "OSUpdate";
        UpdateType[UpdateType["ServiceUpdate"] = 2] = "ServiceUpdate";
    })(UpdateType = EnumsV3.UpdateType || (EnumsV3.UpdateType = {}));
    let EventType;
    (function (EventType) {
        EventType[EventType["Add"] = 1] = "Add";
        EventType[EventType["Remove"] = 2] = "Remove";
    })(EventType = EnumsV3.EventType || (EnumsV3.EventType = {}));
    let UploadSnapshotStatusType;
    (function (UploadSnapshotStatusType) {
        UploadSnapshotStatusType[UploadSnapshotStatusType["Success"] = 1] = "Success";
        UploadSnapshotStatusType[UploadSnapshotStatusType["Fail"] = 2] = "Fail";
    })(UploadSnapshotStatusType = EnumsV3.UploadSnapshotStatusType || (EnumsV3.UploadSnapshotStatusType = {}));
    let CameraActionType;
    (function (CameraActionType) {
        CameraActionType[CameraActionType["Auth"] = 1] = "Auth";
        CameraActionType[CameraActionType["Sensor"] = 2] = "Sensor";
        CameraActionType[CameraActionType["RemoteAccess"] = 3] = "RemoteAccess";
        CameraActionType[CameraActionType["View"] = 4] = "View";
    })(CameraActionType = EnumsV3.CameraActionType || (EnumsV3.CameraActionType = {}));
    let ResultStatus;
    (function (ResultStatus) {
        ResultStatus[ResultStatus["All"] = 1] = "All";
        ResultStatus[ResultStatus["Success"] = 2] = "Success";
        ResultStatus[ResultStatus["Fail"] = 3] = "Fail";
    })(ResultStatus = EnumsV3.ResultStatus || (EnumsV3.ResultStatus = {}));
    let ReaderOutputType;
    (function (ReaderOutputType) {
        ReaderOutputType[ReaderOutputType["OnBoard"] = 1] = "OnBoard";
        ReaderOutputType[ReaderOutputType["Wiegand"] = 2] = "Wiegand";
        ReaderOutputType[ReaderOutputType["RS485"] = 3] = "RS485";
        ReaderOutputType[ReaderOutputType["TCPIP"] = 4] = "TCPIP";
    })(ReaderOutputType = EnumsV3.ReaderOutputType || (EnumsV3.ReaderOutputType = {}));
    let ContactInputType;
    (function (ContactInputType) {
        ContactInputType[ContactInputType["OnBoard"] = 1] = "OnBoard";
        ContactInputType[ContactInputType["Dry"] = 2] = "Dry";
        ContactInputType[ContactInputType["RS485"] = 3] = "RS485";
        ContactInputType[ContactInputType["TCPIP"] = 4] = "TCPIP";
    })(ContactInputType = EnumsV3.ContactInputType || (EnumsV3.ContactInputType = {}));
    let AuthenticationFactorType;
    (function (AuthenticationFactorType) {
        AuthenticationFactorType[AuthenticationFactorType["ProximityCard"] = 0] = "ProximityCard";
        AuthenticationFactorType[AuthenticationFactorType["Bluetooth"] = 2] = "Bluetooth";
        AuthenticationFactorType[AuthenticationFactorType["MiFare"] = 3] = "MiFare";
        AuthenticationFactorType[AuthenticationFactorType["AccessToken"] = 4] = "AccessToken";
        AuthenticationFactorType[AuthenticationFactorType["UHFRfid"] = 5] = "UHFRfid";
        AuthenticationFactorType[AuthenticationFactorType["VehiclePlate"] = 6] = "VehiclePlate";
        AuthenticationFactorType[AuthenticationFactorType["NFC"] = 8] = "NFC";
        AuthenticationFactorType[AuthenticationFactorType["FingerPrint"] = 9] = "FingerPrint";
        AuthenticationFactorType[AuthenticationFactorType["QR_BarCode"] = 14] = "QR_BarCode";
        AuthenticationFactorType[AuthenticationFactorType["MRZ"] = 16] = "MRZ";
    })(AuthenticationFactorType = EnumsV3.AuthenticationFactorType || (EnumsV3.AuthenticationFactorType = {}));
    let AccessDirection;
    (function (AccessDirection) {
        AccessDirection[AccessDirection["All"] = 0] = "All";
        AccessDirection[AccessDirection["Entrance"] = 1] = "Entrance";
        AccessDirection[AccessDirection["Exit"] = 2] = "Exit";
    })(AccessDirection = EnumsV3.AccessDirection || (EnumsV3.AccessDirection = {}));
    let AntiPassbackState;
    (function (AntiPassbackState) {
        AntiPassbackState[AntiPassbackState["Unknown"] = 0] = "Unknown";
        AntiPassbackState[AntiPassbackState["In"] = 1] = "In";
        AntiPassbackState[AntiPassbackState["Out"] = 2] = "Out";
    })(AntiPassbackState = EnumsV3.AntiPassbackState || (EnumsV3.AntiPassbackState = {}));
    let OfflineLogType;
    (function (OfflineLogType) {
        OfflineLogType[OfflineLogType["AccessLog"] = 1] = "AccessLog";
        OfflineLogType[OfflineLogType["StatusSensorLog"] = 2] = "StatusSensorLog";
        OfflineLogType[OfflineLogType["TamperSwitchLog"] = 3] = "TamperSwitchLog";
        OfflineLogType[OfflineLogType["EmergencyLog"] = 4] = "EmergencyLog";
        OfflineLogType[OfflineLogType["SystemStatusLog"] = 5] = "SystemStatusLog";
        OfflineLogType[OfflineLogType["CounterLog"] = 6] = "CounterLog";
        OfflineLogType[OfflineLogType["SystemHealthLog"] = 7] = "SystemHealthLog";
        OfflineLogType[OfflineLogType["FingerPrintAddLog"] = 8] = "FingerPrintAddLog";
        OfflineLogType[OfflineLogType["FingerprintRemoveLog"] = 9] = "FingerprintRemoveLog";
        OfflineLogType[OfflineLogType["FaceRecogniseAddLog"] = 10] = "FaceRecogniseAddLog";
        OfflineLogType[OfflineLogType["FaceRecogniseRemoveLog"] = 11] = "FaceRecogniseRemoveLog";
        OfflineLogType[OfflineLogType["InsertNewCredentialLog"] = 12] = "InsertNewCredentialLog";
    })(OfflineLogType = EnumsV3.OfflineLogType || (EnumsV3.OfflineLogType = {}));
    let DeviceToServerMessageTypes;
    (function (DeviceToServerMessageTypes) {
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLog"] = 1] = "AccessLog";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemStatus"] = 2] = "SystemStatus";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["EmergencyStateChanged"] = 3] = "EmergencyStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["StatusSensorStateChanged"] = 4] = "StatusSensorStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["CounterSensorEvent"] = 5] = "CounterSensorEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["TamperEvent"] = 6] = "TamperEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLogControlPanel"] = 7] = "AccessLogControlPanel";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemHealth"] = 8] = "SystemHealth";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["DeviceOfAdapterConnectionState"] = 9] = "DeviceOfAdapterConnectionState";
    })(DeviceToServerMessageTypes = EnumsV3.DeviceToServerMessageTypes || (EnumsV3.DeviceToServerMessageTypes = {}));
    let ServerToDeviceMessageType;
    (function (ServerToDeviceMessageType) {
        ServerToDeviceMessageType[ServerToDeviceMessageType["GetChangesRequired"] = 1] = "GetChangesRequired";
        ServerToDeviceMessageType[ServerToDeviceMessageType["ConfigOrSettingsChanged"] = 2] = "ConfigOrSettingsChanged";
    })(ServerToDeviceMessageType = EnumsV3.ServerToDeviceMessageType || (EnumsV3.ServerToDeviceMessageType = {}));
    let EmergencyState;
    (function (EmergencyState) {
        EmergencyState[EmergencyState["Normal"] = 0] = "Normal";
        EmergencyState[EmergencyState["Emergency"] = 1] = "Emergency";
    })(EmergencyState = EnumsV3.EmergencyState || (EnumsV3.EmergencyState = {}));
    let AccessLogReason;
    (function (AccessLogReason) {
        AccessLogReason[AccessLogReason["Success"] = 0] = "Success";
        AccessLogReason[AccessLogReason["HasNotRight"] = 1] = "HasNotRight";
        AccessLogReason[AccessLogReason["UnknownCredentialOwner"] = 2] = "UnknownCredentialOwner";
        AccessLogReason[AccessLogReason["UnknownAccessPoint"] = 3] = "UnknownAccessPoint";
        AccessLogReason[AccessLogReason["UnhandledFailure"] = 4] = "UnhandledFailure";
        AccessLogReason[AccessLogReason["AntiPassbackReject"] = 5] = "AntiPassbackReject";
        AccessLogReason[AccessLogReason["AntiPassbackTimeOutReject"] = 6] = "AntiPassbackTimeOutReject";
        AccessLogReason[AccessLogReason["CredentialExpired"] = 8] = "CredentialExpired";
        AccessLogReason[AccessLogReason["InsufficientFund"] = 9] = "InsufficientFund";
        AccessLogReason[AccessLogReason["RuleReject"] = 10] = "RuleReject";
        AccessLogReason[AccessLogReason["Manual"] = 11] = "Manual";
        AccessLogReason[AccessLogReason["StateOpened"] = 12] = "StateOpened";
        AccessLogReason[AccessLogReason["StateDisabled"] = 13] = "StateDisabled";
        AccessLogReason[AccessLogReason["IncompleteMultiFactor"] = 14] = "IncompleteMultiFactor";
        AccessLogReason[AccessLogReason["Forbidden"] = 15] = "Forbidden";
        AccessLogReason[AccessLogReason["UserDisabled"] = 16] = "UserDisabled";
        AccessLogReason[AccessLogReason["RelayNotAvailable"] = 17] = "RelayNotAvailable";
        AccessLogReason[AccessLogReason["ChallengeFail"] = 18] = "ChallengeFail";
        AccessLogReason[AccessLogReason["InvalidChallenge"] = 19] = "InvalidChallenge";
        AccessLogReason[AccessLogReason["MifareFingerPrintNotMatch"] = 20] = "MifareFingerPrintNotMatch";
        AccessLogReason[AccessLogReason["MifareFingerPrintTimeout"] = 21] = "MifareFingerPrintTimeout";
        AccessLogReason[AccessLogReason["RegionCapacityFull"] = 22] = "RegionCapacityFull";
        AccessLogReason[AccessLogReason["CapacityBasedRuleReject"] = 23] = "CapacityBasedRuleReject";
        AccessLogReason[AccessLogReason["Reserved"] = 99] = "Reserved";
    })(AccessLogReason = EnumsV3.AccessLogReason || (EnumsV3.AccessLogReason = {}));
    let StatusSensorState;
    (function (StatusSensorState) {
        StatusSensorState[StatusSensorState["Closed"] = 0] = "Closed";
        StatusSensorState[StatusSensorState["Open"] = 1] = "Open";
        StatusSensorState[StatusSensorState["TimeOut"] = 2] = "TimeOut";
    })(StatusSensorState = EnumsV3.StatusSensorState || (EnumsV3.StatusSensorState = {}));
    let ServerToDeviceRPCMessageType;
    (function (ServerToDeviceRPCMessageType) {
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RemoteAccess"] = 1] = "RemoteAccess";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["ChangeAccessControlPointState"] = 2] = "ChangeAccessControlPointState";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyStart"] = 3] = "EmergencyStart";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyEnd"] = 4] = "EmergencyEnd";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RegionStateChanged"] = 5] = "RegionStateChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["DateTimeChanged"] = 6] = "DateTimeChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["CoinBalanceChanged"] = 7] = "CoinBalanceChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AccessRuleApplied"] = 8] = "AccessRuleApplied";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AskSystemStatus"] = 9] = "AskSystemStatus";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["Reboot"] = 10] = "Reboot";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["SyncError"] = 11] = "SyncError";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["NotificationPattern"] = 12] = "NotificationPattern";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["CredentialRegisterMode"] = 13] = "CredentialRegisterMode";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["TakeSnapshot"] = 14] = "TakeSnapshot";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AskCertificate"] = 15] = "AskCertificate";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RemoteRelay"] = 16] = "RemoteRelay";
    })(ServerToDeviceRPCMessageType = EnumsV3.ServerToDeviceRPCMessageType || (EnumsV3.ServerToDeviceRPCMessageType = {}));
    let AccessControlPointState;
    (function (AccessControlPointState) {
        AccessControlPointState[AccessControlPointState["Normal"] = 1] = "Normal";
        AccessControlPointState[AccessControlPointState["StayOpened"] = 2] = "StayOpened";
        AccessControlPointState[AccessControlPointState["Disabled"] = 3] = "Disabled";
    })(AccessControlPointState = EnumsV3.AccessControlPointState || (EnumsV3.AccessControlPointState = {}));
    let NotificationPatternActionType;
    (function (NotificationPatternActionType) {
        NotificationPatternActionType[NotificationPatternActionType["Add"] = 1] = "Add";
        NotificationPatternActionType[NotificationPatternActionType["Update"] = 2] = "Update";
        NotificationPatternActionType[NotificationPatternActionType["Remove"] = 3] = "Remove";
    })(NotificationPatternActionType = EnumsV3.NotificationPatternActionType || (EnumsV3.NotificationPatternActionType = {}));
    let NotificationPatternType;
    (function (NotificationPatternType) {
        NotificationPatternType[NotificationPatternType["Identity"] = 1] = "Identity";
        NotificationPatternType[NotificationPatternType["StatusSensor"] = 2] = "StatusSensor";
        NotificationPatternType[NotificationPatternType["CounterSensor"] = 3] = "CounterSensor";
    })(NotificationPatternType = EnumsV3.NotificationPatternType || (EnumsV3.NotificationPatternType = {}));
    let CounterSensorEventReason;
    (function (CounterSensorEventReason) {
        CounterSensorEventReason[CounterSensorEventReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
        CounterSensorEventReason[CounterSensorEventReason["MoreAccessThanGranted"] = 6] = "MoreAccessThanGranted";
        CounterSensorEventReason[CounterSensorEventReason["LessAccessThanGranted"] = 7] = "LessAccessThanGranted";
    })(CounterSensorEventReason = EnumsV3.CounterSensorEventReason || (EnumsV3.CounterSensorEventReason = {}));
    let TamperSwitchState;
    (function (TamperSwitchState) {
        TamperSwitchState[TamperSwitchState["Secure"] = 0] = "Secure";
        TamperSwitchState[TamperSwitchState["Tampered"] = 1] = "Tampered";
    })(TamperSwitchState = EnumsV3.TamperSwitchState || (EnumsV3.TamperSwitchState = {}));
    let SystemStatusNotificationReason;
    (function (SystemStatusNotificationReason) {
        SystemStatusNotificationReason[SystemStatusNotificationReason["TimerInterval"] = 0] = "TimerInterval";
        SystemStatusNotificationReason[SystemStatusNotificationReason["AcOk"] = 1] = "AcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["RtcOk"] = 2] = "RtcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureLevel"] = 3] = "TemperatureLevel";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureInCelsius"] = 4] = "TemperatureInCelsius";
        SystemStatusNotificationReason[SystemStatusNotificationReason["BatteryValue"] = 5] = "BatteryValue";
        SystemStatusNotificationReason[SystemStatusNotificationReason["EmergencyState"] = 6] = "EmergencyState";
    })(SystemStatusNotificationReason = EnumsV3.SystemStatusNotificationReason || (EnumsV3.SystemStatusNotificationReason = {}));
    let DeviceChangeItemType;
    (function (DeviceChangeItemType) {
        DeviceChangeItemType[DeviceChangeItemType["AddCredential"] = 1] = "AddCredential";
        DeviceChangeItemType[DeviceChangeItemType["RemoveCredential"] = 2] = "RemoveCredential";
        DeviceChangeItemType[DeviceChangeItemType["ConfigChanged"] = 3] = "ConfigChanged";
        DeviceChangeItemType[DeviceChangeItemType["SettingChanged"] = 4] = "SettingChanged";
        DeviceChangeItemType[DeviceChangeItemType["AddUser"] = 5] = "AddUser";
        DeviceChangeItemType[DeviceChangeItemType["RemoveUser"] = 6] = "RemoveUser";
        DeviceChangeItemType[DeviceChangeItemType["AddAccessRight"] = 7] = "AddAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessRight"] = 8] = "RemoveAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["UserInfo"] = 9] = "UserInfo";
        DeviceChangeItemType[DeviceChangeItemType["RegionState"] = 10] = "RegionState";
        DeviceChangeItemType[DeviceChangeItemType["UserGroupUsers"] = 11] = "UserGroupUsers";
        DeviceChangeItemType[DeviceChangeItemType["RegionTicketBalance"] = 12] = "RegionTicketBalance";
        DeviceChangeItemType[DeviceChangeItemType["RegionMaxEntranceCountRuleState"] = 14] = "RegionMaxEntranceCountRuleState";
        DeviceChangeItemType[DeviceChangeItemType["EmergencyState"] = 15] = "EmergencyState";
        DeviceChangeItemType[DeviceChangeItemType["SyncError"] = 16] = "SyncError";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenAdd"] = 17] = "UserForbiddenAdd";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenRemoved"] = 18] = "UserForbiddenRemoved";
        DeviceChangeItemType[DeviceChangeItemType["UpdateRequired"] = 19] = "UpdateRequired";
        DeviceChangeItemType[DeviceChangeItemType["UpsertAccessNotification"] = 20] = "UpsertAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessNotification"] = 21] = "RemoveAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["UpdateCredential"] = 22] = "UpdateCredential";
    })(DeviceChangeItemType = EnumsV3.DeviceChangeItemType || (EnumsV3.DeviceChangeItemType = {}));
    let FingerIndex;
    (function (FingerIndex) {
        FingerIndex[FingerIndex["LeftPinky"] = 1] = "LeftPinky";
        FingerIndex[FingerIndex["LeftRing"] = 2] = "LeftRing";
        FingerIndex[FingerIndex["LeftMiddle"] = 3] = "LeftMiddle";
        FingerIndex[FingerIndex["LeftIndex"] = 4] = "LeftIndex";
        FingerIndex[FingerIndex["LeftThumb"] = 5] = "LeftThumb";
        FingerIndex[FingerIndex["RightThumb"] = 6] = "RightThumb";
        FingerIndex[FingerIndex["RightIndex"] = 7] = "RightIndex";
        FingerIndex[FingerIndex["RightMiddle"] = 8] = "RightMiddle";
        FingerIndex[FingerIndex["RightRing"] = 9] = "RightRing";
        FingerIndex[FingerIndex["RightPinky"] = 10] = "RightPinky";
    })(FingerIndex = EnumsV3.FingerIndex || (EnumsV3.FingerIndex = {}));
    let CredentialIndex;
    (function (CredentialIndex) {
        CredentialIndex[CredentialIndex["Face"] = 0] = "Face";
        CredentialIndex[CredentialIndex["LeftPinky"] = 1] = "LeftPinky";
        CredentialIndex[CredentialIndex["LeftRing"] = 2] = "LeftRing";
        CredentialIndex[CredentialIndex["LeftMiddle"] = 3] = "LeftMiddle";
        CredentialIndex[CredentialIndex["LeftIndex"] = 4] = "LeftIndex";
        CredentialIndex[CredentialIndex["LeftThumb"] = 5] = "LeftThumb";
        CredentialIndex[CredentialIndex["RightThumb"] = 6] = "RightThumb";
        CredentialIndex[CredentialIndex["RightIndex"] = 7] = "RightIndex";
        CredentialIndex[CredentialIndex["RightMiddle"] = 8] = "RightMiddle";
        CredentialIndex[CredentialIndex["RightRing"] = 9] = "RightRing";
        CredentialIndex[CredentialIndex["RightPinky"] = 10] = "RightPinky";
    })(CredentialIndex = EnumsV3.CredentialIndex || (EnumsV3.CredentialIndex = {}));
    let CredentialType;
    (function (CredentialType) {
        CredentialType[CredentialType["ProximityCard"] = 0] = "ProximityCard";
        CredentialType[CredentialType["BLE"] = 2] = "BLE";
        CredentialType[CredentialType["MiFare"] = 3] = "MiFare";
        CredentialType[CredentialType["AccessToken"] = 4] = "AccessToken";
        CredentialType[CredentialType["UHFRfid"] = 5] = "UHFRfid";
        CredentialType[CredentialType["VehiclePlate"] = 6] = "VehiclePlate";
        CredentialType[CredentialType["NFC"] = 8] = "NFC";
        CredentialType[CredentialType["FingerPrintISO19794"] = 9] = "FingerPrintISO19794";
        CredentialType[CredentialType["QrCode"] = 12] = "QrCode";
        CredentialType[CredentialType["MRZ"] = 16] = "MRZ";
    })(CredentialType = EnumsV3.CredentialType || (EnumsV3.CredentialType = {}));
    let StatusSensorReason;
    (function (StatusSensorReason) {
        StatusSensorReason[StatusSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenAlthoughRelayIsMapped"] = 4] = "UnknownReasonOpenAlthoughRelayIsMapped";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenRelayIsNotMapped"] = 5] = "UnknownReasonOpenRelayIsNotMapped";
        StatusSensorReason[StatusSensorReason["LeavedOpenned"] = 6] = "LeavedOpenned";
        StatusSensorReason[StatusSensorReason["Closed"] = 7] = "Closed";
        StatusSensorReason[StatusSensorReason["ClosedAfterLeavedOpennedTimeout"] = 8] = "ClosedAfterLeavedOpennedTimeout";
    })(StatusSensorReason = EnumsV3.StatusSensorReason || (EnumsV3.StatusSensorReason = {}));
    let CounterSensorReason;
    (function (CounterSensorReason) {
        CounterSensorReason[CounterSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
        CounterSensorReason[CounterSensorReason["MoreAccessThanGranted"] = 6] = "MoreAccessThanGranted";
        CounterSensorReason[CounterSensorReason["LessAccessThanGranted"] = 7] = "LessAccessThanGranted";
    })(CounterSensorReason = EnumsV3.CounterSensorReason || (EnumsV3.CounterSensorReason = {}));
    let AuthenticatorType;
    (function (AuthenticatorType) {
        AuthenticatorType[AuthenticatorType["User"] = 1] = "User";
        AuthenticatorType[AuthenticatorType["Visitor"] = 2] = "Visitor";
    })(AuthenticatorType = EnumsV3.AuthenticatorType || (EnumsV3.AuthenticatorType = {}));
    let DayOfWeek;
    (function (DayOfWeek) {
        DayOfWeek[DayOfWeek["Sunday"] = 0] = "Sunday";
        DayOfWeek[DayOfWeek["Monday"] = 1] = "Monday";
        DayOfWeek[DayOfWeek["Tuesday"] = 2] = "Tuesday";
        DayOfWeek[DayOfWeek["Wednesday"] = 3] = "Wednesday";
        DayOfWeek[DayOfWeek["Thursday"] = 4] = "Thursday";
        DayOfWeek[DayOfWeek["Friday"] = 5] = "Friday";
        DayOfWeek[DayOfWeek["Saturday"] = 6] = "Saturday";
    })(DayOfWeek = EnumsV3.DayOfWeek || (EnumsV3.DayOfWeek = {}));
    let DeviceBrand;
    (function (DeviceBrand) {
        DeviceBrand[DeviceBrand["Armon"] = 1] = "Armon";
        DeviceBrand[DeviceBrand["Zkt"] = 2] = "Zkt";
        DeviceBrand[DeviceBrand["Virdi"] = 3] = "Virdi";
        DeviceBrand[DeviceBrand["AndroidHuawei"] = 4] = "AndroidHuawei";
        DeviceBrand[DeviceBrand["AssaAbloy"] = 5] = "AssaAbloy";
        DeviceBrand[DeviceBrand["HikVision"] = 6] = "HikVision";
        DeviceBrand[DeviceBrand["Impinj"] = 7] = "Impinj";
    })(DeviceBrand = EnumsV3.DeviceBrand || (EnumsV3.DeviceBrand = {}));
    let DeviceModel;
    (function (DeviceModel) {
        DeviceModel[DeviceModel["M3"] = 1] = "M3";
        DeviceModel[DeviceModel["E3"] = 2] = "E3";
        DeviceModel[DeviceModel["M2"] = 3] = "M2";
        DeviceModel[DeviceModel["E2"] = 4] = "E2";
        DeviceModel[DeviceModel["MR1D3V1"] = 5] = "MR1D3V1";
        DeviceModel[DeviceModel["R1D2V1"] = 6] = "R1D2V1";
        DeviceModel[DeviceModel["T1"] = 7] = "T1";
        DeviceModel[DeviceModel["V10"] = 8] = "V10";
        DeviceModel[DeviceModel["V6"] = 9] = "V6";
        DeviceModel[DeviceModel["SpeedwayRevolution"] = 10] = "SpeedwayRevolution";
        DeviceModel[DeviceModel["DSK1T606MF"] = 11] = "DSK1T606MF";
        DeviceModel[DeviceModel["DSK1T804MF"] = 12] = "DSK1T804MF";
        DeviceModel[DeviceModel["DS2CD6825G0"] = 13] = "DS2CD6825G0";
        DeviceModel[DeviceModel["DS2CD4A26FWD"] = 14] = "DS2CD4A26FWD";
        DeviceModel[DeviceModel["DS2CD7A26G0"] = 15] = "DS2CD7A26G0";
        DeviceModel[DeviceModel["AH30"] = 16] = "AH30";
        DeviceModel[DeviceModel["AH40"] = 17] = "AH40";
        DeviceModel[DeviceModel["AH50"] = 18] = "AH50";
        DeviceModel[DeviceModel["KS100V2"] = 19] = "KS100V2";
        DeviceModel[DeviceModel["KS100V3"] = 20] = "KS100V3";
        DeviceModel[DeviceModel["H100"] = 21] = "H100";
        DeviceModel[DeviceModel["C100"] = 22] = "C100";
    })(DeviceModel = EnumsV3.DeviceModel || (EnumsV3.DeviceModel = {}));
    let DeviceProtocol;
    (function (DeviceProtocol) {
        DeviceProtocol[DeviceProtocol["OnBoard"] = 1] = "OnBoard";
        DeviceProtocol[DeviceProtocol["Wiegand"] = 2] = "Wiegand";
        DeviceProtocol[DeviceProtocol["RS485"] = 3] = "RS485";
        DeviceProtocol[DeviceProtocol["TCPIP"] = 4] = "TCPIP";
    })(DeviceProtocol = EnumsV3.DeviceProtocol || (EnumsV3.DeviceProtocol = {}));
    let CardDataFormat;
    (function (CardDataFormat) {
        CardDataFormat[CardDataFormat["Raw"] = 0] = "Raw";
        CardDataFormat[CardDataFormat["ThreeByteWholeData"] = 1] = "ThreeByteWholeData";
        CardDataFormat[CardDataFormat["TwoByteCardNumber"] = 2] = "TwoByteCardNumber";
    })(CardDataFormat = EnumsV3.CardDataFormat || (EnumsV3.CardDataFormat = {}));
    let DryContactType;
    (function (DryContactType) {
        DryContactType[DryContactType["GenericSensor"] = 0] = "GenericSensor";
        DryContactType[DryContactType["StatusSensor"] = 5] = "StatusSensor";
        DryContactType[DryContactType["ExitButton"] = 4] = "ExitButton";
        DryContactType[DryContactType["ACOK"] = 1] = "ACOK";
        DryContactType[DryContactType["DCOK"] = 3] = "DCOK";
        DryContactType[DryContactType["BatteryLow"] = 2] = "BatteryLow";
        DryContactType[DryContactType["TamperSwitch"] = 6] = "TamperSwitch";
        DryContactType[DryContactType["CounterSensor"] = 7] = "CounterSensor";
        DryContactType[DryContactType["Emergency"] = 8] = "Emergency";
    })(DryContactType = EnumsV3.DryContactType || (EnumsV3.DryContactType = {}));
    let NotificationSensorType;
    (function (NotificationSensorType) {
        NotificationSensorType[NotificationSensorType["Status"] = 1] = "Status";
        NotificationSensorType[NotificationSensorType["Counter"] = 2] = "Counter";
    })(NotificationSensorType = EnumsV3.NotificationSensorType || (EnumsV3.NotificationSensorType = {}));
    let AccessRuleAcceptStatus;
    (function (AccessRuleAcceptStatus) {
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Accept"] = 1] = "Accept";
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Reject"] = 2] = "Reject";
    })(AccessRuleAcceptStatus = EnumsV3.AccessRuleAcceptStatus || (EnumsV3.AccessRuleAcceptStatus = {}));
    let AccessRuleType;
    (function (AccessRuleType) {
        AccessRuleType[AccessRuleType["TimeBased"] = 1] = "TimeBased";
        AccessRuleType[AccessRuleType["CountBased"] = 2] = "CountBased";
    })(AccessRuleType = EnumsV3.AccessRuleType || (EnumsV3.AccessRuleType = {}));
    let CredentialRegisterModeFailureReasonType;
    (function (CredentialRegisterModeFailureReasonType) {
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CannotConnectToDevice"] = 1] = "CannotConnectToDevice";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CannotStartCaptureOperation"] = 2] = "CannotStartCaptureOperation";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["FingerPrintRegisterFailed"] = 6] = "FingerPrintRegisterFailed";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CredentialRegisterAlreadyUsing"] = 7] = "CredentialRegisterAlreadyUsing";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["FingerPrintRegisterTimeout"] = 8] = "FingerPrintRegisterTimeout";
    })(CredentialRegisterModeFailureReasonType = EnumsV3.CredentialRegisterModeFailureReasonType || (EnumsV3.CredentialRegisterModeFailureReasonType = {}));
})(EnumsV3 = exports.EnumsV3 || (exports.EnumsV3 = {}));
