"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const fs_1 = __importDefault(require("fs"));
const translate = __importStar(require("i18n"));
const moment_1 = __importDefault(require("moment"));
const path_1 = __importDefault(require("path"));
const uuid_1 = __importDefault(require("uuid"));
const api_error_1 = require("../../../api/api.error");
const app_config_1 = require("../../../app.config");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const business_hooks_1 = require("../../../business/business.hooks");
const dal_access_error_1 = require("../../../dal/access/dal.access.error");
const dal_memcache_1 = require("../../../dal/access/dal.memcache");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const predefined_roles_1 = require("../../../dal/db/predefined/predefined.roles");
const messageBroker_notification_pub_1 = require("../../../messageBroker/messageBroker.notification.pub");
const dal_constants_1 = require("../../../dal/dal.constants");
const ORGANIZATION_ID = "3d93c7c7-2610-4f4a-8158-44b29c82fa05";
const usageLimitExceededNotificationId = "286b05ec-3b4e-4999-b4a4-3c8d3e2e1515";
const organizationUnitUserGroupSynchroniserScheduledJobId = "a001ecab-99c2-4894-a9f3-e9b579d6c5fd";
const regionStateInUserGroupSynchroniserScheduledJobId = "a6f47cd8-81de-4899-868a-f392e4dcd046";
const visitorAccessControlPoints = [
    "58a8bf89-af8b-4ef4-ae37-8ff2e9ca4925",
    "35a15005-3835-452b-9c4e-c2c75d366de6",
    "61d0dd18-395e-4f1d-ba18-99924a692bb7",
    "adde48d5-d05c-4a53-b686-c7b844da9157",
    "c2c98f09-a8a6-43b5-845a-2951959f84d1",
    "04904f6f-9aec-486e-81af-db5dafdcb459",
    "8b2fa0a3-79b1-4776-8810-64b43b383d8d",
    "d50f2028-b268-4b6a-a06a-44346f567d64",
    "673da716-4633-4834-a619-aa5d39d7fa60",
    "f4eee8d7-c265-4a01-8b0c-5d5be0dd77af",
    "f136a68d-3130-49fd-8219-16504daac597",
    "c66b4028-dbc2-4d90-9f0f-11906bbf4133",
    "5fb5ac8c-5d2c-4f43-ad7b-9a06055cd0f7",
    "63c07ee5-9f12-4e56-ad66-818b179300a8",
    "1329d6d1-2b9d-4e4b-960c-655ab2361fe1",
    "1e1c1278-b6f9-449c-b70a-15a0dfce5dbe",
    "c335a70c-5e1b-449b-a930-1370f39ca188",
    "2905d0e5-7214-452b-810c-f4556cc80950",
    "4d55a0e7-95ca-4c5d-9cf2-e9c983b482e2",
];
function CreateHook() {
    return new YilmazPlazaHook();
}
exports.CreateHook = CreateHook;
class YilmazPlazaHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        app_logs_1.logger.info("Custom extension YilmazPlazaHook created!");
        super();
        this.beforePreregisterVisit = this.beforePreregisterVisitImplementation;
        this.beforeVisitorSave = this.beforeStartNewVisitImplementation;
        this.organizationCustomNotification = this.parkingLimitExceededNotificationContent;
        this.scheduledJobRoutine = this.customScheduledJobRoutine.bind(this);
        this.afterVisitorSave = async function (params) {
            app_logs_1.logger.debug("after Visitor Save hook running!");
            let result = {
                errorMessage: "",
                isValid: true,
            };
            let visitorSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId, params.trx);
            let visitDetailed = await dal_manager_1.dbManager.accessVisitor.getActiveVisitDetailed(params.organizationId, params.visitId, visitorSettings, params.trx);
            const licensePlate = visitDetailed.profile.fields["licencePlate"];
            const cardNumber = visitDetailed.profile.fields["cardNumber"];
            if (!cardNumber) {
                return Promise.resolve(null);
            }
            let opTime = new Date();
            let credentialCheck = await params.trx
                .withSchema(params.organizationId)
                .from("userOrganizationCredentials")
                .where("userId", visitDetailed.userId)
                .whereWrapped((qw) => {
                qw.orWhereRaw(`
							(data = '${cardNumber}' AND
							type = ${app_enums_1.enums.CredentialType.MiFare})
						`);
                if (licensePlate) {
                    qw.orWhereRaw(`
							(data = '${licensePlate}' AND
							type = ${app_enums_1.enums.CredentialType.VehiclePlate})
						`);
                }
            })
                .first();
            app_logs_1.logger.debug("credential Check Result:" + JSON.stringify(credentialCheck, null, 4));
            let newCredentialIdVehiclePlate = uuid_1.default.v4();
            let newCredentialIdMifare = uuid_1.default.v4();
            let credentialVehiclePlate = {
                id: newCredentialIdVehiclePlate,
                createdAt: opTime,
                updatedAt: opTime,
                deletedAt: null,
                organizationId: params.organizationId,
                userId: visitDetailed.userId,
                type: app_enums_1.enums.CredentialType.VehiclePlate,
                data: licensePlate,
                expiresOn: (0, moment_1.default)(opTime).endOf("day").toDate(),
                credentialNumber: licensePlate,
                extensionFields: null,
            };
            let credentialMifare = {
                id: newCredentialIdMifare,
                createdAt: opTime,
                updatedAt: opTime,
                deletedAt: null,
                organizationId: params.organizationId,
                userId: visitDetailed.userId,
                type: app_enums_1.enums.CredentialType.MiFare,
                data: cardNumber,
                expiresOn: (0, moment_1.default)(opTime).endOf("day").toDate(),
                credentialNumber: cardNumber,
                extensionFields: null,
                source: dal_constants_1.DalConstants.SourceType.System,
            };
            if (credentialCheck) {
                if (licensePlate) {
                    await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").where("id", credentialVehiclePlate.id).delete();
                }
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").where("id", credentialMifare.id).delete();
            }
            try {
                if (licensePlate) {
                    await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").insert(credentialVehiclePlate);
                }
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").insert(credentialMifare);
                app_logs_1.logger.debug("both credentials inserted in hook for visitor");
            }
            catch (error) {
                if (error.message == "Internal DB error") {
                    const symbolKey = Reflect.ownKeys(error).find((key) => key.toString() === "Symbol(message)");
                    if (error[symbolKey].includes(app_enums_1.enums.ErrorCode.CredentialToInsertAlreadyExists.toString())) {
                        (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.IDENTITY.DUPLICATECREDENTIAL");
                    }
                }
            }
            let accessRights = [];
            for (const acpId of visitorAccessControlPoints) {
                let newAccessRightId = uuid_1.default.v4();
                accessRights.push({
                    id: newAccessRightId,
                    createdAt: opTime,
                    updatedAt: opTime,
                    userId: visitDetailed.userId,
                    accessControlPointId: acpId,
                    remoteAccess: false,
                    access: true,
                });
            }
            await params.trx.withSchema(params.organizationId).from("userAccessRights").insert(accessRights);
            app_logs_1.logger.debug("access rights inserted in hook for visitor");
            return Promise.resolve(result);
        }.bind(this);
    }
    async parkingLimitExceededNotificationContent(params) {
        const locale = params.receiverUser.l;
        const instanceData = params.instanceData;
        if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
            return {
                subject: translate.__({ phrase: "NOTIFICATION.TITLE.PARKFULL", locale }),
                html: Handlebars.compile(fs_1.default.readFileSync(path_1.default.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "custom." + locale + ".handlebars"), "utf8"))({
                    title: translate.__({ phrase: "NOTIFICATION.TITLE.PARKFULL", locale }),
                    headLine: translate.__({ phrase: "NOTIFICATION.EMAIL.PARKFULL", locale }),
                    body: params.receiverUser.l === "tr"
                        ? `Firma Adı: ${instanceData.ou}
						   Otoparktaki Misafir Araç Sayısı: ${instanceData.p}
						   Tarih: ${new Date(instanceData.u).toLocaleString(locale)}
					`
                        : `Company Name: ${instanceData.ou}
					Number of Guest Vehicles in the Parking Lot: ${instanceData.p}
					Date: ${new Date(instanceData.u).toLocaleString(locale)}
			 `,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: new Date().getFullYear().toString(),
                }),
                to: params.receiverUser.e,
            };
        }
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
            const result = {
                title: translate.__({ phrase: "NOTIFICATION.TITLE.PARKFULL", locale }),
                body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PARKFULL", locale }, {
                    organizationUnitName: instanceData.ou,
                    usage: instanceData.p + "",
                }),
            };
            if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
                return {
                    ...result,
                    token: params.receiverUser.n,
                    tokenType: params.receiverUser.z,
                };
            }
            else {
                return result;
            }
        }
        if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
            return {
                text: translate.__({ phrase: "NOTIFICATION.SMS.PARKFULL", locale }),
                phoneNumber: params.receiverUser.m,
            };
        }
    }
    async beforeStartNewVisitImplementation(params) {
        const visitedOrganizationUnitId = params.visitFields.filter((v) => v.name === "visitedOrganizationUnit")[0].value;
        const organizastionUnitVisitorParkCapacity = (await params.trx.raw(`
			SELECT settings FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}"
			WHERE id = ?
		`, [visitedOrganizationUnitId])).rows[0].settings.dynamicFormData.visitorParkCapacity;
        const { rows } = await params.trx.raw(`
			SELECT count(*)::smallint as c FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}" oav
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationVisitorProfiles}" ovp 
			ON oav."organizationVisitorProfileId" = ovp.id AND oav."visitedOrganizationUnitId" = ?
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo 
			ON ovp."userOrganizationId" = uo.id
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.antiPassbackStates}" aps 
			ON aps."userId" =  uo."userId"
			WHERE aps.state = ?
			
		`, [visitedOrganizationUnitId, app_enums_1.enums.AntiPassbackState.In]);
        const currentVisitorCount = rows[0].c;
        const organizationUnit = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitBasic({ organizationId: ORGANIZATION_ID, organizationUnitId: visitedOrganizationUnitId });
        if (currentVisitorCount >= organizastionUnitVisitorParkCapacity && params.force) {
            const systemAdminIds = await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(ORGANIZATION_ID, predefined_roles_1.PredefinedRoles.SystemAdministrator.id);
            const instanceData = {
                ou: organizationUnit.name,
                p: currentVisitorCount,
                u: new Date(),
                receiverUserIds: systemAdminIds,
            };
            const notificationEventId = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                return dal_manager_1.dbManager.accessNotifications.addNotificationEvent({
                    createdT: new Date(),
                    notificationId: usageLimitExceededNotificationId,
                    organizationId: ORGANIZATION_ID,
                    instanceData,
                    trx,
                });
            });
            (0, messageBroker_notification_pub_1.publishToNotificationService)({
                a: 0,
                i: notificationEventId,
                n: app_enums_1.enums.AmqpMessageCode.Empty,
                o: ORGANIZATION_ID,
                v: "1",
                d: instanceData,
            });
        }
        if (currentVisitorCount >= organizastionUnitVisitorParkCapacity && !params.force) {
            throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.VISITOR_REGISTRATION_PARK_SLOT_IS_FULL, "ERRORS.VISITOR.REGISTRATION_PARK_SLOT_FULL", {
                organizationUnitName: organizationUnit.name,
            });
        }
    }
    async beforePreregisterVisitImplementation(params) {
        const visitedOrganizationUnitId = params.visitFields.filter((v) => v.name === "visitedOrganizationUnit")[0].value;
        const expectedStartDate = params.visitFields.filter((v) => v.name === "expectedDate")[0].value.startDate;
        const expectedEndDate = params.visitFields.filter((v) => v.name === "expectedDate")[0].value.endDate;
        const organizationUnitVisitorParkCapacity = (await params.trx.raw(`
			SELECT settings FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}"
			WHERE id = ?
		`, [visitedOrganizationUnitId])).rows[0].settings.dynamicFormData.visitorParkCapacity;
        const countOfCurrentVehicles = (await params.trx.raw(`		
			SELECT count(*)::smallint as c FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}" oav
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationVisitorProfiles}" ovp
			ON ovp.id = oav."organizationVisitorProfileId"	
			WHERE oav."visitedOrganizationUnitId" = ?
			AND (ovp."extensionFields"->>'onFoot')::boolean = false
		
			AND NOT (	(oav."expectedStartUtc" >= ?
					AND oav."expectedStartUtc" > ?) 
				OR
					(oav."expectedEndUtc" <= ?
					AND oav."expectedEndUtc" < ?)
				)	
			`, [visitedOrganizationUnitId, new Date(expectedStartDate), new Date(expectedStartDate), new Date(expectedEndDate), new Date(expectedEndDate)])).rows[0].c;
        const onFoot = params.visitorProfileFields?.find((v) => v.name === "onFoot")?.value;
        if (countOfCurrentVehicles >= organizationUnitVisitorParkCapacity && !params.force && !onFoot) {
            throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.VISITOR_PREREGISTRATION_PARK_SLOT_COULD_BE_FULL, "ERRORS.VISITOR.PREREGISTRATION_PARK_SLOT_COULD_BE_FULL");
        }
        return params.visitorProfileFields;
    }
    async customScheduledJobRoutine(organizationId, scheduledJobId) {
        if (organizationId !== ORGANIZATION_ID) {
            app_logs_1.logger.error("Custom Scheduled Job not defined for this organization!!");
        }
        if (scheduledJobId === organizationUnitUserGroupSynchroniserScheduledJobId) {
            await this.organizationUnitUserGroupSynchroniser();
        }
        else if (scheduledJobId === regionStateInUserGroupSynchroniserScheduledJobId) {
            await this.regionStateInUserGroupSynchroniser();
        }
        else {
            app_logs_1.logger.error(`Scheduled job with id ${scheduledJobId} not applicable for organization ${ORGANIZATION_ID}`);
        }
    }
    async organizationUnitUserGroupSynchroniser() {
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const organizationUnitInfo = (await trx.query(`
				SELECT ou.id, ou.name, ARRAY_REMOVE(ARRAY_AGG(uoou."userOrganizationId"), NULL) AS "userOrganizationIds" FROM "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" AS ou
				LEFT JOIN "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" AS uoou
					ON ou."id" = uoou."organizationUnitId"
				WHERE ou."deletedAt" IS NULL
					AND uoou."deletedAt" IS NULL
				GROUP BY ou.id, ou.name
			`)).rows;
            const userGroupInfo = (await trx.query(`
				SELECT ug.id, ug.name,  ARRAY_REMOVE(ARRAY_AGG(uguo."userOrganizationId"), NULL) AS "userOrganizationIds" FROM "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}" AS ug
				LEFT JOIN "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}" AS uguo
					ON ug."id" = uguo."userGroupId"
				WHERE ug."deletedAt" IS NULL
					AND ug."organizationUnitId" IS NOT NULL
					AND uguo."deletedAt" IS NULL
				GROUP BY ug.id, ug.name
			`)).rows;
            for (const organizationUnit of organizationUnitInfo) {
                const userGroup = userGroupInfo.find((ug) => ug.name === organizationUnit.name);
                if (!userGroup) {
                    const userGroupId = uuid_1.default.v4();
                    await trx.query(`
						INSERT INTO "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}"
						(id, "createdAt", "updatedAt", "organizationId", name, "colorCode", "organizationUnitId")
						VALUES ($1, now(), now(), $2, $3, $4, $5);
					`, [userGroupId, ORGANIZATION_ID, organizationUnit.name, this.getRandomColor(), organizationUnit.id]);
                    await trx.query(`
						INSERT INTO "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}"
						(id, "createdAt", "updatedAt", "userOrganizationId", "userGroupId", "source")
						VALUES ( uuid_generate_v4(), now(), now(), UNNEST($2::UUID[]), $1, $3)
						ON CONFLICT ("userOrganizationId", "userGroupId") WHERE "deletedAt" IS NULL
    					DO NOTHING;
					`, [userGroupId, organizationUnit.userOrganizationIds, dal_constants_1.DalConstants.SourceType.System]);
                }
                else {
                    const missingUsersFromGroup = organizationUnit.userOrganizationIds.filter((uoi) => !userGroup.userOrganizationIds.includes(uoi));
                    if (missingUsersFromGroup && missingUsersFromGroup.length) {
                        await trx.query(`
							INSERT INTO "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}"
							(id, "createdAt", "updatedAt", "userOrganizationId", "userGroupId", "source")
							VALUES ( uuid_generate_v4(), now(), now(), UNNEST($2::UUID[]), $1, $3)
							ON CONFLICT ("userOrganizationId", "userGroupId") WHERE "deletedAt" IS NULL
    						DO NOTHING;
						`, [userGroup.id, missingUsersFromGroup, dal_constants_1.DalConstants.SourceType.System]);
                    }
                    const removedUsersFromUnit = userGroup.userOrganizationIds.filter((uoi) => !organizationUnit.userOrganizationIds.includes(uoi));
                    if (removedUsersFromUnit && removedUsersFromUnit.length) {
                        await trx.query(`
							UPDATE "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}"
							SET "deletedAt" = now(), "source" = $3
							WHERE "userGroupId" = $1
								AND "userOrganizationId" = ANY ($2::UUID[])
						`, [userGroup.id, removedUsersFromUnit, dal_constants_1.DalConstants.SourceType.System]);
                    }
                }
            }
            let userGroupsToRemove = userGroupInfo.filter((ugi) => !organizationUnitInfo.map((uoi) => uoi.name).includes(ugi.name));
            await trx.query(`
				UPDATE "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}"
				SET "deletedAt" = now()
				WHERE id = ANY ($1::UUID[])
			`, [userGroupsToRemove.map((ugtr) => ugtr.id)]);
            await trx.query(`
				UPDATE "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}"
				SET "deletedAt" = now(), "source" = $2
				WHERE "userGroupId" = ANY ($1::UUID[])
			`, [userGroupsToRemove.map((ugtr) => ugtr.id), dal_constants_1.DalConstants.SourceType.System]);
        });
    }
    async regionStateInUserGroupSynchroniser() {
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const accessRuleSets = await dal_manager_1.dbManager.accessAccessLog.listAccessRuleSets({
                organizationId: ORGANIZATION_ID,
                request: {
                    take: 10000,
                    skip: 0,
                },
                trx,
            });
            for (const ars of accessRuleSets.items) {
                const accessRules = await dal_manager_1.dbManager.accessAccessLog.listAccessRules({
                    organizationId: ORGANIZATION_ID,
                    accessRuleSetId: ars.id,
                    pagination: {
                        take: 10000,
                        skip: 0,
                    },
                    trx,
                });
                for (const ar of accessRules.items) {
                    if (ar.type === app_enums_1.enums.AccessRuleType.CapacityBased) {
                        const capacityBasedRuleParameters = ar.parameters;
                        for (const cbrp of capacityBasedRuleParameters) {
                            const groupCapacityUsage = (await dal_manager_1.dbManager.accessRegion.getRegionStateReportNew(ORGANIZATION_ID, {
                                pagination: {
                                    take: 100000,
                                    skip: 0,
                                },
                                status: app_enums_1.enums.IdentityStatusType.Enabled,
                                applyOrganizationUnitFilterHierarchically: false,
                                organizationUnitIds: [],
                                regionId: ars.region.id,
                                state: [app_enums_1.enums.AntiPassbackState.In],
                                userGroupIds: [cbrp.groupId],
                                userIds: [],
                            }, dal_constants_1.DalConstants.SystemUserId)).pagination.total;
                            await trx.query(`
								UPDATE "${ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupAccessRuleSets}"
								SET "currentCapacityUsage" = $1, 
									"lastUpdateAccessControlPointId" = NULL,
									"lastActionDateISO" = now()
								WHERE "userGroupId" = $2 AND
									"accessRuleSetId" = $3
							`, [groupCapacityUsage, cbrp.groupId, ars.id]);
                        }
                    }
                }
            }
        });
    }
    getRandomColor() {
        var letters = "0123456789ABCDEF";
        var color = "";
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
}
