"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = exports.ScheduledJobIdForAutoInsertExcusePPermissions = exports.Days = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const lodash_1 = __importDefault(require("lodash"));
const Cursor = require("pg-cursor");
const app_logs_1 = require("../../../app.logs");
const moment = require("moment");
const dal_constants_1 = require("../../../dal/dal.constants");
const handlebars = require("handlebars");
const translate = __importStar(require("i18n"));
exports.Days = {
    sunday: 0,
    monday: 1,
    tuesday: 2,
    wednesday: 3,
    thursday: 4,
    friday: 5,
    saturday: 6,
};
exports.ScheduledJobIdForAutoInsertExcusePPermissions = "2c212ece-fa82-4699-b786-bb81878342a0";
const ExcusePPermissionTypeId = "a6b8bb1d-6d76-46fb-a12e-297681df337c";
function CreateHook() {
    return new SageHook();
}
exports.CreateHook = CreateHook;
class SageHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.onPrepareVisitorCameEmailNotification = this.onPrepareVisitorCameEmailNotificationImplementation;
        this.scheduledJobRoutine = this.scheduledJobHandler.bind(this);
    }
    async scheduledJobHandler(organizationId, scheduledJobId) {
        switch (scheduledJobId) {
            case exports.ScheduledJobIdForAutoInsertExcusePPermissions:
                const start = moment();
                await this.insertExcuseLeavesAutomatically(organizationId);
                const diff = moment().diff(start, "seconds");
                app_logs_1.logger.info("Excuse permissions inserted automatically in " + diff + " seconds");
                break;
            default:
                app_logs_1.logger.error("Undefined scheduled job id(" + scheduledJobId + ") for organization(" + organizationId + ")");
                break;
        }
    }
    async insertExcuseLeavesAutomatically(organizationId) {
        const systemUserId = dal_constants_1.DalConstants.SystemUserId;
        const startOfYear = moment().startOf("year").toDate();
        const endDate = moment().add(-4, "days").endOf("day").toDate();
        app_logs_1.logger.info("Scheduled job 'auto insertion of excuse permissions' starting between dates " + startOfYear + " - " + endDate);
        let queryParamsIndex = 1;
        try {
            await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                await trx.query(`
                    CREATE TEMP TABLE ppermissionsTemp (
                        "ppermissionId" uuid,
                        "startDateTime" timestamp with time zone,
                        "endDateTime" timestamp with time zone,
                        "userId" uuid
                    );
                `);
                await trx.query(`
                    INSERT INTO ppermissionsTemp ("ppermissionId", "startDateTime", "endDateTime", "userId")
                    SELECT
                        uuid_generate_v4() as "ppermissionId",
                        timestamptz(d.st) as "startDateTime",
                        timestamptz(d.et) as "endDateTime",
                        "userId"
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeDays}"	
                    CROSS JOIN LATERAL (
                        SELECT j->>'s' as st, j->>'e' as et FROM jsonb_array_elements ( data->'c' ) AS j
                        WHERE ( j->>'at')::integer = 9 AND (j->>'et')::integer = 1 AND j->'ad'->'t' IS NULL
                    ) d
                    WHERE date >= $${queryParamsIndex++} and date <= $${queryParamsIndex++};
                `, [startOfYear, endDate]);
                await trx.query(`
                    INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissions}" 
                    ("id", "organizationId", "ppermissionTypeId", "startDateTime", "endDateTime", "note", "status", "requestUserId", "requestRole", "requestDateTime")
                    SELECT
                        pt."ppermissionId" as "id",
                        uuid('${organizationId}') as "organizationId",
                        uuid('${ExcusePPermissionTypeId}') as "ppermissionTypeId",
                        pt."startDateTime" as "startDateTime",
                        pt."endDateTime" as "endDateTime",
                        NULL::text as "note",
                        1 as "status",
                        uuid('${systemUserId}') as "requestUserId",
                        0 as "requestRole",
                        now() as "requestDateTime"
                    FROM ppermissionsTemp as pt;
                `);
                await trx.query(`
                    INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userPPermissions}" 
                    ("id", "userId", "ppermissionId", "currentApprovementOrder")
                    SELECT
                        uuid_generate_v4() as "id",
                        pt."userId" as "userId",
                        pt."ppermissionId" as "ppermissionId",
                        0 as "currentApprovementOrder"
                    FROM ppermissionsTemp as pt
					ON CONFLICT ("userId", "ppermissionId")
					DO UPDATE
					SET 
						"currentApprovementOrder" = EXCLUDED."currentApprovementOrder";
                `);
                await trx.query(`
                    INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userPPermissionApprovements}"
                    ("id", "ppermissionId", "userId", "organizationUnitId", "order", "approverUserId", "approvementDate", "note", "status")
                    SELECT
                        uuid_generate_v4() as "id",
                        pt."ppermissionId" as "ppermissionId",
                        pt."userId" as "userId",
                        null::uuid as "organizationUnitId",
                        0 as "order",
                        uuid('${systemUserId}') as "approverUserId",
                        current_date as "approvementDate",
                        NULL::text as "note",
                        true as "status"
                    FROM ppermissionsTemp as pt;
                `);
                await trx.query(`
                    INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.recalculateWorkQueue}"
                    (id, "userId", "organizationId", reason, "startDate")
                    SELECT 
                        uuid_generate_v4() as "id", 
                        pt."userId" as "userId",
                        uuid('${organizationId}') as "organizationId",
                        16 "reason", 
                        MIN(pt."startDateTime") as "startDate"
                    FROM ppermissionsTemp as pt
                    GROUP BY pt."userId";
                `);
            });
        }
        catch (error) {
            app_logs_1.logger.error("Error while inserting excuse permissions automatically : " + error);
        }
    }
    async generateOrganizationMonthlyReports(organizationId, year, month, trx) {
        const startDate = moment().year(year).month(month).startOf("month");
        const endDate = moment().year(year).month(month).endOf("month");
        let monthlyData = await this.getEmployeeDays(organizationId, startDate, endDate);
        let results = [];
        for (const userData of monthlyData) {
            results.push(await this.calculateMonthlyReportOfUser(organizationId, startDate, endDate, trx, {
                monthlyData: userData,
            }));
        }
        await this.insertMonthlyReports(organizationId, startDate.clone().add(1, "days").toDate(), results, trx);
    }
    async insertMonthlyReports(organizationId, date, employeeMonthlyReports, trx, options) {
        if (options?.update && !options.existingReportId)
            return;
        let query = `          
            ${options?.update ? `UPDATE ` : `INSERT INTO `}  "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeMonths}"
            
            ${options?.update
            ? ` SET (data, "isChecked", note, "updatedAt", "updatedByUserId") = ( `
            : ` (id, "date", "userId", "organizationId", "updatedAt", "isChecked", "data", "monthlyReportId") `} 
            SELECT
                ${options?.update
            ? `
                to_jsonb(datajson->'data') as "data",
                bool(datajson->>'isChecked') as "isChecked",
                NULL as "note",
                now() as "updatedAt",
                NULL:: uuid as "updatedByUserId"
                `
            : `
                uuid_generate_v4() as id,
                date('${date.toUTCString()}') as "date",
                uuid(datajson->>'userId') as "userId",
                uuid(datajson->>'organizationId') as "organizationId",
                now() as "updatedAt",
                bool(datajson->>'isChecked') as "isChecked",
                to_jsonb(datajson->'data') as "data",
                msr.id as "monthlyReportId"
                `}
            FROM jsonb_array_elements((?::text)::jsonb) AS t(datajson)
            INNER JOIN "${organizationId}"."monthlySummaryReports" msr ON msr."organizationId" = ?
            AND msr.year = extract(year from ?::date) AND msr.month = extract(month from ?::date)
            ${options?.update && options.existingReportId ? ` ) WHERE id = '${options.existingReportId}' ;` : `;`}
        `;
        await trx.raw(query, [JSON.stringify(employeeMonthlyReports), organizationId, date, date]);
    }
    async getEmployeeDays(organizationId, startDate, endDate, userId) {
        let result = [];
        let queryParamsIndex = 1;
        let queryParams = [];
        let query = `
            SELECT
            format('%s-%s-1', extract(year from ed.date), extract(month from ed.date)):: date as date,
            ed."userId", ed."organizationId",
            now() as "createdAt",
            false as "isChecked",
            json_agg(
                json_build_object(
                    'p', coalesce(pp.list,'{}') ,
                    'w', ed.data -> 'w',
                    'd', ed.date,
                    'ew', (ed.data -> 's' -> 'ew'):: integer,
                    'n', (ed.data -> 's' -> 'n'):: integer,
                    'e', (ed.data -> 's' -> 'e'):: integer,
                    'm', (ed.data -> 's' -> 'm'):: integer,
                    'el', (ed.data -> 's' -> 'el'):: integer,
                    'es', (ed.data -> 's' -> 'es'):: integer,
                    'll', (ed.data -> 's' -> 'll'):: integer,
                    'ls', (ed.data -> 's' -> 'ls'):: integer,
                    'tel', (ed.data -> 's' -> 'tel'):: integer,
                    'tes', (ed.data -> 's' -> 'tes'):: integer,
                    'tll', (ed.data -> 's' -> 'tll'):: integer,
                    'tls', (ed.data -> 's' -> 'tls'):: integer,
                    'ao', (ed.data -> 's' -> 'ao'):: integer,
                    'eo', (ed.data -> 's' -> 'eo'):: integer,
                    'dw', (ed.data -> 's' -> 'dw'):: integer,
                    'iw', (ed.data -> 's' -> 'iw'):: integer,
                    'ufb', (ed.data -> 's' -> 'ufb'):: float,
                    'afb', (ed.data -> 's' -> 'afb'):: float,
                    'efb', (ed.data -> 's' -> 'efb'):: float,
                    'ucb', (ed.data -> 's' -> 'ucb'):: float,
                    'acb', (ed.data -> 's' -> 'acb'):: float,
                    'ecb', (ed.data -> 's' -> 'ecb'):: float,
                    'uh', (ed.data -> 's' -> 'uh'):: integer,
                    'eh', (ed.data -> 's' -> 'eh'):: integer,
                    'pr', (ed.data -> 's' -> 'pr'):: integer,
                    's', (ed.data->'s'->>'s')::integer
                )
            ) as "data"
            FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeDays}" AS "ed"
            LEFT JOIN LATERAL (
                select array_agg(p ->> 'p') as list from  jsonb_array_elements(ed.data -> 'p') as x(p)
            ) pp ON TRUE
            WHERE ed.date >= $${queryParamsIndex++} AND ed.date <= $${queryParamsIndex++} 
            ${userId ? ` AND "userId" = '${userId}' ` : ``} 
            GROUP BY "userId", "organizationId", extract(year from ed.date), extract(month from ed.date)
            ORDER BY "userId", "organizationId", "date"                         
        `;
        queryParams.push(startDate.toDate(), endDate.toDate());
        const client = await dal_manager_1.dbManager.poolMain.connect();
        const cursor = client.query(new Cursor(query, queryParams));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, rows) => {
                        if (err) {
                            reject(err);
                        }
                        resolve(rows);
                    });
                });
                result = result.concat(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetch monthly summary report data with cursor!");
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            client.release();
        }
        catch (error) {
            client?.release(error);
            app_logs_1.logger.error(error);
        }
        return result;
    }
    async calculateMonthlyReportOfUser(organizationId, startDate, endDate, trx, params) {
        if (!params.monthlyData && !params.userId)
            return;
        let data = params.monthlyData;
        if (!data) {
            data = (await this.getEmployeeDays(organizationId, startDate, endDate, params.userId))[0];
        }
        let result = {
            updatedAt: data.createdAt,
            date: data.date,
            isChecked: data.isChecked,
            organizationId: data.organizationId,
            userId: data.userId,
            data: null,
        };
        let monthlySum = {
            weekend: 0,
            weekday: 0,
            holiday: 0,
            overWork: 0,
            missingWork: 0,
        };
        let weeklySum = {
            weekend: 0,
            weekday: 0,
            holiday: 0,
            overWork: 0,
            missingWork: 0,
        };
        for (const dayData of data.data) {
            const weekday = moment(dayData.d).weekday();
            const d = moment(dayData.d).clone();
            if (result.data) {
                const ppermissions = [...new Set(result.data.p.concat(dayData.p))];
                const workplanList = [...new Set(result.data.w.concat(dayData.w))];
                result.data = lodash_1.default.mergeWith({}, result.data, dayData, lodash_1.default.add);
                result.data.p = ppermissions;
                result.data.w = workplanList;
            }
            else {
                result.data = dayData;
            }
            if (dayData.eh) {
                weeklySum.holiday += dayData.e > 8 ? 8 : dayData.e;
                weeklySum.overWork += dayData.e > 8 ? dayData.e - 8 : 0;
            }
            else if (weekday === exports.Days.saturday || weekday === exports.Days.sunday) {
                weeklySum.weekend += dayData.e > 8 ? 8 : dayData.e;
                weeklySum.overWork += dayData.e > 8 ? dayData.e - 8 : 0;
            }
            else if (weekday === exports.Days.monday || weekday === exports.Days.tuesday || weekday === exports.Days.wednesday || weekday === exports.Days.thursday || weekday === exports.Days.friday) {
                weeklySum.weekday += dayData.e > 3 ? 3 : dayData.e;
                weeklySum.overWork += dayData.e > 3 ? dayData.e - 3 : 0;
                weeklySum.missingWork += dayData.m;
            }
            if (d.weekday() === exports.Days.sunday || d.isSame(endDate, "day")) {
                const weekday = weeklySum.weekday;
                weeklySum.weekday = weekday < 5 ? 0 : weekday - 5;
                weeklySum.overWork += weekday > 5 ? 5 : weekday;
                monthlySum = lodash_1.default.mergeWith({}, weeklySum, monthlySum, lodash_1.default.add);
                weeklySum = {
                    weekend: 0,
                    weekday: 0,
                    holiday: 0,
                    overWork: 0,
                    missingWork: 0,
                };
            }
        }
        if (monthlySum.missingWork && monthlySum.overWork) {
            const missing = monthlySum.missingWork;
            monthlySum.missingWork = monthlySum.overWork > missing ? 0 : missing - monthlySum.overWork;
            monthlySum.overWork = missing > monthlySum.overWork ? 0 : monthlySum.overWork - missing;
        }
        if (monthlySum.missingWork && monthlySum.weekday) {
            const missing = monthlySum.missingWork;
            monthlySum.missingWork = monthlySum.weekday > missing ? 0 : missing - monthlySum.weekday;
            monthlySum.weekday = missing > monthlySum.weekday ? 0 : monthlySum.weekday - missing;
        }
        if (monthlySum.missingWork && monthlySum.weekend) {
            const missing = monthlySum.missingWork;
            monthlySum.missingWork = monthlySum.weekend > missing ? 0 : missing - monthlySum.weekend;
            monthlySum.weekend = missing > monthlySum.weekend ? 0 : monthlySum.weekend - missing;
        }
        if (monthlySum.missingWork && monthlySum.holiday) {
            const missing = monthlySum.missingWork;
            monthlySum.missingWork = monthlySum.holiday > missing ? 0 : missing - monthlySum.holiday;
            monthlySum.holiday = missing > monthlySum.holiday ? 0 : monthlySum.holiday - missing;
        }
        result.data.m = monthlySum.missingWork;
        result.data.e = monthlySum.holiday + monthlySum.overWork + monthlySum.weekday + monthlySum.weekend;
        delete result.data.d;
        if (params.insertToDb) {
            await this.insertMonthlyReports(organizationId, startDate.add(1, "days").toDate(), [result], trx, { update: params.update, existingReportId: params.existingReportId });
        }
        return result;
    }
    async onPrepareVisitorCameEmailNotificationImplementation(context, params) {
        const result = {
            subject: "",
            html: "",
            to: params.receiverUser.e,
        };
        const notificationContext = {
            ...context,
            hasAccount: false,
            visitorCompany: "",
            visitorPhoneNumber: "",
        };
        const username = await dal_manager_1.dbManager.accessUser.getUsername(params.organizationId, params.receiverUser.id);
        if (username) {
            notificationContext.hasAccount = true;
        }
        result.subject = translate.__({ phrase: "NOTIFICATION.TITLE.VISITORCAME", locale: params.receiverUser.l });
        const visitorCompanyResult = await params.trx.query(`
			SELECT ovp."extensionFields"->>'company' AS "company"
				   ovp."extensionFields"->>'phoneNumber' AS "phoneNumber"	
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationVisitorProfiles}" ovp
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}" oav
				ON oav."organizationVisitorProfileId" = ovp.id
			WHERE ovp."deletedAt" IS NULL AND
				oav.id = $1;
		`, [params.instanceData.a]);
        if (visitorCompanyResult.rowCount && visitorCompanyResult.rows[0]) {
            notificationContext.visitorCompany = visitorCompanyResult.rows[0].company;
            notificationContext.visitorPhoneNumber = visitorCompanyResult.rows[0].phoneNumber;
        }
        if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.Turkish) {
            const html = `<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
	xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
	<title>
	</title>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style type="text/css">
		#outlook a {
			padding: 0;
		}

		body {
			margin: 0;
			padding: 0;
			-webkit-text-size-adjust: 100%;
			-ms-text-size-adjust: 100%;
		}

		table,
		td {
			border-collapse: collapse;
			mso-table-lspace: 0pt;
			mso-table-rspace: 0pt;
		}

		img {
			border: 0;
			height: auto;
			line-height: 100%;
			outline: none;
			text-decoration: none;
			-ms-interpolation-mode: bicubic;
		}

		p {
			display: block;
			margin: 13px 0;
		}
	</style>
	<link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
	<style type="text/css">
		@import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
	</style>
	<style type="text/css">
		@media only screen and (min-width:480px) {
			.mj-column-per-50 {
				width: 50% !important;
				max-width: 50%;
			}

			.mj-column-per-100 {
				width: 100% !important;
				max-width: 100%;
			}
		}
	</style>
	<style type="text/css">
		@media only screen and (max-width:480px) {
			table.mj-full-width-mobile {
				width: 100% !important;
			}

			td.mj-full-width-mobile {
				width: auto !important;
			}
		}
	</style>
</head>

<body style="background-color:#FAFAFA;">
	<div style="background-color:#FAFAFA;">
		<div style="background:#01325B;background-color:#01325B;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#01325B;background-color:#01325B;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:20px 0;text-align:left;">
							{{#if organizationLogo}}
							<div class="mj-column-per-50 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left" style="font-size:0px;padding:10px 25px;word-break:break-word;">
											<table border="0" cellpadding="0" cellspacing="0" role="presentation"
												style="border-collapse:collapse;border-spacing:0px;">
												<tbody>
													<tr>
														<td style="width:100px;">
															<img height="auto" src="{{organizationLogo}}"
																style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
																width="100" />
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</table>
							</div>
							{{/if}}
							{{#unless organizationLogo}}
							<div class="mj-column-per-50 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left" style="font-size:0px;padding:10px 25px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#01325B;">
												<p
													style="font-weigth:bold; line-height: 0px; padding-right: 10px; text-align: left;font-size:14px;color:#ffffff;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
													{{{organizationName}}}</p>
											</div>
										</td>
									</tr>
								</table>
							</div>
							{{/unless}}
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div style="background:url(./header-image.png) top center / cover no-repeat;margin:0px auto;max-width:600px;">
			<div style="line-height:0;font-size:0;">
				<table align="center" background="{{headerLogo}}" border="0" cellpadding="0" cellspacing="0"
					role="presentation" style="top center / cover no-repeat;" width="100%">
					<tbody>
						<tr>
							<td style="direction:ltr;font-size:0px;padding:20px 0;text-align:center;">
								<div class="mj-column-per-100 mj-outlook-group-fix"
									style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:middle;width:100%;">
									<table border="0" cellpadding="0" cellspacing="0" role="presentation"
										style="vertical-align:middle;" width="100%">
										<tr>
											<td align="left" style="padding: 10.0px 25.0px;padding-top:
												70.0px;padding-bottom: 10.0px;padding-left: 50.0px;">
												<span style="font-size: 26px; color:#01325B; font-weight: bold; ">Ziyaretçiniz Gelmiştir.</span>
											</td>
										</tr>
									</table>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		<div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#ffffff;background-color:#ffffff;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:0 0 0 0;text-align:center;">
							<div class="mj-column-per-100 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="margin-top:24px; line-height: 15px; text-align: left; margin: 10px 0; margin-bottom:0px; font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Aşağıda bilgileri verilen ziyaretçiniz gelmiştir.</b>
												</p>
											</div>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Tarih: </b> {{{date}}}
												</p>
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Ziyaretçi: </b> {{{visitorFullname}}}
												</p>
												{{#if visitorRegistrationPoint }}
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Ziyaretçi Kabul Noktası: </b> {{{visitorRegistrationPoint}}}
												</p>
												{{/if}}
												{{#if visitorCompany }}
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Ziyaretçi Şirket Bilgisi: </b> {{{visitorCompany}}}
												</p>
												{{/if}}  
												{{#if visitorPhoneNumber }}
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Ziyaretçi Telefon Numarası: </b> {{{visitorPhoneNumber}}}
												</p>
												{{/if}}    
											</div>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:12px;color:#55575d;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
											</div>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#ffffff;background-color:#ffffff;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:32px 0px;text-align:center;">
							<div class="mj-column-per-100 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="center"
											style="font-size:0px;padding:10px 25px;padding-bottom:0px;word-break:break-word;">
											<table border="0" cellpadding="0" cellspacing="0" role="presentation"
												style="border-collapse:collapse;border-spacing:0px;">
												<tbody>
													<tr>
														<td style="width:100px;">
															<img height="auto" src="{{armonLogo}}"
																style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
																width="100" />
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-top:0px;padding-bottom:0px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#55575d;">
											<p
												style="line-height: 16px; text-align: center; margin: 10px 0;font-size:8px;color:#A7A7A7;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
												Bu bildirim ARMON geçiş kontrol sistemi ile gönderilmiştir.<br/>
												Bu bildirimi almak istemiyorsanız<a href={{{unsubscribeType}}}> tıklayınız</a>.<br/>
												Armon'dan email almak istemiyorsanız<a href={{{unsubscribeEmail}}}> tıklayınız</a>.<br/>
												<span style="color:#A7A7A7;font-family:'Times New Roman',Helvetica,Arial,sans-serif">armon © {{{year}}} </span>
											</p>    
											</div>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</body>

</html>`;
            result.html = handlebars.compile(html)(notificationContext);
        }
        else {
            const html = `<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
	xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
	<title>
	</title>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style type="text/css">
		#outlook a {
			padding: 0;
		}

		body {
			margin: 0;
			padding: 0;
			-webkit-text-size-adjust: 100%;
			-ms-text-size-adjust: 100%;
		}

		table,
		td {
			border-collapse: collapse;
			mso-table-lspace: 0pt;
			mso-table-rspace: 0pt;
		}

		img {
			border: 0;
			height: auto;
			line-height: 100%;
			outline: none;
			text-decoration: none;
			-ms-interpolation-mode: bicubic;
		}

		p {
			display: block;
			margin: 13px 0;
		}
	</style>
	<link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
	<style type="text/css">
		@import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
	</style>
	<style type="text/css">
		@media only screen and (min-width:480px) {
			.mj-column-per-50 {
				width: 50% !important;
				max-width: 50%;
			}

			.mj-column-per-100 {
				width: 100% !important;
				max-width: 100%;
			}
		}
	</style>
	<style type="text/css">
		@media only screen and (max-width:480px) {
			table.mj-full-width-mobile {
				width: 100% !important;
			}

			td.mj-full-width-mobile {
				width: auto !important;
			}
		}
	</style>
</head>

<body style="background-color:#FAFAFA;">
	<div style="background-color:#FAFAFA;">
		<div style="background:#01325B;background-color:#01325B;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#01325B;background-color:#01325B;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:20px 0;text-align:left;">
							{{#if organizationLogo}}
							<div class="mj-column-per-50 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left" style="font-size:0px;padding:10px 25px;word-break:break-word;">
											<table border="0" cellpadding="0" cellspacing="0" role="presentation"
												style="border-collapse:collapse;border-spacing:0px;">
												<tbody>
													<tr>
														<td style="width:100px;">
															<img height="auto" src="{{organizationLogo}}"
																style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
																width="100" />
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</table>
							</div>
							{{/if}}
							{{#unless organizationLogo}}
							<div class="mj-column-per-50 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left" style="font-size:0px;padding:10px 25px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#01325B;">
												<p
													style="font-weigth:bold; line-height: 0px; padding-right: 10px; text-align: left;font-size:14px;color:#ffffff;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
													{{{organizationName}}}</p>
											</div>
										</td>
									</tr>
								</table>
							</div>
							{{/unless}}
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div style="background:url(./header-image.png) top center / cover no-repeat;margin:0px auto;max-width:600px;">
			<div style="line-height:0;font-size:0;">
				<table align="center" background="{{headerLogo}}" border="0" cellpadding="0" cellspacing="0"
					role="presentation" style="top center / cover no-repeat;" width="100%">
					<tbody>
						<tr>
							<td style="direction:ltr;font-size:0px;padding:20px 0;text-align:center;">
								<div class="mj-column-per-100 mj-outlook-group-fix"
									style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:middle;width:100%;">
									<table border="0" cellpadding="0" cellspacing="0" role="presentation"
										style="vertical-align:middle;" width="100%">
										<tr>
											<td align="left" style="padding: 10.0px 25.0px;padding-top:
												70.0px;padding-bottom: 10.0px;padding-left: 50.0px;">
												<span style="font-size: 26px; color:#01325B; font-weight: bold; ">Your Visitor Has Come</span>
											</td>
										</tr>
									</table>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		<div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#ffffff;background-color:#ffffff;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:0 0 0 0;text-align:center;">
							<div class="mj-column-per-100 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="margin-top:24px; line-height: 15px; text-align: left; margin: 10px 0; margin-bottom:0px; font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Your visitor, whose information is given below, has arrived.</b>
												</p>
											</div>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Date: </b> {{{date}}}
												</p>
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Visitor Name: </b> {{{visitorFullname}}}
												</p>
												{{#if visitorRegistrationPoint }}
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Visitor Registration Point: </b> {{{visitorRegistrationPoint}}}
												</p>
												{{/if}}  
												{{#if visitorCompany }}
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
													<b>Visitor Company: </b> {{{visitorCompany}}}
												</p>
												{{/if}}   
		
											</div>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
												<p
													style="line-height: 20px; text-align: left; margin: 0px 0;font-size:12px;color:#55575d;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
											</div>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
			<table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
				style="background:#ffffff;background-color:#ffffff;width:100%;">
				<tbody>
					<tr>
						<td style="direction:ltr;font-size:0px;padding:32px 0px;text-align:center;">
							<div class="mj-column-per-100 mj-outlook-group-fix"
								style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
								<table border="0" cellpadding="0" cellspacing="0" role="presentation"
									style="vertical-align:top;" width="100%">
									<tr>
										<td align="center"
											style="font-size:0px;padding:10px 25px;padding-bottom:0px;word-break:break-word;">
											<table border="0" cellpadding="0" cellspacing="0" role="presentation"
												style="border-collapse:collapse;border-spacing:0px;">
												<tbody>
													<tr>
														<td style="width:100px;">
															<img height="auto" src="{{armonLogo}}"
																style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
																width="100" />
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
									<tr>
										<td align="left"
											style="font-size:0px;padding:10px 25px;padding-top:0px;padding-bottom:0px;word-break:break-word;">
											<div
												style="font-family:Segoe UI, Arial, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#55575d;">
											<p
												style="line-height: 16px; text-align: center; margin: 10px 0;font-size:8px;color:#A7A7A7;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
												This notification was sent via the ARMON access control system.<br/>
												If you do not want to receive this notification,<a href={{{unsubscribeType}}}> click here </a>.<br/>
												If you do not want to receive email from Armon,<a href={{{unsubscribeEmail}}}> click here </a>.<br/>
												<span style="color:#A7A7A7;font-family:'Times New Roman',Helvetica,Arial,sans-serif">armon © {{{year}}} </span>
											</p>
											</div>
										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</body>

</html>`;
            result.html = handlebars.compile(html)(notificationContext);
        }
        return result;
    }
}
