"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemsanAccessLogsCustomReport = exports.generateReport = void 0;
const path = __importStar(require("path"));
const uuid_1 = __importDefault(require("uuid"));
const lodash_1 = __importDefault(require("lodash"));
const app_config_1 = require("../../../app.config");
const i18n_1 = __importDefault(require("i18n"));
const moment_1 = __importDefault(require("moment"));
const dal_manager_1 = require("../../../dal/dal.manager");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const exceljs_1 = __importDefault(require("exceljs"));
const api_error_1 = require("../../../api/api.error");
const generator_1 = require("../../../business/report/generator");
const report_util_1 = require("../../../business/report/report.util");
var Constants;
(function (Constants) {
    Constants.DateFormat = "dd.mm.yyyy";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
})(Constants || (Constants = {}));
async function generateReport(request, locale) {
    const report = new TemsanAccessLogsCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
class TemsanAccessLogsCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._requestFilter = request.filter;
        this._filter = {
            userIds: this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserIdFromFreeSearch).value,
            userGroupIds: this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
            organizationUnitIds: this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
            filterOrganizationUnitMembersHierarchically: this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
            sortDateDesc: true,
            startUtc: (0, moment_1.default)(this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay)
                .startOf("day")
                .toDate(),
            endUtc: (0, moment_1.default)(this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay)
                .endOf("day")
                .toDate(),
        };
        this._fileId = uuid_1.default.v4();
        this._filePath = path.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        this._currentDate = (0, moment_1.default)();
        this._wb = new exceljs_1.default.stream.xlsx.WorkbookWriter({
            filename: this._filePath,
            useStyles: true,
            useSharedStrings: true,
        });
        this._isEmpty = true;
    }
    async generateReport() {
        this._organizationName = (await dal_manager_1.dbManager.accessRedisCache.getOrganizationCache({ organizationId: this._request.organizationId })).n;
        app_logs_1.logger.debug("Organization Name : " + this._organizationName);
        this._ws = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._ws.properties.defaultRowHeight = 15;
        this._rowIndex = 8;
        let requestedUserCaption = (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: this._request.organizationId, userId: this._request.requesterUserId })).caption;
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        this._requestedUserCaption = requestedUserCaption[0].text[0];
        app_logs_1.logger.debug("Requested User : " + this._requestedUserCaption);
        this._wb.creator = this._requestedUserCaption;
        await this.addFilterToSheet(this._ws, 1, 1);
        this.initSheet(this._ws, 7, 1);
        app_logs_1.logger.debug("Generating report...");
        await this.constructExcel();
        app_logs_1.logger.debug("end of fetching");
        this._ws.pageSetup.printArea = "A1:" + this._ws.getColumn(this._ws.columns.length).letter + this._rowIndex;
        this._ws.pageSetup.printTitlesRow = "7:7";
        await this._wb.commit();
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return {
            preparedReportId: this._fileId,
            filePath: this._filePath,
            format: app_enums_1.enums.ReportFormat.Excel,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.AccessLogs,
            sendFileInAttachments: undefined,
            reportContainsEmptyData: this._request.reportTemplateId ? this._isEmpty : undefined,
        };
    }
    setDataCell(params) {
        let c = params.ws.getCell(params.rowIndex, params.colIndex);
        c.value = params.value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
    }
    async addFilterToSheet(ws, startRowIndex, startColIndex) {
        let border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        let filterResult = await this.createFilters();
        let filtersArr = [];
        if (filterResult.accessResult) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.STATUS", locale: this._locale }) + " : " + filterResult.accessResult);
        }
        if (filterResult.direction) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.DIRECTION", locale: this._locale }) + " : " + filterResult.direction);
        }
        if (filterResult.users) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.IDENTITES", locale: this._locale }) + " : " + filterResult.users);
        }
        if (filterResult.organizationUnits) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + filterResult.organizationUnits);
        }
        if (filterResult.accessControlPoints) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_CONTROL_POINTS", locale: this._locale }) + " : " + filterResult.accessControlPoints);
        }
        if (filterResult.accessReasons) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_REASONS", locale: this._locale }) + " : " + filterResult.accessReasons);
        }
        if (filterResult.titleCredential) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.TITLE_CREDENTIAL", locale: this._locale }) + " : " + filterResult.titleCredential);
        }
        if (this._filter.showOnlyVisitors) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_LOGS_ONLY_VISITORS", locale: this._locale }) + " : " + filterResult.showOnlyVisitors);
        }
        if (this._filter.showOnlyExitButtons) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_LOGS_ONLY_EXIT_BUTTONS", locale: this._locale }) + " : " + filterResult.showOnlyExitButtons);
        }
        if (this._filter.showOnlyRemoteAccess) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_LOGS_ONLY_REMOTE_ACCESS", locale: this._locale }) + " : " + filterResult.showOnlyRemoteAccess);
        }
        if (this._filter.showOnlyManuallyInserted) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_LOGS_ONLY_MANUALLY_INSERTED", locale: this._locale }) + " : " + filterResult.showOnlyManuallyInserted);
        }
        if (filterResult.manualCreator) {
            filtersArr.push(i18n_1.default.__({ phrase: "REPORT.ACCESS_LOGS_MANUAL_LOG_CREATOR", locale: this._locale }) + " : " + filterResult.manualCreator);
        }
        if (filtersArr.length === 0) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.NOT_EXISTING", locale: this._locale }));
        }
        app_logs_1.logger.debug("Applied Filters:");
        app_logs_1.logger.debug(filtersArr);
        app_logs_1.logger.debug(filtersArr.join("\r\n"));
        app_logs_1.logger.debug("\n");
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationName + " " + i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS", locale: this._locale }), border, {
            bold: true,
        });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.FILE_CREATION_DATE", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, this._currentDate.locale(this._locale).format("LL") + " " + this._currentDate.locale(this._locale).format("HH:mm:ss"), border, { italic: false });
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.REQUESTED_USER", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 1, this._requestedUserCaption, border);
        this.addFilterCell(ws, startRowIndex + 3, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE_REPORT_BELONGS_TO", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 3, startColIndex + 1, filterResult.date, border);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
        ws.mergeCells(startRowIndex + 3, startColIndex + 1, startRowIndex + 3, startColIndex + 2);
        ws.mergeCells(startRowIndex + 4, startColIndex + 1, startRowIndex + 4, startColIndex + 2);
        this.addFilterCell(ws, startRowIndex + 4, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.APPLIED_FILTERS", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 4, startColIndex + 1, filtersArr.join("\r\n"), border);
        let filterlength = filtersArr.length;
        let row = ws.getRow(startRowIndex + 4);
        row.height = filterlength * 20;
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
    addInitCell(ws, row, col, value, border) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    initSheet(ws, startRowIndex, startColIndex) {
        let columns = [];
        this.addInitCell(ws, startRowIndex, startColIndex++, "Sicil No.", Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(ws, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS_USER", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(ws, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS_ACCESS_TIME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(ws, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS_ACCESS_POINT", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(ws, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS_ORG_UNIT", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        ws.autoFilter = {
            from: "A" + startRowIndex,
            to: ws.getColumn(columns.length).letter + startRowIndex,
        };
        ws.columns = columns;
        ws.views.push({ state: "frozen", ySplit: startRowIndex, activeCell: "A1", showGridLines: false });
    }
    async createFilters() {
        let date;
        if (this._filter.startUtc != null && this._filter.endUtc) {
            date =
                (0, moment_1.default)(this._filter.startUtc).locale(this._locale).format("LL") +
                    " " +
                    (0, moment_1.default)(this._filter.startUtc).locale(this._locale).format("HH:mm:ss") +
                    " - " +
                    (0, moment_1.default)(this._filter.endUtc).locale(this._locale).format("LL") +
                    " " +
                    (0, moment_1.default)(this._filter.endUtc).locale(this._locale).format("HH:mm:ss");
        }
        else if (this._filter.startUtc != null) {
            date = (0, moment_1.default)(this._filter.startUtc).locale(this._locale).format("LL") + " " + (0, moment_1.default)(this._filter.startUtc).locale(this._locale).format("HH:mm:ss");
        }
        let accessResult;
        if (this._filter.accessResult) {
            let key = report_util_1.ReportConstants.AccessResultTypes.filter((item) => this._filter.accessResult === item.type);
            accessResult = i18n_1.default.__({ phrase: key.description, locale: this._locale });
        }
        let direction;
        if (this._filter.direction) {
            let key = report_util_1.ReportConstants.Direction.filter((item) => this._filter.direction === item.type);
            direction = i18n_1.default.__({ phrase: key.description, locale: this._locale });
        }
        let filterResult = await dal_manager_1.dbManager.accessReport.collectAccessLogReportFilterInfo(this._filter.userIds, this._filter.userGroupIds, this._filter.organizationUnitIds, this._filter.accessControlPointIds, this._filter.regionIds, this._request.organizationId);
        let users;
        if (filterResult.userCaptions != null && filterResult.userCaptions.length > 0) {
            let _res = "";
            filterResult.userCaptions.forEach((userCaption, index) => {
                _res += "";
                userCaption.captionLines.forEach((item, _index) => {
                    if (item.text != null && item.text != "__avatar") {
                        item.text.forEach((element) => {
                            if (element != null)
                                _res += element + (_index < filterResult.userCaptions.length - 1 ? " " : "");
                        });
                    }
                });
                _res += index < filterResult.userCaptions.length - 1 ? "\r\n" : "";
            });
            users = _res;
        }
        let userGroups;
        if (filterResult.userGroups != null && filterResult.userGroups.length > 0) {
            let res = "";
            filterResult.userGroups.forEach((userGroup, index) => {
                res += userGroup.name + (index < filterResult.userGroups.length - 1 ? "\r\n" : " ");
            });
            userGroups = res;
        }
        let organizationUnits;
        if (filterResult.organizationUnits != null && filterResult.organizationUnits.length > 0) {
            let res = "";
            filterResult.organizationUnits.forEach((org, index) => {
                res += org.name + (index < filterResult.organizationUnits.length - 1 ? "\r\n" : " ");
            });
            organizationUnits = res;
        }
        let accessControlPoints;
        if (filterResult.accessControlPoints != null && filterResult.accessControlPoints.length > 0) {
            let res = "";
            filterResult.accessControlPoints.forEach((acp, index) => {
                res += acp.name + (index < filterResult.accessControlPoints.length - 1 ? "\r\n" : " ");
            });
            accessControlPoints = res;
        }
        let accessReasons;
        if (this._filter.reasons != null && this._filter.reasons.length > 0) {
            let res = "";
            this._filter.reasons.forEach((reason, index) => {
                let key = report_util_1.ReportConstants.AccessLogReason.filter((item) => reason === item.type);
                res += i18n_1.default.__({ phrase: key.description, locale: this._locale }) + (index < this._filter.reasons.length - 1 ? "\r\n" : " ");
            });
            accessReasons = res;
        }
        let titleCredential;
        if (this._filter.credentialData != null && this._filter.credentialData != "") {
            titleCredential = this._filter.credentialData;
        }
        let showOnlyVisitors = i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: this._locale });
        if (this._filter.showOnlyVisitors) {
            showOnlyVisitors = i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale });
        }
        let showOnlyExitButtons = i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: this._locale });
        if (this._filter.showOnlyExitButtons) {
            showOnlyExitButtons = i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale });
        }
        let showOnlyRemoteAccess = i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: this._locale });
        if (this._filter.showOnlyRemoteAccess) {
            showOnlyRemoteAccess = i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale });
        }
        let showOnlyManuallyInserted = i18n_1.default.__({ phrase: "EXCEL-REPORT.NO", locale: this._locale });
        if (this._filter.showOnlyManuallyInserted) {
            showOnlyManuallyInserted = i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale });
        }
        let manualCreator;
        if (this._filter.manualRecordCreatorUserId) {
            const userCaptions = (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: this._request.organizationId, userId: this._filter.manualRecordCreatorUserId }))
                .caption;
            if (userCaptions.length > 0) {
                manualCreator = userCaptions[0].text[0];
            }
        }
        return {
            date: date,
            accessResult: accessResult,
            direction: direction,
            filterResult: filterResult,
            users: users,
            userGroups: userGroups,
            organizationUnits: organizationUnits,
            accessControlPoints: accessControlPoints,
            titleCredential: titleCredential,
            showOnlyVisitors: showOnlyVisitors,
            showOnlyExitButtons: showOnlyExitButtons,
            showOnlyRemoteAccess: showOnlyRemoteAccess,
            showOnlyManuallyInserted: showOnlyManuallyInserted,
            accessReasons: accessReasons,
            manualCreator: manualCreator,
        };
    }
    async constructExcel() {
        if (this._filter.authorizeForFilter) {
            let authResultForFilter = await dal_manager_1.dbManager.accessFunctions.dbFuncAuthorizeUserFor({
                organizationId: this._request.organizationId,
                userId: this._request.requesterUserId,
                organizationUnitIds: this._filter.organizationUnitIds,
                accessControlPointIds: this._filter.accessControlPointIds,
                userIds: this._filter.userIds,
                userGroupIds: this._filter.userGroupIds,
            });
            if (!authResultForFilter.result) {
                throw (0, api_error_1.generateForbiddenError)({ message: "Unauthorized filter items" });
            }
            if (lodash_1.default.isEmpty(this._filter.organizationUnitIds) && lodash_1.default.isEmpty(this._filter.userGroupIds) && lodash_1.default.isEmpty(this._filter.userIds)) {
                this._filter.organizationUnitIds = this._filter.permittedUnitIds;
                if (this._filter.organizationUnitIds.length > 0) {
                    this._filter.filterOrganizationUnitMembersHierarchically = true;
                }
            }
        }
        let filterUsers = await dal_manager_1.dbManager.accessFunctions.dbFuncCollectUsersForAccessReportFilter({
            organizationId: this._request.organizationId,
            userIds: this._filter.userIds,
            organizationUnitIds: this._filter.organizationUnitIds,
            userGroupIds: this._filter.userGroupIds,
            filterOrganizationUnitMembersHierarchically: this._filter.filterOrganizationUnitMembersHierarchically,
        });
        let filterUserIds = (filterUsers && filterUsers.length) > 0 ? filterUsers.map((f) => f.userId) : [];
        this._filter.userIds = filterUserIds;
        const option = Object.assign(this._filter, {
            take: app_config_1.appConfig.reportExportRowLimit,
            skip: undefined,
        });
        await dal_manager_1.dbManager.accessAccessLog.getAccessLogsReportNew(this._request.organizationId, option, async (rows) => {
            app_logs_1.logger.debug("[AccessLogsReport]Fetch data %s rows", rows.items.length);
            this.constructRows(rows);
            this._isEmpty = rows.items.length > 0;
        });
        (0, report_util_1.styleExcelWorksheet)(this._ws, this._locale);
    }
    createCellForIdentity(record, locale) {
        let result = "";
        let caption;
        if (record.userCaptions != null && record.userCaptions.length > 0)
            caption = (0, report_util_1.parseCaptionForExcel)(record.userCaptions);
        else {
            if (record.identity && !record.userCaptions) {
                result += record.identity.organizationUnits;
            }
            else {
                result += "";
            }
            if (!record.identity && !record.isExitButton) {
                result += i18n_1.default.__({ phrase: "PDF-REPORT.unknown_identity", locale });
            }
            if (!record.identity && record.isExitButton) {
                result += i18n_1.default.__({ phrase: "PDF-REPORT.identity_exit_button", locale });
            }
            if (!record.identity && !record.isExitButton && record.unknownCredentialData) {
                result += "-" + record.unknownCredentialData;
            }
        }
        return {
            result: result,
            caption: caption,
        };
    }
    createCellForAccessTime(record, locale) {
        if (record && record.utc) {
            let date = (0, moment_1.default)(record.utc);
            return (0, moment_1.default)(date).locale(this._locale).format("LL") + " " + (0, moment_1.default)(date).locale(this._locale).format("HH:mm:ss");
        }
        else {
            return "";
        }
    }
    createCellForAccessPoint(record, locale) {
        let visual = "";
        let counterSensorData = "";
        let statusSensorData = "";
        return {
            an: record.accessControlPoint != null && record.accessControlPoint.name != null ? record.accessControlPoint.name : "",
            visual: visual,
            counterSensorData: counterSensorData,
            statusSensorData: statusSensorData,
        };
    }
    createCellForUserGroups(record) {
        let result = "";
        if (record.identity == null)
            return result;
        let userGroups = record.identity.userGroups;
        if (userGroups == null || userGroups.length == 0)
            return result;
        userGroups.forEach((userGroup) => {
            result += userGroup.name + "\r\n";
        });
        return result;
    }
    createCellForOrganizationUnits(record) {
        let result = "";
        if (record.identity == null)
            return result;
        let organizationUnits = record.identity.organizationUnits;
        if (organizationUnits == null || organizationUnits.length == 0)
            return result;
        organizationUnits.forEach((org) => {
            result += org.name + "\r\n";
        });
        return result;
    }
    createCellForStatus(record, locale) {
        let log = "";
        if (record.isVisitor) {
            log += i18n_1.default.__({ phrase: "PDF-REPORT.log_visitor", locale }) + "\r\n";
        }
        if (record.isRemoteAccess) {
            log += i18n_1.default.__({ phrase: "PDF-REPORT.log_remote_access", locale }) + "\r\n";
        }
        if (record.isManuallyLogged) {
            log += i18n_1.default.__({ phrase: "PDF-REPORT.log_manual", locale }, { manualCreator: record.manualRecordCreatorCaptions[0].text[0] }) + "\r\n";
        }
        if (record.isExitButton) {
            log += i18n_1.default.__({ phrase: "PDF-REPORT.log_exit_button", locale }) + "\r\n";
        }
        let translationKey = this.getStatusDescription(record.result, record.direction);
        let isSuccess = this.isSuccess(record);
        let credentialDescription = "";
        if (record.credentials && record.credentials.length > 0) {
            let visibleCredentialData = [];
            record.credentials.forEach((credential) => {
                visibleCredentialData.push((0, report_util_1.getCredentialDataVisibility)(credential.type));
            });
            record.credentials.forEach((credential, index) => {
                let credentialType = report_util_1.ReportConstants.CredentialTypes.find((item) => item.type === credential.type);
                credentialDescription += "\r\n" + i18n_1.default.__({ phrase: "PDF-REPORT." + credentialType.description, locale }) + " ";
                if (credential.data && visibleCredentialData[index]) {
                    credentialDescription += "(" + credential.data + ")";
                }
                if (record.mobileAuthenticated) {
                    credentialDescription += "\r\n" + i18n_1.default.__({ phrase: "EXCEL-REPORT.MOBILE_AUTHENTICATED", locale });
                }
            });
        }
        return {
            statusColor: this.getStatusColor(isSuccess),
            description: record.accessControlPoint != null && record.accessControlPoint.name != null
                ? i18n_1.default.__({ phrase: "PDF-REPORT." + translationKey, locale }, {
                    an: record.accessControlPoint.name,
                })
                : i18n_1.default.__({ phrase: "PDF-REPORT." + translationKey, locale }),
            log: log,
            statusInfo: (0, report_util_1.getAccessLogStatusInfo)(record.direction, this._locale, isSuccess),
            credentialDescription: credentialDescription,
        };
    }
    isSuccess(record) {
        return record.result === app_enums_1.enums.AccessLogReason.Success || (record.isManuallyLogged && record.result === app_enums_1.enums.AccessLogReason.Manual);
    }
    getStatusColor(isSuccess) {
        return isSuccess ? "#62A420" : "#E62700";
    }
    getStatusDescription(result, direction) {
        return (0, report_util_1.getDescriptionAccessLogItem)(result, direction);
    }
    constructRows(rows) {
        rows.items.forEach((record) => {
            let cellForIdentity = this.createCellForIdentity(record, this._locale);
            let cellForAccessTime = this.createCellForAccessTime(record, this._locale);
            let cellForAccessPoint = this.createCellForAccessPoint(record, this._locale);
            let cellForStatus = this.createCellForStatus(record, this._locale);
            let cellForUserGroups = this.createCellForUserGroups(record);
            let cellForOrganizationUnits = this.createCellForOrganizationUnits(record);
            this.addRowToGeneralWorksheet(this._ws, cellForIdentity, cellForAccessTime, cellForAccessPoint, cellForStatus, cellForUserGroups, cellForOrganizationUnits);
        });
    }
    addRowToGeneralWorksheet(worksheet, cellForIdentity, cellForAccessTime, cellForAccessPoint, cellForStatus, cellForUserGroups, cellForOrganizationUnits) {
        let identity = cellForIdentity.caption != null ? cellForIdentity.caption : cellForIdentity.result;
        let accessTime = cellForAccessTime;
        let acp = cellForAccessPoint.an;
        let result = cellForStatus.statusInfo;
        let description = cellForStatus.description + "\r\n" + cellForStatus.log;
        let credentialDescription = cellForStatus.credentialDescription;
        let colIndex = 1;
        this.setDataCell({
            rowIndex: this._rowIndex,
            colIndex: colIndex++,
            value: (identity.split("\r\n")[1] ?? ""),
            ws: worksheet,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._rowIndex,
            colIndex: colIndex++,
            value: (identity.split("\r\n")[0] ?? ""),
            ws: worksheet,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._rowIndex,
            colIndex: colIndex++,
            value: (accessTime ?? ""),
            ws: this._ws,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._rowIndex,
            colIndex: colIndex++,
            value: (acp ?? ""),
            ws: this._ws,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._rowIndex,
            colIndex: colIndex++,
            value: (cellForOrganizationUnits ?? ""),
            ws: this._ws,
            border: Constants.Styling.Dotted,
        });
        this._ws.getRow(this._rowIndex).commit();
        this._rowIndex++;
    }
}
exports.TemsanAccessLogsCustomReport = TemsanAccessLogsCustomReport;
