"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemsanPPermissionHizmetAlimCustomReport = exports.generateReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_constants_1 = require("../../../dal/dal.constants");
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
const controller_report_1 = require("../../../api/pacs/v2/controllers/controller.report");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
            top: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.RightThick = {
            right: {
                style: "thick",
            },
        };
        Styling.AllThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thick",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thick",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
})(Constants || (Constants = {}));
async function generateReport(request, locale) {
    let report = new TemsanPPermissionHizmetAlimCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
class TemsanPPermissionHizmetAlimCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._wb = new exceljs_1.default.Workbook();
        this._request = request;
        this._filter = request.filter;
        this._options = {
            date: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateDay).value).startOf("day"),
            organizationId: request.organizationId,
            requesterUserId: request.requesterUserId,
            locale: locale,
        };
        this._ppermissionTypeGroups = [
            {
                groupName: "Görevli",
                ppermissionTypeIds: [
                    "7e0d63d9-9f31-4712-a743-9f85f049bbe3",
                    "224719c5-56e7-45db-ad0e-ab0f50e59368",
                    "0d25d0ea-0dae-41c6-ad08-2cdf514bfec8",
                    "fd8eae61-2af8-4f19-a0c9-863fd7037727",
                    "40756baa-08d0-4ecb-b90d-72d726e3ddc5",
                ],
            },
            {
                groupName: "Hastanede",
                ppermissionTypeIds: ["90e72b0d-c6ad-4f89-8e19-e14d25e81e6d"],
            },
            {
                groupName: "Mazaret İzinli",
                ppermissionTypeIds: [
                    "aff7fbac-18bb-4baa-8ffe-3de027fce639",
                    "aac57c1f-6f4a-4591-baff-292fb6804012",
                    "fb045e21-ea2e-4a4b-ba1e-337b9aab76a5",
                    "2a1a2b06-ca6f-411b-9047-c59557bdea75",
                    "c02cbe47-ad6f-40ef-97e1-456dc5f045cf",
                    "ae262845-093b-4894-a010-6970b89f2229",
                    "2b107311-9bbc-4f7c-b990-d7100bbabd9b",
                    "6fde0e96-150c-4b83-a731-75110cf9cfaa",
                    "a6800149-615e-44e2-bab5-15ef6b628a7c",
                    "72d6b877-8c60-4a12-8bc5-1685b4ff5cbc",
                    "f85d1e35-2937-4fcb-bb40-50a24fdf9a64",
                    "6c3639cc-0316-410f-9836-706d22751c9b",
                    "872eebe2-cf51-4ad7-b82c-89390ce5270e",
                    "8b517be8-d546-4d55-9cc6-20a65c39f780",
                    "56de10ee-7b75-4047-b235-c48736d0e2e8",
                    "8fa57e39-5a5b-4b73-88a6-ccbffc8c9abf",
                    "05c1c0a2-c87b-4839-a613-da3695ce9171",
                    "0347ec0d-be95-48d1-ae10-8e1b3213c689",
                    "5ec0cd76-fd30-49c1-8f02-c9c277d8d672",
                    "1776b27c-3a02-4366-817a-d860bc4944dc",
                ],
            },
            {
                groupName: "Raporlu",
                ppermissionTypeIds: ["0cda96b8-94ea-48f4-aded-06f57562e3c3"],
            },
            {
                groupName: "Yıllık İzinli",
                ppermissionTypeIds: ["af339686-c4d9-4590-9053-51d6317450bb"],
            },
            {
                groupName: "Ücretsiz İzinli",
                ppermissionTypeIds: ["49f1f979-c6ae-4a8f-8fcd-3f559e7835fa"],
            },
        ];
        this._userGroupIds = [
            { name: "DYBTEM", id: "20e670de-f63b-4a71-8011-6aef175e8fea" },
            { name: "GMTEM", id: "aa3b122b-6a29-43ac-b321-74164281739f" },
            { name: "DYBGUV", id: "291e0edf-1b18-4785-9cfd-b0b2cd810186" },
            { name: "GMGUV", id: "ca2e6bb9-7d23-4406-88a1-24d581b53e32" },
            { name: "DYBSOF", id: "da1de158-693c-464e-b968-708b7efef8e4" },
            { name: "GMSOF", id: "c3b3ed64-aec7-46a7-861a-fcc89f3b280d" },
            { name: "GMYEM", id: "83f0dcc4-3a73-41fc-b05d-7825c3e041d7" },
            { name: "DYBYEM", id: "5f9a73e2-7a3c-427d-844b-b66e9c1cba95" },
            { name: "GMCAY", id: "9bb4a864-e2a6-481b-8763-5c3f15a47974" },
        ];
    }
    async generateReport() {
        app_logs_1.logger.info("Generating custom report");
        if ((0, moment_1.default)(this._options.date).isSame((0, moment_1.default)(), "day")) {
            await (0, controller_report_1.refreshUsersSummaryForToday)({
                requesterUserId: this._options.requesterUserId,
                userGroupIds: this._userGroupIds.map((i) => i.id),
                organizationId: this._options.organizationId,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
            });
        }
        this._usersWithUserGroups = await dal_manager_1.dbManager.accessUserGroup.listUserGroupsForControlPanel(this._request.organizationId);
        this._data = await dal_manager_1.dbManager.accessPacs2.workSummaryOfFilteredEmployeesAtDate(this._options.requesterUserId, this._options.organizationId, {
            date: this._options.date.toDate(),
            paginationRequest: { take: 500, skip: 0 },
            sortType: dal_constants_1.DalConstants.WorkSummarySortType.Name,
            sortOrder: "DESC",
            userFilter: {
                userGroupIds: this._userGroupIds.map((i) => i.id),
            },
        });
        this._filePath = await this.generate();
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
            sendFileInAttachments: undefined,
            customReportName: "TEMSAN HİZMET ALIM PERSONEL YOKLAMASI",
        };
    }
    async generate() {
        this._organizationBasic = await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._request.organizationId);
        this._wsGeneral = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this.addFilterToSheet(this._wsGeneral, 1, 1);
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 6;
        this._wsGeneral.headerFooter.oddHeader =
            "&L" +
                this._organizationBasic.name +
                " " +
                " HİZMET ALIM PERSONEL YOKLAMASI " +
                "\n" +
                "&R" +
                i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: this._locale }) +
                " : " +
                this._options.date.clone().locale(this._locale).format("LL") +
                +"\n";
        this._wsGeneral.headerFooter.oddFooter = i18n_1.default.__({ phrase: "EXCEL-REPORT.PAGE", locale: this._locale }) + " &P / &N" + "&R" + "&D  &T";
        let requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._request.organizationId, [this._request.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Requester user not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        this.addRowsTotalPersonnel();
        this.addRowsAbsentPersonnel();
        this.listPPermissions();
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + this._generalRowIndex;
        this._wsGeneral.pageSetup.printTitlesRow = "5:5";
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.info("File is ready -> " + this._filePath);
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        let columns = [];
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "" });
        columns.push({ width: 20 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "Temizlik", border: Constants.Styling.AllThin, backgroundColorCode: "C5C5C5" });
        columns.push({ width: 20 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "Kiralık Araç Şoförleri", border: Constants.Styling.AllThin, backgroundColorCode: "C5C5C5" });
        columns.push({ width: 20 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "Yemekhane", border: Constants.Styling.AllThin, backgroundColorCode: "C5C5C5" });
        columns.push({ width: 20 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "Güvenlik", border: Constants.Styling.AllThin, backgroundColorCode: "C5C5C5" });
        columns.push({ width: 20 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "Diğer", border: Constants.Styling.AllThin, backgroundColorCode: "C5C5C5" });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        columns.push({ width: 20 });
        wsRaw.columns = columns;
        wsRaw.views = [{ activeCell: "A1", showGridLines: false }];
    }
    listPPermissions() {
        let colIndex = 1;
        this._generalRowIndex++;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "İş Yeri Dışındaki Personel İsim Listesi",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex, this._generalRowIndex, colIndex + 14);
        this._generalRowIndex++;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "Temizlik",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex - 1, this._generalRowIndex, colIndex + 1);
        colIndex += 2;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "Kiralık Araç Şoförleri",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex - 1, this._generalRowIndex, colIndex + 1);
        colIndex += 2;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "Yemekhane",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex - 1, this._generalRowIndex, colIndex + 1);
        colIndex += 2;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "Güvenlik",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex - 1, this._generalRowIndex, colIndex + 1);
        colIndex += 2;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "Diğer",
            border: Constants.Styling.AllThinButRightThick,
            backgroundColorCode: "A5A5A5",
            isBold: true,
            inMiddle: true,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex - 1, this._generalRowIndex, colIndex + 1);
        this._generalRowIndex++;
        let maxRow = 0;
        for (let i = 0; i < this._ppermissionTypeGroups.length; i++) {
            const ppermissionGroup = this._ppermissionTypeGroups[i];
            colIndex = 1;
            this._generalRowIndex += maxRow;
            const userGroupsIds = this._userGroupIds.map((i) => i.id);
            for (let i = 0; i < userGroupsIds.length; i += 2) {
                this.setDataCell({
                    rowIndex: this._generalRowIndex,
                    colIndex: colIndex,
                    value: ppermissionGroup.groupName,
                    ws: this._wsGeneral,
                    backgroundColorCode: "C5C5C5",
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex,
                    colIndex: colIndex + 1,
                    value: "Açıklama",
                    ws: this._wsGeneral,
                    backgroundColorCode: "C5C5C5",
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex,
                    colIndex: colIndex + 2,
                    value: "Dönüş Tarihi",
                    ws: this._wsGeneral,
                    backgroundColorCode: "C5C5C5",
                    border: Constants.Styling.AllThinButRightThick,
                });
                const groupIds = [userGroupsIds[i]];
                if (i + 1 < userGroupsIds.length) {
                    groupIds.push(userGroupsIds[i + 1]);
                }
                let userIdsOfUserGroup = this._usersWithUserGroups.find((ug) => ug.userGroupId === groupIds[0])?.userIds ?? [];
                if (groupIds.length > 1) {
                    userIdsOfUserGroup = userIdsOfUserGroup.concat(this._usersWithUserGroups.find((ug) => ug.userGroupId === groupIds[1])?.userIds ?? []);
                }
                const usersData = this._data.items.filter((d) => userIdsOfUserGroup.includes(d.userId));
                const allAbsentPersonnelData = usersData.filter((ud) => !ud.firstStart && !ud.normalWorkDuration);
                const userList = allAbsentPersonnelData.filter((pd) => pd.usedPermissions?.find((p) => ppermissionGroup.ppermissionTypeIds.includes(p.typeId)));
                if (!userList || userList.length === 0) {
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex,
                        value: "Yok",
                        ws: this._wsGeneral,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex + 2,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.RightThick,
                    });
                }
                for (let i = 0; i < userList.length; i++) {
                    const userData = userList[i];
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1 + i,
                        colIndex: colIndex,
                        value: userData.userCaption[0].text[0],
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllThin,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1 + i,
                        colIndex: colIndex + 1,
                        value: userData.usedPermissions.find((p) => ppermissionGroup.ppermissionTypeIds.includes(p.typeId)).name,
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllThin,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1 + i,
                        colIndex: colIndex + 2,
                        value: userData.usedPermissions.find((p) => ppermissionGroup.ppermissionTypeIds.includes(p.typeId)).range.end.format("DD.MM.YY"),
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllThin,
                    });
                }
                colIndex += 3;
                maxRow = userList.length + 2;
            }
            colIndex = 3;
            for (let i = 1; i <= maxRow; i++) {
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex,
                    ws: this._wsGeneral,
                    border: Constants.Styling.RightThick,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex + 3,
                    ws: this._wsGeneral,
                    border: Constants.Styling.RightThick,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex + 6,
                    ws: this._wsGeneral,
                    border: Constants.Styling.RightThick,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex + 9,
                    ws: this._wsGeneral,
                    border: Constants.Styling.RightThick,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex + 12,
                    ws: this._wsGeneral,
                    border: Constants.Styling.RightThick,
                });
            }
        }
        colIndex = 1;
        const userGroupsIds = this._userGroupIds.map((i) => i.id);
        let maxAbsent = 0;
        for (let i = 0; i < userGroupsIds.length - 1; i += 2) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex,
                value: "Gelmeyen",
                ws: this._wsGeneral,
                backgroundColorCode: "C5C5C5",
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex + 1,
                value: "Açıklama",
                ws: this._wsGeneral,
                backgroundColorCode: "C5C5C5",
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex + 2,
                value: "Dönüş Tarihi",
                ws: this._wsGeneral,
                backgroundColorCode: "C5C5C5",
                border: Constants.Styling.AllThinButRightThick,
            });
            const group1 = userGroupsIds[i];
            const group2 = userGroupsIds[i + 1];
            const userIdsOfUserGroup = (this._usersWithUserGroups.find((ug) => ug.userGroupId === group1)?.userIds ?? []).concat(this._usersWithUserGroups.find((ug) => ug.userGroupId === group2)?.userIds ?? []);
            const usersData = this._data.items.filter((d) => userIdsOfUserGroup.includes(d.userId));
            const allAbsentPersonnelData = usersData.filter((ud) => !ud.firstStart && !ud.normalWorkDuration && ud.usedPermissions.length === 0);
            if (allAbsentPersonnelData.length > maxAbsent) {
                maxAbsent = allAbsentPersonnelData.length;
            }
            for (let i = 0; i < allAbsentPersonnelData.length; i++) {
                const userData = allAbsentPersonnelData[i];
                this.setDataCell({
                    rowIndex: this._generalRowIndex + 1 + i,
                    colIndex: colIndex,
                    value: userData.userCaption[0].text[0],
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + 1 + i,
                    colIndex: colIndex + 1,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + 1 + i,
                    colIndex: colIndex + 2,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
            }
            colIndex += 3;
        }
        colIndex = 3;
        for (let i = 1; i <= maxAbsent; i++) {
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex,
                ws: this._wsGeneral,
                border: Constants.Styling.RightThick,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex + 3,
                ws: this._wsGeneral,
                border: Constants.Styling.RightThick,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex + 6,
                ws: this._wsGeneral,
                border: Constants.Styling.RightThick,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex + 9,
                ws: this._wsGeneral,
                border: Constants.Styling.RightThick,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex + 12,
                ws: this._wsGeneral,
                border: Constants.Styling.RightThick,
            });
        }
    }
    addRowsAbsentPersonnel() {
        let colIndex = 1;
        this.setDataCell({
            rowIndex: this._generalRowIndex++,
            colIndex: colIndex,
            value: "DIŞ.PERSONEL",
            ws: this._wsGeneral,
            backgroundColorCode: "F35A15",
        });
        for (let i = 0; i < this._ppermissionTypeGroups.length; i++) {
            const group = this._ppermissionTypeGroups[i];
            this.setDataCell({
                rowIndex: this._generalRowIndex + i,
                colIndex: colIndex,
                value: group.groupName,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex + this._ppermissionTypeGroups.length,
            colIndex: colIndex,
            value: "Gelmeyen",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        colIndex++;
        const userGroupsIds = this._userGroupIds.map((i) => i.id);
        for (let i = 0; i < userGroupsIds.length; i += 2) {
            const selectedUserGroupIds = [userGroupsIds[i]];
            if (i + 1 < userGroupsIds.length) {
                selectedUserGroupIds.push(userGroupsIds[i + 1]);
            }
            const userGroupsDetails = this._usersWithUserGroups.filter((ug) => selectedUserGroupIds.includes(ug.userGroupId));
            let userIdsOfUserGroup = [];
            for (const data of userGroupsDetails) {
                userIdsOfUserGroup = userIdsOfUserGroup.concat(data?.userIds ?? []);
            }
            const usersData = this._data.items.filter((d) => userIdsOfUserGroup.includes(d.userId));
            const absentPersonnelData = usersData.filter((ud) => !ud.firstStart && !ud.normalWorkDuration);
            const camePersonnelData = usersData.filter((ud) => ud.firstStart && ud.normalWorkDuration > 0);
            for (let i = 0; i < this._ppermissionTypeGroups.length; i++) {
                const group = this._ppermissionTypeGroups[i];
                const userList = absentPersonnelData.filter((pd) => pd.usedPermissions?.find((p) => group.ppermissionTypeIds.includes(p.typeId)));
                this.setDataCell({
                    rowIndex: this._generalRowIndex + i,
                    colIndex: colIndex,
                    value: (userList.length ?? 0),
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
            }
            const absentPersonnelDataWithoutPPermissions = usersData.filter((ud) => !ud.firstStart && !ud.normalWorkDuration && ud.usedPermissions.length === 0);
            this.setDataCell({
                rowIndex: this._generalRowIndex + this._ppermissionTypeGroups.length,
                colIndex: colIndex,
                value: (absentPersonnelDataWithoutPPermissions.length ?? 0),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            colIndex++;
        }
        this._generalRowIndex += this._ppermissionTypeGroups.length + 1;
        colIndex = 1;
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: "TOPLAM",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        for (let i = 1; i <= 5; i++) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex,
                value: {
                    formula: "SUM(" +
                        this._wsGeneral.getRow(this._generalRowIndex - (this._ppermissionTypeGroups.length + 1)).getCell(colIndex).address +
                        ":" +
                        this._wsGeneral.getRow(this._generalRowIndex - 1).getCell(colIndex).address +
                        ")",
                },
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            colIndex++;
        }
        this._generalRowIndex++;
    }
    addRowsTotalPersonnel() {
        let colIndex = 1;
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "Toplam",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "Mevcut",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        const userGroupsIds = this._userGroupIds.map((i) => i.id);
        for (let i = 0; i < userGroupsIds.length; i += 2) {
            const selectedUserGroupIds = [userGroupsIds[i]];
            if (i + 1 < userGroupsIds.length) {
                selectedUserGroupIds.push(userGroupsIds[i + 1]);
            }
            const userGroupsDetails = this._usersWithUserGroups.filter((ug) => selectedUserGroupIds.includes(ug.userGroupId));
            let userIdsOfUserGroup = [];
            for (const data of userGroupsDetails) {
                userIdsOfUserGroup = userIdsOfUserGroup.concat(data?.userIds ?? []);
            }
            const usersData = this._data.items.filter((d) => userIdsOfUserGroup.includes(d.userId));
            const absentPersonnelData = usersData.filter((ud) => !ud.firstStart && !ud.normalWorkDuration);
            const camePersonnelData = usersData.filter((ud) => ud.firstStart && ud.normalWorkDuration > 0);
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex,
                value: (usersData?.length ?? 0),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex + 1,
                colIndex: colIndex++,
                value: (camePersonnelData?.length ?? 0),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
        }
        this._generalRowIndex += 3;
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        c.value = params.value ?? "";
        c.alignment = {
            horizontal: params.inMiddle ? "center" : "left",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: params.isBold || false,
        };
        if (params.border) {
            c.border = Object.assign(c.border ?? {}, params.border);
        }
        if (params.numFmt) {
            c.numFmt = params.numFmt;
        }
        if (params.backgroundColorCode) {
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        }
        if (params.textColor) {
            c.font = {
                color: { argb: params.textColor },
            };
        }
    }
    addInitCell(params) {
        let c = params.ws.getCell(params.row, params.col);
        c.value = params.value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.textColor) {
            c.font = {
                color: { argb: params.textColor },
            };
        }
        if (params.backgroundColorCode) {
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        }
    }
    addFilterToSheet(ws, startRowIndex, startColIndex) {
        let border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationBasic.name.toUpperCase() + " Hizmet Alım Personel Yoklaması", border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, this._options.date.clone().locale(this._locale).format("LL"), border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
}
exports.TemsanPPermissionHizmetAlimCustomReport = TemsanPPermissionHizmetAlimCustomReport;
