"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const joi_1 = __importDefault(require("joi"));
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
const metuSyncConfigSchema = joi_1.default.object({
    ...{
        BIDB_DB_HOST: joi_1.default.string().ip({ version: "ipv4" }).required(),
        BIDB_DB_PORT: joi_1.default.number().port().required(),
        BIDB_DB_NAME: joi_1.default.string().min(3).required(),
        BIDB_DB_USERNAME: joi_1.default.string().min(3).required(),
        BIDB_DB_PASSWORD: joi_1.default.string().min(3).required(),
        PGAPPNAME: joi_1.default.custom((value) => {
            process.env.PGAPPNAME = value;
            return value;
        }).default(() => {
            process.env.PGAPPNAME = "metu-sync";
            return process.env.PGAPPNAME;
        }),
        PGHOST: joi_1.default.custom((value) => {
            const error = joi_1.default.string().hostname().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGHOST = value;
            return value;
        }).default(() => {
            process.env.PGHOST = "127.0.0.1";
            return process.env.PGHOST;
        }),
        PGPORT: joi_1.default.custom((value) => {
            const error = joi_1.default.number().port().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGPORT = value;
            return parseInt(value);
        }).default(() => {
            process.env.PGPORT = "5432";
            return parseInt(process.env.PGPORT);
        }),
        PGUSER: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGUSER = value;
            return value;
        }).default(() => {
            process.env.PGUSER = "armonapi";
            return process.env.PGUSER;
        }),
        PGUSERPASSWORD: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGUSERPASSWORD = value;
            return value;
        }).required(),
        PGSUPERUSER: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGSUPERUSER = value;
            return value;
        }).default(() => {
            process.env.PGSUPERUSER = "armonsuper";
            return process.env.PGSUPERUSER;
        }),
        PGDATABASE: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.PGDATABASE = value;
            return value;
        }).default(() => {
            process.env.PGDATABASE = "armon";
            return process.env.PGDATABASE;
        }),
        NODE_ENV: joi_1.default.custom((value) => {
            process.env.NODE_ENV = value;
            return value;
        }).default(() => {
            process.env.NODE_ENV = "production";
            return process.env.NODE_ENV;
        }),
        LOG_DIRECTORY: joi_1.default.custom((value) => {
            process.env.LOG_DIRECTORY = value;
            return value;
        }).default(() => {
            process.env.LOG_DIRECTORY =
                os_1.default.platform() === "win32" ? path_1.default.resolve(process.env.APPDATA, "armon", "webapp", "log", "sync") : path_1.default.resolve("/", "var", "opt", "armon", "webapp", "log", "sync");
            return process.env.LOG_DIRECTORY;
        }),
        LOG_LEVEL: joi_1.default.custom((value) => {
            process.env.LOG_LEVEL = value;
            return value;
        }).default(() => {
            process.env.LOG_LEVEL = process.env.NODE_ENV === "development" ? "debug" : "info";
            return process.env.LOG_LEVEL;
        }),
        LOG_LAST_DAY_COUNT: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.LOG_LAST_DAY_COUNT = value;
            return value;
        }).default(() => {
            process.env.LOG_LAST_DAY_COUNT = "60";
            return process.env.LOG_LAST_DAY_COUNT;
        }),
        REDIS_HOST: joi_1.default.custom((value) => {
            const error = joi_1.default.string().hostname().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.REDIS_HOST = value;
            return value;
        }).default(() => {
            process.env.REDIS_HOST = "localhost";
            return process.env.REDIS_HOST;
        }),
        REDIS_PORT: joi_1.default.custom((value) => {
            const error = joi_1.default.number().port().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.REDIS_PORT = value;
            return parseInt(value);
        }).default(() => {
            process.env.REDIS_PORT = "6379";
            return parseInt(process.env.REDIS_PORT);
        }),
    },
});
class MetuSyncConfig {
    constructor() {
        const validation = metuSyncConfigSchema.validate(process.env, {
            allowUnknown: true,
        });
        if (validation.error) {
            throw validation.error;
        }
        const data = validation.value;
        Object.assign(this, data);
    }
}
const metuSyncConfig = new MetuSyncConfig();
exports.default = metuSyncConfig;
