"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BIDBGroupIdArmonGroupNameMapping = exports.ChangeOperation = exports.BIDBGroupId = exports.metuSyncTablenames = void 0;
exports.metuSyncTablenames = {
    T_User: "kisi",
    T_UserChange: "kisi_degisiklik",
    T_Validity: "gecerlilik",
    T_UserGroup: "kisi_rol",
    T_UserGroupChange: "kisi_rol_degisiklik",
    T_UserDetail: "kisi_yetki",
    T_UserDetailChange: "kisi_yetki_degisiklik",
    T_Group: "rol",
};
var BIDBGroupId;
(function (BIDBGroupId) {
    BIDBGroupId[BIDBGroupId["STUDENT"] = 1] = "STUDENT";
    BIDBGroupId[BIDBGroupId["GRADUATE"] = 2] = "GRADUATE";
    BIDBGroupId[BIDBGroupId["PERSONNEL"] = 3] = "PERSONNEL";
    BIDBGroupId[BIDBGroupId["RETIRED_PERSONNEL"] = 4] = "RETIRED_PERSONNEL";
    BIDBGroupId[BIDBGroupId["TEMPORARY_PERSONNEL"] = 5] = "TEMPORARY_PERSONNEL";
    BIDBGroupId[BIDBGroupId["PERSONNEL_RELATIVE"] = 6] = "PERSONNEL_RELATIVE";
    BIDBGroupId[BIDBGroupId["ACADEMIC_PERSONNEL"] = 7] = "ACADEMIC_PERSONNEL";
    BIDBGroupId[BIDBGroupId["ADMINISTRATIVE_PERSONNEL"] = 8] = "ADMINISTRATIVE_PERSONNEL";
})(BIDBGroupId = exports.BIDBGroupId || (exports.BIDBGroupId = {}));
var ChangeOperation;
(function (ChangeOperation) {
    ChangeOperation[ChangeOperation["DELETE"] = 0] = "DELETE";
    ChangeOperation[ChangeOperation["INSERT"] = 1] = "INSERT";
    ChangeOperation[ChangeOperation["UPDATE"] = 2] = "UPDATE";
})(ChangeOperation = exports.ChangeOperation || (exports.ChangeOperation = {}));
exports.BIDBGroupIdArmonGroupNameMapping = {
    [BIDBGroupId.STUDENT]: "Öğrenci",
    [BIDBGroupId.GRADUATE]: "Mezun - Yaya",
    [BIDBGroupId.PERSONNEL]: "Personel",
    [BIDBGroupId.RETIRED_PERSONNEL]: "Emekli Personel",
    [BIDBGroupId.TEMPORARY_PERSONNEL]: "Geçici Kamu Personeli",
    [BIDBGroupId.PERSONNEL_RELATIVE]: "Personel Yakını",
    [BIDBGroupId.ACADEMIC_PERSONNEL]: "Akademik",
    [BIDBGroupId.ADMINISTRATIVE_PERSONNEL]: "İdari",
};
