"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
if (!process.env.PGAPPNAME) {
    process.env.PGAPPNAME = "metu-sync";
}
const metu_synchronization_config_1 = __importDefault(require("./utils/metu.synchronization.config"));
const app_logs_1 = require("../../../app.logs");
app_logs_1.appLogger.init(metu_synchronization_config_1.default.LOG_DIRECTORY);
const business_sync_changes_1 = require("./service/business.sync-changes");
app_logs_1.logger.info(`METU Sync Service is starting...`);
app_logs_1.logger.info(`METU Sync config is loaded and validated`);
const commander_1 = __importDefault(require("commander"));
const utils_1 = require("./utils/utils");
const business_sync_full_1 = require("./service/business.sync-full");
const start = async () => {
    const cliArgs = parseSyncApplicationCliArguments();
    await (0, utils_1.initSyncOp)();
    if (cliArgs.fullSync) {
        await (0, business_sync_full_1.syncAllUsers)();
    }
    else {
        await (0, business_sync_changes_1.syncChanges)();
    }
    process.exit(0);
};
const parseSyncApplicationCliArguments = () => {
    const cliParams = commander_1.default.option("-f, --full-sync", "sync armon db against bidb db for all users").parse(process.argv);
    return cliParams;
};
start();
