"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CleanUnusablePreregistartionsScheduledJobId = exports.MetuAuditLogExporterScheduledJobId = exports.CreateHook = void 0;
const fs_1 = __importDefault(require("fs"));
const handlebars = __importStar(require("handlebars"));
const https_1 = __importDefault(require("https"));
const luxon_1 = require("luxon");
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
const strong_soap_1 = require("strong-soap");
const uuid_1 = __importDefault(require("uuid"));
const xml2js_1 = __importDefault(require("xml2js"));
const app_config_1 = require("../../../app.config");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const business_hooks_1 = require("../../../business/business.hooks");
const dal_access_error_1 = require("../../../dal/access/dal.access.error");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const messageBroker_server_to_device_pub_1 = require("../../../messageBroker/messageBroker.server-to-device.pub");
const messagebroker_models_1 = require("../../../messageBroker/messagebroker.models");
const dal_access_psql_organization_1 = require("../../../dal/access/psql/dal.access.psql.organization");
const hesCodeSecretId = "95d1778b-8005-4be9-8d4b-ec6269847ff4";
const studentInfoServiceSecretId = "fcc275d2-a760-41aa-a3ca-db3803204694";
const registrationPointExitACPMapping = {
    "d4b799c3-6a27-4098-a321-5eba04d7d953": "47eb5918-8e4c-40bd-85cb-2448c462bae7",
    "b75d1f7f-6392-4daa-b382-b579a4d1d524": "44ac227d-254a-4a22-8b1d-bb24ab710a05",
    "054ec65e-b938-449d-a003-ee666bfc284e": "05f7fbd0-7bb7-4403-b2eb-cc7f585a73e4",
    "7cda1ed8-de11-4688-888f-9e049d27c132": "da972a57-dce4-48dd-8a22-cafb9ac754fa",
    "9e5f03ec-6778-43dd-995f-e7142e8cb094": "3c5c5225-113e-430e-bb34-92c5ddb53bc0",
};
const registrationPointEntranceAcpMapping = {
    "b75d1f7f-6392-4daa-b382-b579a4d1d524": "17ae52aa-23ae-4121-af26-a7aa082bf21b",
    "d4b799c3-6a27-4098-a321-5eba04d7d953": "9b345370-8603-452d-b5bb-5f3dd1b05164",
    "7cda1ed8-de11-4688-888f-9e049d27c132": "de870706-c70b-427f-a273-ecaac68046db",
    "9e5f03ec-6778-43dd-995f-e7142e8cb094": "fc801b99-ded8-4e46-98a9-d89a3e12b0f4",
};
const visitorExitAccessControlPoints = [
    "443154de-ae74-4b22-8f88-50e40999cce6",
    "44ac227d-254a-4a22-8b1d-bb24ab710a05",
    "05f7fbd0-7bb7-4403-b2eb-cc7f585a73e4",
    "47eb5918-8e4c-40bd-85cb-2448c462bae7",
    "39930f7a-453e-4ad5-9764-11a12149db99",
    "da972a57-dce4-48dd-8a22-cafb9ac754fa",
    "307a876e-3116-461e-a77d-05766cf9ba4f",
    "3c5c5225-113e-430e-bb34-92c5ddb53bc0",
];
function CreateHook() {
    return new MetuHook();
}
exports.CreateHook = CreateHook;
exports.MetuAuditLogExporterScheduledJobId = "d15ce69d-56d9-4968-9ac8-bc9a4cf1d451";
exports.CleanUnusablePreregistartionsScheduledJobId = "5d202453-e1ac-461b-b48a-0fdd954ac63f";
class MetuHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.onPrepareVisitorCameEmailNotification = this.onPrepareVisitorCameEmailNotificationImplementation;
        this.customVisitGenericSearch = async function (params) {
            let result = {
                total: 0,
                items: [],
            };
            if (params.field != "reason")
                return Promise.resolve(result);
            let now = new Date();
            await dal_manager_1.dbManager.transaction(async (trx) => {
                let qb = trx.withSchema(params.organizationId).from("metu_calendar").where("startdate", "<=", now).where("enddate", ">=", now).whereNotNull("event");
                if (params.filter) {
                    qb.where("event", "ilike", "%" + params.filter + "%");
                }
                (await qb.limit(params.take).offset(params.skip).select("event")).forEach((e) => result.items.push({
                    id: e.event.toLocaleUpperCase(),
                    matchItem: null,
                    captionLines: [e.event.toLocaleUpperCase()],
                }));
                result.total = result.items.length;
            });
            return Promise.resolve(result);
        }.bind(this);
        this.customVisitorGenericSearch = async function (params) {
            let result = {
                total: 0,
                items: [],
            };
            if (params.filter.length < 5) {
                return Promise.resolve(result);
            }
            try {
                let studentInfo = await this.getStudentInfoServiceResult(params.filter, params.organizationId);
                if (!studentInfo || studentInfo.length < 1) {
                    app_logs_1.logger.info("no student Info");
                }
                if (studentInfo.length > 1) {
                    app_logs_1.logger.info("muliple student Info");
                }
                for (const student of studentInfo) {
                    if (student.status == "Null") {
                        result.items.push({
                            id: student.number,
                            matchItem: null,
                            captionLines: ["Bilinmeyen Numara " + "Durum: Bilinmiyor"],
                        });
                        continue;
                    }
                    if (student.graduationStatus == "Mezun" && student.status == "") {
                        result.items.push({
                            id: student.number,
                            matchItem: student.number,
                            captionLines: [student.name + " " + student.surname + " Durum: " + student.graduationStatus],
                        });
                        continue;
                    }
                    if (student.graduationStatus == "" && student.status == "") {
                        result.items.push({
                            id: student.number,
                            matchItem: student.number,
                            captionLines: [student.name + " " + student.surname + " Durum: Bilinmiyor"],
                        });
                        continue;
                    }
                    result.items.push({
                        id: student.number,
                        matchItem: null,
                        captionLines: [student.name + " " + student.surname + " Durum: " + student.status],
                    });
                }
            }
            catch (error) {
                app_logs_1.logger.error(`Error while searching `);
                app_logs_1.logger.error(error);
            }
            return Promise.resolve(result);
        }.bind(this);
        this.beforePreregisterVisit = async function (params) {
            let visitorProfileId = params.visitorProfileId;
            let licensePlate;
            let visitorProfileFields = params.visitorProfileFields ? params.visitorProfileFields : [];
            if (visitorProfileId) {
                let organizationVisitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId);
                let visitor = await dal_manager_1.dbManager.accessVisitor.getVisitor(params.organizationId, visitorProfileId, organizationVisitorModuleSettings);
                for (let key of Object.keys(visitor.fields)) {
                    visitorProfileFields.push({
                        name: key,
                        value: visitor.fields[key],
                    });
                }
            }
            const preregisterDate = luxon_1.DateTime.now();
            if ((preregisterDate.weekday < 6 && (preregisterDate.hour < 6 || preregisterDate.hour > 17 || (preregisterDate.hour === 17 && preregisterDate.minute > 30))) ||
                preregisterDate.weekday > 5) {
                const identityDetailed = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(params.organizationId, dal_constants_1.DalConstants.SystemUserId, {
                    userId: params.requesterUserId,
                    hasIdentityFullWrite: true,
                    hasOrganizationWideRight: true,
                    hasOrganizationWideRightToSeePassiveUsers: true,
                });
                if (!identityDetailed.userGroups.find((f) => ["Lojman", "Akademik", "Akademik Süreli"].includes(f.name))) {
                    (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.CUSTOM.ODTUPASS_PREREGISTER_PREVENTION", {}, false);
                }
            }
            licensePlate = visitorProfileFields.find((pair) => pair.name == "licencePlate").value;
            let existingUsersWithLicensePlate = await dal_manager_1.dbManager.accessUser.searchUsersByLicensePlate({ organizationId: params.organizationId, licensePlate: licensePlate });
            if (existingUsersWithLicensePlate.length == 0) {
                let activeVisitByLicensePlate = await dal_manager_1.dbManager.accessVisitor.isLicensePlateRegisteredByVisitors(params.organizationId, licensePlate);
                if (activeVisitByLicensePlate)
                    (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.VISITOR.ALREADY_ACTIVE_VISIT_FOR_PLATE", {}, false);
                else
                    return visitorProfileFields;
            }
            else {
                let roleIds = await dal_manager_1.dbManager.accessUser.getTypedRoleIdsOfOrganization(params.organizationId);
                let userRoleTypeId = await dal_manager_1.dbManager.accessUser.getUserRoleId({ organizationId: params.organizationId, userId: existingUsersWithLicensePlate[0].userId });
                if (roleIds.organizationVisitorId == userRoleTypeId)
                    (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.VISITOR.ALREADY_ACTIVE_VISIT_FOR_PLATE", {}, false);
                else
                    (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.VISITOR.PLATE_IN_USE", {}, false);
            }
        }.bind(this);
        this.afterVisitorSave = async function (params) {
            let result = {
                errorMessage: "",
                isValid: true,
            };
            let visitorSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId, params.trx);
            let visitDetailed = await dal_manager_1.dbManager.accessVisitor.getActiveVisitDetailed(params.organizationId, params.visitId, visitorSettings, params.trx);
            let licensePlate = visitDetailed.profile.fields["licencePlate"];
            if (!licensePlate) {
                return Promise.resolve(null);
            }
            let opTime = luxon_1.DateTime.now();
            let credentialCheck = await params.trx
                .withSchema(params.organizationId)
                .from("userOrganizationCredentials")
                .where("data", licensePlate)
                .where("type", app_enums_1.enums.CredentialType.VehiclePlate)
                .where("userId", visitDetailed.userId)
                .first();
            let newCredentialId = uuid_1.default.v4();
            let credential = {
                id: newCredentialId,
                createdAt: opTime,
                updatedAt: opTime,
                deletedAt: null,
                organizationId: params.organizationId,
                userId: visitDetailed.userId,
                type: app_enums_1.enums.CredentialType.VehiclePlate,
                data: licensePlate,
                expiresOn: opTime.endOf("day").toJSDate(),
                credentialNumber: licensePlate,
                extensionFields: null,
                source: dal_constants_1.DalConstants.SourceType.System,
            };
            if (credentialCheck) {
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").where("id", credential.id).delete();
            }
            try {
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").insert(credential);
            }
            catch (error) {
                if (error.message == "Internal DB error") {
                    const symbolKey = Reflect.ownKeys(error).find((key) => key.toString() === "Symbol(message)");
                    if (error[symbolKey].includes(app_enums_1.enums.ErrorCode.CredentialToInsertAlreadyExists.toString())) {
                        (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.IDENTITY.DUPLICATECREDENTIAL");
                    }
                }
            }
            let accessRights = [];
            const entranceAcp = registrationPointEntranceAcpMapping[visitDetailed.visitorRegistrationPointId];
            if (entranceAcp) {
                let newAccessRightId = uuid_1.default.v4();
                accessRights.push({
                    id: newAccessRightId,
                    createdAt: opTime,
                    updatedAt: opTime,
                    userId: visitDetailed.userId,
                    accessControlPointId: entranceAcp,
                    remoteAccess: false,
                    access: true,
                });
            }
            await params.trx.withSchema(params.organizationId).from("userAccessRights").insert(accessRights);
            setTimeout(async () => {
                const exitAccessRights = visitorExitAccessControlPoints.map((acpId) => ({
                    id: uuid_1.default.v4(),
                    createdAt: opTime,
                    updatedAt: opTime,
                    userId: visitDetailed.userId,
                    accessControlPointId: acpId,
                    remoteAccess: false,
                    access: true,
                }));
                try {
                    await dal_manager_1.dbManager.transaction(async (trx) => {
                        await trx.withSchema(params.organizationId).from("userAccessRights").insert(exitAccessRights);
                    });
                }
                catch (err) {
                    app_logs_1.logger.error(`Error while adding userAccessRights for visitor exit asynchronously, visitId: ${visitDetailed.id}`);
                    app_logs_1.logger.error(err);
                }
            }, 0);
            return Promise.resolve(result);
        }.bind(this);
        this.afterTerminateVisit = async function (params) {
            let acpId = registrationPointExitACPMapping[params.visitorRegistrationPointId];
            if (acpId) {
                setTimeout(() => {
                    this.sendRemoteOpen(params.organizationId, acpId, params.userId, false);
                }, 2000);
            }
            return Promise.resolve({
                errorMessage: "",
                isValid: true,
            });
        }.bind(this);
        this.beforeVisitorSave = async function (params) {
            let visitorProfileId = params.visitorProfileId;
            let visitorProfileFields = [];
            if (params.visitorProfileFields?.length) {
                visitorProfileFields = params.visitorProfileFields;
            }
            else {
                if (visitorProfileId) {
                    let organizationVisitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId);
                    let visitor = await dal_manager_1.dbManager.accessVisitor.getVisitor(params.organizationId, visitorProfileId, organizationVisitorModuleSettings);
                    for (let key of Object.keys(visitor.fields)) {
                        visitorProfileFields.push({
                            name: key,
                            value: visitor.fields[key],
                        });
                    }
                }
            }
            let isGraduate = visitorProfileFields.find((f) => f.name === "graduated")?.value === "true" || visitorProfileFields.find((f) => f.name === "graduated")?.value === true;
            let licencePlate = visitorProfileFields.find((f) => f.name === "licencePlate")?.value;
            let studentNumber = visitorProfileFields.find((f) => f.name === "studentNumber")?.value;
            if (isGraduate && (licencePlate || studentNumber)) {
                const now = luxon_1.DateTime.now();
                const startOfMonth = now.startOf("month");
                const qParams = [];
                qParams.push(startOfMonth, now);
                const whereConditions = [];
                if (licencePlate) {
                    whereConditions.push(` log ->'p'->'fields'->>'licencePlate' = ? `);
                    qParams.push(licencePlate);
                }
                if (studentNumber) {
                    whereConditions.push(` log->'p'->'fields'->>'studentNumber' = ? `);
                    qParams.push(studentNumber);
                }
                const q = `
					SELECT id,
						"organizationId",
						"startUtc",
						"endUtc",
						"visitorProfileId",
						"visitedUserId",
						"visitorRegistrationPointId",
						log
					FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitHistory}"
					WHERE "startUtc" > ?
						AND "endUtc" < ?
						AND log ->'p'->'fields'->>'graduated' = 'true'
						AND ( ${whereConditions.join(` OR `)} )
				`;
                const checkPreviousVisitResult = await params.trx.raw(q, qParams);
                if (!checkPreviousVisitResult.rows.length) {
                    return;
                }
                else {
                    const previousVisit = checkPreviousVisitResult.rows[0];
                    (0, dal_access_error_1.throwDbAccessConflictErrorTr)("ERRORS.CUSTOM.ODTUPASS_GRADUATE_VISIT_LIMIT", { visit_date: luxon_1.DateTime.fromJSDate(previousVisit.startUtc).toFormat("yyyy-MM-dd") }, false);
                }
            }
            else {
                return;
            }
        };
        this.scheduledJobRoutine = this.customScheduledJobRoutine.bind(this);
    }
    async customScheduledJobRoutine(organizationId, scheduledJobId) {
        if (scheduledJobId === exports.MetuAuditLogExporterScheduledJobId) {
            await this.auditLogExporter();
        }
        else if (scheduledJobId === exports.CleanUnusablePreregistartionsScheduledJobId) {
            await this.preregistrationCleaner(organizationId);
        }
        else {
            app_logs_1.logger.error("Scheduled job id is not equal to only defined custom scheduled job (MetuAuditLogExporterScheduledJobId) for organization " + organizationId);
            app_logs_1.logger.error("Probably there is an error in scheduling mechanism");
        }
    }
    async beforeSendVisitorNotification(organizationId, userId) {
        const username = await dal_manager_1.dbManager.accessUser.getUsername(organizationId, userId);
        if (username) {
            return true;
        }
        else {
            return false;
        }
    }
    async preregistrationCleaner(organizationId) {
        const cleaningStartTime = luxon_1.DateTime.now().startOf("day").toSQL();
        const selectionSessionStates = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const totalRemovedSelectionStates = (await trx.query(`
					SELECT COUNT(id) as cnt FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessions}"
					WHERE "expirationUtc" > $1 
				`, [cleaningStartTime])).rows;
            return totalRemovedSelectionStates;
        });
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            await trx.query(`
				DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessions}"
				WHERE "expirationUtc" > $1
				`, [cleaningStartTime]);
        });
        app_logs_1.logger.info("----------------------------------------------------");
        app_logs_1.logger.info("Number of deleted selection sessions : " + selectionSessionStates[0].cnt);
        app_logs_1.logger.info("Expired selection sessions cleaned");
        let stateIds = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const totalRemovedState = (await trx.query(`
					SELECT COUNT(id) as cnt FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationVisitorStates}"
					WHERE "deletedAt" IS NOT NULL;
					`)).rows;
            return totalRemovedState;
        });
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            await trx.query(`
				DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationVisitorStates}"
				WHERE "deletedAt" IS NOT NULL;
				`);
        });
        app_logs_1.logger.info("----------------------------------------------------");
        app_logs_1.logger.info("Number of deleted visitor states : " + stateIds[0].cnt);
        app_logs_1.logger.info("Expired visitor states cleaned");
        let visitIds = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const totalPreregistrationCount = (await trx.query(`
				SELECT COUNT(id) as cnt FROM  "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}"
				WHERE "expectedStartUtc" < $1 AND "state" = $2;
				`, [cleaningStartTime, dal_constants_1.DalConstants.UnterminatedVisitState.Expected])).rows;
            return totalPreregistrationCount;
        });
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            await trx.query(`
				DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}"
				WHERE "expectedStartUtc" < $1 AND "state" = $2;
				`, [cleaningStartTime, dal_constants_1.DalConstants.UnterminatedVisitState.Expected]);
        });
        app_logs_1.logger.info("----------------------------------------------------");
        app_logs_1.logger.info("Number of deleted pre-registrations : " + visitIds[0].cnt);
        app_logs_1.logger.info("Updating active pre-registrations");
    }
    async auditLogExporter() {
        app_logs_1.logger.debug("audit log exported started");
        const today = luxon_1.DateTime.now();
        const logs = await dal_manager_1.dbManager.accessLog.listAuditLogs(today.startOf("day").toJSDate(), today.endOf("day").toJSDate());
        const exportFile = path_1.default.resolve(app_config_1.appConfig.log.httpRequests.customDirectory, today.toFormat("dd-MM-yyyy") + ".audit.log");
        const stream = fs_1.default.createWriteStream(exportFile);
        for (const log of logs) {
            stream.write(log.m + os_1.default.EOL);
        }
        stream.end();
        stream.close();
        this.removeOldFiles();
        app_logs_1.logger.info("audit logs exported to file " + exportFile.toString() + " line count : " + logs.length);
    }
    removeOldFiles() {
        let now = new Date().getTime();
        let files = fs_1.default.readdirSync(app_config_1.appConfig.log.httpRequests.customDirectory);
        for (let file of files) {
            if (!file.includes("audit.log")) {
                continue;
            }
            let filePath = path_1.default.resolve(app_config_1.appConfig.log.httpRequests.customDirectory, file);
            let stat = fs_1.default.statSync(filePath);
            let endTime = new Date(stat.ctime).getTime() + 3600000 * 24 * 7;
            if (now > endTime) {
                return fs_1.default.unlinkSync(filePath);
            }
        }
    }
    async getStudentInfoServiceResult(studentNo, organizationId) {
        let students = [];
        const studentInfoServiceSecret = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            return await (0, dal_access_psql_organization_1.getOrganizationSecretById)(organizationId, studentInfoServiceSecretId, trx);
        });
        var auth = "Basic " + new Buffer(studentInfoServiceSecret.metuUserName + ":" + studentInfoServiceSecret.metuPassword).toString("base64");
        let requestPromise = new Promise(async (resolve, reject) => {
            strong_soap_1.soap.createClient(studentInfoServiceSecret.wsdlUrl, {
                endpoint: studentInfoServiceSecret.serviceUrl,
                forceSoap12Headers: true,
                wsdl_headers: { Authorization: auth },
                normalizeNames: true,
                namespaceArrayElements: true,
                disableCache: true,
            }, function (err, client) {
                if (err) {
                    app_logs_1.logger.error(err);
                    reject();
                    return;
                }
                if (!client) {
                    reject();
                    return;
                }
                client.addSoapHeader("Content-Type", "text/html; charset=utf-8");
                client.addHttpHeader("Content-Type", "text/html; charset=utf-8");
                client.setSecurity(new strong_soap_1.soap.BasicAuthSecurity(studentInfoServiceSecret.metuUserName, studentInfoServiceSecret.metuPassword));
                client.getStudentDetailedInfo({ studentInfo: studentNo }, function (err, result, raw) {
                    var options = { explicitArray: false, ignoreAttrs: true, tagNameProcessors: [xml2js_1.default.processors.stripPrefix] };
                    if (err) {
                        reject();
                        return;
                    }
                    else {
                        xml2js_1.default.parseString(raw, options, (err, result) => {
                            if (err) {
                                app_logs_1.logger.error("An error has occurred: " + err);
                                reject();
                                return;
                            }
                            var soapBody = result.Envelope.Body;
                            if (soapBody.$) {
                                delete soapBody.$;
                            }
                            let items = soapBody["getStudentDetailedInfoResponse"]["return"]["item"];
                            let studentNo = items.find((i) => i.key === "numara").value;
                            let name = items.find((i) => i.key === "ad").value;
                            let surname = items.find((i) => i.key === "soyad").value;
                            let statusValue = items.some((i) => i.key === "durum") ? items.find((i) => i.key === "durum").value : "";
                            let graduationStatusValue = items.some((i) => i.key == "mezun") ? items.find((i) => i.key === "mezun").value : "";
                            let status = "";
                            if (statusValue && statusValue["item"] && statusValue["item"]["item"]) {
                                let stat = statusValue.item.item.find((v) => v.key == "durumbilgi");
                                if (stat) {
                                    status = stat.value;
                                }
                            }
                            let graduation = "";
                            if (graduationStatusValue && graduationStatusValue["item"] && graduationStatusValue["item"]["item"]) {
                                let stat = graduationStatusValue.item.item.find((v) => v.key == "mezunbilgi");
                                if (stat) {
                                    graduation = stat.value;
                                }
                            }
                            students.push({
                                name: name,
                                surname: surname,
                                status: status,
                                number: studentNo,
                                graduationStatus: graduation,
                            });
                            resolve(null);
                        });
                    }
                });
            });
        }).catch((err) => app_logs_1.logger.error(err));
        await requestPromise;
        return Promise.resolve(students);
    }
    async sendRemoteOpen(organizationId, accessControlPointId, userId, qr) {
        try {
            let accessAccessControlPoint = await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointBasic(organizationId, accessControlPointId);
            if (accessAccessControlPoint.deviceId) {
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToRpcQueue(accessAccessControlPoint.deviceId, {
                    e: messagebroker_models_1.ServerToDeviceRPCMessageType.RemoteAccess,
                    p: {
                        a: accessControlPointId,
                        d: app_enums_1.enums.AccessDirection.Exit,
                        o: userId,
                        iq: qr,
                    },
                }, 3000, (err, success) => {
                    if (err) {
                        app_logs_1.logger.error("unable to send remote access " + err);
                    }
                });
            }
        }
        catch (error) {
            app_logs_1.logger.error("unable to send remote access " + error);
        }
    }
    async onPrepareVisitorCameEmailNotificationImplementation(context, params) {
        const result = {
            subject: "",
            html: "",
            to: "",
        };
        const metuContext = {
            ...context,
            hasAccount: false,
        };
        const username = await dal_manager_1.dbManager.accessUser.getUsername(params.organizationId, params.receiverUser.id);
        if (username) {
            metuContext.hasAccount = true;
        }
        result.to = params.receiverUser.e;
        result.attachments = [
            {
                content: metuLogo.split("base64,")[1],
                encoding: "base64",
                filename: "logo.png",
                cid: "metuLogo",
            },
        ];
        if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.Turkish) {
            result.subject = "OdtüPass Ziyaretçi Bildirimi";
            const html = `
					<div class="greeting">
							<p>Sayın {{{visitedFullname}}},</p>
						</div>
						<p>
						<div class="intro">
							<p>Ziyaretçiniz kampüse giriş yapmıştır.</p>
						</div>
				<div>
					<table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse;width:50%" >
					<tbody>
					<tr>
					   <td>{{{visitorFullname}}}</td>
					 </tr> 
					 <tr>
					   <td>{{{date}}}</td>
					 </tr> 
					 <tr>
					   <td>{{{visitorRegistrationPoint}}}</td>
					</tr>
				 </tbody>
					</table>
				</div>
				<div>
				{{#if hasAccount}}
				<p>Akademik ve idari personellerimiz https://odtupass.metu.edu.tr adresinden ziyaretçileri için ön kayıt
					oluşturabilirler.</p>
				{{/if}}
					<p>Soru, görüş ve önerileriniz için ktkb@metu.edu.tr mail adresinden bize ulaşabilirsiniz.</p>
					<p>Kampüs Teknolojileri ve Koordinasyon Birimi</p>
				</div>
			<div>  
		<img src="cid:metuLogo" />
		</div>
			`;
            result.html = handlebars.compile(html)(metuContext);
        }
        else {
            result.subject = "MetuPass Visitor Notification";
            result.to = params.receiverUser.e;
            const html = `
			<div class= "greeting">
            <p>Dear {{{visitedFullname}}}, </p>
               </div>
               <p>
               <div class="intro">
                  <p>Your visitor has arrived to the campus. </p>
			<div>
            <table  border="0" cellpadding="0" cellspacing="0" style="border-collapse:collapse;width:50%" >
               <tbody>
                  <tr>
                     <td>{{{visitorFullname}}}</td>
				   </tr> 
				   <tr>
                     <td>{{{date}}}</td>
				   </tr> 
				   <tr>
                     <td>{{{visitorRegistrationPoint}}}</td>
                  </tr>
               </tbody>
            </table>
         </div>
      <div>
        {{#if hasAccount}}
		  <p>Our academic and administrative staff can register their visitors via https://odtupass.metu.edu.tr.</p>
        {{/if}}
                  <p>For your questions and valuable feedbacks please get in contact with ktkb@metu.edu.tr.</p>
                  <p>Campus Technologies and Coordination Department</p>
	   </div>    
	   <img src="cid:metuLogo" />
	   </div>
			`;
            result.html = handlebars.compile(html)(metuContext);
        }
        return result;
    }
}
function checkHesCode(hesCode, organizationId) {
    const dataToBeSent = new TextEncoder().encode(JSON.stringify({
        hes_code: hesCode.toUpperCase(),
    }));
    return new Promise(async (resolve, reject) => {
        const hesCodeSecret = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            return await (0, dal_access_psql_organization_1.getOrganizationSecretById)(organizationId, hesCodeSecretId, trx);
        });
        const hesCodeUrl = {
            host: hesCodeSecret.host,
            port: hesCodeSecret.port,
            path: hesCodeSecret.path,
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
        };
        let req = https_1.default.request(hesCodeUrl, (res) => {
            let hesCodeState = "";
            res.on("data", (chunk) => {
                hesCodeState += chunk;
            });
            res.on("end", () => {
                if (hesCodeState == "RISKY") {
                    reject("ERRORS.VISITOR.RISKY_HES_CODE");
                }
                else if (hesCodeState == "NO RECORD" || hesCodeState == "error.hescodenotfound") {
                    reject("ERRORS.VISITOR.INCORRECT_HES_CODE");
                }
                else if (hesCodeState == "RISKLESS") {
                    resolve();
                }
                else if (hesCodeState === "error.hescodehasbeenexpired") {
                    reject("ERRORS.VISITOR.HES_CODE_EXPIRED");
                }
                else {
                    reject("ERRORS.VISITOR.INVALID_HES_RESPONSE");
                }
            });
        });
        req.on("error", (e) => {
            console.log(e);
            reject("ERRORS.VISITOR.HES_REQUEST_ERROR");
        });
        req.write(dataToBeSent);
        req.end();
    });
}
const metuLogo = `data:image/jpeg;base64,/9j/4AAQSkZJRgABAgEASABIAAD/2wBDAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQECAgICAgICAgICAgMDAwMDAwMDAwP/2wBDAQEBAQEBAQIBAQICAgECAgMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwP/wAARCABNAMgDAREAAhEBAxEB/8QAHQABAAICAwEBAAAAAAAAAAAAAAcIBgoEBQkLAv/EADYQAAAGAwABAwEECQMFAAAAAAIDBAUGBwABCAkREhMUFRYhIgoXMTdBWHeY1zK2tzg5dnm4/8QAHgEBAAAHAQEBAAAAAAAAAAAAAAECBAUGBwgJAwr/xABMEQACAQMDAgQCBAUQCAcAAAABAgMABBEFBhIHIQgTMUEUYSIyUXEJI1KB4hUWMzQ2VFZic3WRk5Wys7U1N0JyobTB1Dh0d4KSsfD/2gAMAwEAAhEDEQA/AN/jFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKYpTFKgm/OnKB5dipczv61YnWLEpGaU27flhprw+np/i2pTRqMNZDhJpOrTAOCM0lvRqTSwb9wg6D+OUV9qNjpsXnX0qxp7Z9T9wGSfzA1nvT/AKXdQeqmrHRen2k3eqX6gF/KUCOIHOGmncpBArEEK00iKx7Ak9qpFSflwo/pmaqIZzhSHVl2AQqdJneZxGroy0wBh2aSE1GZIZVPLEhyNh04CFsBAFYSjh7AMXs0WEQ9Waz3TZ6jN5Onw3U2D3ZUAUfezOuM+2a3nvjwgb66YaIutdStd2lobSLyjtri+nku5cHDCGC1s7lpeHqxjLKMgcixC1zaj8s/Pd7WRKamqyEWvI53EHh1ZHKOq3ChYo+OKxiVrErz91Y3Mr0j0pmZbd9CMwz7JQrB7L3r2hEL1Dqa13RYXtw1rbJK06EgjMak49eIaQFsfxQa+G8PCL1F2Ftq03duu+0i20C8hjlSZU1WeJFlVWj8+a20uaC2L8gB8RLGM5yQME3kr++K0sd6WxNmdnJlnjWjE4udczuOSCvrCRtgFO0Y3kEQmTayvLpHPrA/GB1QlKmo8W9fEpMCIO93mC9t7hzEhInAyUYFWx9vFgCR/GGV+w1oncOwdz7asU1e9hin0CV+CXlrNDd2jOV5CM3Fs8kcc3H6RglZJ1GecakECYsq6wymKUxSmKUxSsXms0itcxGRzycPaKNQ+Is65/ksgchDAgZ2ZtIGpXuCwZYDDAp0pANiFvQd79NfsyIBJwPWnpWPwm3q0sd8lkbg8xZ5K+wVPDlcubG0w0alhT2DGk0xhZy8JhJYQgkUYVlLU/t2L3Ej1vfpv8MEEdzUMg1JGQqNMUpilMUpilMUpilQ50Fd0U5upexL0nLfIXWJVnHjpK/N0USNq6Rq0JB6dOMpoSO7sxNh6vY1Id6CcsTg9Nb/ADfw3SX15Fp9pJezBjFGuSFwTj5ZIH/EVmfTzY2rdS97absPQpLaLV9UuRDE87OsKsQTmRo45XC4B7rG5+VSk0OZD00tbwlAcWmdm5E5pi1AQBPAQvTFKiQHhLMNLCcEs3WhaCIWtb9fTe9fjlSjB1Dj0Iz/AE1it5ayWV3LZSkGWGRkJGcEoxU4yAcZHbIBx7CuxyaqamKUxSmKVUvt/rCJ8V82z++pQnLdFTClIaYXGBH6TmS+fPohJIxHgGe4JgEpinQlS4wvQjCG1KpOCEey9B3a9Z1OLSNPkvpO5UYUflMfQf8AU/YATW3ehfSTV+t3UzT9gaUxiiuGMlzPjIt7SL6U8xHoWC4SIHCvM8aEgNkaV/KtP3n5me5lrzd80elzGSXuZ3BKkXuISw2u0C3RDVAK9QKNK22P7dVikLe1p/QwKcAlC80Kowk/R2otMtL3dusl7xyU+tI35KD0VR6DPoB7d2OcHPtx1Y3lsPwV9CEstjWMEd+x+G06Bu7XN465ku7txxeby1Uyzv2LkR26mJXj4b39T1JW1GQCOVdUsOZIJA4ohAgZI6wJAJUhANa1s9WqM/MpcnZwO9Tli1SM1WsUDGceYYaMQt7ptbW3soFtrVFSBRgAf/u5PuT3J7nvXgdu3d+5t97hud1bvvZ7/X7uQvLNK3Jj9iqPqpGgwscaBY40ARFVQAPmV3S4uDP0HbLs0rljW6tdyTtxbHNuVHonBucEU2dVKJchWphlKUixIpKCYUaWIIyxh0IO9b1rec73jMl9K6EhhMxBHYghj3FfqA2TbW95070izvI0ltJdFtUdHUMjo1tGrKysCrKykhlIIIJBGK29fE12m2+R+onbnzpNUes6KoZG3SmGWm1LAM1hOUeBsLI22fGZAn0Ja0WNDXBSSid1IAfTOiZcn0rLVFqlxI9p7X1ddwWpsNQOb+ABlcdmI9A4Ps6nsx9CCM5ywrx38XPRK58NW8IeonTNFTpvr7vBc2MimS0SY/jXsZ4j9GSzuUVpbdCecDxSGFomigce1dIz2TPIphWNlnJDrZqNc1NkmckKXSBvnUWf0qlXAbWaW8BZZLehmyFvVkLEpetkoJA1uaMkRhCYo43MLOeR+dtcY+KiIBPoGU/VcD25YOR7MGA7AGuIt87f0uyFnujbAddo6xHI8CM3N7WeJlW7sJHyS7WzPG0cjfSltJ7WZwrysi1W8rF9WzzvyK9TOkpEmiFgvs+r2AtkrPam95Oj6WXPwETi4IELqmXNol30pYigGGkG/EEwQwa0aEAw3GJQz4PpWvnJC5FVEnx3b/GfSHELfMu233o2CdB3YRUM6hcrqCv4alITOaRCHTm2uLAFa5hNTjWDOK9hycZZpBehCNKMNL3OODq2BggVL9JSO+cmoogtieSC9627nvuH98l1jHuZbz6YgkZqs3lujJiW7MdMsaKZtCYc7XNjc5N2lze8Ft/vOQOJxX0/zjGeIzYAxIjUqpXOQPc1AFiCc+ldlbt2+QBy8d8L8gcH7KQVxptoeCvUspxt5uqWSI5fM1M0DFHiVlzqVhdVsdMeU7qnOMRENpiIo1KLRJZYTvQsBH5nlke/21EluPLNZdcs67ZoCgeWZRZHXSK+jeoOtuV4C9oHLm6l4UgZamsqHz92sCu1iFI2SNskieTHlN+hOG06Jcm0h9CBlhPNDkAEZiAMYB96EsAO/qat9KbZnMN8p1O0DFl7Ow1PYvL0msCbRltiEOTqZFLYi8vsejLqvlAWD73exjY24hKnTAXgSFkl6Dor09fWQAGIsfXNRyeePbFfqm7ytWQ9peVGtnqYK3CD0FHuUl1Qx45C0aSwtVPaEk0ul5qM4tuAscPtuRISlJgVpikIBA9pegA3sO8ZtL25k1fU7d3JhgWEoMD6PKIs3t3yRnvmuo96bE2np3RLpRuays0j13cFzry6hMGk5XK2mqwW9uGBcqnlQsyAxqhIOWy2DVL6KWeRa9vHw09cNHkQkMesN5rKdT5JEnbnTmVRCC1cJepOm21rHJLVYXwhI6N8a2HagITBJjjvk+I0IPjHaLI6/e6ENUS/ZZzGzcTFDx+iT2zwz3A9fb51uzfsPhv2F4iJuj9505t7nbkOqWto1xHrGti6K3MUDeYqNfeUWR5s8CQHVePJC3ITBK+5rxdfGpzHZEJWMiXsXr82r6iqk9EyIVDKRZ80ehNz5N1DA4o3psSszBHGlc5qNnJVDemUbKCYX8G/ZlVLrN623ra4hKjVrvgidhjmxwWwcjAAJPYgHHbFYbpPQjYlp4m907a1xJ36M7NF9qF+GlYSGxto+cVqJUaJ2klmkigTi6TOgYq3mDNW+8ePREv6K5ybV9rjILv2ppdLqL6EbikqNAYitysXUxmfFZ7e3pG9AhMkbbtG6iKTJyExI1oiigBAXoOrtoN/Lf6eGuf29EzRyj0+mhwewwBkYbsAO+BWnPEZ040fpx1Jlt9pBj0+1ezt9U0hyzOG0+9jEkSh3Z3YQv5kAZ3d2EQd2LMTXmdwuf1r3jSormV+UKRQSyJG+zU95patqwphYnpwtvkK5naY4+sEgZfvbrScsgpQAagRPzpFJIdHGj9VRuO6KdU1uz+LOpMlwzNmNEj/ABeDgAgjl8+/sR3PqenuvCdIegW9/wBZUPSu2v8AbVtBbCPUr2+1JTqJeFZJJopYpPh+5LIQgbjIjkogxEnd9A9Cd/c+cC1UiuCw2Sr7+lnYzHzZLulXCKRda2x2mHp9mRrZfThH2xMuizcnVszEkKN2YlTmhSHb3sBS8YTMnvr/AFyw0OIXcix3zXYiaUqpAjJbEhAyo7Aew7fY1UXTzp34e+oniC1afZunT6r0+s9mS6zb6Kk86vNqUcVsH0pJnZZ3KySyMoDupkXAZ7dStSdZVO+RKuYhBro5i7pmHXapunEOUO1VySBUUCHWLAXF1IQyYaCUR5MzBTloW88R4xErAnbICPac0CgBexVFxaa9bxJeadevdEOuUKx8XUnBwRj0Hf19PQ5rFts7z8OO5NYv9k9UdhWWzopLC4Ed9Ddaobizu0jLQB4JmkyWcBQGjK8iBIjRlgIr8ldmT1e7eSCpFkoc1FbR/wAetYzZlh5hhe2hulb7bMkand8Tl6K0bpcvbm4gkzex71sBWvTWsptw3E7NqFqWPw62CMF9gxcgn7yAKyvwybY0C3s+mm74bWJdzXHUW9tpLgA+Y8EVhDJHETnHFHdmHbOWPerucjWZPZN132jWr9KHN0glYVfwurgEYVGFibIqpnlUTxzmBzWAJQTCxyBe0pjVHuEL1ESH09MvGlXE8mq3lu7EwRx23Eey8kYtj7yBmtHdYNsaBpnR7ZO59PtYotf1XVd0LdzqDznFrf2qW4c5wfKSR1TAHZjnNek2ZDXM1MUpilMUrVk/ScZi9I4jyBX6dUcCOyGSXLMXZF7DNEKXqGtlcskdVfJsOiTDkSGdugPTW9iBpR+OtaFr11r1FlcRWkAP4tmkY/eoQD+gMf6a9WvwXejWU2sby3DIgOo21tp1vG3bKx3L3ksy49QGa1gP2Ep29DiVf0aSCM6DmK/7NJIK1IJXfJcEcFOig6PGz19X0TkDOQI7/UIotbZi4QQ/sDsW9/xyq6eQounT3A/ZGn4n7lVSP75rE/wnGv3tx1S29td2P6nWmgG6QZ7eZd3dxDIcfaVsogT7gD7K2Rs2BXmjXy2r6/fnc/8AVixf94PGc3Xv7dm/lX/vGv1V7A/cJon80Wf/AC8degnhJl7xEvJXzwU1KBlppYOwYg/JtDEApwZ3Otpar0nP9v4jAld21IrAH9mzUwPX8Mvmz5Xi3DBx9G5KfmCjf9QD+auePHHo1lq/hk3G12oMtoLS4ibGSkiXtuuR82jeSMn8l2reXkRX2R1RVjmmF8RczpS4Iy/Eka9TXJXEZdUkhhKpbrewh+hjiV9khYBeuxAOeNB0HehiEHc0g4anEw/24ZAfnxZCv5hl/wD5V4Rac/xnSjVbWXu1lrmnTxE+iLcW+oQ3Kr/GmaKzYj0K2+c5UAxf5BeVJB2PzY+09EJk3QSYAk0RmsUkD0gNcWQt9iDsBxSo3ghOA5UWgWF7GDZpZR4iTPaPZRodCLFco24Nk+la2YchiqiGcb9+3fe/MFg9Y3bzgrgPNdihtFAy0vD5k3SOTSVEmS/Z5bkdJ0oEZSc5ShAA0RJpICyTjd6IMH8Wy5+caqQgOTUvFiRyxgVHzd47+9YBH+n61qHp+iY1U/TNp3TY0gaH6rXp+k6HVypCmJ2SJ3s44RSc8iNIUxIdhLEAB4BGB1+bI+YhwSDkCnFhkA9jVr5dwa9OfjSBwUx2E1ifiK0isHLsN1ZVaZoOcGWWM0pcHEbIjVrFhCNQYgNKJL0cYMIRA2IW963kgf8AGc/nU3H6PGv32VxXY3QfM1B1ZWlixmFWjzxY1N2nEpLJWha4xV1k9TxZ5jRBDimTFK1iVCea+CWA39Op9wk4Chl+0wQwkcKxJ9DRlyMe9YLSPIfX6/syN9d9aWtRb84QKnX2p4jFaRi8vbEipO/uqxyPWvB8sEWamGlE4HC9xY1Hzb9gdBK0AQjIs6cOCA+vvUArcuTViNBf9wvzZf8AifEf/wAwzHMOsf8ATusf7tv/AILV2h1B/wDDr0P/APObm/zu2qpXju8ckE6O8etIO086Q7Rb4xYsRlCeRVJEuin5jpoTaCeSttPZkdcja1zGQzOAEWjVCcQRlmqDTDN69R7y16DoEOoaFC09xeCORDlFlIjxyYY4Yxg+4+2tveI7xJ69018RWu2mgba2TJqmm3kBh1C40eKXUefwsDiRrwSLKZELcUcEFUVVHYVnLdREi6A7bSV7yvYqfnykvFdXDLUFcyAVdtdstqi7rMZlIZ8nbm+ZOyVscXaNwlOnQOSxT9SvTOYdnbF7lQTM+62Ul9rAg0yTyLPTIxGh4hx5jj6WAxwSFwCTkg9/erFc7+07p70OfcXVfTW3FvnqvqUmoXkXxj2DjTLKRfhC720bOkc1yXlhjThE8JCYxEVqR6PjVncO+R5VCretku2Ih5EoY4ydvm5VfMFZt5HSNLpSS1zMKMRxcvY2sySVoq0earLGQa8OYywjKGaVs0X3s47nRtwGG6l82K/QkNxCDzY/UYBIGU75/wBo+2axrfWp7W66+GtNc2dpB0jWOnF6kD2pu5b1zo2pMSsnnzKkriG9XisZDLbwBiGVXCir7X0J4f8AqOFKrM6thkJ5D6sjz7LEVjMsaNndU3RD5uxOi/alemk0CZ4s9zN4PJGEQhr0qk/635ExhOzCday3Jf7U1KE3Opolrqas3MDkkisCe+VALH7wTnsR2rad3078Y/SrW02x0lvb7ePSa5t7drOSYWt/ptxayxpxRoLuSeK2jByAInRPK4yq/F81l1NdjSuufFnUtudMV9JuoadlHTW6vnD/AHizjkr4j5WdZbICma4ZY1ujA/isZQxibEidOBSAWl6lQUDSn8oBb+tpq0tvtqK61GNrm0a54MZBk+SWOJGBB54wAM+pI71Z96dGdJ3J4rNX2f0w1G12rvO12v8AHWsWlyCGJtdjt4jJp1u6SxfBiXnI7lCPKRHJj7sKr/0lYPj7rtTW0w8V9tOsS6pmN31shZqv5wkdjlQaw251kKMuRNU9qxUZqAp2LbUL26ThSJvlNCUSIoZWjNlUOoT6FbmOXbUpTU3mQBIi/FgT3DJ9XGPbA9hjFbC6Z7d8Q+44tT0bxXaRFedJ7LQr1pL7WYbM3Vm8cLGGS0vlHxZl8zvzMj8VLOHDleU8eSD97fk5/wDWZTn/ADRMcrdwftrUf5uj/wARqwHw1fuQ6Xf+qGo/5bb1dvin/rz8hv8ASfx0/wDDVmZeNH/03f8A8la/4b1o7rf/AKgenP8AO+8P8ysq9YMyeuSKYpTFKYpWvZ+kVc5P1p8s19d0YbT3VdzrM3VTJSExZhp6Ku7JStLTIXoBRWhmHFtcljzHs/0D6EpBnHjEEske94Jv2we502O8jGWt3Of9x8An8xC5+WT7V6J/g4OpOn7U6rajsbVJVhg3JZRrCWIAa8smkkhiJOAC8M11w7/SkCRgFnFU2/RsOlmFnd7u5PkLiQhdZcpRXDWyc8ZZQXlwamsqPWI1kDMGHah1LZULQtITl6EMSRGsN3rQCBby09PtRRHm0yQ4Zz5ifMgYYffgKQPsBPtW6PwmXTG/vLPQ+renRtJaWatp16QCfLSRzNZyEAdozK1xGznAEkkKerittzNo15CV8tq+v353P/Vixf8AeDxnN17+3Zv5V/7xr9VewP3CaJ/NFn/y8dexP6Pnzo+2h2qVdhzcf9x+dorIHta7GkbG3KJvOGR0hMVj+jN/l2vE2Ozm6A9PX4vszW9+mxl+uV7FsHudX+MI/E26k59uTAqo+/BJ/NXGf4RDqRYbV6IHY6Sr+ru5LuKJYwfpi2tZY7mebH5HOOGA/leccZAbG4NHFYbE6YlMqbh6OjNFQFzp1O5pzdCTOtiWa8w2eWWz71r8h+oOwwGJA0cDYgaWuq1KL2nJDga2tGfP1FpV/Y4UMeftZyrOP/aFT87EeoNeN2pQnbnTC00m5GNU17UE1EoR3js7KO5tbKT5fFS3eoHicHy4IJRlJkJpv5q10ib/AB/WKpiTi4tUl1O6ZKZVzS4GNTgQ4nWlFikm0zgUemElM2eIOtD+QOg/t3vWsusP7J3rV0n1a8ge6vKLMb34Pg1Kw1G/MnRLqhdNdkNreUa0uVVNtMSBvjsmA8bKGlNjpdkTz6FQnLCPfxpNmN5vqaeEAvqkYWQk/V9vz1Iz5XHv71InYcYR2J5Ho9FZJQl2dPMSXgyuJEVWlMWG6QJ9aHcucAQanS9eje2bSlqRJV5iE4rYxbMPcCR7Dv49bDBDiPIIH0qHu3fv2qcPIDwXzxXXj0kl3xKG2nXti1dUMP8Aue0vlvWC6OEKFLLOSyV7j8jSnSVS2Pzs1utjOqc048J3t/KAAvjKK0GCOxk4nGCaiygLmsP6m5hqvl3i3naWU6GZsj7dPSHFTpYC11sGZSbbmqQM00cCgoi355XltCY1VK1mzSk2iiztCBoet6KL9pWLOQfYGhAAGPtFXmvdwcCvMLwo3FLlhTeqoToI1UgLUnARqTSWOQbKNUJQj0QcYVsOthEIO9h9PwyRf2JvvFTH64rk8pDVleTjzEmICC1S4tLwQNGmOO+nKUKwc5ygScg0/wBhnwFnHa0EQ/bv2636+m/TMS0zI3Fq3HucW3+Ea6+6tLE3hd6MrcMUgL7rDMBkhf1YgyQO2SBkgZGfSs1/XT5T/wCR7nv+7Mz/ABhn2+M3L+84P6/9CrJ+sjwo/wAOtxf2AP8Avqfrp8p/8j3Pf92Zn+MMfGbl/ecH9f8AoU/WR4Uf4dbi/sAf99T9dPlP/ke57/uzM/xhj4zcv7zg/r/0KfrI8KP8Otxf2AP++rHl078kboqNXOfj35acVp/s+dYu6ZQq1R3xFgJL+VQoqcw4z4ySwhD6736BDrWvw1rPm024GPJrC2J+c36FXGDQPDRaxCC16ibrjgXOFXRWVRk5OAL8AZJJPzOa5yG8PJs8tJBrbxJzQ6sa5J8aYxD1uSuaViEYNk+wgZFYmo1CQRetg9A+oN6/D9mTm63JjibK3x/LfoVQjZvhWEvnDfm5BMG5cv1B+lyznOfjs5z3z6571Hce6J7hECuX2M8ZcXJ92ugAvqlwbeuo8hV2EgVxdRMPmgwi6xIVyUsyGpznMekWjd6bizDxa0UEQtSibcKHK2FsGH2S/oVW3GgeGa7iMF11E3VLAcfRfRWZTjuOxvyO3qKoJ0Yttu0od5QbytVNz9GntDxzDKUea9proKM3a+xN7idmO7yPc2RNCNsdokrV/aJ5ISFqYrfyJRh1vYtC0Gy6ra6oba/1LUYkiV7NUAV+eeL5znA+2t+9H909I7XdPTfpd001bUdYns97XGoTS3Vj8FhbizWEIq+bKGwYs55A9/TtXtHzPz5Jq+vnovoFzemJbGuia55MbIwyoduG3xkNpeuZRHn4x+0oRkoNFuqmTFDSfTnHb2WWP5NA37dbybTrCSC9uL5ipjuI4AAM5HloQc+3fPbFckdT+oml7i2Btvp5awTpqe29S1955G4eVKNSvIJohFhi+Y1gYSc1XuRx5DJF48vNaJpilMUpildRII+yStheovJmlA/R2RNS9jfmR1TFLWx3Z3VKahcm1wSHhGSpRrUh4yzCxa2EYBb1vJJESVDHIA0bAgg+hB7EGqzTtQvtIv4NV0uaS31K2lSWKWNirxyRsGR0Yd1ZWAKkdwRmtQbrrwpdM8r3Ih6U8dq13l8fjEoJm0WhrS4Jw2xVLgjUbWAbmoh7UbT2fFSh+pBZWhHOShIb9IrRrAaOVHar1TZ+o6ZdjUNBJdFbkqg/TQ/YM/XX/iR2IPcn2L6P+N/ph1X2XJ0z8RyQ2eoXVqbae5kQ/AX6MOJeQxDNjOfrFsLCki+dDNCxSJPXjj3yxBsRG31z2BRlw80Xo2aA2Pit7qGxyaxkLoWP4PqEDhtkWu0KVKfbsw1I8FlpE+/ylrjt70HWVaTuf4gC31WGW3vR2OY34E/I4JX7m7D8o1x51l8I525NJuTo5r2jbn2HLl4li1CzN9ChGcOnmrHcqvosluTI/q0CYydVuN8C210N0zahD+oT0pX5lszlS6TmftL4JwNbVUtcVJWoXXrUhUzedOzgjO9yItIkAiOH6aMVk63oWa0j0O6v9RlD/iYPNbLMDnHI/VUDkxPtgY+Yr1e1PxA7Q6c9MNJk09W1zcI0i1WO1tJIuAdbdAfibuRltrWNGGJDJIZFGSsTkYrb65To0VH0vHudOQYDL6nr1OcNfPukrpiRsYnssflxCIEikkRqSVoUEwd565lEaSp1cnbGWPsRQE4k6Z5JTbbh7V0yy+DtFsNKR4oPVpZFwzHtkqjYYsfQFwqr2wHA4146dWd9jfW9rnqR1j1Cz1fcTDhaaNptwJ7S3iUsYYbjUIGe3jtUJ5vHYz3N3dMZBJLZPKLlfRCAQGL1jEmiEw5vG3MLOBUIkKhWrcnFevcVqh0eXt7d3A5S5vkhkDwtPXOC9UaaqXLVBp5wxmGCFu+wQR20QhiGEH5ySe5JJ7kk5JJ7kkk1zluHcGq7p1ibXNakEl/MVzhVRERFCRxRRoFSKGKNUihijVY4o0WNFCqAIy6Z5xhHVdTuNO2G6ypmjLnIIjIz10MXNDc+gXQySNspayiVT4xyJvCkPcGssCgIkohjJ2LQBAFvQ9VCsVOR61ZCAwwarhP/ABi8xWCv6xeFKWYRt77Hb4g22i8xZyjyRezERR3a5ApHA/tSLO6VkNmchZk6982qKX6XKy9GB0ULWvSYSMMfKoFAc/Ougv3xeVLftttd2KLx6kqSdNdYR+ograPsuNQIC6HxxcpckqdxUjr95eFJqxaeA1SD6sKUwackWiQiBreFlKjGARmoFATnvUpreFa/euQZHxlLLTvicQSVFqSnew5tOGSTXIcUomKWagK+9rlETWcwtEvRlpiAmtZmi0Qfj/EWtD1DmefMAZqPEcePtWQ9DcW1N0xz7Gucp+6z1sicOUQhfF5PDpAgZJ0zO8AQba2J5TOh7I4spjgJvNNLO+VuMJ3s4QyyyzAlDLK5VuQ9aiVBGDUQ0d41q0pe9WHot4vnrDoCzYnFnyIRJz6OuFJZZEYaZCWeQ56Z9lxFhcidmJlqkASjFJiQO1Jhnw/LsJgYtISvHAA+VQCgHPcmrIxHmau4Vb3Sd2siuUgmnVCKskFlfM7kba0ZVTQpwgUVMiSdO3J1jKo2yOZglIzD1OzFGgjB8ete3dugsILe9nvo+XnXHDnk9vxa8VwMdux79zWwdw9SNw7m2Lt3p7qK2w0HbHx/wZRGWU/qjcLc3HnOXIfEiDy+KJxXIPI96qBFvEhzFEWZEwtr9aytChjLpFChvrrAH9dptcgWNr0IcHat1S1sLKMtN2GoSIhpm553sgLsmcC0xIA3EysfsrXvAVw5N4guW5YJ/MdpBcIByKJNcOWgapLD2VAlb2uRR2TFqGljaYCjYGgw1wjJAdJU6UDYlJMNClSp9j0IMfNb5U4D51JSfxqc9pITbcCTONgaZbmsxrtWU/WLoY9fSyFoVOSxIha2t+gzpGz4+E93PFtK4oHDejBBNCMJwAGBh5jZB7dqjxFcJF4vuXk0lepSrQyp8Xu7q4vZJL6qirimZnde9zqSAeG0YoeBefIGp6sVzMQuq49Y6pE/0qMtTpCgQpk7zGxinEVwW3xYcuM5TAU1J5Y36jUljMgajEe4InPJSxA93Pj8d0eVAgGloG7b2f8AG4F7LkADBjOC4hUKFRx7zWpwFZ6Lx/UyW5UE/t0ruNmlHMlfDrKmJG2WGcWpiUW1BpHXqYBDIpbFUPPdE8fkIAmrBtn1DiJtRAXiVkFDJNh5h7+nenEdvlXQKPGvz6sZOg4+sdbLVNvR7TImCYaOkbHtXH2OUTVVYDq0w5wDFgLUyL7xqxDThcjHPaUrXxk7AEQ/fSX9tHqNo9lcZEMi4OOxx9/f/wCqzDYG9NY6b7y0/fO3hC2tabcCaETKXi5gEfTVWQsME9gw++r6tTcnZ2ttaEmzNpWtAjbk2zhaGbtOhTlpidmjCEARmbLK17t61rW9/wANZ9lUIoQegGP6Kxm7uZL26lvJsebLIztjsMsSxx8sntXPyaqemKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSmKUxSv/2Q== `;
