"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.UserListKGMCustomReport = void 0;
const exceljs_1 = __importDefault(require("exceljs"));
const fs_1 = __importDefault(require("fs"));
const i18n_1 = __importDefault(require("i18n"));
const moment_1 = __importDefault(require("moment"));
const path_1 = __importDefault(require("path"));
const app_config_1 = require("../../../app.config");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const generator_1 = require("../../../business/report/generator");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_manager_1 = require("../../../dal/dal.manager");
const uuid = require("uuid");
const dynamicFormCurrent_1 = require("../../../lib/es/models/dynamicFormCurrent");
var Constants;
(function (Constants) {
    Constants.DateFormat = "dd.mm.yyyy";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
})(Constants || (Constants = {}));
class UserListKGMCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._request = request;
        this._filter = request.filter;
        this.requesterUserId = request.requesterUserId;
        this._pool = dal_manager_1.dbManager.poolMain;
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        if (fs_1.default.existsSync(this._filePath)) {
            fs_1.default.unlinkSync(this._filePath);
        }
        this._wb = new exceljs_1.default.stream.xlsx.WorkbookWriter({
            filename: this._filePath,
            useStyles: true,
            useSharedStrings: true,
        });
        this._currentDate = (0, moment_1.default)();
        let orgUnits = [];
        if (this._filter.filters.find((i) => i.type === 4).value[0]) {
            orgUnits.push({
                id: this._filter.filters.find((i) => i.type === 4).value[0],
                includeDescendants: this._filter.filters.find((i) => i.type === 5).value,
            });
        }
        this._options = {
            organizationId: this._request.organizationId,
            status: 1,
            organizationUnits: orgUnits,
            userGroupIds: this._filter.filters.find((i) => i.type === 3).value,
        };
    }
    async getExtensionFields() {
        const client = await this._pool.connect();
        const { rows } = await client.query(`
            SELECT fields FROM "${this._options.organizationId}"."organizationForms" as orgForms
            WHERE orgForms."organizationId" = $1;
        `, [this._options.organizationId]);
        if (rows[0]) {
            app_logs_1.logger.debug("Connected. There are %s extension fields!", rows[0].fields.length);
            this._extensionFields = rows[0].fields;
        }
        else {
            app_logs_1.logger.debug("No extension fields...");
            this._extensionFields = null;
        }
        client.release();
    }
    addGeneralRow(row) {
        let colIndex = 1;
        if (row.organizationProfile[0].name) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].name.toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].surname) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].surname.toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].uniqueId) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].uniqueId,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].email) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].email,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].phoneNumber) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].phoneNumber,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].address) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].address,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].username) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].username,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationUnits[0].organizationUnitId) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: [...new Set(row.organizationUnits.map((ou) => ou.name))].join(", ").toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        let userGroups = [...new Map(row.userGroups.map((item) => [item.id, item])).values()];
        if (userGroups && userGroups.length > 0) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: [...new Set(row.userGroups.map((ug) => ug.name))].join(", ").toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        let cardInfo = row.credentials.find((x) => x.type == 3 || x.type == 0);
        let vehiclePlateInfo = row.credentials.find((x) => x.type == 6);
        if (cardInfo) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: cardInfo.data,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (vehiclePlateInfo) {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: vehiclePlateInfo.data,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        if (row.organizationProfile[0].extensionFields) {
            this.setExtensionCells({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.organizationProfile[0].extensionFields,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        else {
            this.setExtensionCells({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: null,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        this._wsGeneral.getRow(this._generalRowIndex).commit();
        this._generalRowIndex++;
    }
    setExtensionCells(params) {
        if (params.value) {
            Object.keys(params.value).forEach((fieldKey) => {
                let extIndex = this._extensionFields.map((e) => e["name"]).indexOf(fieldKey);
                let colIndex = extIndex + params.colIndex;
                let c = params.ws.getCell(params.rowIndex, colIndex);
                if (this._extensionFields[extIndex] && this._extensionFields[extIndex]["type"]) {
                    const formExtensionFieldDefinition = this._extensionFields[extIndex];
                    switch (formExtensionFieldDefinition.type) {
                        case dynamicFormCurrent_1.FormFieldType.Date:
                            c.value = (0, moment_1.default)(params.value[fieldKey]).format("DD/MM/YYYY");
                            break;
                        case dynamicFormCurrent_1.FormFieldType.Time:
                            c.value = (0, moment_1.default)(params.value[fieldKey]).format("HH:mm:ss");
                            break;
                        case dynamicFormCurrent_1.FormFieldType.DateTime:
                            c.value = (0, moment_1.default)(params.value[fieldKey]).format("DD/MM/YYYY HH:mm:ss");
                            break;
                        case dynamicFormCurrent_1.FormFieldType.Select:
                            c.value = formExtensionFieldDefinition.options.find((elem) => elem.value === params.value[fieldKey]).captionLines.join("\n");
                            break;
                        case dynamicFormCurrent_1.FormFieldType.DateRange:
                            const dateRange = (0, moment_1.default)(formExtensionFieldDefinition.options.startCaption).format("DD/MM/YYYY HH:mm:ss") +
                                " - " +
                                (0, moment_1.default)(formExtensionFieldDefinition.options.endCaption).format("DD/MM/YYYY HH:mm:ss");
                            c.value = dateRange;
                            break;
                        default:
                            c.value = params.value[fieldKey];
                            break;
                    }
                    c.alignment = {
                        horizontal: "left",
                        vertical: "middle",
                        wrapText: true,
                    };
                    if (params.border) {
                        c.border = params.border;
                    }
                }
            });
            this._extensionFields
                .map((e) => e["name"])
                .forEach((element) => {
                if (!Object.keys(params.value).includes(element)) {
                    let colIndex = this._extensionFields.map((e) => e["name"]).indexOf(element) + params.colIndex;
                    let c = params.ws.getCell(params.rowIndex, colIndex);
                    c.value = "";
                    c.alignment = {
                        horizontal: "left",
                        vertical: "middle",
                        wrapText: true,
                    };
                    if (params.border) {
                        c.border = params.border;
                    }
                }
            });
        }
        else {
            if (this._extensionFields) {
                for (let i = 0; i < this._extensionFields.length; i++) {
                    let c = params.ws.getCell(params.rowIndex, params.colIndex++);
                    c.value = "";
                    c.alignment = {
                        horizontal: "left",
                        vertical: "middle",
                        wrapText: true,
                    };
                    if (params.border) {
                        c.border = params.border;
                    }
                }
            }
        }
    }
    setDataCell(params) {
        let c = params.ws.getCell(params.rowIndex, params.colIndex);
        c.value = params.value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
    }
    addFilterToSheet(ws, startRowIndex, startColIndex, filter) {
        let border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationName + " " + i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_LIST", locale: this._locale }), border, {
            bold: true,
        });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.FILE_CREATION_DATE", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, {
            formula: "DATE(" + this._currentDate.year() + "," + (this._currentDate.month() + 1) + "," + this._currentDate.date() + ")",
        }, border, { italic: true }, Constants.DateFormat);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.APPLIED_FILTERS", locale: this._locale }), border);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.APPLIED_FILTERS", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 1, filter, border);
        let filterlength = filter.split("\r\n").length;
        let row = ws.getRow(startRowIndex + 2);
        row.height = filterlength * 20;
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
    addInitCell(ws, row, col, value, border) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        let columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.NAME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.SURNAME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.UNIQUE_ID", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.EMAIL", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 35 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.PHONE_NUMBER", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 22 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ADDRESS", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.USERNAME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 35 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.POSITION_TITLE", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.CARD_NUMBER", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.CREDENTIALTYPE_VEHICLE_PLATE", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 30 });
        if (this._extensionFields) {
            this._extensionFields.forEach((field) => {
                this.addInitCell(wsRaw, startRowIndex, startColIndex++, field["caption"], Constants.Styling.AllThin);
                columns.push({ width: 30 });
            });
        }
        wsRaw.autoFilter = {
            from: "A" + startRowIndex,
            to: wsRaw.getColumn(columns.length).letter + startRowIndex,
        };
        wsRaw.columns = columns;
        wsRaw.views.push({ state: "frozen", ySplit: startRowIndex, activeCell: "A1", showGridLines: false });
    }
    async generateUserListReport() {
        this._organizationName = (await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._options.organizationId)).name;
        app_logs_1.logger.debug("Organization Name : " + this._organizationName);
        await this.getExtensionFields();
        this._wsGeneral = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 6;
        let requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._options.organizationId, [this.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        this._wb.creator = this._requestedUserCaption;
        let filters = [];
        let filter = this._options;
        if (filter.status) {
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.STATUS", locale: this._locale }) +
                " : " +
                i18n_1.default.__({ phrase: "EXCEL-REPORT." + dal_constants_1.DalConstants.IdentityStatusType[filter.status].toUpperCase(), locale: this._locale }));
        }
        if (filter.profileFilter) {
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.PROFILE_FILTER", locale: this._locale }) + " : " + filter.profileFilter);
        }
        if (filter.organizationUnits && filter.organizationUnits[0]) {
            let organizationUnitInfo = await dal_manager_1.dbManager.accessOrganizationUnit.getIdNamePairsOfOrganizationUnits(this._options.organizationId, [
                filter.organizationUnits[0].id,
            ]);
            let organizationUnitName = organizationUnitInfo[0].name;
            app_logs_1.logger.debug("Organization Unit Name : " + organizationUnitName);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + organizationUnitName);
            if (filter.organizationUnits[0].includeDescendants) {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.INCLUDE_DESCENDANTS", locale: this._locale }) + " : " + i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale }));
            }
        }
        if (filter.userGroupIds && filter.userGroupIds[0]) {
            let userGroupName = (await dal_manager_1.dbManager.accessUserGroup.listUserGroupsByIds(this._options.organizationId, filter.userGroupIds))[0].name;
            app_logs_1.logger.debug("User group : " + userGroupName);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_GROUPS", locale: this._locale }) + " : " + userGroupName);
        }
        if (filters.length === 0) {
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.NOT_EXISTING", locale: this._locale }));
        }
        app_logs_1.logger.debug("\n\nApplied Filters:\n");
        app_logs_1.logger.debug(filters.join("\r\n"));
        app_logs_1.logger.debug("\n\n");
        this.addFilterToSheet(this._wsGeneral, 1, 1, filters.join("\r\n"));
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        console.log("Generating report...");
        await dal_manager_1.dbManager.accessIdentity.fetchAllDataIdentity(this._options, this._request.organizationId, this.onDataCallbackFunction.bind(this));
        console.log("end of fetching");
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + this._generalRowIndex;
        this._wsGeneral.pageSetup.printTitlesRow = "5:5";
        this._wsGeneral.commit();
        await this._wb.commit();
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
            sendFileInAttachments: undefined,
            customReportName: i18n_1.default.__({ phrase: "REPORT.IDENTITIES", locale: this._locale }),
        };
    }
    async onDataCallbackFunction(rows) {
        app_logs_1.logger.debug("Fetch data %s rows", rows.length);
        for (const row of rows) {
            this.addGeneralRow(row);
        }
        return Promise.resolve();
    }
    async generateReport() {
        return await this.generateUserListReport();
    }
}
exports.UserListKGMCustomReport = UserListKGMCustomReport;
async function generateReport(request, locale) {
    let report = new UserListKGMCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
