"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const moment_1 = __importDefault(require("moment"));
const uuid_1 = __importDefault(require("uuid"));
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const business_hooks_1 = require("../../../business/business.hooks");
const messageBroker_server_to_device_pub_1 = require("../../../messageBroker/messageBroker.server-to-device.pub");
const messagebroker_models_1 = require("../../../messageBroker/messagebroker.models");
const dal_constants_1 = require("../../../dal/dal.constants");
let visitorAccessControlPointsForVehicle = [
    "2a9d7bd2-4491-45dd-95dd-12bc0b0cabea",
    "49915964-c9da-49cb-a170-fc1f8507ba2f",
    "7bac55bd-5cc0-48c7-ba32-c07fe0794173",
    "987b33e2-3fe4-44f1-bf68-04324bc5099c",
    "d61b2283-1e4a-4b5e-a24f-c13d2d2ca17e",
    "efeddd30-5db1-42b2-8160-754dd35b3cd2",
    "502316bc-c16e-4e4a-8b4a-ff89b5e158fe",
];
const registrationPointEntranceACPMapping = {
    "393e396f-7a6e-4ec7-8675-8e09c94fe03a": "7bac55bd-5cc0-48c7-ba32-c07fe0794173",
    "b4535a5e-4978-4473-9f54-e7a56073558e": "49915964-c9da-49cb-a170-fc1f8507ba2f",
    "bbab0b8e-f953-481c-b027-34e37b7a334e": "d61b2283-1e4a-4b5e-a24f-c13d2d2ca17e",
};
function CreateHook() {
    return new KarabukHook();
}
exports.CreateHook = CreateHook;
class KarabukHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.afterVisitorSave = async function (params) {
            let visitorSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId, params.trx);
            let visitDetailed = await dal_manager_1.dbManager.accessVisitor.getActiveVisitDetailed(params.organizationId, params.visitId, visitorSettings, params.trx);
            let licensePlate = visitDetailed.profile.fields["licencePlate"];
            if (!licensePlate) {
                return Promise.resolve(null);
            }
            let opTime = new Date();
            let credentialCheck = await params.trx
                .withSchema(params.organizationId)
                .from("userOrganizationCredentials")
                .where("data", licensePlate)
                .where("type", app_enums_1.enums.CredentialType.VehiclePlate)
                .where("userId", visitDetailed.userId)
                .first();
            let newCredentialId = uuid_1.default.v4();
            let credential = {
                id: newCredentialId,
                createdAt: opTime,
                updatedAt: opTime,
                deletedAt: null,
                organizationId: params.organizationId,
                userId: visitDetailed.userId,
                type: app_enums_1.enums.CredentialType.VehiclePlate,
                data: licensePlate,
                expiresOn: (0, moment_1.default)(opTime).endOf("day").toDate(),
                credentialNumber: licensePlate,
                extensionFields: null,
                source: dal_constants_1.DalConstants.SourceType.System
            };
            if (credentialCheck) {
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").where("id", credential.id).delete();
            }
            await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").insert(credential);
            let accessRights = [];
            for (const acpId of visitorAccessControlPointsForVehicle) {
                let newAccessRightId = uuid_1.default.v4();
                accessRights.push({
                    id: newAccessRightId,
                    createdAt: opTime,
                    updatedAt: opTime,
                    userId: visitDetailed.userId,
                    accessControlPointId: acpId,
                    remoteAccess: false,
                    access: true,
                });
            }
            let acpId = registrationPointEntranceACPMapping[visitDetailed.visitorRegistrationPointId];
            await params.trx.withSchema(params.organizationId).from("userAccessRights").insert(accessRights);
            if (acpId) {
                setTimeout(() => {
                    this.sendRemoteOpen(params.organizationId, acpId, dal_constants_1.DalConstants.SystemUserId, false);
                }, 100);
            }
            return Promise.resolve({
                errorMessage: "",
                isValid: true,
            });
        }.bind(this);
    }
    async sendRemoteOpen(organizationId, accessControlPointId, userId, qr) {
        try {
            let accessAccessControlPoint = await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointBasic(organizationId, accessControlPointId);
            if (accessAccessControlPoint.deviceId) {
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToRpcQueue(accessAccessControlPoint.deviceId, {
                    e: messagebroker_models_1.ServerToDeviceRPCMessageType.RemoteAccess,
                    p: {
                        a: accessControlPointId,
                        d: app_enums_1.enums.AccessDirection.Entrance,
                        o: userId,
                        iq: qr,
                    },
                }, 3000, (err, success) => {
                    if (err) {
                        app_logs_1.logger.error("unable to send remote access " + err);
                    }
                });
            }
        }
        catch (error) {
            app_logs_1.logger.error("unable to send remote access " + error);
        }
    }
}
