"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const handlebars_1 = __importDefault(require("handlebars"));
const i18n_1 = __importDefault(require("i18n"));
const dal_memcache_1 = require("../../../dal/access/dal.memcache");
function CreateHook() {
    return new GubretasHook();
}
exports.CreateHook = CreateHook;
class GubretasHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.onPACSSelfAbsentEmployeeEmailNotification = async (params) => {
            const date = new Date();
            return {
                subject: i18n_1.default.__({ phrase: "NOTIFICATION.TITLE.PACSABSENTEMPLOYEENOTIFICATIONSELF", locale: "tr" }),
                html: handlebars_1.default.compile(pacsAbsentEmployeeSelfEmailTr)({
                    day: date.getDate().toString(),
                    month: (date.getMonth() + 1).toString(),
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: date.getFullYear().toString(),
                }),
                to: params.receiverUser.e,
            };
        };
        this.onPACSSelfOverworkedEmployeeEmailNotification = async (params) => {
            const date = new Date();
            return {
                subject: i18n_1.default.__({ phrase: "NOTIFICATION.TITLE.PACSOVERWORKEDEMPLOYEENOTIFICATIONSELF", locale: "tr" }),
                html: handlebars_1.default.compile(pacsOverworkedEmployeeSelfEmailTr)({
                    day: date.getDate().toString(),
                    month: (date.getMonth() + 1).toString(),
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: date.getFullYear().toString(),
                }),
                to: params.receiverUser.e,
            };
        };
        this.onPACSSelfMissingWorkEmailNotification = async (params) => {
            const date = new Date();
            return {
                subject: i18n_1.default.__({ phrase: "NOTIFICATION.TITLE.PACSMISSINGWORK", locale: "tr" }),
                html: handlebars_1.default.compile(pacsMissingWorkSelfEmail)({
                    day: date.getDate().toString(),
                    month: (date.getMonth() + 1).toString(),
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: date.getFullYear().toString(),
                }),
                to: params.receiverUser.e,
            };
        };
    }
}
const pacsAbsentEmployeeSelfEmailTr = `
<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
    xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <title>
    </title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">
        #outlook a {
            padding: 0;
        }

        body {
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table,
        td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
        }

        p {
            display: block;
            margin: 13px 0;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
    <style type="text/css">
        @import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
    </style>
    <style type="text/css">
        @media only screen and (min-width:480px) {
            .mj-column-per-50 {
                width: 50% !important;
                max-width: 50%;
            }

            .mj-column-per-100 {
                width: 100% !important;
                max-width: 100%;
            }
        }
    </style>
    <style type="text/css">
        @media only screen and (max-width:480px) {
            table.mj-full-width-mobile {
                width: 100% !important;
            }

            td.mj-full-width-mobile {
                width: auto !important;
            }
        }
    </style>
</head>

<body style="background-color:#FAFAFA;">
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:middle;"
            width="100%">
            <tr>
                <td align="left" style="padding: 10.0px 25.0px;padding-top:
                                                70.0px;padding-bottom: 10.0px;padding-left: 50.0px;">
                    <span style="font-size: 26px; color: #01325B; font-weight: bold;">İşe Başlamama Bildirimi</span>
                </td>
            </tr>
        </table>
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:0 0 0 0;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <p
                                                style="margin-top:24px; line-height: 15px; text-align: left; margin: 10px 0; margin-bottom:0px; font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <b><p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Merhabalar,</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İşyerinde uyguladığımız PDKS kontrolümüz kapsamında {{day}}/{{month}}/{{year}} tarihinde giriş kaydınızın olmadığı tespit edilmiştir.</p>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İzin girişinizi GBS üzerinden girmenizi rica ederiz.</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                *İzin girişinizi oluşturduysanız lütfen bu maili dikkate almayınız.</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İnsan Kaynakları Müdürlüğü</p><r></b><br><hr>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu e-posta otomatik olarak üretildi. Yanıtlamayınız! </p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:32px 0px;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="center"
                                        style="font-size:0px;padding:10px 25px;padding-bottom:0px;word-break:break-word;">
                                        <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                            style="border-collapse:collapse;border-spacing:0px;">
                                            <tbody>
                                                <tr>
                                                    <td style="width:100px;">
                                                        <img height="auto" src="{{armonLogo}}"
                                                            style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
                                                            width="100" />
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-top:0px;padding-bottom:0px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#55575d;">
                                            <p
                                                style="line-height: 16px; text-align: center; margin: 10px 0;font-size:8px;color:#A7A7A7;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu bildirim ARMON geçiş kontrol sistemi ile gönderilmiştir. &nbsp;<br /><span
                                                style="color:#A7A7A7;font-family:'Times New Roman',Helvetica,Arial,sans-serif">armon
                                                © {{{year}}} </span></p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    </div>
</body>

</html>
`;
const pacsOverworkedEmployeeSelfEmailTr = `
<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
    xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <title>
    </title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">
        #outlook a {
            padding: 0;
        }

        body {
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table,
        td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
        }

        p {
            display: block;
            margin: 13px 0;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
    <style type="text/css">
        @import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
    </style>
    <style type="text/css">
        @media only screen and (min-width:480px) {
            .mj-column-per-50 {
                width: 50% !important;
                max-width: 50%;
            }

            .mj-column-per-100 {
                width: 100% !important;
                max-width: 100%;
            }
        }
    </style>
    <style type="text/css">
        @media only screen and (max-width:480px) {
            table.mj-full-width-mobile {
                width: 100% !important;
            }

            td.mj-full-width-mobile {
                width: auto !important;
            }
        }
    </style>
</head>

<body style="background-color:#FAFAFA;">
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:middle;"
            width="100%">
            <tr>
                <td align="left" style="padding: 10.0px 25.0px;padding-top:
                                                70.0px;padding-bottom: 10.0px;padding-left: 50.0px;">
                    <span style="font-size: 26px; color: #01325B; font-weight: bold;">İşe Başlamama Bildirimi</span>
                </td>
            </tr>
        </table>
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:0 0 0 0;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <p
                                                style="margin-top:24px; line-height: 15px; text-align: left; margin: 10px 0; margin-bottom:0px; font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <b><p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Merhabalar,</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İşyerinde uyguladığımız PDKS kontrolümüz kapsamında {{day}}/{{month}}/{{year}} tarihinde çıkış kaydınızın olmadığı tespit edilmiştir.</p>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Lütfen kartınızı en yakın yetkili olduğunuz çıkış noktasından okutunuz.</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İnsan Kaynakları Müdürlüğü</p><r></b><br><hr>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu e-posta otomatik olarak üretildi. Yanıtlamayınız! </p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:32px 0px;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="center"
                                        style="font-size:0px;padding:10px 25px;padding-bottom:0px;word-break:break-word;">
                                        <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                            style="border-collapse:collapse;border-spacing:0px;">
                                            <tbody>
                                                <tr>
                                                    <td style="width:100px;">
                                                        <img height="auto" src="{{armonLogo}}"
                                                            style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
                                                            width="100" />
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-top:0px;padding-bottom:0px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#55575d;">
                                            <p
                                                style="line-height: 16px; text-align: center; margin: 10px 0;font-size:8px;color:#A7A7A7;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu bildirim ARMON geçiş kontrol sistemi ile gönderilmiştir. &nbsp;<br /><span
                                                style="color:#A7A7A7;font-family:'Times New Roman',Helvetica,Arial,sans-serif">armon
                                                © {{{year}}} </span></p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    </div>
</body>

</html>
`;
const pacsMissingWorkSelfEmail = `<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
    xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <title>
    </title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">
        #outlook a {
            padding: 0;
        }

        body {
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table,
        td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
        }

        p {
            display: block;
            margin: 13px 0;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700" rel="stylesheet" type="text/css">
    <style type="text/css">
        @import url(https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700);
    </style>
    <style type="text/css">
        @media only screen and (min-width:480px) {
            .mj-column-per-50 {
                width: 50% !important;
                max-width: 50%;
            }

            .mj-column-per-100 {
                width: 100% !important;
                max-width: 100%;
            }
        }
    </style>
    <style type="text/css">
        @media only screen and (max-width:480px) {
            table.mj-full-width-mobile {
                width: 100% !important;
            }

            td.mj-full-width-mobile {
                width: auto !important;
            }
        }
    </style>
</head>

<body style="background-color:#FAFAFA;">
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:middle;"
            width="100%">
            <tr>
                <td align="left" style="padding: 10.0px 25.0px;padding-top:
                                                70.0px;padding-bottom: 10.0px;padding-left: 50.0px;">
                    <span style="font-size: 26px; color: #01325B; font-weight: bold;">Eksik Mesai Bildirimi</span>
                </td>
            </tr>
        </table>
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:0 0 0 0;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <p
                                                style="margin-top:24px; line-height: 15px; text-align: left; margin: 10px 0; margin-bottom:0px; font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-left:50px;word-break:break-word;">
                                      <div
                                            style="font-family:Segoe UI, Arial, sans-serif;font-size:12px;line-height:2px;text-align:left;color:#55575d;">
                                            <b><p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Merhabalar,</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İşyerinde uyguladığımız PDKS kontrolümüz kapsamında {{day}}/{{month}}/{{year}} tarihinde geç giriş yada erken çıkış yaptığınız tespit edilmiştir.</p>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İzin girişinizi GBS üzerinden girmenizi rica ederiz.</p><br>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                *İzin girişinizi oluşturduysanız lütfen bu maili dikkate almayınız.</p><br>                                                
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                İnsan Kaynakları Müdürlüğü</p><r></b><br><hr>
                                            <p
                                                style="line-height: 20px; text-align: left; margin: 0px 0;font-size:14px;color:#01325B;font-family:'Segoe UI, Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu e-posta otomatik olarak üretildi. Yanıtlamayınız! </p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div style="background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;">
        <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation"
            style="background:#ffffff;background-color:#ffffff;width:100%;">
            <tbody>
                <tr>
                    <td style="direction:ltr;font-size:0px;padding:32px 0px;text-align:center;">
                        <div class="mj-column-per-100 mj-outlook-group-fix"
                            style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                            <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                style="vertical-align:top;" width="100%">
                                <tr>
                                    <td align="center"
                                        style="font-size:0px;padding:10px 25px;padding-bottom:0px;word-break:break-word;">
                                        <table border="0" cellpadding="0" cellspacing="0" role="presentation"
                                            style="border-collapse:collapse;border-spacing:0px;">
                                            <tbody>
                                                <tr>
                                                    <td style="width:100px;">
                                                        <img height="auto" src="{{armonLogo}}"
                                                            style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;"
                                                            width="100" />
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left"
                                        style="font-size:0px;padding:10px 25px;padding-top:0px;padding-bottom:0px;word-break:break-word;">
                                        <div
                                            style="font-family:Segoe UI, Arial, Arial, sans-serif;font-size:13px;line-height:22px;text-align:left;color:#55575d;">
                                            <p
                                                style="line-height: 16px; text-align: center; margin: 10px 0;font-size:8px;color:#A7A7A7;font-family:'Segoe UI,Times New Roman',Helvetica,Arial,sans-serif">
                                                Bu bildirim ARMON geçiş kontrol sistemi ile gönderilmiştir. &nbsp;<br /><span
                                                    style="color:#A7A7A7;font-family:'Times New Roman',Helvetica,Arial,sans-serif">armon
                                                    © {{{year}}} </span></p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    </div>
</body>

</html>`;
