"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPermissionUsageCount = exports.substractBreaksForWhiteCollar = exports.substractBreaks = exports.calculatePermissionTime = exports.applyHolidays = exports.applyRuleForWhiteCollar = exports.applyRuleForBlueCollarShiftUnion = exports.applyRuleForBlueCollarUnion = exports.applyRuleForBetweenShiftTimes = exports.applyRuleForBlueCollarShift = void 0;
const luxon_1 = require("luxon");
const constants_1 = require("../models/constants");
const dal_constants_1 = require("../../../../dal/dal.constants");
const app_enums_1 = require("../../../../app.enums");
function applyRuleForBlueCollarShift(data, permissionTime, userExtraWorkData, vacations, previousDay) {
    const currentDayStart = luxon_1.DateTime.fromISO(String(data.d));
    const currentDayEnd = currentDayStart.plus({ days: 1 });
    const vacationExistency = vacations.items.find((elem) => luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromJSDate(elem.startDateTime), luxon_1.DateTime.fromJSDate(elem.endDateTime)).intersection(luxon_1.Interval.fromDateTimes(currentDayStart, currentDayEnd)));
    if (vacationExistency) {
        applyHolidays(data, userExtraWorkData, currentDayStart, vacationExistency, permissionTime);
    }
    else if (data.s.wd === 0) {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_SONU_UCRET_TURU] += substractBreaks(permissionTime);
    }
    else {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_ICI_UCRET_TURU] += substractBreaks(permissionTime);
    }
    if (previousDay) {
        applyRuleForBetweenShiftTimes(previousDay, data, userExtraWorkData);
    }
}
exports.applyRuleForBlueCollarShift = applyRuleForBlueCollarShift;
function applyRuleForBetweenShiftTimes(previousDay, currentDay, extraWorkData) {
    const currentDayWorkingStart = currentDay.ws.filter((elem) => elem.wt === dal_constants_1.DalConstants.WorkPlanTimeRangeType.WorkingHours)[0]?.s;
    const previosDayWorkingEnd = previousDay.e.filter((elem) => elem.wt === dal_constants_1.DalConstants.WorkPlanTimeRangeType.WorkingHours).slice(-1)[0]?.e;
    if (previosDayWorkingEnd && currentDayWorkingStart && currentDay.s.n > 0 && previousDay.s.n > 0) {
        const hoursBetweenTwoShifts = luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(previosDayWorkingEnd), luxon_1.DateTime.fromISO(currentDayWorkingStart))
            .toDuration("hours")
            .toObject().hours;
        if (hoursBetweenTwoShifts < 16) {
            extraWorkData[constants_1.ExtraWorkTypes.KISA_DONUS_UCRET_TURU] += 7.5;
        }
    }
}
exports.applyRuleForBetweenShiftTimes = applyRuleForBetweenShiftTimes;
function applyRuleForBlueCollarUnion(data, permissionTime, userExtraWorkData, vacations) {
    const currentDayStart = luxon_1.DateTime.fromISO(String(data.d));
    const currentDayEnd = currentDayStart.plus({ days: 1 });
    const vacationExistency = vacations.items.find((elem) => luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromJSDate(elem.startDateTime), luxon_1.DateTime.fromJSDate(elem.endDateTime)).intersection(luxon_1.Interval.fromDateTimes(currentDayStart, currentDayEnd)));
    if (vacationExistency) {
        applyHolidays(data, userExtraWorkData, currentDayStart, vacationExistency, permissionTime);
    }
    else if (data.s.wd === 0) {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_SONU_UCRET_TURU] += substractBreaks(permissionTime);
    }
    else {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_ICI_UCRET_TURU] += substractBreaks(permissionTime);
    }
}
exports.applyRuleForBlueCollarUnion = applyRuleForBlueCollarUnion;
function applyRuleForBlueCollarShiftUnion(data, permissionTime, userExtraWorkData, vacations, previousDay) {
    const currentDayStart = luxon_1.DateTime.fromISO(String(data.d));
    const currentDayEnd = currentDayStart.plus({ days: 1 });
    const vacationExistency = vacations.items.find((elem) => luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromJSDate(elem.startDateTime), luxon_1.DateTime.fromJSDate(elem.endDateTime)).intersection(luxon_1.Interval.fromDateTimes(currentDayStart, currentDayEnd)));
    if (vacationExistency) {
        applyHolidays(data, userExtraWorkData, currentDayStart, vacationExistency, permissionTime);
    }
    else if (data.s.wd === 0) {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_SONU_UCRET_TURU] += substractBreaks(permissionTime);
    }
    else {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_ICI_UCRET_TURU] += substractBreaks(permissionTime);
    }
    if (previousDay) {
        applyRuleForBetweenShiftTimes(previousDay, data, userExtraWorkData);
    }
}
exports.applyRuleForBlueCollarShiftUnion = applyRuleForBlueCollarShiftUnion;
function applyRuleForWhiteCollar(data, permissionTime, userExtraWorkData, vacations) {
    const currentDayStart = luxon_1.DateTime.fromISO(String(data.d));
    const currentDayEnd = currentDayStart.plus({ days: 1 });
    const vacationExistency = vacations.items.find((elem) => luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromJSDate(elem.startDateTime), luxon_1.DateTime.fromJSDate(elem.endDateTime)).intersection(luxon_1.Interval.fromDateTimes(currentDayStart, currentDayEnd)));
    if (vacationExistency) {
        applyHolidays(data, userExtraWorkData, currentDayStart, vacationExistency, permissionTime);
    }
    else if (data.s.wd === 0) {
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_SONU_UCRET_TURU] += substractBreaksForWhiteCollar(permissionTime);
    }
    else {
        let workingTime = 0;
        data.c.forEach((segment) => {
            if (segment.es.w === true) {
                const intersection = luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(segment.s), luxon_1.DateTime.fromISO(segment.e)).intersection(luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(currentDayStart.toISO()).set({ hour: 18 }), luxon_1.DateTime.fromISO(currentDayStart.toISO()).plus({ day: 1 })));
                workingTime += intersection ? intersection.toDuration("hours").toObject().hours : 0;
            }
        });
        userExtraWorkData[constants_1.ExtraWorkTypes.HAFTA_ICI_UCRET_TURU] += substractBreaksForWhiteCollar(workingTime);
    }
}
exports.applyRuleForWhiteCollar = applyRuleForWhiteCollar;
function applyHolidays(data, userExtraWorkData, currentDay, vacationExistency, permissionTime) {
    switch (vacationExistency.type) {
        case app_enums_1.enums.VacationType.BeforeNational:
        case app_enums_1.enums.VacationType.BeforeReligious:
            let workingTime = 0;
            data.c.forEach((segment) => {
                if (segment.es.w === true) {
                    const intersection = luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(segment.s), luxon_1.DateTime.fromISO(segment.e)).intersection(luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(currentDay.toISO()).set({ hour: 13 }), luxon_1.DateTime.fromISO(currentDay.toISO()).plus({ day: 1 })));
                    workingTime += intersection ? intersection.toDuration("hours").toObject().hours : 0;
                }
            });
            userExtraWorkData[constants_1.ExtraWorkTypes.RESMI_TATIL_UCRET_TURU] += substractBreaks(workingTime);
            break;
        case app_enums_1.enums.VacationType.National:
        case app_enums_1.enums.VacationType.Religious:
            userExtraWorkData[constants_1.ExtraWorkTypes.RESMI_TATIL_UCRET_TURU] += substractBreaks(permissionTime);
            break;
    }
}
exports.applyHolidays = applyHolidays;
function calculatePermissionTime(permissionUsageShort) {
    const permissionUsageTime = permissionUsageShort.u / 60;
    const permissionDefinitionRange = luxon_1.DateTime.fromISO(permissionUsageShort.r.e)
        .diff(luxon_1.DateTime.fromISO(permissionUsageShort.r.e), "hours")
        .toObject().hours;
    if (permissionUsageTime < 3 && permissionDefinitionRange === 3) {
        return 3;
    }
    else {
        return permissionUsageTime;
    }
}
exports.calculatePermissionTime = calculatePermissionTime;
function roundToNearestHalfHour(input) {
    return Math.ceil(input * 2) / 2;
}
function substractBreaks(time) {
    if (time <= 4) {
        time = roundToNearestHalfHour(time - 0.25);
    }
    else if (time < 7) {
        time = roundToNearestHalfHour(time - 0.5);
    }
    else if (time < 8) {
        if (time < 7.35) {
            time = 7.5;
        }
        else {
            time = 8;
        }
    }
    else if (time <= 11) {
        if (time === 8) {
            time -= 0.5;
        }
        else {
            time = roundToNearestHalfHour(time - 1);
        }
    }
    else {
        time = roundToNearestHalfHour(time - 1.5);
    }
    return time;
}
exports.substractBreaks = substractBreaks;
function substractBreaksForWhiteCollar(time) {
    if (time <= 4) {
        time -= 0.25;
    }
    else if (time <= 7.5) {
        time -= 0.5;
    }
    else if (time <= 11) {
        if (time === 8) {
            time -= 0.5;
        }
        else {
            time -= 1;
        }
    }
    else {
        time -= 1.5;
    }
    return time;
}
exports.substractBreaksForWhiteCollar = substractBreaksForWhiteCollar;
function getPermissionUsageCount(permissions, permissionType) {
    let result = 0;
    result =
        permissions
            ?.filter((elem) => elem.typeId === permissionType)
            .map((item) => item.usageDay)
            .reduce((acc, curr) => acc + curr, 0) ?? 0;
    return result;
}
exports.getPermissionUsageCount = getPermissionUsageCount;
