"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartOfOrganizationForm = exports.ExtraLeaveTypeId = exports.ExtraWorkTypes = exports.EmployeeUnionConditions = exports.EmployeeSubGroups = exports.HeadersStyling = exports.generateEmployeeDataQuery = exports.TallyReportContent = exports.TallyReportsAdditionalPaymentContents = exports.TallyReportPermissionConditionsContent = exports.TallyReportPreviousMonthPermissionConditionsContent = exports.SecondReportFeeTypeRules = exports.FirstReportFeeTypeRules = exports.UniqueIdExtensionFieldRule = exports.AdditionalPaymentSecondReportFeeTypes = exports.AdditionalPaymentFirstReportFeeTypes = exports.EYASPermissionTypeAbbrevations = exports.EYASPermissionTypes = void 0;
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
exports.EYASPermissionTypes = {
    SAP100: "69e0fc4e-55ce-48d4-a8a8-be7424d00196",
    SAP131: "ad04abc5-43d0-45dd-9a58-fa20fc92dbca",
    SAP135: "251d35dd-4f79-4896-8a9f-8f55a081f06f",
    SAP150: "1752150a-8d41-4215-a094-dc2d766205c9",
    SAP155: "67099cba-1017-4e65-9e88-37d056d94d90",
    SAP15: "94f91480-6931-4cec-b811-8b7e5d6fd473",
    SAP160: "415b5c9b-74fb-47ea-815f-7c6e95b3b085",
    SAP200: "93e00aaa-d50a-430d-9d06-527afe0d3ac7",
    SAP210: "6128f4d5-7c29-482e-af4e-018af86b92a3",
    SAP240: "11ac1771-64cc-4639-992c-67c856d1d0b3",
    SAP25: "30eb6ac9-fc7b-4fe8-82e8-2467f43cd6ed",
    SAP270: "e4285652-fa34-4802-9b92-8ca745117bac",
    SAP280: "502b364e-5296-405a-91be-851539ecf66e",
    SAP310: "8235ed06-7f7c-4bd1-bf1e-a311c2ae8b26",
    SAP380: "0c358827-d982-4825-9feb-44fda1dd4078",
    SAP390: "65f6d83d-09a0-45e2-afb7-1c9012303f96",
    SAP400: "cf98eb30-63ee-4231-b66b-482bfbd7e069",
    SAP45: "c1fda513-f1f8-4be6-8520-796ac583e64b",
    SAP470: "7e8426ca-3a82-4b3b-a0da-7c5eee1e3e78",
    SAP480: "56792138-91b5-4786-8649-edfcb2e81cb8",
    SAP490: "8814db56-2fcc-408f-bd80-5b38fe57fedd",
    SAP500: "22f9e505-ff95-44ee-b050-5ecf43984867",
    SAP510: "71d61075-9280-4fa6-985a-196009e6a67c",
    SAP55: "fceda345-c772-4cd3-8d53-9855cf73c046",
    SAP56: "b4fb7d5f-88e1-4d25-b3c8-141db8dcaed3",
    SAP80: "fbcd7045-4156-4fae-bbbd-44fd19654204",
    SEYYAR_GOREV: "916e0446-3abb-4ed2-b249-4cdc3a71ac29",
    ARAC_KULLANMA: "0e3f637d-0edf-44dc-b1b4-9271b7a772e2",
};
exports.EYASPermissionTypeAbbrevations = {
    [exports.EYASPermissionTypes.SAP150]: "Y",
    [exports.EYASPermissionTypes.SAP155]: "Y.Y.",
    [exports.EYASPermissionTypes.SAP135]: "Ü.İ",
    [exports.EYASPermissionTypes.SAP200]: "Ü.SİZ",
    [exports.EYASPermissionTypes.SAP210]: "D",
    [exports.EYASPermissionTypes.SAP55]: "R",
    [exports.EYASPermissionTypes.SAP56]: "R.D.Ö",
    [exports.EYASPermissionTypes.SAP131]: "R",
    [exports.EYASPermissionTypes.SAP470]: "R.D",
    [exports.EYASPermissionTypes.SAP500]: "S",
    [exports.EYASPermissionTypes.SAP160]: "S.İ",
    [exports.EYASPermissionTypes.SAP240]: "K.Ç",
    [exports.EYASPermissionTypes.SAP100]: "S",
    [exports.EYASPermissionTypes.SAP390]: "D.İ",
    [exports.EYASPermissionTypes.SAP380]: "İ.D",
    [exports.EYASPermissionTypes.SAP310]: "Y.Ç",
    [exports.EYASPermissionTypes.SAP280]: "G",
    [exports.EYASPermissionTypes.SAP270]: "T",
    [exports.EYASPermissionTypes.SAP15]: "EV.",
    [exports.EYASPermissionTypes.SAP45]: "VE.",
    [exports.EYASPermissionTypes.SAP25]: "BA.",
    [exports.EYASPermissionTypes.SAP400]: "U.Ç",
    [exports.EYASPermissionTypes.SAP480]: "T.Ş.",
    [exports.EYASPermissionTypes.SAP490]: "EVL.",
    [exports.EYASPermissionTypes.SAP80]: "Ü.D",
    [exports.EYASPermissionTypes.SAP510]: "S.Y.",
};
var AdditionalPaymentFirstReportFeeTypes;
(function (AdditionalPaymentFirstReportFeeTypes) {
    AdditionalPaymentFirstReportFeeTypes["YEMEK_UCRETI_NET"] = "2010";
    AdditionalPaymentFirstReportFeeTypes["YOL_UCRETI_AKTARIM"] = "2050";
    AdditionalPaymentFirstReportFeeTypes["YEMEK_ODEME_SENDIKA"] = "2975";
})(AdditionalPaymentFirstReportFeeTypes = exports.AdditionalPaymentFirstReportFeeTypes || (exports.AdditionalPaymentFirstReportFeeTypes = {}));
var AdditionalPaymentSecondReportFeeTypes;
(function (AdditionalPaymentSecondReportFeeTypes) {
    AdditionalPaymentSecondReportFeeTypes["VARDIYA_TAZMINATI_2LI"] = "2986";
    AdditionalPaymentSecondReportFeeTypes["VARDIYA_TAZMINATI_3LU"] = "2985";
    AdditionalPaymentSecondReportFeeTypes["SEYYAR_GOREV_TAZMINATI"] = "2994";
    AdditionalPaymentSecondReportFeeTypes["ARAC_KULLANIM_TAZMINATI"] = "2988";
    AdditionalPaymentSecondReportFeeTypes["BAKIM_TAZMINATI"] = "2260";
})(AdditionalPaymentSecondReportFeeTypes = exports.AdditionalPaymentSecondReportFeeTypes || (exports.AdditionalPaymentSecondReportFeeTypes = {}));
exports.UniqueIdExtensionFieldRule = {
    key: "org_employee_group",
    validValues: ["1", "2", "4", "7", "9", "F"],
};
exports.FirstReportFeeTypeRules = {
    [AdditionalPaymentFirstReportFeeTypes.YEMEK_UCRETI_NET]: {
        name: "2010 Yemek Ücreti Net",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["1", "4", "10"],
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'lü vardiya oranı", "2'li vardiya oranı"],
                    },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP200,
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP470,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP155,
                    exports.EYASPermissionTypes.SAP135,
                    exports.EYASPermissionTypes.SAP500,
                    exports.EYASPermissionTypes.SAP160,
                    exports.EYASPermissionTypes.SAP100,
                    exports.EYASPermissionTypes.SAP390,
                    exports.EYASPermissionTypes.SAP380,
                    exports.EYASPermissionTypes.SAP310,
                    exports.EYASPermissionTypes.SAP15,
                    exports.EYASPermissionTypes.SAP45,
                    exports.EYASPermissionTypes.SAP25,
                    exports.EYASPermissionTypes.SAP480,
                    exports.EYASPermissionTypes.SAP490,
                    exports.EYASPermissionTypes.SAP510,
                ],
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["1", "4", "10"],
                    },
                    { key: "org_shift_comp_ratio", validValues: ["Vardiya Tazminatı Almaz"] },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP200,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP470,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP155,
                    exports.EYASPermissionTypes.SAP135,
                    exports.EYASPermissionTypes.SAP500,
                    exports.EYASPermissionTypes.SAP160,
                    exports.EYASPermissionTypes.SAP100,
                    exports.EYASPermissionTypes.SAP390,
                    exports.EYASPermissionTypes.SAP380,
                    exports.EYASPermissionTypes.SAP310,
                    exports.EYASPermissionTypes.SAP15,
                    exports.EYASPermissionTypes.SAP45,
                    exports.EYASPermissionTypes.SAP25,
                    exports.EYASPermissionTypes.SAP480,
                    exports.EYASPermissionTypes.SAP490,
                    exports.EYASPermissionTypes.SAP510,
                ],
            },
        ],
    },
    [AdditionalPaymentFirstReportFeeTypes.YOL_UCRETI_AKTARIM]: {
        name: "2050 Yol Ücreti Net",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["1", "4", "10"],
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'lü vardiya oranı", "2'li vardiya oranı"],
                    },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP200,
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP470,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP155,
                    exports.EYASPermissionTypes.SAP135,
                    exports.EYASPermissionTypes.SAP500,
                    exports.EYASPermissionTypes.SAP160,
                    exports.EYASPermissionTypes.SAP100,
                    exports.EYASPermissionTypes.SAP390,
                    exports.EYASPermissionTypes.SAP380,
                    exports.EYASPermissionTypes.SAP310,
                    exports.EYASPermissionTypes.SAP15,
                    exports.EYASPermissionTypes.SAP45,
                    exports.EYASPermissionTypes.SAP25,
                    exports.EYASPermissionTypes.SAP480,
                    exports.EYASPermissionTypes.SAP490,
                    exports.EYASPermissionTypes.SAP510,
                    exports.EYASPermissionTypes.SAP400,
                ],
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["1", "4", "10"],
                    },
                    { key: "org_shift_comp_ratio", validValues: ["Vardiya Tazminatı Almaz"] },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP200,
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP470,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP155,
                    exports.EYASPermissionTypes.SAP135,
                    exports.EYASPermissionTypes.SAP500,
                    exports.EYASPermissionTypes.SAP160,
                    exports.EYASPermissionTypes.SAP100,
                    exports.EYASPermissionTypes.SAP390,
                    exports.EYASPermissionTypes.SAP380,
                    exports.EYASPermissionTypes.SAP310,
                    exports.EYASPermissionTypes.SAP15,
                    exports.EYASPermissionTypes.SAP45,
                    exports.EYASPermissionTypes.SAP25,
                    exports.EYASPermissionTypes.SAP480,
                    exports.EYASPermissionTypes.SAP490,
                    exports.EYASPermissionTypes.SAP510,
                    exports.EYASPermissionTypes.SAP400,
                ],
            },
        ],
    },
    [AdditionalPaymentFirstReportFeeTypes.YEMEK_ODEME_SENDIKA]: {
        name: "2975 Yemek Ücreti Net Sendika ",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                ],
                decreasingPermissions: [],
            },
        ],
    },
};
exports.SecondReportFeeTypeRules = {
    [AdditionalPaymentSecondReportFeeTypes.VARDIYA_TAZMINATI_2LI]: {
        name: "2986 2'li vardiya tazminatı",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["2'li vardiya oranı"],
                    },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP470,
                ],
            },
        ],
    },
    [AdditionalPaymentSecondReportFeeTypes.VARDIYA_TAZMINATI_3LU]: {
        name: "2985 3'lü vardiya tazminatı",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'lü vardiya oranı"],
                    },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP470,
                ],
            },
        ],
    },
    [AdditionalPaymentSecondReportFeeTypes.SEYYAR_GOREV_TAZMINATI]: {
        name: "2994 Seyyar Görev Tazminatı",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                ],
                decreasingPermissions: [],
            },
        ],
    },
    [AdditionalPaymentSecondReportFeeTypes.ARAC_KULLANIM_TAZMINATI]: {
        name: "2988 Araç Kullanım Tazminatı",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                ],
                decreasingPermissions: [],
            },
        ],
    },
    [AdditionalPaymentSecondReportFeeTypes.BAKIM_TAZMINATI]: {
        name: "Bakım Tazminatı",
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["4", "10"],
                    },
                    {
                        key: "org_care_comp",
                        validValues: ["Alır"],
                    },
                ],
                decreasingPermissions: [
                    exports.EYASPermissionTypes.SAP55,
                    exports.EYASPermissionTypes.SAP56,
                    exports.EYASPermissionTypes.SAP80,
                    exports.EYASPermissionTypes.SAP131,
                    exports.EYASPermissionTypes.SAP150,
                    exports.EYASPermissionTypes.SAP200,
                    exports.EYASPermissionTypes.SAP210,
                    exports.EYASPermissionTypes.SAP240,
                    exports.EYASPermissionTypes.SAP270,
                    exports.EYASPermissionTypes.SAP280,
                    exports.EYASPermissionTypes.SAP470,
                ],
            },
        ],
    },
};
exports.TallyReportPreviousMonthPermissionConditionsContent = [
    "=Y",
    "=Y.Y",
    "=Ü.SİZ",
    "=K.Ç",
    "=Y.Ç",
    "=Ü.D",
    "=G",
    "=T",
    "=D",
    "=R",
    "=R.D.Ö",
    "R.D",
    "=U.İ",
    "=S.İ",
    "=İ.D",
    "=T.Ş",
    "=EV.",
    "=VE.",
    "=BA.",
    "=EVL.",
    "=S",
    "D.İ",
    "SçY",
];
exports.TallyReportPermissionConditionsContent = [
    {
        name: "UZAKTAN ÇALIŞMA",
        conditions: ["=U.Ç"],
    },
    {
        name: "YILLIK İZİN",
        conditions: ["=Y"],
    },
    {
        name: "YILLIK İZİN (Yarım Gün)",
        conditions: ["=Y.Y"],
    },
    {
        name: "ÜCRETSİZ İZİN",
        conditions: ["=Ü.SİZ", "=K.Ç", "=Y.Ç", "=Ü.D", "=G", "=T", "=D"],
    },
    {
        name: "RAPORLAR",
        conditions: ["=R", "=R.D.Ö", "R.D"],
    },
    {
        name: "ÜCRETLİ İZİN",
        conditions: ["=U.İ", "=S.İ", "=İ.D", "=T.Ş"],
    },
    {
        name: "MAZERET İZNİ",
        conditions: ["=EV.", "=VE.", "=BA.", "=EVL."],
    },
    {
        name: "SOSYAL İZİN",
        conditions: ["=S", "D.İ", "SçY"],
    },
    {
        name: "ÇALIŞILMAYAN GELEN TATİL",
        conditions: ["=GT"],
    },
    {
        name: "ÇALIŞILMAYAN HAFTA TATİLİ",
        conditions: ["=HT"],
    },
    {
        name: "ÇALIŞILMAYAN BAYRAM TATİLİ",
        conditions: ["=BT", "=A"],
    },
];
exports.TallyReportsAdditionalPaymentContents = [
    exports.SecondReportFeeTypeRules[AdditionalPaymentSecondReportFeeTypes.SEYYAR_GOREV_TAZMINATI],
    exports.SecondReportFeeTypeRules[AdditionalPaymentSecondReportFeeTypes.ARAC_KULLANIM_TAZMINATI],
    exports.SecondReportFeeTypeRules[AdditionalPaymentSecondReportFeeTypes.VARDIYA_TAZMINATI_2LI],
    exports.SecondReportFeeTypeRules[AdditionalPaymentSecondReportFeeTypes.VARDIYA_TAZMINATI_3LU],
    exports.FirstReportFeeTypeRules[AdditionalPaymentFirstReportFeeTypes.YEMEK_ODEME_SENDIKA],
    exports.FirstReportFeeTypeRules[AdditionalPaymentFirstReportFeeTypes.YEMEK_UCRETI_NET],
    exports.FirstReportFeeTypeRules[AdditionalPaymentFirstReportFeeTypes.YOL_UCRETI_AKTARIM],
];
exports.TallyReportContent = [
    "NORMAL ÇALIŞMA GÜNÜ",
    ...exports.TallyReportPermissionConditionsContent.map((elem) => elem.name),
    "TOPLAM GÜN",
    "Haftaiçi Toplam Fazla Mesai Saati",
    "Haftasonu Toplam Fazla Mesai Saati",
    "UBGT Fazla Mesai Saati",
    "Kısa Dönüş Fazla Mesai Saati",
    ...Object.values(exports.SecondReportFeeTypeRules).map((elem) => elem.name),
    "İŞ GÜÇLÜĞÜ TAZMİNATI TAZMİNATI",
    "BÖLGE TAZMİNATI GRUBU",
    "AİLE YARDIMI (gün)",
    ...Object.values(exports.FirstReportFeeTypeRules).map((elem) => elem.name),
];
function generateEmployeeDataQuery(organizationId, userFilter, startDate, startDateWithOffset, endDate, endDateWithOffset) {
    let bindings = userFilter.bindingKeys;
    const result = `
		DECLARE employee_day_cursor
		CURSOR FOR
		WITH employee_day_cte AS(
			SELECT	"userId",
					"uniqueId",
					fullname,
					COALESCE("extensionFields","extensionFields",'{}') as "extensionFields",
					"employmentStartUtc",
					"employmentEndUtc",
					jsonb_agg("dailyData" ORDER BY "dailyData"->'data'->>'d' ASC) "monthlyData",
					(SUM(CASE WHEN (ordered.data->'s'->>'wd')::int > 0 AND ordered.date >= $${userFilter.bindingKeys.length + 1} THEN 1 END))::integer as "countOfWorkingDays",
					SUM(CASE WHEN ordered."normalWork" + ordered."extraWork" - ordered."expectedWork" >= 240 THEN 1 ELSE 0 END)::integer as "mealFee"
			FROM
			(
				SELECT  ed."userId",
						ed."date",
						uop."uniqueId",
						uop."name" || ' ' || uop."surname" as fullname,
						uop."extensionFields"::jsonb,
						uop."employmentStartUtc",
						uop."employmentEndUtc",
						ed.data,
						jsonb_build_object('date', ed.date, 'data', ed.data) as "dailyData",
						(ed.data->'s'->>'ew')::integer as "expectedWork",
						(ed.data->'s'->>'n')::integer as "normalWork",
						(ed.data->'s'->>'e')::integer as "extraWork"
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" as uo
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" as uop
					ON uo.id = uop."userOrganizationId"
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeDays}" AS ed
					ON ed."userId" = uop."userId"
				INNER JOIN
					(${userFilter.query}) AS T3
					ON T3."userId" = ed."userId" AND ed."data" IS NOT NULL
				WHERE ed.date >= $${userFilter.bindingKeys.length + 3} AND ed.date <= $${userFilter.bindingKeys.length + 4}
				ORDER BY ed.date ASC
			) as ordered
			GROUP BY "userId", "uniqueId", fullname, "extensionFields"::jsonb, "employmentStartUtc", "employmentEndUtc"
		), permission_cte AS (
			SELECT  pp.id,
					upp."userId",
					pt.id as "typeId",
					pp."dynamicFormData",
					CASE    WHEN tstzrange($${userFilter.bindingKeys.length + 3}, $${userFilter.bindingKeys.length + 1}) && tstzrange(pp."startDateTime", pp."endDateTime") 
								 AND pp."requestDateTime" >=  $${userFilter.bindingKeys.length + 3} AND pp."requestDateTime" < $${userFilter.bindingKeys.length + 2}
							THEN tstzrange(pp."startDateTime", pp."endDateTime") * tstzrange($${userFilter.bindingKeys.length + 3} , $${userFilter.bindingKeys.length + 4})
							WHEN tstzrange($${userFilter.bindingKeys.length + 3}, $${userFilter.bindingKeys.length + 1}) && tstzrange(pp."startDateTime", pp."endDateTime") 
								 AND pp."requestDateTime" >=  $${userFilter.bindingKeys.length + 3} 
							THEN tstzrange(pp."startDateTime", pp."endDateTime") * tstzrange($${userFilter.bindingKeys.length + 3} , $${userFilter.bindingKeys.length + 2})
							WHEN  tstzrange($${userFilter.bindingKeys.length + 1}, $${userFilter.bindingKeys.length + 4}) && tstzrange(pp."startDateTime", pp."endDateTime")
								AND pp."requestDateTime" < $${userFilter.bindingKeys.length + 2}
							THEN tstzrange($${userFilter.bindingKeys.length + 1}, $${userFilter.bindingKeys.length + 4}) * tstzrange(pp."startDateTime", pp."endDateTime")
							WHEN  tstzrange($${userFilter.bindingKeys.length + 1}, $${userFilter.bindingKeys.length + 4}) &&  tstzrange(pp."startDateTime", pp."endDateTime")
								AND pp."requestDateTime" >= $${userFilter.bindingKeys.length + 2}
							THEN tstzrange($${userFilter.bindingKeys.length + 1}, $${userFilter.bindingKeys.length + 2}) * tstzrange(pp."startDateTime", pp."endDateTime")
					ELSE NULL END as "permissionIntersection"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissions}" as pp
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userPPermissions}" as upp
				ON pp.id = upp."ppermissionId"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissionTypes}" as pt
				ON  pt.id = pp."ppermissionTypeId"
			WHERE	pp.status = 1 
		)
		SELECT  edc.*,
				perms."permissions"
		FROM employee_day_cte as edc
		LEFT JOIN (
			SELECT 	
				"userId",
				jsonb_agg(
					jsonb_build_object(
					'id',"id",
					'typeId', "typeId",
					'dynamicFormData', "dynamicFormData",
					'usageDay', EXTRACT (DAY FROM (upper("permissionIntersection") - lower("permissionIntersection")))
					)
				) as permissions
			FROM permission_cte
			WHERE "permissionIntersection" IS NOT NULL
			GROUP BY "userId"
			) perms
		ON perms."userId" = edc."userId";
`;
    bindings.push(startDate, endDateWithOffset, startDateWithOffset, endDate);
    return { query: result, bindings: bindings };
}
exports.generateEmployeeDataQuery = generateEmployeeDataQuery;
exports.HeadersStyling = {
    v1: {
        border: {
            right: {
                style: "thin",
            },
            bottom: {
                style: "thick",
            },
        },
        font: { name: "Calibri", size: 16, bold: true, color: { argb: "FFC00000" } },
    },
    v2: {
        border: {
            right: {
                style: "thin",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
        },
        font: { name: "Calibri", size: 14, bold: true },
    },
    v3: {
        border: {
            right: {
                style: "thin",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
        },
        font: { name: "Calibri", size: 14, bold: false },
    },
};
var EmployeeSubGroups;
(function (EmployeeSubGroups) {
    EmployeeSubGroups["BEYAZ_YAKA"] = "1";
    EmployeeSubGroups["MAVI_YAKA_SENDIKALI_VARDIYALI"] = "2";
    EmployeeSubGroups["MAVI_YAKA_SENDIKALI_VARDIYASIZ"] = "3";
    EmployeeSubGroups["MAVI_YAKA_SENDIKASIZ_VARDIYALI"] = "4";
})(EmployeeSubGroups = exports.EmployeeSubGroups || (exports.EmployeeSubGroups = {}));
exports.EmployeeUnionConditions = {
    [EmployeeSubGroups.BEYAZ_YAKA]: [{ key: "org_employee_subgroup", values: ["1"] }],
    [EmployeeSubGroups.MAVI_YAKA_SENDIKALI_VARDIYALI]: [{ key: "org_employee_subgroup", values: ["10"] }, { key: "org_shift_comp_ratio", values: ["2'li vardiya oranı", "3'lü vardiya oranı"] }],
    [EmployeeSubGroups.MAVI_YAKA_SENDIKALI_VARDIYASIZ]: [{ key: "org_employee_subgroup", values: ["10"] }, { key: "org_shift_comp_ratio", values: ["Vardiya Tazminatı Almaz"] }],
    [EmployeeSubGroups.MAVI_YAKA_SENDIKASIZ_VARDIYALI]: [{ key: "org_employee_subgroup", values: ["4"] }],
};
var ExtraWorkTypes;
(function (ExtraWorkTypes) {
    ExtraWorkTypes[ExtraWorkTypes["HAFTA_ICI_UCRET_TURU"] = 4260] = "HAFTA_ICI_UCRET_TURU";
    ExtraWorkTypes[ExtraWorkTypes["HAFTA_SONU_UCRET_TURU"] = 4265] = "HAFTA_SONU_UCRET_TURU";
    ExtraWorkTypes[ExtraWorkTypes["KISA_DONUS_UCRET_TURU"] = 1580] = "KISA_DONUS_UCRET_TURU";
    ExtraWorkTypes[ExtraWorkTypes["RESMI_TATIL_UCRET_TURU"] = 4460] = "RESMI_TATIL_UCRET_TURU";
})(ExtraWorkTypes = exports.ExtraWorkTypes || (exports.ExtraWorkTypes = {}));
exports.ExtraLeaveTypeId = "ca6a0f5b-737c-47d3-8bb4-1f9e422509d4";
exports.PartOfOrganizationForm = {
    org_employee_subgroup: {
        1: "Normal Beyaz Yaka",
        2: "Normal Mavi Yaka",
        10: "Mavi Yaka Günlük",
    },
    org_workplan_rule: {
        VAR2A: "2'li Vardiya - A",
        VAR2B: "2'li Vardiya - B",
        VAR2C: "2'li Vardiya - C",
        VAR3A: "3'lü Vardiya - A",
        VAR3B: "3'lü Vardiya - B",
        NOR1: "Büro 9 Saat",
        NOR1ADM: "Büro 9 Saat (Pandemi) ADM",
        NOR1GDZ: "Büro 9 Saat (Pandemi) GDZ",
        MYA: "Mavi Yaka A",
        MYB: "Mavi Yaka B",
        MYC: "Mavi Yaka C",
        MYD: "Mavi Yaka D",
        MYTA: "Mavi Yaka (Teknik Şef) A",
        MYTB: "Mavi Yaka (Teknik Şef) B",
    },
};
