"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ADM_EMPLOYEE_SUB_GROUPS = exports.GEDIZTallyReportConstants = exports.ADMTallyReportConstants = exports.HeaderStyleThird = exports.HeaderStyleSecond = exports.HeaderStyle = exports.BreakRestRules = exports.WithoutUnionGrossSalary = exports.WithoutUnionNetSalary = exports.NewUnionInitializer = exports.OldUnionInitializer = exports.weekend = exports.workingDays = exports.GDZRefectoryRegionId = exports.ADMRefectoryRegionId = exports.ADMFeeTypeRules = exports.GDZFeeTypeRules = exports.feeType = exports.unionInformation = exports.workDiffValues = exports.GDZPermissionTypes = exports.ADMPermissionTypes = exports.userGroupFilter = void 0;
const utils_1 = require("./utils");
exports.userGroupFilter = {
    key: "org_employee_group",
    validValues: ["1", "2", "A", "4", "6"],
};
exports.ADMPermissionTypes = {
    SAP260: "e3987a8d-bebe-423d-aa70-7362ff5a3a50",
    SAP265: "96f4525a-6dbb-4a84-963a-72a63f11584e",
    SAP270: "dd6019fe-3670-41d7-a352-914743dd1de9",
    SAP290: "d5418632-f3bb-4752-a5c7-b00707bad8a6",
    SAP300: "44a6042b-6adf-4ec9-84d1-b919d4b8b6f2",
    SAP301: "7e884b97-1800-4436-bdd0-edd559c59fba",
    SAP350: "33845cf6-94e2-49cc-becf-7916154efdc9",
    SAP390: "5f946a57-e2ab-4c93-9aab-93cf4d634059",
    SAP1105: "ecac41dc-55b0-4368-a1e4-9b2d499e2ebf",
    SAP145: "503bbaed-69d1-4160-8907-0225a763c639",
    SAP147: "1a49c5b9-f63c-4c94-b0f9-b4fb4fc5c62e",
    SAP150: "bd8f546d-80f7-436e-a93b-df7990193f10",
    SAP155: "ec283a3f-5f59-4d35-95c1-12f456554333",
    SAP160: "765a9a42-dd8b-42ef-b970-41da11cfdd8f",
    SAP170: "500dad0d-90f2-4a04-ba01-7108ff97e8fe",
    SAP180: "bf53e3f3-a31c-4cf4-a8b5-510e26f9686c",
    SAP190: "c827498e-5ca8-4c60-87b1-3be043f0e937",
    SAP195: "13ab3468-b57a-48ad-b15f-c51fbb8e85cf",
    SAP200: "bea272b1-7cea-4ad2-9988-22452d0332ee",
    SAP210: "a294c7b5-10c1-48d5-9b65-814626951ad1",
    SAP220: "979bf016-28d9-4e40-979a-7bf89e9f23a2",
    SAP221: "35435455-6855-451e-aa47-c5d279a393f9",
    SAP225: "ac071c38-6278-48d7-a3c4-77d82cb9b063",
    SAP230: "458cbef2-25dc-4a38-9a44-80b353ddc79c",
    SAP235: "8f79ed16-de27-40e9-8cad-ffa9958cae85",
    SAP240: "c34f8224-c5c2-413d-9ab6-46081dedf3ac",
    SAP255: "2dd98e5b-1aaa-46d0-8753-bef32837ba5a",
    SAP105: "37818a01-b54a-4039-8ff9-2c9d0eb03eef",
    SAP110: "c1783c72-eaba-439d-9465-4c0dccf47966",
    SAP120: "3979ac75-7899-4227-b221-129548ca32ca",
    SAP125: "a2f8997b-312b-42c2-8113-cb5847de6f0d",
    SAP130: "fdb222d8-e7ab-4e66-b945-00f112e886f9",
    SAP131: "30c104b5-2d17-4bad-8984-e1f5b56d91a9",
    SAP135: "da1627d8-4e6c-40f6-9dea-ee5225e282a2",
    SAP140: "4eebb43c-3da4-4434-aecb-eadc5081c7c3",
    SAP165: "73c79729-843b-406e-a06c-8dbd5cea2bfa",
    SAP245: "706b6858-a527-4837-b60e-1480512d60c1",
    SAP250: "726ffa4c-8910-47ab-8437-29951836afd8",
    SAP100: "15f5765f-0e3c-4c75-9179-ac9a89e2f692",
    SAP115: "176bcda6-b9f6-4241-913c-6af775a665ec",
    SAP1100: "2585d034-f466-4290-b96c-259b6c4153cf",
    SAP1130: "65d7b292-ea31-499b-929c-449591ad9f34",
    SAP1210: "3998db7a-17d5-4a52-8923-930cff6a19b3",
    SAP1215: "9a918965-92f2-4875-9914-e5f6edb5d577",
    SAP1220: "f3742d34-79de-4c7d-954a-46fa5036cf26",
    SAP1230: "922d6d28-86a7-4aa9-9569-ab082d2f0c13",
    SAP1240: "c5100733-39fc-409b-bc0f-941d173f0fcb",
    SAP1250: "81269592-7c15-4aa4-9c24-58780b95ce6b",
    SAP1260: "7145d353-b852-4717-958a-4bc68c8ed246",
    SAP400: "7cd36f0e-ab46-4fe7-ba7e-457020f24ef5",
    SAP500: "739157e2-b50d-4fe2-a22a-6c0de8968f2c",
    SAP605: "410df9b5-ae46-4edd-a53a-476088c1dc32",
    SAP650: "9409b216-faf1-49c6-8a1f-3e771f467a5b",
    SAP700: "072879ba-9fc3-43e9-9092-4a5952ec4434",
    SAP705: "8323e0f4-c7a3-4114-951c-247d8020e34f",
    SAP710: "5625a860-188e-41b2-b169-b9267f8ebef6",
    SAPMazeret: "d012c288-f2cf-41a2-b65d-c5a9f231acea",
    SAP1135: "b70beb59-9b23-4c0a-984f-3e19e08e595c",
    SAP670: "b0d168a5-8f8b-4c0d-80b2-b81eeb77064c",
    SAP690: "e23dda1e-eb20-4e50-babe-4affd6b7dfe1",
    SAPFazla: "82fb2946-ea17-474d-857d-8f1eea31ba3d",
    SAP1270: "3e8808e0-f407-4045-9a45-978b30c39216",
    SAP185: "d3c59d0e-0ec9-4636-be87-83dea355d04b",
    SAP1280: "bdcd3ba2-71d4-4b1d-8345-88fa99a24c54",
};
exports.GDZPermissionTypes = {
    SAP100: "15f5765f-0e3c-4c75-9179-ac9a89e2f692",
    SAP105: "37818a01-b54a-4039-8ff9-2c9d0eb03eef",
    SAP110: "c1783c72-eaba-439d-9465-4c0dccf47966",
    SAP115: "176bcda6-b9f6-4241-913c-6af775a665ec",
    SAP120: "3979ac75-7899-4227-b221-129548ca32ca",
    SAP125: "a2f8997b-312b-42c2-8113-cb5847de6f0d",
    SAP130: "fdb222d8-e7ab-4e66-b945-00f112e886f9",
    SAP135: "da1627d8-4e6c-40f6-9dea-ee5225e282a2",
    SAP140: "4eebb43c-3da4-4434-aecb-eadc5081c7c3",
    SAP145: "503bbaed-69d1-4160-8907-0225a763c639",
    SAP147: "1a49c5b9-f63c-4c94-b0f9-b4fb4fc5c62e",
    SAP150: "bd8f546d-80f7-436e-a93b-df7990193f10",
    SAP155: "ec283a3f-5f59-4d35-95c1-12f456554333",
    SAP160: "765a9a42-dd8b-42ef-b970-41da11cfdd8f",
    SAP165: "73c79729-843b-406e-a06c-8dbd5cea2bfa",
    SAP170: "500dad0d-90f2-4a04-ba01-7108ff97e8fe",
    SAP180: "bf53e3f3-a31c-4cf4-a8b5-510e26f9686c",
    SAP190: "c827498e-5ca8-4c60-87b1-3be043f0e937",
    SAP195: "13ab3468-b57a-48ad-b15f-c51fbb8e85cf",
    SAP200: "bea272b1-7cea-4ad2-9988-22452d0332ee",
    SAP210: "a294c7b5-10c1-48d5-9b65-814626951ad1",
    SAP220: "979bf016-28d9-4e40-979a-7bf89e9f23a2",
    SAP221: "35435455-6855-451e-aa47-c5d279a393f9",
    SAP225: "ac071c38-6278-48d7-a3c4-77d82cb9b063",
    SAP230: "458cbef2-25dc-4a38-9a44-80b353ddc79c",
    SAP235: "8f79ed16-de27-40e9-8cad-ffa9958cae85",
    SAP240: "c34f8224-c5c2-413d-9ab6-46081dedf3ac",
    SAP245: "706b6858-a527-4837-b60e-1480512d60c1",
    SAP250: "726ffa4c-8910-47ab-8437-29951836afd8",
    SAP255: "2dd98e5b-1aaa-46d0-8753-bef32837ba5a",
    SAP260: "e3987a8d-bebe-423d-aa70-7362ff5a3a50",
    SAP265: "96f4525a-6dbb-4a84-963a-72a63f11584e",
    SAP270: "dd6019fe-3670-41d7-a352-914743dd1de9",
    SAP290: "d5418632-f3bb-4752-a5c7-b00707bad8a6",
    SAP300: "44a6042b-6adf-4ec9-84d1-b919d4b8b6f2",
    SAP301: "7e884b97-1800-4436-bdd0-edd559c59fba",
    SAP350: "33845cf6-94e2-49cc-becf-7916154efdc9",
    SAP390: "5f946a57-e2ab-4c93-9aab-93cf4d634059",
    SAP400: "7cd36f0e-ab46-4fe7-ba7e-457020f24ef5",
    SAP500: "739157e2-b50d-4fe2-a22a-6c0de8968f2c",
    SAP605: "410df9b5-ae46-4edd-a53a-476088c1dc32",
    SAP650: "9409b216-faf1-49c6-8a1f-3e771f467a5b",
    SAP670: "b0d168a5-8f8b-4c0d-80b2-b81eeb77064c",
    SAP690: "e23dda1e-eb20-4e50-babe-4affd6b7dfe1",
    SAP700: "072879ba-9fc3-43e9-9092-4a5952ec4434",
    SAP705: "8323e0f4-c7a3-4114-951c-247d8020e34f",
    SAP710: "5625a860-188e-41b2-b169-b9267f8ebef6",
    SAP1100: "2585d034-f466-4290-b96c-259b6c4153cf",
    SAP1105: "ecac41dc-55b0-4368-a1e4-9b2d499e2ebf",
    SAP1130: "65d7b292-ea31-499b-929c-449591ad9f34",
    SAP1135: "b70beb59-9b23-4c0a-984f-3e19e08e595c",
    SAP1210: "3998db7a-17d5-4a52-8923-930cff6a19b3",
    SAP1215: "9a918965-92f2-4875-9914-e5f6edb5d577",
    SAP1220: "f3742d34-79de-4c7d-954a-46fa5036cf26",
    SAP1230: "922d6d28-86a7-4aa9-9569-ab082d2f0c13",
    SAP1240: "c5100733-39fc-409b-bc0f-941d173f0fcb",
    SAP1250: "81269592-7c15-4aa4-9c24-58780b95ce6b",
    SAP1260: "7145d353-b852-4717-958a-4bc68c8ed246",
    SAP1270: "3e8808e0-f407-4045-9a45-978b30c39216",
    SAP131: "30c104b5-2d17-4bad-8984-e1f5b56d91a9",
    SAPFazla: "82fb2946-ea17-474d-857d-8f1eea31ba3d",
    SAPMazeret: "d012c288-f2cf-41a2-b65d-c5a9f231acea",
    SAP1280: "cbc93723-ffaa-40f2-a7b0-a3de9c6c7bea",
    SAP185: "318eee21-e0f4-435a-ba7f-e067ed9c9bc5",
};
exports.workDiffValues = ["A1", "B2", "C3"];
exports.unionInformation = {
    withUnionGroupOne: ["10", "14"],
    withUnionGroupSecond: ["11", "15"],
};
var feeType;
(function (feeType) {
    feeType[feeType["IS_GUCLUGU_GUNU"] = 3000] = "IS_GUCLUGU_GUNU";
    feeType[feeType["BAKIM_TAZMINATI_GUNU"] = 3005] = "BAKIM_TAZMINATI_GUNU";
    feeType[feeType["POZISYON_DISI_ARAC_KULLANIMI"] = 3008] = "POZISYON_DISI_ARAC_KULLANIMI";
    feeType[feeType["VARDIYA_TAZMINATI_GUNU"] = 3010] = "VARDIYA_TAZMINATI_GUNU";
    feeType[feeType["KASA_TAZMINATI_ROTATIF"] = 3015] = "KASA_TAZMINATI_ROTATIF";
    feeType[feeType["YOL_PARASI_NET"] = 3055] = "YOL_PARASI_NET";
    feeType[feeType["VARDIYA_AMIRI_SOR_TAZMIN"] = 3230] = "VARDIYA_AMIRI_SOR_TAZMIN";
    feeType[feeType["YEMEK_UCRETI_NET"] = 3800] = "YEMEK_UCRETI_NET";
    feeType[feeType["YEMEK_UCRETI_NET_YEMEKHANE"] = 3825] = "YEMEK_UCRETI_NET_YEMEKHANE";
    feeType[feeType["KASA_TAZMINATI_AMBAR"] = 3810] = "KASA_TAZMINATI_AMBAR";
})(feeType = exports.feeType || (exports.feeType = {}));
exports.GDZFeeTypeRules = [
    {
        name: "İş Güçlüğü Tazminatı Günü",
        type: feeType.IS_GUCLUGU_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_work_diff_comp",
                        validValues: exports.workDiffValues,
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_work_diff_comp",
                        validValues: exports.workDiffValues,
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Bakım Tazminatı Günü",
        type: feeType.BAKIM_TAZMINATI_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_care_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_care_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Vardiya Tazminatı Günü",
        type: feeType.VARDIYA_TAZMINATI_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'LÜ VARDIYA ORANI", "2'LI VARDIYA ORANI"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'LÜ VARDIYA ORANI", "2'LI VARDIYA ORANI"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Kasa Tazminatı Günü (Rotatif)",
        type: feeType.KASA_TAZMINATI_ROTATIF,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["ROTATIF IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP1280,
                    exports.GDZPermissionTypes.SAP105,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["ROTATIF IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1280,
                    exports.GDZPermissionTypes.SAP105,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Yol Parası Net Günü",
        type: feeType.YOL_PARASI_NET,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "12", "13", "14", "15", "16", "26"],
                    },
                    {
                        key: "org_fare_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP145,
                    exports.GDZPermissionTypes.SAP1220,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount) {
                    rawFeeCount = user.countOfWorkingDays;
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount += (0, utils_1.totalWorkedHolidays)(user.monthlyData);
                    rawFeeCount += (0, utils_1.totalWorkedWeekends)(user.monthlyData);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Vardiya Amiri Sor.Tazminatı Günü",
        type: feeType.VARDIYA_AMIRI_SOR_TAZMIN,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "12", "13", "14", "15", "16"],
                    },
                    {
                        key: "org_shift_resp_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Yemek Ücreti Günü",
        type: feeType.YEMEK_UCRETI_NET,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "14", "15"],
                    },
                    {
                        key: "org_food_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP145,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1270,
                    exports.GDZPermissionTypes.SAP1280,
                    exports.GDZPermissionTypes.SAP185,
                ],
                async calculate(user, rawFeeCount, organizationId, startDate, endDate, trx) {
                    rawFeeCount = user.countOfWorkingDays;
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount -= await (0, utils_1.getRefectoryAccessCountOfUserBetweenDates)(organizationId, user.userId, exports.ADMRefectoryRegionId, startDate, endDate, trx);
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["12", "13", "16", "26"],
                    },
                    {
                        key: "org_food_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP145,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1270,
                    exports.GDZPermissionTypes.SAP1280,
                    exports.GDZPermissionTypes.SAP185,
                ],
                async calculate(user, rawFeeCount, organizationId, startDate, endDate, trx) {
                    rawFeeCount = user.countOfWorkingDays;
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount -= await (0, utils_1.getRefectoryAccessCountOfUserBetweenDates)(organizationId, user.userId, exports.ADMRefectoryRegionId, startDate, endDate, trx);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Kasa Tazminatı Günü (Ambar)",
        type: feeType.KASA_TAZMINATI_AMBAR,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["AMBAR IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["AMBAR IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.GDZPermissionTypes.SAP115,
                    exports.GDZPermissionTypes.SAP190,
                    exports.GDZPermissionTypes.SAP1260,
                    exports.GDZPermissionTypes.SAP690,
                    exports.GDZPermissionTypes.SAP160,
                    exports.GDZPermissionTypes.SAP350,
                    exports.GDZPermissionTypes.SAP650,
                    exports.GDZPermissionTypes.SAP125,
                    exports.GDZPermissionTypes.SAP130,
                    exports.GDZPermissionTypes.SAP131,
                    exports.GDZPermissionTypes.SAP135,
                    exports.GDZPermissionTypes.SAP140,
                    exports.GDZPermissionTypes.SAP200,
                    exports.GDZPermissionTypes.SAP210,
                    exports.GDZPermissionTypes.SAP220,
                    exports.GDZPermissionTypes.SAP250,
                    exports.GDZPermissionTypes.SAP245,
                    exports.GDZPermissionTypes.SAP290,
                    exports.GDZPermissionTypes.SAP670,
                    exports.GDZPermissionTypes.SAP100,
                    exports.GDZPermissionTypes.SAP110,
                    exports.GDZPermissionTypes.SAP120,
                    exports.GDZPermissionTypes.SAP170,
                    exports.GDZPermissionTypes.SAP390,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP147,
                    exports.GDZPermissionTypes.SAP155,
                    exports.GDZPermissionTypes.SAP165,
                    exports.GDZPermissionTypes.SAP260,
                    exports.GDZPermissionTypes.SAP270,
                    exports.GDZPermissionTypes.SAP710,
                    exports.GDZPermissionTypes.SAP1100,
                    exports.GDZPermissionTypes.SAP1105,
                    exports.GDZPermissionTypes.SAP1130,
                    exports.GDZPermissionTypes.SAP1135,
                    exports.GDZPermissionTypes.SAP1210,
                    exports.GDZPermissionTypes.SAP1215,
                    exports.GDZPermissionTypes.SAP1230,
                    exports.GDZPermissionTypes.SAP1240,
                    exports.GDZPermissionTypes.SAP1250,
                    exports.GDZPermissionTypes.SAP180,
                    exports.GDZPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
];
exports.ADMFeeTypeRules = [
    {
        name: "İş Güçlüğü Tazminatı Günü",
        type: feeType.IS_GUCLUGU_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_work_diff_comp",
                        validValues: exports.workDiffValues,
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_work_diff_comp",
                        validValues: exports.workDiffValues,
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Bakım Tazminatı Günü",
        type: feeType.BAKIM_TAZMINATI_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_care_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount = (0, utils_1.substractWeeklyHolidaysForAnnualLeaves)(user, exports.ADMPermissionTypes.SAP100, rawFeeCount);
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_care_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount = (0, utils_1.substractWeeklyHolidaysForAnnualLeaves)(user, exports.ADMPermissionTypes.SAP100, rawFeeCount);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Vardiya Tazminatı Günü",
        type: feeType.VARDIYA_TAZMINATI_GUNU,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'LÜ VARDIYA ORANI", "2'LI VARDIYA ORANI"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount = (0, utils_1.substractWeeklyHolidaysForAnnualLeaves)(user, exports.ADMPermissionTypes.SAP100, rawFeeCount);
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_shift_comp_ratio",
                        validValues: ["3'LÜ VARDIYA ORANI", "2'LI VARDIYA ORANI"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount = (0, utils_1.substractWeeklyHolidaysForAnnualLeaves)(user, exports.ADMPermissionTypes.SAP100, rawFeeCount);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Kasa Tazminatı Günü (Rotatif)",
        type: feeType.KASA_TAZMINATI_ROTATIF,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["ROTATIF IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["ROTATIF IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Yol Parası Net Günü",
        type: feeType.YOL_PARASI_NET,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "12", "13", "14", "15", "16", "26"],
                    },
                    {
                        key: "org_fare_comp",
                        validValues: ["ALIR"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP147,
                    exports.ADMPermissionTypes.SAP155,
                    exports.ADMPermissionTypes.SAP165,
                    exports.ADMPermissionTypes.SAP260,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP710,
                    exports.ADMPermissionTypes.SAP1100,
                    exports.ADMPermissionTypes.SAP1105,
                    exports.ADMPermissionTypes.SAP1130,
                    exports.ADMPermissionTypes.SAP1135,
                    exports.ADMPermissionTypes.SAP1210,
                    exports.ADMPermissionTypes.SAP1215,
                    exports.ADMPermissionTypes.SAP1230,
                    exports.ADMPermissionTypes.SAP1240,
                    exports.ADMPermissionTypes.SAP1250,
                    exports.ADMPermissionTypes.SAP145,
                    exports.ADMPermissionTypes.SAP1220,
                    exports.ADMPermissionTypes.SAP180,
                    exports.ADMPermissionTypes.SAP1270,
                    exports.ADMPermissionTypes.SAP185,
                    exports.ADMPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount) {
                    rawFeeCount = user.countOfWorkingDays;
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount += (0, utils_1.totalWorkedHolidays)(user.monthlyData);
                    rawFeeCount += (0, utils_1.totalWorkedWeekends)(user.monthlyData);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Yemek Ücreti Günü",
        type: feeType.YEMEK_UCRETI_NET,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "14", "15"],
                    },
                    {
                        key: "org_food_comp",
                        validValues: ["ALIR"],
                    },
                    {
                        key: "org_personnel_subfield",
                        validValues: [
                            "5040",
                            "5037",
                            "5029",
                            "5036",
                            "5032",
                            "5031",
                            "5038",
                            "5067",
                            "5035",
                            "5034",
                            "5043",
                            "5044",
                            "5027",
                            "5022",
                            "5026",
                            "5039",
                            "5042",
                            "5049",
                            "5064",
                            "5033",
                            "5051",
                            "5050",
                            "5053",
                            "5030",
                            "5063",
                            "5024",
                            "5052",
                            "5023",
                            "5045",
                            "5057",
                            "5058",
                            "5066",
                            "5062",
                            "5048",
                            "5021",
                            "5046",
                            "5025",
                            "5059",
                            "5065",
                            "5061",
                            "5054",
                            "5055",
                            "5068",
                            "5056",
                            "5047",
                            "5060",
                        ],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP147,
                    exports.ADMPermissionTypes.SAP155,
                    exports.ADMPermissionTypes.SAP165,
                    exports.ADMPermissionTypes.SAP260,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP710,
                    exports.ADMPermissionTypes.SAP1100,
                    exports.ADMPermissionTypes.SAP1105,
                    exports.ADMPermissionTypes.SAP1130,
                    exports.ADMPermissionTypes.SAP1135,
                    exports.ADMPermissionTypes.SAP1210,
                    exports.ADMPermissionTypes.SAP1215,
                    exports.ADMPermissionTypes.SAP1230,
                    exports.ADMPermissionTypes.SAP1240,
                    exports.ADMPermissionTypes.SAP1250,
                    exports.ADMPermissionTypes.SAP145,
                    exports.ADMPermissionTypes.SAP180,
                    exports.ADMPermissionTypes.SAP1270,
                    exports.ADMPermissionTypes.SAP185,
                    exports.ADMPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount, organizationId, startDate, endDate, trx) {
                    rawFeeCount = user.countOfWorkingDays;
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount += (0, utils_1.totalWorkedHolidays)(user.monthlyData);
                    rawFeeCount += (0, utils_1.totalWorkedWeekends)(user.monthlyData);
                    rawFeeCount -= await (0, utils_1.getRefectoryAccessCountOfUserBetweenDates)(organizationId, user.userId, exports.ADMRefectoryRegionId, startDate, endDate, trx);
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["12", "13", "16", "26"],
                    },
                    {
                        key: "org_food_comp",
                        validValues: ["ALIR"],
                    },
                    {
                        key: "org_personnel_subfield",
                        validValues: [
                            "5040",
                            "5037",
                            "5029",
                            "5036",
                            "5032",
                            "5031",
                            "5038",
                            "5067",
                            "5035",
                            "5034",
                            "5043",
                            "5044",
                            "5027",
                            "5022",
                            "5026",
                            "5039",
                            "5042",
                            "5049",
                            "5064",
                            "5033",
                            "5051",
                            "5050",
                            "5053",
                            "5030",
                            "5063",
                            "5024",
                            "5052",
                            "5023",
                            "5045",
                            "5057",
                            "5058",
                            "5066",
                            "5062",
                            "5048",
                            "5021",
                            "5046",
                            "5025",
                            "5059",
                            "5065",
                            "5061",
                            "5054",
                            "5055",
                            "5068",
                            "5056",
                            "5047",
                            "5060",
                        ],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP147,
                    exports.ADMPermissionTypes.SAP155,
                    exports.ADMPermissionTypes.SAP165,
                    exports.ADMPermissionTypes.SAP260,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP710,
                    exports.ADMPermissionTypes.SAP1100,
                    exports.ADMPermissionTypes.SAP1105,
                    exports.ADMPermissionTypes.SAP1130,
                    exports.ADMPermissionTypes.SAP1135,
                    exports.ADMPermissionTypes.SAP1210,
                    exports.ADMPermissionTypes.SAP1215,
                    exports.ADMPermissionTypes.SAP1230,
                    exports.ADMPermissionTypes.SAP1240,
                    exports.ADMPermissionTypes.SAP1250,
                    exports.ADMPermissionTypes.SAP145,
                    exports.ADMPermissionTypes.SAP180,
                    exports.ADMPermissionTypes.SAP1270,
                    exports.ADMPermissionTypes.SAP185,
                    exports.ADMPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount, organizationId, startDate, endDate, trx) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount += (0, utils_1.totalWorkedHolidays)(user.monthlyData);
                    rawFeeCount += (0, utils_1.totalWorkedWeekends)(user.monthlyData);
                    rawFeeCount -= await (0, utils_1.getRefectoryAccessCountOfUserBetweenDates)(organizationId, user.userId, exports.ADMRefectoryRegionId, startDate, endDate, trx);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Yemek Ücreti Net (Yemekhane Hizmeti Olan Bölgedeki Yemek Yardımı)",
        type: feeType.YEMEK_UCRETI_NET_YEMEKHANE,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: ["10", "11", "14", "15"],
                    },
                    {
                        key: "org_food_comp",
                        validValues: ["ALIR"],
                    },
                    {
                        key: "org_personnel_subfield",
                        validValues: ["5028", "5010", "5020"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP147,
                    exports.ADMPermissionTypes.SAP155,
                    exports.ADMPermissionTypes.SAP165,
                    exports.ADMPermissionTypes.SAP260,
                    exports.ADMPermissionTypes.SAP270,
                    exports.ADMPermissionTypes.SAP710,
                    exports.ADMPermissionTypes.SAP1100,
                    exports.ADMPermissionTypes.SAP1105,
                    exports.ADMPermissionTypes.SAP1130,
                    exports.ADMPermissionTypes.SAP1135,
                    exports.ADMPermissionTypes.SAP1210,
                    exports.ADMPermissionTypes.SAP1215,
                    exports.ADMPermissionTypes.SAP1230,
                    exports.ADMPermissionTypes.SAP1240,
                    exports.ADMPermissionTypes.SAP1250,
                    exports.ADMPermissionTypes.SAP145,
                    exports.ADMPermissionTypes.SAP180,
                    exports.ADMPermissionTypes.SAP1270,
                    exports.ADMPermissionTypes.SAP185,
                    exports.ADMPermissionTypes.SAP1280,
                ],
                async calculate(user, rawFeeCount, organizationId, startDate, endDate, trx) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    rawFeeCount += (0, utils_1.totalWorkedHolidays)(user.monthlyData);
                    rawFeeCount += (0, utils_1.totalWorkedWeekends)(user.monthlyData);
                    rawFeeCount -= await (0, utils_1.getRefectoryAccessCountOfUserBetweenDates)(organizationId, user.userId, exports.ADMRefectoryRegionId, startDate, endDate, trx);
                    return rawFeeCount;
                },
            },
        ],
    },
    {
        name: "Kasa Tazminatı Günü (Ambar)",
        type: feeType.KASA_TAZMINATI_AMBAR,
        rules: [
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupOne,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["AMBAR IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
            {
                extensionFieldRules: [
                    {
                        key: "org_employee_subgroup",
                        validValues: exports.unionInformation.withUnionGroupSecond,
                    },
                    {
                        key: "org_vault_comp",
                        validValues: ["AMBAR IÇIN ALAN"],
                    },
                ],
                decreasingPermissions: [
                    exports.ADMPermissionTypes.SAP115,
                    exports.ADMPermissionTypes.SAP190,
                    exports.ADMPermissionTypes.SAP1260,
                    exports.ADMPermissionTypes.SAP690,
                    exports.ADMPermissionTypes.SAP160,
                    exports.ADMPermissionTypes.SAP350,
                    exports.ADMPermissionTypes.SAP650,
                    exports.ADMPermissionTypes.SAP125,
                    exports.ADMPermissionTypes.SAP130,
                    exports.ADMPermissionTypes.SAP131,
                    exports.ADMPermissionTypes.SAP135,
                    exports.ADMPermissionTypes.SAP140,
                    exports.ADMPermissionTypes.SAP200,
                    exports.ADMPermissionTypes.SAP210,
                    exports.ADMPermissionTypes.SAP220,
                    exports.ADMPermissionTypes.SAP250,
                    exports.ADMPermissionTypes.SAP245,
                    exports.ADMPermissionTypes.SAP290,
                    exports.ADMPermissionTypes.SAP670,
                    exports.ADMPermissionTypes.SAP100,
                    exports.ADMPermissionTypes.SAP110,
                    exports.ADMPermissionTypes.SAP120,
                    exports.ADMPermissionTypes.SAP170,
                    exports.ADMPermissionTypes.SAP390,
                    exports.ADMPermissionTypes.SAP270,
                ],
                async calculate(user, rawFeeCount) {
                    this.decreasingPermissions.forEach((permType) => {
                        rawFeeCount -= user.permissions ? user.permissions.filter((perm) => perm.typeId === permType).reduce((acc, curr) => acc + curr.usageDay, 0) : 0;
                    });
                    return rawFeeCount;
                },
            },
        ],
    },
];
exports.ADMRefectoryRegionId = "f7811a4e-4d69-4604-801f-e10614e9c285";
exports.GDZRefectoryRegionId = "f2eba185-3552-432a-9bd0-bcc27f8dca60";
exports.workingDays = [1, 2, 3, 4, 5];
exports.weekend = [6, 7];
exports.OldUnionInitializer = [
    {
        type: 2000,
        value: 0,
        description: "Haftaiçi FM 100",
    },
    {
        type: 2005,
        value: 0,
        description: "Haftaiçi FM 150",
    },
    {
        type: 2015,
        value: 0,
        description: "Haftasonu C.tesi FM 150",
    },
    {
        type: 2020,
        value: 0,
        description: "Haftasonu Pazar FM 200",
    },
    {
        type: 2025,
        value: 0,
        description: "Arefe Çalışması 50",
    },
    {
        type: 2030,
        value: 0,
        description: "Arefe Çalışması 100",
    },
    {
        type: 2035,
        value: 0,
        description: "Arefe Çalışması 200",
    },
    {
        type: 2050,
        value: 0,
        description: "Genel Tatil FM 200",
    },
    {
        type: 2055,
        value: 0,
        description: "Genel Tatil FM 600",
    },
    {
        type: 2060,
        value: 0,
        description: "Vardiya Ara Dinlenme %50",
    },
    {
        type: 2065,
        value: 0,
        description: "Kısa Dönüş",
    },
];
exports.NewUnionInitializer = [
    {
        type: 2010,
        value: 0,
        description: "Fazla Mesai 50 (Hİçi,HSn)",
    },
    {
        type: 2040,
        value: 0,
        description: "Genel Tatil FM 100",
    },
    {
        type: 2045,
        value: 0,
        description: "Genel Tatil FM 150",
    },
    {
        type: 2060,
        value: 0,
        description: "Vardiya Ara Dinlenme %50",
    },
    {
        type: 2065,
        value: 0,
        description: "Kısa Dönüş",
    },
];
exports.WithoutUnionNetSalary = [
    {
        type: 2510,
        value: 0,
        description: "Fazla Mesai 50 Net",
    },
    {
        type: 2540,
        value: 0,
        description: "Genel Tatil FM 100 Net",
    },
    {
        type: 2545,
        value: 0,
        description: "Genel Tatil FM 150 Net",
    },
];
exports.WithoutUnionGrossSalary = [
    {
        type: 2010,
        value: 0,
        description: "Fazla Mesai 50 Brüt",
    },
    {
        type: 2040,
        value: 0,
        description: "Genel Tatil FM 100 Brüt",
    },
];
exports.BreakRestRules = [
    {
        hoursRange: {
            start: 0,
            end: 4,
        },
        breakTime: 0.25,
    },
    {
        hoursRange: {
            start: 4,
            end: 7.5,
        },
        breakTime: 0.5,
    },
    {
        hoursRange: {
            start: 7.5,
            end: 11,
        },
        breakTime: 1,
    },
    {
        hoursRange: {
            start: 11,
            end: 24,
        },
        breakTime: 1.5,
    },
];
exports.HeaderStyle = {
    border: {
        right: {
            style: "thin",
        },
        bottom: {
            style: "thick",
        },
    },
    font: { name: "Calibri", size: 16, bold: true, color: { argb: "FFC00000" } },
};
exports.HeaderStyleSecond = {
    border: {
        right: {
            style: "thin",
        },
        bottom: {
            style: "thick",
        },
        top: {
            style: "thin",
        },
        left: {
            style: "thin",
        },
    },
    font: { name: "Calibri", size: 14, bold: true },
};
exports.HeaderStyleThird = {
    border: {
        right: {
            style: "thin",
        },
        bottom: {
            style: "thick",
        },
        top: {
            style: "thin",
        },
        left: {
            style: "thin",
        },
    },
    font: { name: "Calibri", size: 14, bold: false },
};
exports.ADMTallyReportConstants = {
    PERMISSION_NAMES: ["UZAKTAN ÇALIŞMA", "YILLIK İZİN", "ÜCRETSİZ İZİN", "RAPORLAR", "ÜCRETLİ İZİN", "MAZERET İZNİ", "SOSYAL İZİN"],
    HOLIDAY_NAMES: ["ÇALIŞILMAYAN GENEL TATİL", "ÇALIŞILMAYAN HAFTA TATİLİ", "ÇALIŞILMAYAN BAYRAM TATİLİ"],
    EXTRA_WORK_NAMES: ["Haftaiçi Toplam Fazla Mesai Saati", "Haftasonu Toplam Fazla Mesai Saati", "UBGT Fazla Mesai Saati"],
    EXTRA_PERMISSION_TYPE_ID: "82fb2946-ea17-474d-857d-8f1eea31ba3d",
    PERMISSION_TYPE_ABBREVATIONS: {
        [exports.ADMPermissionTypes.SAP100]: "Y.İ",
        [exports.ADMPermissionTypes.SAP110]: "Ü.İ",
        [exports.ADMPermissionTypes.SAP115]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP120]: "Ü.İ",
        [exports.ADMPermissionTypes.SAP125]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP131]: "Doğum R.",
        [exports.ADMPermissionTypes.SAP135]: "R",
        [exports.ADMPermissionTypes.SAP140]: "Doğum R.",
        [exports.ADMPermissionTypes.SAP145]: "FMİ",
        [exports.ADMPermissionTypes.SAP147]: "S.İ",
        [exports.ADMPermissionTypes.SAP150]: "M.İ.",
        [exports.ADMPermissionTypes.SAP155]: "Sendikal İ.",
        [exports.ADMPermissionTypes.SAP160]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP165]: "S.İ",
        [exports.ADMPermissionTypes.SAP170]: "İş Arama",
        [exports.ADMPermissionTypes.SAP180]: "DGİ",
        [exports.ADMPermissionTypes.SAP190]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP200]: "Doğum R.",
        [exports.ADMPermissionTypes.SAP210]: "Doğum R.",
        [exports.ADMPermissionTypes.SAP221]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP230]: "İdari İzin",
        [exports.ADMPermissionTypes.SAP245]: "R",
        [exports.ADMPermissionTypes.SAP250]: "R",
        [exports.ADMPermissionTypes.SAP130]: "R",
        [exports.ADMPermissionTypes.SAP255]: "Yarım Ç.",
        [exports.ADMPermissionTypes.SAP260]: "Sendikal İ.",
        [exports.ADMPermissionTypes.SAP290]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP350]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP390]: "Ü.İ",
        [exports.ADMPermissionTypes.SAP500]: "Ü.İ",
        [exports.ADMPermissionTypes.SAP650]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP670]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP690]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP1100]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1105]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1130]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1135]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1210]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1215]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1220]: "U",
        [exports.ADMPermissionTypes.SAP1230]: "Ü.İ ",
        [exports.ADMPermissionTypes.SAP1250]: "M.İ.",
        [exports.ADMPermissionTypes.SAP1260]: "Ücretsiz",
        [exports.ADMPermissionTypes.SAP1270]: "S(Yarım)",
        [exports.ADMPermissionTypes.SAP185]: "Y(Yarım)",
    },
    PRIORITIZED_LEAVES_OVER_HOLIDAYS: [
        exports.ADMPermissionTypes.SAP160,
        exports.ADMPermissionTypes.SAP195,
        exports.ADMPermissionTypes.SAP255,
        exports.ADMPermissionTypes.SAP650,
        exports.ADMPermissionTypes.SAP690,
        exports.ADMPermissionTypes.SAP130,
        exports.ADMPermissionTypes.SAP135,
        exports.ADMPermissionTypes.SAP140,
        exports.ADMPermissionTypes.SAP250,
        exports.ADMPermissionTypes.SAP131,
        exports.ADMPermissionTypes.SAP200,
        exports.ADMPermissionTypes.SAP245,
        exports.ADMPermissionTypes.SAP1220,
        exports.ADMPermissionTypes.SAP115,
        exports.ADMPermissionTypes.SAP1260,
        exports.ADMPermissionTypes.SAP190,
        exports.ADMPermissionTypes.SAP221,
        exports.ADMPermissionTypes.SAP350,
    ],
    PERMISSION_DESCRIPTIONS: [
        "Y.i: Yıllık İzin",
        "DGİ: Doğum Günü İzni",
        'Doğum R.: "131- Sağlık Raporu(Ödenen-Doğum)", "140 - Sağlık Raporu(Doğum)", "210 - Doğum izni - 21 Tkvm Günü", "200 - Analık-azm.90 Takvim Günü"',
        'FMİ: "145 - Ücretli İzin(FM Karşılık)"',
        "İdari İzin: 230 - İdari İzin",
        "İş Arama : 170 - İş Arama İzni",
        `M.İ:   "1100 - Mazeret İzni(Evlilik)", "1105 - Mazeret İzni(Evlilik-Sen)", "1130 - Mazeret İzni(Vefat İzni)", "1135 - Mazeret İzni(Vefat-Sen)",
				"1210 - Mazeret İzni(Babalık)","1215 - Mazeret İzni(Babalık-Sen)","1250 - Mazeret İzni(Evlat Edin.)","150 - Sosyal İzin(Refakat-Sen)"`,
        'R: "130 - Sağlık Raporu(Ödenen)", "135 - Sağlık Raporu(Ödenmeyen)", "245 - İş kazası", "250 - İş Göremezlik"',
        'S.İ : "147 - Sosyal İzin(Sendikasız)", "165 - Sosyal İzin(Sendikalı)"',
        'Sendikal İ.: "155 - Sendikal İzin ", "260 - Sendikal İzin"',
        "U: 1220 - Uzaktan Çalışma",
        'Ü.İ: "110 - Ücretli İzin", "120 - Ücretli İzin", "390 - Ücretli Askerlik İzni", "500 - Eğitim/Kurs/Seminer", "1230 - Taşınma İzni"',
        `Ücretsiz:  "115 - Ücretsiz İzin", "125 - Mazeretsiz İzin", "160 - Ücretsiz İzin(Kısmi Çalş)", "90 - Ücretsiz İzin", "221 - Ücretsiz Hastalık",
					"290 - Tutukluluk/Mahkumiye", "350 - Ücretsiz Dvms.izni >1 Gün", "650 - Ücretsiz Dvms.İzni >1 Gün", "670 - Askerlik Hizmeti", "690 - Ücretsiz Askerlik İzni", "1260 - Ücretsiz İzin(Doğum)"
		`,
        'Yarım Ç.: "255 - Ücretsiz İzin(Yarım Çalş)"',
    ],
    EXCEL_FORMULA_CONDITIONS: {
        ["UZAKTAN_CALISMA"]: ["=U"],
        ["YILLIK_I"]: [""],
        ["UCRETSIZ_I"]: ["=Ücretsiz", "=Yarım Ç."],
        ["RAPORLAR"]: ["=R", "=Doğum R."],
        ["UCRETLI_I"]: ["=Ü.İ", "=Sendikal İ.", "=İş Arama", "=FMİ", "=DGİ", "=İdari İzin"],
        ["MAZERET_I"]: ["=M.İ"],
        ["SOSYAL_I"]: ["=S.İ"],
        ["CGT"]: ["=GT"],
        ["CHT"]: ["=HT"],
        ["CBT"]: ["=BT"],
    },
};
exports.GEDIZTallyReportConstants = {
    PERMISSION_NAMES: ["UZAKTAN ÇALIŞMA", "YILLIK İZİN", "ÜCRETSİZ İZİN", "RAPORLAR", "ÜCRETLİ İZİN", "MAZERET İZNİ", "SOSYAL İZİN"],
    HOLIDAY_NAMES: ["ÇALIŞILMAYAN GENEL TATİL", "ÇALIŞILMAYAN HAFTA TATİLİ", "ÇALIŞILMAYAN BAYRAM TATİLİ"],
    EXTRA_WORK_NAMES: ["Haftaiçi Toplam Fazla Mesai Saati", "Haftasonu Toplam Fazla Mesai Saati", "UBGT Fazla Mesai Saati"],
    EXTRA_PERMISSION_TYPE_ID: "82fb2946-ea17-474d-857d-8f1eea31ba3d",
    PERMISSION_TYPE_ABBREVATIONS: {
        [exports.GDZPermissionTypes.SAP100]: { abbr: "Y.İ", colorCode: "FF00B050" },
        [exports.GDZPermissionTypes.SAP110]: { abbr: "Ü.İ", colorCode: "FFB1A0C7" },
        [exports.GDZPermissionTypes.SAP115]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP120]: { abbr: "Ü.İ", colorCode: "FFB1A0C7" },
        [exports.GDZPermissionTypes.SAP125]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP1260]: { abbr: "Doğum R.", colorCode: "FF99FFCC" },
        [exports.GDZPermissionTypes.SAP130]: { abbr: "R", colorCode: "FFBFBFBF" },
        [exports.GDZPermissionTypes.SAP135]: { abbr: "Doğum R.", colorCode: "FF99FFCC" },
        [exports.GDZPermissionTypes.SAP145]: { abbr: "FMİ", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP147]: { abbr: "S.İ", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP150]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP155]: { abbr: "Sendikal İ.", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP160]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP165]: { abbr: "S.İ", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP170]: { abbr: "İş Arama", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP180]: { abbr: "DGİ", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP190]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP200]: { abbr: "Doğum R.", colorCode: "FF99FFCC" },
        [exports.GDZPermissionTypes.SAP210]: { abbr: "Doğum R.", colorCode: "FF99FFCC" },
        [exports.GDZPermissionTypes.SAP221]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP230]: { abbr: "İdari İzin", colorCode: "FF00FF00" },
        [exports.GDZPermissionTypes.SAP245]: { abbr: "R", colorCode: "FFBFBFBF" },
        [exports.GDZPermissionTypes.SAP250]: { abbr: "R", colorCode: "FFBFBFBF" },
        [exports.GDZPermissionTypes.SAP130]: { abbr: "R", colorCode: "FFBFBFBF" },
        [exports.GDZPermissionTypes.SAP255]: { abbr: "Yarım Ç.", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP260]: { abbr: "Sendikal İ.", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP290]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP350]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP390]: { abbr: "Ü.İ", colorCode: "FFB1A0C7" },
        [exports.GDZPermissionTypes.SAP500]: { abbr: "Ü.İ", colorCode: "FFB1A0C7" },
        [exports.GDZPermissionTypes.SAP650]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP670]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP690]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
        [exports.GDZPermissionTypes.SAP1100]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1105]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1130]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1135]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1210]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1215]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1220]: { abbr: "U", colorCode: "FFFFFFFF" },
        [exports.GDZPermissionTypes.SAP1230]: { abbr: "Ü.İ", colorCode: "FFB1A0C7" },
        [exports.GDZPermissionTypes.SAP1250]: { abbr: "M.İ.", colorCode: "FFFFFF66" },
        [exports.GDZPermissionTypes.SAP1260]: { abbr: "Ücretsiz", colorCode: "FFFF0000" },
    },
    LEAVE_TYPES_WITH_BUSSINESS_LOGIC: {
        GROUP_1: [exports.GDZPermissionTypes.SAP100, exports.GDZPermissionTypes.SAP105],
        GROUP_2: [
            exports.GDZPermissionTypes.SAP115,
            exports.GDZPermissionTypes.SAP190,
            exports.GDZPermissionTypes.SAP1260,
            exports.GDZPermissionTypes.SAP690,
            exports.GDZPermissionTypes.SAP125,
            exports.GDZPermissionTypes.SAP160,
            exports.GDZPermissionTypes.SAP350,
            exports.GDZPermissionTypes.SAP650,
            exports.GDZPermissionTypes.SAP130,
            exports.GDZPermissionTypes.SAP131,
            exports.GDZPermissionTypes.SAP135,
            exports.GDZPermissionTypes.SAP140,
            exports.GDZPermissionTypes.SAP200,
            exports.GDZPermissionTypes.SAP210,
            exports.GDZPermissionTypes.SAP220,
        ],
        GROUP_3: [
            exports.GDZPermissionTypes.SAP110,
            exports.GDZPermissionTypes.SAP120,
            exports.GDZPermissionTypes.SAP170,
            exports.GDZPermissionTypes.SAP147,
            exports.GDZPermissionTypes.SAP155,
            exports.GDZPermissionTypes.SAP165,
            exports.GDZPermissionTypes.SAP260,
            exports.GDZPermissionTypes.SAP710,
            exports.GDZPermissionTypes.SAP1100,
            exports.GDZPermissionTypes.SAP1130,
            exports.GDZPermissionTypes.SAP1210,
            exports.GDZPermissionTypes.SAP1240,
            exports.GDZPermissionTypes.SAP1230,
            exports.GDZPermissionTypes.SAP1220,
            exports.GDZPermissionTypes.SAP145,
            exports.GDZPermissionTypes.SAP180,
            exports.GDZPermissionTypes.SAP1280,
        ],
    },
    EXCEL_FORMULA_CONDITIONS: {
        ["UZAKTAN_CALISMA"]: ["=U"],
        ["YILLIK_I"]: ["=Y.İ"],
        ["UCRETSIZ_I"]: ["=Ücretsiz", "=Yarım Ç."],
        ["RAPORLAR"]: ["=R", "=Doğum R."],
        ["UCRETLI_I"]: ["=Ü.İ", "=Sendikal İ.", "=İş Arama", "=FMİ", "=DGİ", "=İdari İzin"],
        ["MAZERET_I"]: ["=M.İ"],
        ["SOSYAL_I"]: ["=S.İ"],
        ["CGT"]: ["=GT"],
        ["CHT"]: ["=HT"],
        ["CBT"]: ["=BT"],
    },
};
exports.ADM_EMPLOYEE_SUB_GROUPS = {
    "10": "BY-Sendikalı 1 grup",
    "11": "BY-Sendikalı 2 grup",
    "12": "BY-Sendikasız",
    "13": "BY-Sendikasız Devir",
    "14": "MY-Sendikalı 1 grup",
    "15": "MY-Sendikalı 2 grup",
    "16": "MY-Sendikasız",
    "26": "BY-Sendikasız Gunluk",
    "22": "BY-EK 71",
    "24": "MY-EK 71",
    "23": "BY-Geçici Madde 192",
    "25": "MY-Geçici Madde 192",
};
