"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformNotificationToCRMParameters = void 0;
const restapi_1 = require("../../../../lib/es/models/restapi");
const dal_manager_1 = require("../../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const dal_constants_1 = require("../../../../dal/dal.constants");
const crm_consts_1 = require("./crm-consts");
const transformNotificationToCRMParameters = async (organizationId, params, trx) => {
    const notificationEvent = await dal_manager_1.dbManager.accessNotifications.getNotificationOfEvent({ organizationId: params.message.o, eventId: params.message.i, trx });
    switch (notificationEvent.type) {
        case restapi_1.NotificationType.VisitorInvitation:
            const visitorInvitationInstanceData = params.message.d;
            const invitationInfo = visitorInvitationInstanceData.i;
            const invitationVisitInfo = await dal_manager_1.dbManager.accessVisitor.getVisitorFullnameAndRegistrationPoint(organizationId, invitationInfo.visitId, trx);
            if (params.medium === restapi_1.NotificationMedium.Email) {
                return {
                    isImplemented: false,
                    transformedParameters: null,
                };
            }
            else {
                let campaignCode;
                switch (invitationVisitInfo.visitorRegistrationPointId) {
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.BASKENT:
                        campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.AYESAS:
                        campaignCode = crm_consts_1.SMSCampaignCode.AYESAS_VISITOR_INVITATION;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.TEPSAS:
                        campaignCode = crm_consts_1.SMSCampaignCode.TEPSAS_VISITOR_INVITATION;
                        break;
                    default:
                        if (!invitationVisitInfo?.visitorRegistrationPointId) {
                            const preRegistrationCheckDbResult = await trx.query(`
								SELECT log->>'r' as "requesterUserId"
								FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitorPreregistrationHistory}"
								WHERE log->>'vid' = $1
							`, [invitationInfo.visitId]);
                            if (preRegistrationCheckDbResult.rowCount) {
                                const preregistrarUserId = preRegistrationCheckDbResult.rows[0].requesterUserId;
                                const preregistrarUser = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(organizationId, dal_constants_1.DalConstants.SystemUserId, {
                                    userId: preregistrarUserId,
                                    hasIdentityFullWrite: true,
                                    hasOrganizationWideRight: true,
                                    trx,
                                });
                                if (preregistrarUser?.organizationProfile?.extensionFields["org_company_code"]) {
                                    switch (preregistrarUser.organizationProfile.extensionFields["org_company_code"]) {
                                        case "0090":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                        case "0690":
                                            campaignCode = crm_consts_1.SMSCampaignCode.TEPSAS_VISITOR_INVITATION;
                                            break;
                                        case "0670":
                                            campaignCode = crm_consts_1.SMSCampaignCode.AYESAS_VISITOR_INVITATION;
                                            break;
                                        case "0220":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                        case "0291":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                        case "0290":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                        case "0292":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                    }
                                }
                            }
                        }
                        break;
                }
                let transformedVariables = [
                    { PNAME: "LINK", PVALUE: "https://panel.armongate.com/qr/?qr=" + encodeURI(JSON.stringify(invitationInfo.qrCodeData)) },
                ];
                return {
                    isImplemented: true,
                    transformedParameters: {
                        campaignCode,
                        campaignVariables: transformedVariables,
                        reciever: Array.isArray(invitationInfo.visitorProfile.fields)
                            ? invitationInfo.visitorProfile.fields.find((f) => f.name === "uniqueId")?.value
                            : invitationInfo.visitorProfile.fields.uniqueId,
                    },
                };
            }
        default:
            return {
                isImplemented: false,
                transformedParameters: null,
            };
    }
};
exports.transformNotificationToCRMParameters = transformNotificationToCRMParameters;
