"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocialAreaCreditReducerScheduledJobIds = exports.CreateHook = void 0;
const uuid_1 = __importDefault(require("uuid"));
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const dal_constants_1 = require("../../../dal/dal.constants");
const moment_1 = __importDefault(require("moment"));
const moment_range_1 = require("moment-range");
const app_logs_1 = require("../../../app.logs");
const business_pacs_report_1 = require("../../../business/pacs/business.pacs.report");
const app_enums_1 = require("../../../app.enums");
const api_error_1 = require("../../../api/api.error");
const CREDIT_PERIOD_END = 14;
const organizationId = "9c4dc008-1fa9-4924-bbe1-61599e650252";
const usersToIgnore = ["8abea600-94f2-4c90-b40a-d46ee5294d25", "97be5dc0-25b4-4f90-ba8a-590f6d7a5520", "594084da-6177-43e7-bb88-879d820c774a", "09c5eee6-68c4-499f-9645-00e9a3d51768"];
function CreateHook() {
    return new DevletArsivleriHook();
}
exports.CreateHook = CreateHook;
exports.SocialAreaCreditReducerScheduledJobIds = [
    "0741bebb-1b73-4c7d-9239-c8ddeb1ff7b7",
    "bbeb5920-4c2a-4daa-af14-b4c71c017f76",
    "af85e5cc-5d02-42bc-a0f9-b1a189fefced",
    "c7a56925-317a-4867-a2a2-5db827a2c534",
    "ef462203-9d2c-40f8-80d8-e3f053a8fc87",
];
class DevletArsivleriHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        app_logs_1.logger.info("Custom extension DevletArsivleriHook created!");
        super();
        this.beforeAssingUserRegionTicketUnits = this.customBeforeAssingUserRegionTicketUnits;
        this.scheduledJobRoutine = this.customScheduledJobRoutine.bind(this);
    }
    async customBeforeAssingUserRegionTicketUnits(organizationId, requesterUserId, userSelectionSessionId, updateAmount) {
        let result = [];
        app_logs_1.logger.info("Running scheduled job beforeAssingUserRegionTicketUnits");
        let userIds = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let session = await dal_manager_1.dbManager.accessUser.validateUserSelectionSession(organizationId, requesterUserId, userSelectionSessionId, trx);
            let userIdsOfSelectionSession = await trx.query(`
                SELECT "userId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessionActions}"
                WHERE "sessionId" = $1 AND "action" = $2;
            `, [userSelectionSessionId, dal_constants_1.DalConstants.UserSelectionSessionAction.Added]);
            return userIdsOfSelectionSession.rows.map((r) => r.userId);
        });
        let today = (0, moment_1.default)();
        let nextSocialAreaCreditPeriod;
        if (today.get("date") <= CREDIT_PERIOD_END) {
            nextSocialAreaCreditPeriod = today.clone().set("date", CREDIT_PERIOD_END);
        }
        else {
            nextSocialAreaCreditPeriod = today.clone().add(1, "month").set("date", CREDIT_PERIOD_END);
        }
        for (const uid of userIds) {
            if (usersToIgnore.includes(uid)) {
                continue;
            }
            const employeeWorkplan = await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
                return await dal_manager_1.dbManager.accessPacs2.getEmployeeWorkPlan(trx, organizationId, uid, {
                    startDateTime: new Date(today.format("YYYY-MM-DD")),
                    endDateTime: nextSocialAreaCreditPeriod.clone().add(1, "day").toDate(),
                });
            }, requesterUserId, organizationId);
            let employeeWorkingSchedule = employeeWorkplan.workingSchedule;
            let organizationHolidays = employeeWorkplan.holidays;
            for (const ews of employeeWorkingSchedule) {
                if (ews.workingHours.length > 0) {
                    let isHoliday = false;
                    for (const ewh of ews.workingHours) {
                        let holidaysContainingWorkSchedule = organizationHolidays.filter((h) => new moment_range_1.DateRange(h.originalRange.startDateTime, h.originalRange.endDateTime).contains(new moment_range_1.DateRange(ewh.range.startDateTime, ewh.range.endDateTime)));
                        if (holidaysContainingWorkSchedule.length > 0) {
                            isHoliday = true;
                            break;
                        }
                    }
                    if (isHoliday) {
                        ews.workingHours = [];
                        continue;
                    }
                }
            }
            employeeWorkingSchedule = employeeWorkingSchedule.filter((ews) => ews.workingHours.length > 0);
            if (updateAmount > employeeWorkingSchedule.length) {
                result.push({ userId: uid, maxValue: employeeWorkingSchedule.length });
                await dal_manager_1.dbManager.accessUser.removeUserFromUserSelectionSession(organizationId, requesterUserId, userSelectionSessionId, uid);
            }
        }
        return result;
    }
    async customScheduledJobRoutine(organizationId, scheduledJobId) {
        if (exports.SocialAreaCreditReducerScheduledJobIds.includes(scheduledJobId)) {
            await this.socialAreaCreditReducer();
        }
        else {
            app_logs_1.logger.error("Scheduled job id not found in SocialAreaCreditReducerScheduledJobIds list!");
        }
    }
    async socialAreaCreditReducer() {
        const CREDIT_CHANGE_AMOUNT = -1;
        const PAGINATION_TAKE = 100000;
        const PAGINATION_SKIP = 0;
        const date = new Date();
        let userRegionTicketStatus = [];
        let dailyTicketUsageUserIdList = [];
        const userTicketUsageStatus = await dal_manager_1.dbManager.accessSocial.listUserRegionTicketUnits(organizationId, {
            take: PAGINATION_TAKE,
            skip: PAGINATION_SKIP,
        }, {});
        const dailyTicketUsageHistory = await dal_manager_1.dbManager.accessLog.listRegionTicketReport(organizationId, {
            take: PAGINATION_TAKE,
            skip: PAGINATION_SKIP,
        }, {
            startDateTime: (0, moment_1.default)().startOf("day").toDate(),
            endDateTime: (0, moment_1.default)().endOf("day").toDate(),
        });
        for (const iterator of dailyTicketUsageHistory.items) {
            if (iterator.o && !dailyTicketUsageUserIdList.includes(iterator.o)) {
                dailyTicketUsageUserIdList.push(iterator.o);
            }
        }
        userRegionTicketStatus = userTicketUsageStatus.items.filter((utus) => !dailyTicketUsageUserIdList.includes(utus.user.id) && utus.remainingUnits > 0);
        const dailySummaryOfUsers = await (0, business_pacs_report_1.getDailySummaryReport)(organizationId, {
            date: date,
            pagination: {
                take: PAGINATION_TAKE,
                skip: PAGINATION_SKIP,
            },
            sortingMethod: app_enums_1.enums.WorkSummarySortType.Name,
            status: app_enums_1.enums.IdentityStatusType.Enabled,
            userIds: userRegionTicketStatus.map((urts) => urts.user.id),
            hasOrganizationWide: true,
            permittedUnitIds: null,
        }, dal_constants_1.DalConstants.SystemUserId, true, null);
        dailySummaryOfUsers.items = dailySummaryOfUsers.items.filter((uds) => uds.workPlan && uds.workPlan.startOfWorkUtc);
        const userIdsToReduceCredit = dailySummaryOfUsers.items.map((i) => i.user.id);
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const dbResult = await dal_manager_1.dbManager.accessUser.obtainUserSelectionSession(organizationId, {
                requestUserId: dal_constants_1.DalConstants.SystemUserId,
                type: app_enums_1.enums.UserSelectionSessionType.RegionTicketTransaction,
                relatedItemId: uuid_1.default.v4(),
                forceToCreate: true,
                isAuthorizedForAllUsers: true,
            }, trx);
            if (!dbResult.upserted) {
                throw (0, api_error_1.generateConflictError)({
                    message: "There is already a session for that ticket transaction. Please see detailes.",
                    details: dbResult.overwritten,
                });
            }
            else {
                await trx.query(`
					INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessionActions}" 
					("id","sessionId", "userId", "originalMappingId", "generatedMappingId","action")
					VALUES (uuid_generate_v4(), $1, UNNEST($2::uuid[]), null, uuid_generate_v4(), $3);
                 `, [dbResult.sessionId, userIdsToReduceCredit, dal_constants_1.DalConstants.UserSelectionSessionAction.Added]);
                await dal_manager_1.dbManager.accessSocial.assignRegionTicketUserUnits(organizationId, {
                    userSelectionSessionId: dbResult.sessionId,
                    amount: CREDIT_CHANGE_AMOUNT,
                    note: "Kullanılmayan kontör sistem tarafından düşülmüştür.",
                    requestUserId: dal_constants_1.DalConstants.SystemUserId,
                }, trx);
            }
        });
    }
}
