"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
function CreateHook() {
    return new AlfaSolarHook();
}
exports.CreateHook = CreateHook;
class AlfaSolarHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.changePermissionApprovementLevel = async function (organizationId, userId, approvementList, permissionTypeId) {
            const annualPermissionTypeId = "75de69bd-8abc-4407-823a-9b464b33b19d";
            const organizationIdNamePair = [
                {
                    name: "KUZEY ÜRETİM A",
                    id: "e3574db2-6103-4f1b-be92-ce1839798210",
                },
                {
                    name: "KUZEY ÜRETİM B",
                    id: "d45e9a8c-2391-4946-ba10-c44a8b05a4bc",
                },
                {
                    name: "KUZEY ÜRETİM C",
                    id: "14225afa-5b41-41fe-8ce7-6e9e83146a64",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-1 A",
                    id: "b5cc779d-525c-4667-b27d-9b5f89b160f2",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-1 B",
                    id: "8af3d53d-9317-449e-98a0-e6a83e82e3db",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-1 C",
                    id: "3a245305-c6ee-4e72-881c-e3fcc06eb051",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-2 A",
                    id: "5210b87b-b374-4129-9d5c-dd59665a19b2",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-2 B",
                    id: "36fd6bbf-0248-4770-b032-2161180cade5",
                },
                {
                    name: "GÜNEY ÜRETİM FAZ-2 C",
                    id: "51056065-745b-498e-8f27-e957ed739658",
                },
            ];
            const permissionApprovementRule = ["239c5522-1d4a-4a04-afab-15e078d2961f", "239c5522-1d4a-4a04-afab-15e078d2961f", null];
            const organizationUnitsOfUser = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitBasicOfUser(organizationId, userId);
            if (permissionTypeId &&
                permissionTypeId === annualPermissionTypeId &&
                organizationUnitsOfUser.find((elem) => organizationIdNamePair.find((item) => item.id === elem.id && elem.manager?.id !== userId))) {
                return permissionApprovementRule;
            }
            return approvementList;
        }.bind(this);
    }
}
