"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const crypto_1 = __importDefault(require("crypto"));
function CreateHook() {
    return new FevziGandurHook();
}
exports.CreateHook = CreateHook;
class FevziGandurHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.overrideUserAccountWithEmail = (params) => {
            if (params.identity.organizationProfile.email) {
                if (params.identity.userAccount?.username !== params.identity.organizationProfile.email) {
                    params.identity.userAccount = {
                        username: params.identity.organizationProfile.email,
                        password: crypto_1.default.randomBytes(12).toString("hex"),
                    };
                }
            }
        };
        this.beforeUserInsert = async (params) => {
            const result = {
                errorMessage: "",
                isValid: true,
            };
            this.overrideUserAccountWithEmail(params);
            return result;
        };
        this.beforeUserUpdate = async (params) => {
            const result = {
                errorMessage: "",
                isValid: true,
            };
            this.overrideUserAccountWithEmail(params);
            return result;
        };
    }
}
