"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TurquoiseYachtEmployeeDailyAttendanceCustomReport = exports.generateReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_constants_1 = require("../../../dal/dal.constants");
const uuid_1 = __importDefault(require("uuid"));
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
const controller_report_1 = require("../../../api/pacs/v2/controllers/controller.report");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
            top: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.AllThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thick",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thick",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
})(Constants || (Constants = {}));
async function generateReport(request, locale) {
    const report = new TurquoiseYachtEmployeeDailyAttendanceCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
class TurquoiseYachtEmployeeDailyAttendanceCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._wb = new exceljs_1.default.Workbook();
        this._request = request;
        this._filter = request.filter;
        this._options = {
            date: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateDay).value),
        };
    }
    async generateReport() {
        app_logs_1.logger.info("Generating custom report");
        const filter = {
            sortType: dal_constants_1.DalConstants.WorkSummarySortType.Name,
            sortOrder: "DESC",
            userFilter: {},
            date: this._options.date.toDate(),
            paginationRequest: { skip: 0, take: app_config_1.appConfig.reportExportRowLimit },
        };
        if ((0, moment_1.default)(this._options.date).isSame((0, moment_1.default)(), "day")) {
            try {
                await (0, controller_report_1.refreshUsersSummaryForToday)({
                    requesterUserId: this._request.requesterUserId,
                    applyOrganizationUnitFilterHierarchically: filter.userFilter.applyOrganizationUnitFilterHierarchically,
                    userGroupIds: filter.userFilter.userGroupIds,
                    organizationId: this._request.organizationId,
                    organizationUnitIds: filter.userFilter.organizationUnitIds,
                    userIds: filter.userFilter.userIds,
                    requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                    requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                    userOrganizationStatus: filter.userFilter.userOrganizationStatus,
                });
            }
            catch (error) {
                app_logs_1.logger.error("Error while refreshing today in custom report generation : " + error);
                return;
            }
        }
        this._dailyData = await dal_manager_1.dbManager.accessPacs2.workSummaryOfFilteredEmployeesAtDate(this._request.requesterUserId, this._request.organizationId, filter);
        this._usersWithOrgUnits = await dal_manager_1.dbManager.accessOrganizationUnit.listUsersWithOrganizationUnits(this._request.organizationId);
        this._usersWithUserGroups = await dal_manager_1.dbManager.accessUserGroup.listUserGroupsForControlPanel(this._request.organizationId);
        this._userGroupsDetailed = await dal_manager_1.dbManager.accessUserGroup.listUserGroupsByIds(this._request.organizationId, this._usersWithUserGroups.map((ug) => ug.userGroupId));
        this._rootOrgUnits = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitsAtRootLevel({ organizationId: this._request.organizationId });
        this._allOrgUnitsDetailed = [];
        let ids = this._rootOrgUnits.map((r) => r.id);
        await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
            const units = await dal_manager_1.dbManager.accessOrganizationUnit.getAllSuccessorOrganizationUnitsBasic(this._request.organizationId, ids, trx);
            this._allOrgUnitsDetailed = this._allOrgUnitsDetailed.concat(units);
        }, this._request.requesterUserId, this._request.organizationId);
        this._subcontractors = this._allOrgUnitsDetailed.filter((ou) => ou.name === "DESTEK FİRMALAR");
        this._ppermissionTypes = await dal_manager_1.dbManager.accessPacs.listPPermissionTypes(this._request.organizationId, {
            take: 100,
            skip: 0,
        });
        this._filePath = await this.generate();
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
            sendFileInAttachments: undefined,
            customReportName: "TURQUOISE YACHT & TURQUOISE SHIPYARD EMPLOYEE DAILY ATTENDANCE REPORT",
        };
    }
    async generate() {
        this._organizationBasic = await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._request.organizationId);
        this._wsGeneral = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: "en" }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this.addFilterToSheet(this._wsGeneral, 1, 1);
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._orgUnitRowIndex = 6;
        this._personnelListRowIndex = 6;
        this._wsGeneral.headerFooter.oddHeader =
            "&L" +
                this._organizationBasic.name +
                " " +
                " Employee Daily Attendance Report " +
                "\n" +
                "&R" +
                i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: "en" }) +
                " : " +
                (0, moment_1.default)(this._options.date).locale("en").format("LL") +
                "\n";
        this._wsGeneral.headerFooter.oddFooter = i18n_1.default.__({ phrase: "EXCEL-REPORT.PAGE", locale: "en" }) + " &P / &N" + "&R" + "&D  &T";
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        const requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._request.organizationId, [this._request.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Requester user not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        for (const item of this._dailyData.items) {
            if (!item.firstStart && !item.normalWorkDuration) {
                this.addPersonnelRow(item);
            }
        }
        this.addPersonnelRow(null, true);
        this.addUserGroups();
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + this._orgUnitRowIndex;
        this._wsGeneral.pageSetup.printTitlesRow = "5:5";
        this._fileId = uuid_1.default.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.info("File is ready -> " + this._filePath);
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        const columns = [];
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "DEPARTMENT", border: Constants.Styling.AllThin, note: "KULLANICI GRUBU" });
        columns.push({ width: 45 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "TOTAL PERSONNEL", border: Constants.Styling.AllThin, note: "TOPLAM ÇALIŞAN" });
        columns.push({ width: 15 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "TOTAL ABSENT PERSONNEL", border: Constants.Styling.AllThin, note: "GELMEYEN ÇALIŞAN TOPLAMI" });
        columns.push({ width: 15 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "NUMBER OF PERSONNEL ON SHIFT", border: Constants.Styling.AllThin, note: "VARDİYALI ÇALIŞAN" });
        columns.push({ width: 15 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "TOTAL DAILY ATTENDANTS", border: Constants.Styling.AllThin, note: "GELEN ÇALIŞAN" });
        columns.push({ width: 15 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "", border: Constants.Styling.Dotted });
        columns.push({ width: 5 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "NAME & SURNAME", border: Constants.Styling.AllThin, note: "ADI SOYADI" });
        columns.push({ width: 50 });
        this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: "ABSENT WITHOUT LEAVE", border: Constants.Styling.AllThin, note: "HABERSİZ / İZİNSİZ\r\nBİLGİ YOK" });
        columns.push({ width: 15 });
        for (const pt of this._ppermissionTypes.items) {
            this.addInitCell({ ws: wsRaw, row: startRowIndex, col: startColIndex++, value: pt.name, border: Constants.Styling.AllThin });
            columns.push({ width: 15 });
        }
        wsRaw.columns = columns;
        wsRaw.views = [{ showGridLines: false }];
    }
    addInitCell(params) {
        const c = params.ws.getCell(params.row, params.col);
        c.value = params.value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = params.border;
        if (params.note) {
            c.note = params.note;
        }
        if (params.backgroundColorCode) {
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        }
    }
    addPersonnelRow(row, addSumRow) {
        let colIndex;
        if (row) {
            colIndex = 6;
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex++,
                value: (this._personnelListRowIndex - 5),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex++,
                value: row.userCaption[0].text[0].toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            if (row.usedPermissions?.length > 0) {
                for (const ppermission of row.usedPermissions) {
                    const index = this._ppermissionTypes.items.findIndex((pt) => pt.id === ppermission.id);
                    if (index >= 0) {
                        this.setDataCell({
                            rowIndex: this._personnelListRowIndex,
                            colIndex: colIndex + 1 + index,
                            value: 1,
                            ws: this._wsGeneral,
                            border: Constants.Styling.AllThin,
                        });
                    }
                    else {
                        this.setDataCell({
                            rowIndex: this._personnelListRowIndex,
                            colIndex: colIndex,
                            value: 1,
                            ws: this._wsGeneral,
                            border: Constants.Styling.AllThin,
                        });
                    }
                }
            }
            else if (!row.firstStart || row.normalWorkDuration === 0) {
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex,
                    value: 1,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
            }
            for (let i = 0; i <= this._ppermissionTypes.items.length; i++) {
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex++,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
            }
            this._personnelListRowIndex++;
            colIndex = 0;
        }
        if (addSumRow) {
            colIndex = 6;
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex++,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex++,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            for (let i = 0; i <= this._ppermissionTypes.items.length; i++) {
                const startAddress = this._wsGeneral.getColumn(colIndex).letter + 6;
                const endAddress = this._wsGeneral.getColumn(colIndex).letter + (this._personnelListRowIndex - 1);
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex++,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                    value: {
                        formula: "SUM(" + startAddress + ":" + endAddress + ")",
                    },
                    backgroundColorCode: "81ABE0",
                });
            }
        }
    }
    addUserGroups() {
        let totalAbsent = 0;
        let totalCame = 0;
        let totalPersonnel = 0;
        for (const userGroup of this._userGroupsDetailed) {
            let colIndex = 1;
            let usersIds = this._usersWithUserGroups.find((ug) => ug.userGroupId === userGroup.id).userIds;
            usersIds = usersIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
            let personnelCame = 0;
            let personnelAbsent = 0;
            let userList = "";
            let count = 0;
            for (const userId of usersIds) {
                const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                    personnelCame++;
                }
                else {
                    personnelAbsent++;
                }
                userList += ++count + " - " + dailyData.userCaption[0].text[0].toUpperCase() + "\r\n";
            }
            totalAbsent += personnelAbsent;
            totalCame += personnelCame;
            totalPersonnel += usersIds.length;
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: userGroup.name.toUpperCase(),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: usersIds.length,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
                note: userList,
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: personnelAbsent,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: personnelCame,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this._orgUnitRowIndex++;
        }
        let colIndex = 1;
        for (let i = 0; i < 5; i++) {
            this.setDataCell({
                ws: this._wsGeneral,
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: "",
                border: Constants.Styling.Dotted,
            });
        }
        this._orgUnitRowIndex++;
        colIndex = 1;
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "TOTAL SUM OF PERSONNEL",
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
        });
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: totalPersonnel,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
            isTextRed: true,
        });
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: totalAbsent,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
            isTextRed: true,
        });
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "",
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
        });
        this.setDataCell({
            ws: this._wsGeneral,
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: totalCame,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
            isTextRed: true,
        });
        let subcontractorsTotalPersonnel = 0;
        let subcontractorsAbsentPersonnel = 0;
        let subcontractorsCamePersonnel = 0;
        for (const subconctractor of this._subcontractors) {
            const firms = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(subconctractor.id));
            const allFirmsUsers = this._usersWithOrgUnits.filter((uou) => firms.map((f) => f.id).includes(uou.organizationUnitId)).map((f) => f.userIds);
            let userIds = [];
            for (const item of allFirmsUsers) {
                userIds.push(...item);
            }
            userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
            for (const userId of userIds) {
                const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                    subcontractorsCamePersonnel++;
                }
                else {
                    subcontractorsAbsentPersonnel++;
                }
            }
            subcontractorsTotalPersonnel += userIds.length;
        }
        this._orgUnitRowIndex++;
        colIndex = 1;
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "TOTAL SUM OF SUBCONTRACTORS",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: subcontractorsTotalPersonnel,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: subcontractorsAbsentPersonnel,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: subcontractorsCamePersonnel,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this._orgUnitRowIndex++;
        colIndex = 1;
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "TOTAL SUM",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "B3B4B7",
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: (subcontractorsTotalPersonnel + totalPersonnel),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "B3B4B7",
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: (subcontractorsAbsentPersonnel + totalAbsent),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "B3B4B7",
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "B3B4B7",
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: (subcontractorsCamePersonnel + totalCame),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "B3B4B7",
        });
        for (const subcontractor of this._subcontractors) {
            this._orgUnitRowIndex += 2;
            colIndex = 1;
            const parent = this._rootOrgUnits.find((ou) => ou.id === subcontractor.ancestorIds[0]);
            this.addInitCell({
                row: this._orgUnitRowIndex,
                col: colIndex++,
                value: (parent.name.toUpperCase() + " SUBCOTRACTORS "),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.addInitCell({
                row: this._orgUnitRowIndex,
                col: colIndex++,
                value: "GENERAL",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.addInitCell({
                row: this._orgUnitRowIndex,
                col: colIndex++,
                value: "ABSENT PERSONNEL",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.addInitCell({
                row: this._orgUnitRowIndex,
                col: colIndex++,
                value: "DAILY ATTENDANTS",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            const firms = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(subcontractor.id));
            let subcontractorsTotalPersonnel = 0;
            let subcontractorsAbsentPersonnel = 0;
            let subcontractorsCamePersonnel = 0;
            for (const firm of firms) {
                let userIds = this._usersWithOrgUnits.find((uou) => firm.id === uou.organizationUnitId)?.userIds || [];
                userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
                let total = 0;
                let absent = 0;
                let came = 0;
                let userList = "";
                let camePersonnel = "";
                let count = 0;
                for (const userId of userIds) {
                    const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                    if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                        came++;
                        camePersonnel += ++count + " - " + dailyData.userCaption[0].text[0].toUpperCase() + "\r\n";
                    }
                    else {
                        absent++;
                    }
                    userList += ++count + " - " + dailyData.userCaption[0].text[0].toUpperCase() + "\r\n";
                }
                total += userIds.length;
                this._orgUnitRowIndex++;
                colIndex = 1;
                this.setDataCell({
                    rowIndex: this._orgUnitRowIndex,
                    colIndex: colIndex++,
                    value: firm.name.toUpperCase(),
                    ws: this._wsGeneral,
                    border: Constants.Styling.Dotted,
                });
                this.setDataCell({
                    rowIndex: this._orgUnitRowIndex,
                    colIndex: colIndex++,
                    value: total,
                    ws: this._wsGeneral,
                    border: Constants.Styling.Dotted,
                    note: userList,
                });
                this.setDataCell({
                    rowIndex: this._orgUnitRowIndex,
                    colIndex: colIndex++,
                    value: absent,
                    ws: this._wsGeneral,
                    border: Constants.Styling.Dotted,
                });
                this.setDataCell({
                    rowIndex: this._orgUnitRowIndex,
                    colIndex: colIndex++,
                    value: came,
                    ws: this._wsGeneral,
                    border: Constants.Styling.Dotted,
                    note: camePersonnel,
                });
                subcontractorsTotalPersonnel += total;
                subcontractorsAbsentPersonnel += absent;
                subcontractorsCamePersonnel += came;
            }
            this._orgUnitRowIndex++;
            colIndex = 1;
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: "TOTAL SUM",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: subcontractorsTotalPersonnel,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: subcontractorsAbsentPersonnel,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: subcontractorsCamePersonnel,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                backgroundColorCode: "B3B4B7",
            });
            this._orgUnitRowIndex++;
            colIndex = 1;
        }
        this._orgUnitRowIndex += 3;
        colIndex = 1;
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: (0, moment_1.default)(this._options.date).locale("en").format("LL"),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            isTextRed: true,
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        let rootsTotalPersonnel = 0;
        for (const root of this._rootOrgUnits) {
            this._orgUnitRowIndex++;
            colIndex = 1;
            const orgUnits = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(root.id) &&
                !this._subcontractors.map((s) => s.id).includes(ou.id) &&
                !ou.ancestorIds.some((ai) => this._subcontractors.map((s) => s.id).includes(ai)));
            let totalRootPersonnel = 0;
            for (const orgUnit of orgUnits) {
                let userIds = this._usersWithOrgUnits.find((uou) => orgUnit.id === uou.organizationUnitId)?.userIds;
                if (userIds) {
                    userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
                    totalRootPersonnel += userIds.length;
                }
            }
            rootsTotalPersonnel += totalRootPersonnel;
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: (root.name.toUpperCase() + " - TOTAL SUM OF PERSONNEL"),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._orgUnitRowIndex,
                colIndex: colIndex++,
                value: totalRootPersonnel,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
        }
        this._orgUnitRowIndex++;
        colIndex = 1;
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: "TOTAL SUM",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
        });
        this.setDataCell({
            rowIndex: this._orgUnitRowIndex,
            colIndex: colIndex++,
            value: rootsTotalPersonnel,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            backgroundColorCode: "81ABE0",
        });
        this._personnelListRowIndex += 2;
        colIndex = 7;
        for (const root of this._rootOrgUnits) {
            const subcontractor = this._subcontractors.find((s) => s.ancestorIds.includes(root.id));
            let subcontotal = 0;
            let subconabsent = 0;
            let subconcame = 0;
            if (subcontractor) {
                const firms = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(subcontractor.id));
                const allFirmsUsers = this._usersWithOrgUnits.filter((uou) => firms.map((f) => f.id).includes(uou.organizationUnitId)).map((f) => f.userIds);
                let userIds = [];
                for (const item of allFirmsUsers) {
                    userIds.push(...item);
                }
                userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
                for (const userId of userIds) {
                    const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                    if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                        subconcame++;
                    }
                    else {
                        subconabsent++;
                    }
                }
                subcontotal += userIds.length;
            }
            let total = 0;
            let absent = 0;
            let came = 0;
            const firms = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(root.id));
            const allFirmsUsers = this._usersWithOrgUnits.filter((uou) => firms.map((f) => f.id).includes(uou.organizationUnitId)).map((f) => f.userIds);
            let userIds = [];
            for (const item of allFirmsUsers) {
                userIds.push(...item);
            }
            userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
            for (const userId of userIds) {
                const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                    came++;
                }
                else {
                    absent++;
                }
            }
            total += userIds.length;
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: (root.name.toUpperCase() + " - TOTAL SUM"),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: total,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: (root.name.toUpperCase() + " SUBCONT. - ATTANDANCE"),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: subcontotal,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: (root.name.toUpperCase() + " - ABSENT PERSONNEL"),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: (absent + subconabsent),
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex,
                colIndex: colIndex,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this.setDataCell({
                rowIndex: this._personnelListRowIndex++,
                colIndex: colIndex + 1,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
            this._personnelListRowIndex += 2;
        }
        colIndex = 7;
        this.addInitCell({
            row: this._personnelListRowIndex,
            col: colIndex,
            value: "SUBCONTRACTORS SHORT PERIOD WORK",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.addInitCell({
            row: this._personnelListRowIndex,
            col: colIndex + 1,
            value: "PROJECT",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.addInitCell({
            row: this._personnelListRowIndex,
            col: colIndex + 2,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.addInitCell({
            row: this._personnelListRowIndex,
            col: colIndex + 3,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.addInitCell({
            row: this._personnelListRowIndex++,
            col: colIndex + 4,
            value: "ATTENDED PERSONNEL",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        for (const subconctractor of this._subcontractors) {
            const firms = this._allOrgUnitsDetailed.filter((ou) => ou.ancestorIds.includes(subconctractor.id));
            for (const firm of firms) {
                let camePersonnel = 0;
                let userIds = this._usersWithOrgUnits.find((uou) => uou.organizationUnitId === firm.id)?.userIds || [];
                userIds = userIds.filter((ui) => this._dailyData.items.map((item) => item.userId).includes(ui));
                let userList = "";
                for (const userId of userIds) {
                    const dailyData = this._dailyData.items.find((dd) => dd.userId === userId);
                    if (dailyData.firstStart && dailyData.normalWorkDuration > 0) {
                        camePersonnel++;
                        userList += (0, moment_1.default)(dailyData.firstStart).format("DD.MM.YYYY hh:mm") + " - " + dailyData.userCaption[0].text[0].toUpperCase() + "\r\n";
                    }
                }
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex,
                    value: firm.name.toUpperCase(),
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex + 1,
                    value: firm.shortCode?.toUpperCase(),
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex + 2,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex,
                    colIndex: colIndex + 3,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                });
                this.setDataCell({
                    rowIndex: this._personnelListRowIndex++,
                    colIndex: colIndex + 4,
                    value: camePersonnel,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllThin,
                    note: userList,
                });
            }
        }
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        if (params.value) {
            c.value = params.value;
        }
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.numFmt) {
            c.numFmt = params.numFmt;
        }
        if (params.backgroundColorCode) {
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        }
        if (params.isTextRed) {
            c.font = {
                color: { argb: "C2051E" },
                bold: true,
            };
        }
        if (params.note) {
            c.note = params.note;
        }
    }
    addFilterToSheet(ws, startRowIndex, startColIndex) {
        const border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationBasic.name + " Employee Daily Attendance Report ", border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: "en" }), border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, (0, moment_1.default)(this._options.date).locale("en").format("LL"), border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
}
exports.TurquoiseYachtEmployeeDailyAttendanceCustomReport = TurquoiseYachtEmployeeDailyAttendanceCustomReport;
