"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnadoluIntegrationAccessResult = exports.AnadoluIntegrationAccessType = exports.anadoluIntegrationAuthorizeUser = void 0;
const got_1 = __importDefault(require("got"));
const dal_access_psql_organization_1 = require("../../dal/access/psql/dal.access.psql.organization");
const dal_manager_1 = require("../../dal/dal.manager");
const anadoluSecretId = "dd9e6ad2-dbb8-407f-9cd1-8e1b6b0ba437";
const anadoluIntegrationAuthorizeUser = async (params) => {
    const anadoluSecret = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        return await (0, dal_access_psql_organization_1.getOrganizationSecretById)(params.organizationId, anadoluSecretId, trx);
    });
    const response = await got_1.default.post(`${anadoluSecret.serviceBaseUrl}${anadoluSecret.authorizationEndpoint}`, {
        json: true,
        headers: {
            Authorization: `Bearer ${anadoluSecret.authenticationBearerToken}`,
        },
        body: params,
    });
    return {
        statusCode: response.statusCode,
        data: response.body,
    };
};
exports.anadoluIntegrationAuthorizeUser = anadoluIntegrationAuthorizeUser;
var AnadoluIntegrationAccessType;
(function (AnadoluIntegrationAccessType) {
    AnadoluIntegrationAccessType["MIFARE_CARD"] = "MIFARE_CARD";
    AnadoluIntegrationAccessType["BARCODE"] = "BARCODE";
    AnadoluIntegrationAccessType["QRCODE"] = "QRCODE";
})(AnadoluIntegrationAccessType = exports.AnadoluIntegrationAccessType || (exports.AnadoluIntegrationAccessType = {}));
var AnadoluIntegrationAccessResult;
(function (AnadoluIntegrationAccessResult) {
    AnadoluIntegrationAccessResult["ERISIM_KABUL_EDILDI"] = "ERISIM_KABUL_EDILDI";
    AnadoluIntegrationAccessResult["ERISIM_REDDEDILDI"] = "ERISIM_REDDEDILDI";
})(AnadoluIntegrationAccessResult = exports.AnadoluIntegrationAccessResult || (exports.AnadoluIntegrationAccessResult = {}));
