"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const app_enums_1 = require("../../../app.enums");
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
function CreateHook() {
    return new ArventoHook();
}
exports.CreateHook = CreateHook;
class ArventoHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.beforeUserInsert = async (params) => {
            const result = {
                errorMessage: "",
                isValid: true,
            };
            let dbResult = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
                const userRole = await trx.query(`
                    SELECT "roleId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}"
                    WHERE "deletedAt" IS NULL AND
                        "userId" = $1
                `, [params.requesterUserId]);
                if (!userRole.rowCount) {
                    return null;
                }
                const userUnitRoles = await trx.query(`
                    SELECT uoou."roleId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" AS uoou
                    INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS uo
                        ON uo.id = uoou."userOrganizationId" AND uoou."deletedAt" IS NULL AND uo."deletedAt" IS NULL
                    WHERE uo."userId" = $1
                `, [params.requesterUserId]);
                if (!userUnitRoles.rowCount) {
                    return null;
                }
                return {
                    roleId: userRole.rows[0].roleId,
                    unitRoleIds: userUnitRoles.rows.map((r) => r.roleId),
                };
            });
            if (dbResult &&
                dbResult.roleId === "1aaf09a7-80ce-4031-b73c-a4f397c13b70" &&
                dbResult.unitRoleIds.includes("6303dbf7-4644-423c-a1ff-3022fbb7157b") &&
                (!params.identity.organizationUnits || !params.identity.organizationUnits.length)) {
                result.isValid = false;
                result.errorCode = app_enums_1.enums.HttpStatusCode.CONFLICT;
                result.errorMessage = "ERRORS.CUSTOM.COMMON_UNABLETOADDUSERWITHOUTUNIT";
            }
            return result;
        };
        this.beforeUserUpdate = async (params) => {
            const result = {
                errorMessage: "",
                isValid: true,
            };
            let dbResult = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
                const userRole = await trx.query(`
                    SELECT "roleId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}"
                    WHERE "deletedAt" IS NULL AND
                        "userId" = $1
                `, [params.requesterUserId]);
                if (!userRole.rowCount) {
                    return null;
                }
                const userUnitRoles = await trx.query(`
                    SELECT uoou."roleId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" AS uoou
                    INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS uo
                        ON uo.id = uoou."userOrganizationId" AND uoou."deletedAt" IS NULL AND uo."deletedAt" IS NULL
                    WHERE uo."userId" = $1
                `, [params.requesterUserId]);
                if (!userUnitRoles.rowCount) {
                    return null;
                }
                const userToUpdateDisabled = await trx.query(`
					SELECT uo."isDisabled" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS uo
					WHERE uo."userId" = $1
				`, [params.identity.id]);
                const userToUpdateOrganizaitonUnitIds = await trx.query(`
					SELECT uoou."organizationUnitId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" AS uoou
						INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS uo
					ON uo.id = uoou."userOrganizationId" AND uoou."deletedAt" IS NULL AND uo."deletedAt" IS NULL
					WHERE uo."userId" = $1
				`, [params.identity.id]);
                return {
                    roleId: userRole.rows[0].roleId,
                    unitRoleIds: userUnitRoles.rows.map((r) => r.roleId),
                    isUserToUpdateDisabled: userToUpdateDisabled.rows[0]?.isDisabled,
                    userToUpdateOrganizationUnitIds: userToUpdateOrganizaitonUnitIds.rows.map((r) => r.organizationUnitId),
                };
            });
            if (dbResult &&
                dbResult.roleId === "1aaf09a7-80ce-4031-b73c-a4f397c13b70" &&
                dbResult.unitRoleIds.includes("6303dbf7-4644-423c-a1ff-3022fbb7157b")) {
                if (dbResult.isUserToUpdateDisabled &&
                    !params.identity.organizationProfile.isDisabled &&
                    !params.identity.addedOrganizationUnits?.length &&
                    !dbResult.userToUpdateOrganizationUnitIds?.length) {
                    result.isValid = false;
                    result.errorCode = app_enums_1.enums.HttpStatusCode.BAD_REQUEST;
                    result.errorMessage = "ERRORS.CUSTOM.COMMON_UNABLETOADDUSERWITHOUTUNIT";
                }
            }
            return result;
        };
    }
}
