"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateDefaultRolesForOrganization = exports.PredefinedRoles = exports.DefaultGeneratedRoles = void 0;
const uuid_1 = __importDefault(require("uuid"));
const predefined_permissions_1 = require("./predefined.permissions");
exports.DefaultGeneratedRoles = [
    {
        name: "OrganizationUnitReporter",
        isOrganizationWide: false,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.accessLog.getUnknownUserAccess(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.visitor.getRead(),
        ]),
    },
    {
        name: "OrganizationWideReporter",
        isOrganizationWide: true,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.accessLog.getUnknownUserAccess(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.visitor.getRead(),
            predefined_permissions_1.Permissions.region.getRead(),
        ]),
    },
    {
        name: "OrganizationUnitHumanResourcesManager",
        isOrganizationWide: false,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.identity.getEdit(),
            predefined_permissions_1.Permissions.identity.getHierarchy(),
            predefined_permissions_1.Permissions.identity.getAccessRight(),
            predefined_permissions_1.Permissions.identity.getUserAccount(),
            predefined_permissions_1.Permissions.identity.getGrantRemoteAccess(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.accessLog.getUnknownUserAccess(),
            predefined_permissions_1.Permissions.activity.get(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.organizationUnit.getReadDetailed(),
            predefined_permissions_1.Permissions.organizationUnit.getWrite(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.userGroup.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.attendancePlan.getRead(),
            predefined_permissions_1.Permissions.attendancePlan.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getRead(),
            predefined_permissions_1.Permissions.ppermission.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getHRApprovement(),
            predefined_permissions_1.Permissions.ppermission.getManuallyWrite(),
        ]),
    },
    {
        name: "OrganizationWideHumanResourcesManager",
        isOrganizationWide: true,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.identity.getEdit(),
            predefined_permissions_1.Permissions.identity.getHierarchy(),
            predefined_permissions_1.Permissions.identity.getAccessRight(),
            predefined_permissions_1.Permissions.identity.getUserAccount(),
            predefined_permissions_1.Permissions.identity.getGrantRemoteAccess(),
            predefined_permissions_1.Permissions.identity.getCredentialWrite(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.accessLog.getUnknownUserAccess(),
            predefined_permissions_1.Permissions.activity.get(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.organizationUnit.getReadDetailed(),
            predefined_permissions_1.Permissions.organizationUnit.getWrite(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.userGroup.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.region.getRead(),
            predefined_permissions_1.Permissions.attendancePlan.getRead(),
            predefined_permissions_1.Permissions.attendancePlan.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getRead(),
            predefined_permissions_1.Permissions.ppermission.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getHRApprovement(),
            predefined_permissions_1.Permissions.ppermission.getManuallyWrite(),
            predefined_permissions_1.Permissions.scheduled_job.getRead(),
            predefined_permissions_1.Permissions.scheduled_job.getWrite(),
            predefined_permissions_1.Permissions.notification_job.getRead(),
            predefined_permissions_1.Permissions.notification_job.getWrite(),
            predefined_permissions_1.Permissions.identity.getIdentityReportRead(),
        ]),
    },
    {
        name: "OrganizationUnitSecurity",
        isOrganizationWide: false,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.activity.get(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.visitor.getRead(),
            predefined_permissions_1.Permissions.visitor.getWrite(),
            predefined_permissions_1.Permissions.visitor.getSearchAll(),
        ]),
    },
    {
        name: "OrganizationWideSecurity",
        isOrganizationWide: true,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.identity.getCredentialWrite(),
            predefined_permissions_1.Permissions.activity.get(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.visitor.getRead(),
            predefined_permissions_1.Permissions.visitor.getWrite(),
            predefined_permissions_1.Permissions.region.getRead(),
            predefined_permissions_1.Permissions.region.getWrite(),
            predefined_permissions_1.Permissions.visitor.getSearchAll(),
        ]),
    },
];
exports.PredefinedRoles = {
    SystemAdministrator: {
        id: "52a088f3-4b54-4c60-b204-b8ec3dfe794a",
        name: "SystemAdministrator",
        isOrganizationWide: true,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.identity.getEdit(),
            predefined_permissions_1.Permissions.identity.getCreate(),
            predefined_permissions_1.Permissions.identity.getHierarchy(),
            predefined_permissions_1.Permissions.identity.getAccessRight(),
            predefined_permissions_1.Permissions.identity.getUserAccount(),
            predefined_permissions_1.Permissions.identity.getGrantRemoteAccess(),
            predefined_permissions_1.Permissions.identity.getCredentialWrite(),
            predefined_permissions_1.Permissions.identity.getFullWrite(),
            predefined_permissions_1.Permissions.identity.getAccessNotifications(),
            predefined_permissions_1.Permissions.identity.getSensorNotifications(),
            predefined_permissions_1.Permissions.identity.getIdentityForbiddenEdit(),
            predefined_permissions_1.Permissions.identity.getIdentityForbiddenView(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.accessLog.getUnknownUserAccess(),
            predefined_permissions_1.Permissions.activity.get(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.organizationUnit.getReadDetailed(),
            predefined_permissions_1.Permissions.organizationUnit.getWrite(),
            predefined_permissions_1.Permissions.organization.getEdit(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.userGroup.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getWrite(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.system.getRead(),
            predefined_permissions_1.Permissions.system.getWrite(),
            predefined_permissions_1.Permissions.system.getFeedbackRead(),
            predefined_permissions_1.Permissions.system.getFeedbackWrite(),
            predefined_permissions_1.Permissions.system.getEmergency(),
            predefined_permissions_1.Permissions.system.getOrganizationWidePassiveUsersView(),
            predefined_permissions_1.Permissions.scheduled_job.getRead(),
            predefined_permissions_1.Permissions.scheduled_job.getWrite(),
            predefined_permissions_1.Permissions.notification_job.getRead(),
            predefined_permissions_1.Permissions.notification_job.getWrite(),
            predefined_permissions_1.Permissions.visitor.getRead(),
            predefined_permissions_1.Permissions.visitor.getWrite(),
            predefined_permissions_1.Permissions.visitor.getPreregister(),
            predefined_permissions_1.Permissions.visitor.getSearchAll(),
            predefined_permissions_1.Permissions.visitor.getForbidden(),
            predefined_permissions_1.Permissions.visitor.getTemporaryPermit(),
            predefined_permissions_1.Permissions.visitor.getViewVisitors(),
            predefined_permissions_1.Permissions.visitor.getDeletePreregister(),
            predefined_permissions_1.Permissions.role.getWrite(),
            predefined_permissions_1.Permissions.region.getRead(),
            predefined_permissions_1.Permissions.region.getWrite(),
            predefined_permissions_1.Permissions.attendancePlan.getRead(),
            predefined_permissions_1.Permissions.attendancePlan.getAssign(),
            predefined_permissions_1.Permissions.attendancePlan.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getRead(),
            predefined_permissions_1.Permissions.ppermission.getWrite(),
            predefined_permissions_1.Permissions.ppermission.getHRApprovement(),
            predefined_permissions_1.Permissions.ppermission.getReadAll(),
            predefined_permissions_1.Permissions.ppermission.getManuallyWrite(),
            predefined_permissions_1.Permissions.accessLog.getInsertManual(),
            predefined_permissions_1.Permissions.accessLog.getDeleteManual(),
            predefined_permissions_1.Permissions.social.getRead(),
            predefined_permissions_1.Permissions.social.getWrite(),
            predefined_permissions_1.Permissions.identity.getIdentityReportRead(),
        ]),
    },
    UnitAdministrator: {
        id: "dfd8d89f-a971-4dbe-b772-e7e01ce0c8c4",
        name: "UnitAdministrator",
        isOrganizationWide: false,
        permissions: JSON.stringify([
            predefined_permissions_1.Permissions.user.getUser(),
            predefined_permissions_1.Permissions.identity.getReadBasic(),
            predefined_permissions_1.Permissions.identity.getReadDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportDetailed(),
            predefined_permissions_1.Permissions.accessLog.getReportSummary(),
            predefined_permissions_1.Permissions.userGroup.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getRead(),
            predefined_permissions_1.Permissions.attendanceControl.getReport(),
            predefined_permissions_1.Permissions.organizationUnit.getReadBasic(),
            predefined_permissions_1.Permissions.ppermission.getRead(),
            predefined_permissions_1.Permissions.ppermission.getWrite(),
            predefined_permissions_1.Permissions.scheduled_job.getRead(),
            predefined_permissions_1.Permissions.scheduled_job.getWrite(),
            predefined_permissions_1.Permissions.notification_job.getRead(),
            predefined_permissions_1.Permissions.notification_job.getWrite(),
        ]),
    },
    StandartUserOrganization: {
        id: "28f5672e-cda7-4cd0-bbb4-82f2ee4b7ec3",
        name: "StandartUserOrganization",
        isOrganizationWide: true,
        permissions: JSON.stringify([predefined_permissions_1.Permissions.user.getUser(), predefined_permissions_1.Permissions.identity.getIdentityReportRead()]),
    },
    StandartUser: {
        id: "62dc8044-0311-429b-805e-c86b91343c5b",
        name: "StandartUser",
        isOrganizationWide: false,
        permissions: JSON.stringify([predefined_permissions_1.Permissions.user.getUser()]),
    },
    OrganizationUnitVisitor: {
        id: "9b8eebd7-057f-4021-ad6f-f2879733bdb9",
        name: "OrganizationUnitVisitor",
        isOrganizationWide: false,
        permissions: "[]",
    },
    OrganizationVisitor: {
        id: "2a4ad5ff-1ced-45f8-992f-e19fc4e766d7",
        name: "OrganizationVisitor",
        isOrganizationWide: true,
        permissions: "[]",
    },
    OrganizationWideHumanResourcesManager: {
        id: "9e791732-dce8-4ea0-ace9-52db31b53c76",
        name: "OrganizationWideHumanResourcesManager",
        isOrganizationWide: true,
        permissions: exports.DefaultGeneratedRoles.find((f) => f.name === "OrganizationWideHumanResourcesManager").permissions,
    },
    OrganizationUnitHumanResourcesManager: {
        id: "bafbd37c-dc41-4eac-b273-5cafe465e5b2",
        name: "OrganizationUnitHumanResourcesManager",
        isOrganizationWide: false,
        permissions: exports.DefaultGeneratedRoles.find((f) => f.name === "OrganizationUnitHumanResourcesManager").permissions,
    },
    getRoleById: function (id) {
        switch (id) {
            case exports.PredefinedRoles.SystemAdministrator.id:
                return exports.PredefinedRoles.SystemAdministrator;
            case exports.PredefinedRoles.StandartUserOrganization.id:
                return exports.PredefinedRoles.StandartUserOrganization;
            case exports.PredefinedRoles.StandartUser.id:
                return exports.PredefinedRoles.StandartUser;
            case exports.PredefinedRoles.OrganizationUnitVisitor.id:
                return exports.PredefinedRoles.OrganizationUnitVisitor;
            case exports.PredefinedRoles.OrganizationVisitor.id:
                return exports.PredefinedRoles.OrganizationVisitor;
            case exports.PredefinedRoles.UnitAdministrator.id:
                return exports.PredefinedRoles.UnitAdministrator;
            case exports.PredefinedRoles.OrganizationWideHumanResourcesManager.id:
                return exports.PredefinedRoles.OrganizationWideHumanResourcesManager;
            case exports.PredefinedRoles.OrganizationUnitHumanResourcesManager.id:
                return exports.PredefinedRoles.OrganizationUnitHumanResourcesManager;
            default:
                throw Error("Unknown predefined role id");
        }
    },
    getPermissionsArrayByRoleId: function (roleId) {
        return JSON.parse(exports.PredefinedRoles.getRoleById(roleId).permissions);
    },
};
function generateDefaultRolesForOrganization(organizationId, roleIds) {
    let items = exports.DefaultGeneratedRoles.map((r) => {
        return {
            id: uuid_1.default.v4(),
            isOrganizationWide: r.isOrganizationWide,
            name: r.name,
            permissions: r.permissions,
            organizationId: organizationId,
        };
    });
    if (!roleIds) {
        roleIds = {
            systemAdministrator: uuid_1.default.v4(),
            unitAdministrator: uuid_1.default.v4(),
            standartUserOrganization: uuid_1.default.v4(),
            standartUser: uuid_1.default.v4(),
            organizationVisitor: uuid_1.default.v4(),
            organizationUnitVisitor: uuid_1.default.v4(),
        };
    }
    items.push({
        id: roleIds.systemAdministrator,
        isOrganizationWide: exports.PredefinedRoles.SystemAdministrator.isOrganizationWide,
        name: exports.PredefinedRoles.SystemAdministrator.name,
        permissions: exports.PredefinedRoles.SystemAdministrator.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.SystemAdministrator.id,
        minPermissions: exports.PredefinedRoles.SystemAdministrator.permissions,
    });
    items.push({
        id: roleIds.unitAdministrator,
        isOrganizationWide: exports.PredefinedRoles.UnitAdministrator.isOrganizationWide,
        name: exports.PredefinedRoles.UnitAdministrator.name,
        permissions: exports.PredefinedRoles.UnitAdministrator.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.UnitAdministrator.id,
        minPermissions: exports.PredefinedRoles.UnitAdministrator.permissions,
    });
    items.push({
        id: roleIds.standartUserOrganization,
        isOrganizationWide: exports.PredefinedRoles.StandartUserOrganization.isOrganizationWide,
        name: exports.PredefinedRoles.StandartUserOrganization.name,
        permissions: exports.PredefinedRoles.StandartUserOrganization.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.StandartUserOrganization.id,
        minPermissions: exports.PredefinedRoles.StandartUserOrganization.permissions,
    });
    items.push({
        id: roleIds.standartUser,
        isOrganizationWide: exports.PredefinedRoles.StandartUser.isOrganizationWide,
        name: exports.PredefinedRoles.StandartUser.name,
        permissions: exports.PredefinedRoles.StandartUser.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.StandartUser.id,
        minPermissions: exports.PredefinedRoles.StandartUser.permissions,
    });
    items.push({
        id: roleIds.organizationVisitor,
        isOrganizationWide: exports.PredefinedRoles.OrganizationVisitor.isOrganizationWide,
        name: exports.PredefinedRoles.OrganizationVisitor.name,
        permissions: exports.PredefinedRoles.OrganizationVisitor.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.OrganizationVisitor.id,
        minPermissions: exports.PredefinedRoles.OrganizationVisitor.permissions,
    });
    items.push({
        id: roleIds.organizationUnitVisitor,
        isOrganizationWide: exports.PredefinedRoles.OrganizationUnitVisitor.isOrganizationWide,
        name: exports.PredefinedRoles.OrganizationUnitVisitor.name,
        permissions: exports.PredefinedRoles.OrganizationUnitVisitor.permissions,
        organizationId: organizationId,
        typeId: exports.PredefinedRoles.OrganizationUnitVisitor.id,
        minPermissions: exports.PredefinedRoles.OrganizationUnitVisitor.permissions,
    });
    return items;
}
exports.generateDefaultRolesForOrganization = generateDefaultRolesForOrganization;
