"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrganizationOnlyPermissions = exports.Permissions = void 0;
exports.Permissions = {
    system: {
        name: "system",
        code: "s",
        description: "",
        getRead: function () {
            return "s:r";
        },
        getWrite: function () {
            return "s:w";
        },
        getFeedbackRead: function () {
            return "s:fr";
        },
        getFeedbackWrite: function () {
            return "s:fw";
        },
        getEmergency: function () {
            return "s:e";
        },
        getOrganizationWidePassiveUsersView: function () {
            return "s:pu";
        },
    },
    role: {
        name: "role",
        code: "r",
        description: "",
        getWrite: function () {
            return "r:w";
        },
    },
    organization: {
        name: "organization",
        code: "o",
        description: "",
        getEdit: function () {
            return "o:e";
        },
    },
    userGroup: {
        name: "user_group",
        code: "g",
        description: "",
        getRead: function () {
            return "g:r";
        },
        getWrite: function () {
            return "g:w";
        },
    },
    user: {
        name: "user",
        code: "e",
        description: "",
        getUser: function () {
            return "e:u";
        },
    },
    accessControlPoint: {
        name: "access_control_point",
        code: "p",
        description: "",
        getSnapshot: function () {
            return "p:ss";
        },
    },
    identity: {
        name: "identity",
        code: "i",
        description: "",
        getReadBasic: function () {
            return "i:b";
        },
        getReadDetailed: function () {
            return "i:d";
        },
        getEdit: function () {
            return "i:e";
        },
        getCreate: function () {
            return "i:c";
        },
        getHierarchy: function () {
            return "i:h";
        },
        getAccessRight: function () {
            return "i:a";
        },
        getUserAccount: function () {
            return "i:u";
        },
        getGrantRemoteAccess: function () {
            return "i:g";
        },
        getCredentialWrite: function () {
            return "i:cx";
        },
        getFullWrite: function () {
            return "i:fw";
        },
        getAccessNotifications: function () {
            return "i:na";
        },
        getSensorNotifications: function () {
            return "i:ns";
        },
        getIdentityForbiddenEdit: function () {
            return "i:ba";
        },
        getIdentityForbiddenView: function () {
            return "i:bv";
        },
        getIdentityReportRead: function () {
            return "i:rr";
        },
    },
    accessLog: {
        name: "access_log",
        code: "l",
        description: "",
        getReportDetailed: function () {
            return "l:d";
        },
        getReportSummary: function () {
            return "l:s";
        },
        getInsertManual: function () {
            return "l:m";
        },
        getDeleteManual: function () {
            return "l:md";
        },
        getUnknownUserAccess: function () {
            return "l:u";
        },
    },
    activity: {
        name: "activity",
        code: "a",
        description: "",
        get: function () {
            return "a:a";
        },
    },
    organizationUnit: {
        name: "organization_unit",
        code: "u",
        description: "",
        getReadBasic: function () {
            return "u:b";
        },
        getReadDetailed: function () {
            return "u:d";
        },
        getWrite: function () {
            return "u:w";
        },
    },
    attendanceControl: {
        name: "attendance_control",
        code: "j",
        description: "",
        getRead: function () {
            return "j:r";
        },
        getReport: function () {
            return "j:l";
        },
        getWrite: function () {
            return "j:w";
        },
    },
    visitor: {
        name: "visitor",
        code: "v",
        description: "",
        getRead: function () {
            return "v:r";
        },
        getWrite: function () {
            return "v:w";
        },
        getPreregister: function () {
            return "v:p";
        },
        getSearchAll: function () {
            return "v:a";
        },
        getForbidden: function () {
            return "v:b";
        },
        getTemporaryPermit: function () {
            return "v:t";
        },
        getViewVisitors: function () {
            return "v:v";
        },
        getDeletePreregister: function () {
            return "v:pd";
        },
    },
    region: {
        name: "region",
        code: "n",
        description: "",
        getRead: function () {
            return "n:r";
        },
        getWrite: function () {
            return "n:w";
        },
        getReadRegionSpecific: function () {
            return "ns:r";
        },
        getWriteRegionSpecific: function () {
            return "ns:w";
        },
        getNotificationRegionSpecific: function () {
            return "ns:n";
        },
    },
    attendancePlan: {
        name: "attendance_plan",
        code: "h",
        description: "PACS view shift plans, calendar",
        getRead: function () {
            return "h:r";
        },
        getAssign: function () {
            return "h:a";
        },
        getWrite: function () {
            return "h:w";
        },
    },
    ppermission: {
        name: "ppermission",
        code: "hp",
        description: "PACS ppermission",
        getRead: function () {
            return "hp:r";
        },
        getWrite: function () {
            return "hp:w";
        },
        getNotification: function () {
            return "hp:n";
        },
        getHRApprovement: function () {
            return "hp:h";
        },
        getReadAll: function () {
            return "hp:la";
        },
        getManuallyWrite: function () {
            return "hp:mw";
        },
    },
    social: {
        name: "social",
        code: "sc",
        description: "social module permissions",
        getRead: function () {
            return "sc:r";
        },
        getWrite: function () {
            return "sc:w";
        },
    },
    terminal: {
        name: "terminal",
        code: "t",
        description: "Terminal Permissions",
        getRead: function () {
            return "t:r";
        },
        getWrite: function () {
            return "t:w";
        },
        getNotification: function () {
            return "t:n";
        },
    },
    scheduled_job: {
        name: "scheduled_job",
        code: "sj",
        description: "Scheduled Job Permissions",
        getRead: function () {
            return "sj:r";
        },
        getWrite: function () {
            return "sj:w";
        },
    },
    notification_job: {
        name: "notification_job",
        code: "nj",
        description: "Notification Job Permissions",
        getRead: function () {
            return "nj:r";
        },
        getWrite: function () {
            return "nj:w";
        },
    },
    isOrganizationOnly: function (permission) {
        return exports.OrganizationOnlyPermissions.indexOf(permission) >= 0;
    },
};
exports.OrganizationOnlyPermissions = [
    exports.Permissions.system.getRead(),
    exports.Permissions.system.getWrite(),
    exports.Permissions.role.getWrite(),
    exports.Permissions.organization.getEdit(),
    exports.Permissions.region.getRead(),
    exports.Permissions.region.getWrite(),
    exports.Permissions.attendancePlan.getRead(),
    exports.Permissions.attendancePlan.getWrite(),
];
