"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    await changesOnFilterResult.up(client, dbuser, dbsuperuser);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await changesOnFilterResult.down(client, dbuser, dbsuperuser);
}
exports.down = down;
const changesOnFilterResult = {
    up: async (client, dbuser, dbsuperuser) => {
        const q = `
		CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_change_filter_result()
		RETURNS TRIGGER AS $$
		BEGIN
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO "___ORGANIZATION_ID___"."userAccessRights"(
				id, "createdAt", "updatedAt", "deletedAt", "userId", "accessControlPointId", "remoteAccess", "markedAsFavorite", read, access, config, "grant", snapshot)
				SELECT 	gen_random_uuid(),
						now(), 
						now(), 
						NULL, 
						sq."userId", 
						sq."accessControlPointId", 
						sq."remoteAccess",
						NULL, 
						sq."read", 
						sq."access", 
						sq."config", 
						sq."grant", 
						sq."snapshot"
				FROM (
					SELECT nt."userId",
						ufacp."accessControlPointId",
						BOOL_OR (ufacp."read") AS "read",
						BOOL_OR (ufacp."access") AS "access",
						BOOL_OR (ufacp."remoteAccess") AS "remoteAccess",
						BOOL_OR (ufacp."config") AS "config",
						BOOL_OR (ufacp."grant") AS "grant",
						BOOL_OR (ufacp."snapshot") AS "snapshot"
					FROM new_table as nt
					INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
						ON nt."filterId" = ufacp."filterId"
					GROUP BY nt."userId", ufacp."accessControlPointId"
				) sq
				LEFT JOIN "___ORGANIZATION_ID___"."userAccessRights" as uar
					ON  uar."userId" = sq."userId" 
						AND sq."accessControlPointId" = uar."accessControlPointId"
						AND uar."deletedAt" IS NULL
				WHERE  uar.id IS NULL;
				
				UPDATE "___ORGANIZATION_ID___"."userAccessRights" as uar
				SET    "read" = (ufacp."read" OR uar.read),
					access = (ufacp."access" OR uar.access),
					"remoteAccess" = (ufacp."remoteAccess" OR uar."remoteAccess"),
					config = (ufacp.config OR uar.config),
					"grant" = (ufacp."grant" OR uar."grant"),
					snapshot = (ufacp.snapshot OR uar.snapshot)
				FROM new_table as nt
				INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
					ON nt."filterId" = ufacp."filterId"
				WHERE uar."userId" = nt."userId" AND ufacp."accessControlPointId" = uar."accessControlPointId"
						AND uar."deletedAt" IS NULL;
			ELSIF (TG_OP = 'DELETE') THEN
				WITH will_be_effected_acps AS (
						SELECT ot."filterId",
								ufacp."accessControlPointId",
								ot."userId"
						FROM old_table as ot
						INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
								ON ufacp."filterId" = ot."filterId"
					), acp_relations AS (
						SELECT  wbea."accessControlPointId",
								fr."userId",
								fr."filterId"
						FROM will_be_effected_acps as wbea
						INNER JOIN "___ORGANIZATION_ID___".filter_result as fr
							ON	fr."userId" = wbea."userId" AND wbea."filterId" <> fr."filterId"
						INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
								ON ufacp."filterId" = fr."filterId"	
						WHERE wbea."accessControlPointId" = ufacp."accessControlPointId"
					), deleted_users AS (
						DELETE FROM "___ORGANIZATION_ID___"."userAccessRights" as uar
						USING will_be_effected_acps as wbea
						LEFT JOIN acp_relations as ar
							ON wbea."filterId" = ar."filterId"
						WHERE   ar."filterId" IS NULL
								AND uar."accessControlPointId" = wbea."accessControlPointId" 
								AND uar."userId" = wbea."userId"
					)
					UPDATE "___ORGANIZATION_ID___"."userAccessRights" as uar
					SET  	"updatedAt" = now(), 
							"read" = sub_q."read",
							"access" = sub_q.access,
							"remoteAccess" = sub_q."remoteAccess",
							"config" = sub_q.config,
							"grant" = sub_q."grant",
							"snapshot" = sub_q.snapshot
					FROM	(
								SELECT  ar."userId",
										ar."accessControlPointId",
										BOOL_OR(ufacp."read") as "read",
										BOOL_OR(ufacp.access) as "access",
										BOOL_OR(ufacp."remoteAccess") as "remoteAccess",
										BOOL_OR(ufacp.config) as "config",
										BOOL_OR(ufacp."grant") as "grant",
										BOOL_OR(ufacp.snapshot) as "snapshot"
								FROM acp_relations as ar
								INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
									ON ar."accessControlPointId" = ufacp."accessControlPointId"
								WHERE ufacp."filterId" = ar."filterId"
								GROUP BY ar."userId", ar."accessControlPointId"
							) sub_q
					WHERE sub_q."accessControlPointId" = uar."accessControlPointId" 
						AND uar."userId" = sub_q."userId";		
			END IF;
		RETURN NULL;
		END;
		$$ LANGUAGE plpgsql;

		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
        const q = `
		CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_change_filter_result()
		RETURNS TRIGGER AS $$
		BEGIN
			IF (TG_OP = 'INSERT') THEN
				INSERT INTO "___ORGANIZATION_ID___"."userAccessRights"(
				id, "createdAt", "updatedAt", "deletedAt", "userId", "accessControlPointId", "remoteAccess", "markedAsFavorite", read, access, config, "grant", snapshot)
				SELECT 	gen_random_uuid(),
						now(), 
						now(), 
						NULL, 
						nt."userId", 
						ufacp."accessControlPointId", 
						ufacp."remoteAccess",
						NULL, 
						ufacp."read", 
						ufacp."access", 
						ufacp."config", 
						ufacp."grant", 
						ufacp."snapshot"
				FROM new_table as nt
				INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
					ON nt."filterId" = ufacp."filterId"
				LEFT JOIN "___ORGANIZATION_ID___"."userAccessRights" as uar
					ON  uar."userId" = nt."userId" 
						AND ufacp."accessControlPointId" = uar."accessControlPointId"
						AND uar."deletedAt" IS NULL
				WHERE  uar.id IS NULL;
				
				UPDATE "___ORGANIZATION_ID___"."userAccessRights" as uar
				SET    "read" = (ufacp."read" OR uar.read),
					access = (ufacp."access" OR uar.access),
					"remoteAccess" = (ufacp."remoteAccess" OR uar."remoteAccess"),
					config = (ufacp.config OR uar.config),
					"grant" = (ufacp."grant" OR uar."grant"),
					snapshot = (ufacp.snapshot OR uar.snapshot)
				FROM new_table as nt
				INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
					ON nt."filterId" = ufacp."filterId"
				WHERE uar."userId" = nt."userId" AND ufacp."accessControlPointId" = uar."accessControlPointId"
						AND uar."deletedAt" IS NULL;
			ELSIF (TG_OP = 'DELETE') THEN
				WITH will_be_effected_acps AS (
						SELECT ot."filterId",
								ufacp."accessControlPointId",
								ot."userId"
						FROM old_table as ot
						INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
								ON ufacp."filterId" = ot."filterId"
					), acp_relations AS (
						SELECT  wbea."accessControlPointId",
								fr."userId",
								fr."filterId"
						FROM will_be_effected_acps as wbea
						INNER JOIN "___ORGANIZATION_ID___".filter_result as fr
							ON	fr."userId" = wbea."userId" AND wbea."filterId" <> fr."filterId"
						INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
								ON ufacp."filterId" = fr."filterId"	
						WHERE wbea."accessControlPointId" = ufacp."accessControlPointId"
					), deleted_users AS (
						DELETE FROM "___ORGANIZATION_ID___"."userAccessRights" as uar
						USING will_be_effected_acps as wbea
						LEFT JOIN acp_relations as ar
							ON wbea."filterId" = ar."filterId"
						WHERE   ar."filterId" IS NULL
								AND uar."accessControlPointId" = wbea."accessControlPointId" 
								AND uar."userId" = wbea."userId"
					)
					UPDATE "___ORGANIZATION_ID___"."userAccessRights" as uar
					SET  	"updatedAt" = now(), 
							"read" = sub_q."read",
							"access" = sub_q.access,
							"remoteAccess" = sub_q."remoteAccess",
							"config" = sub_q.config,
							"grant" = sub_q."grant",
							"snapshot" = sub_q.snapshot
					FROM	(
								SELECT  ar."userId",
										ar."accessControlPointId",
										BOOL_OR(ufacp."read") as "read",
										BOOL_OR(ufacp.access) as "access",
										BOOL_OR(ufacp."remoteAccess") as "remoteAccess",
										BOOL_OR(ufacp.config) as "config",
										BOOL_OR(ufacp."grant") as "grant",
										BOOL_OR(ufacp.snapshot) as "snapshot"
								FROM acp_relations as ar
								INNER JOIN "___ORGANIZATION_ID___".user_filter_access_control_points as ufacp
									ON ar."accessControlPointId" = ufacp."accessControlPointId"
								WHERE ufacp."filterId" = ar."filterId"
								GROUP BY ar."userId", ar."accessControlPointId"
							) sub_q
					WHERE sub_q."accessControlPointId" = uar."accessControlPointId" 
						AND uar."userId" = sub_q."userId";		
			END IF;
		RETURN NULL;
		END;
		$$ LANGUAGE plpgsql;

		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
};
