"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const predefined_permissions_1 = require("../../predefined/predefined.permissions");
const predefined_roles_1 = require("../../predefined/predefined.roles");
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const assignAttendancePlanPermission = '"' + predefined_permissions_1.Permissions.attendancePlan.getAssign() + '"';
    for (const organization of organizationList.rows) {
        const systemAdministrator = (await client.query(`
        	SELECT id, permissions, "typeId" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" WHERE "deletedAt" IS NULL AND "typeId" = '${predefined_roles_1.PredefinedRoles.SystemAdministrator.id}'
        `)).rows[0];
        let permissionsArray = systemAdministrator.permissions.replace(new RegExp("[\\[\\]]", "g"), "").split(",");
        if (permissionsArray.length === 1 && permissionsArray[0] === "") {
            permissionsArray = [];
        }
        let updateNeeded = false;
        if (!permissionsArray.includes(assignAttendancePlanPermission)) {
            updateNeeded = true;
            permissionsArray.push(assignAttendancePlanPermission);
        }
        if (updateNeeded) {
            const newPermissions = "[" + permissionsArray.join(",") + "]";
            await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
                SET permissions = $1
                WHERE "typeId" = $2
                `, [newPermissions, predefined_roles_1.PredefinedRoles.SystemAdministrator.id]);
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const assignAttendancePlanPermission = '"' + predefined_permissions_1.Permissions.attendancePlan.getAssign() + '"';
    for (const organization of organizationList.rows) {
        const systemAdministrator = (await client.query(`
				SELECT id, permissions, "typeId" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
				WHERE "deletedAt" IS NULL AND "typeId" = '${predefined_roles_1.PredefinedRoles.SystemAdministrator.id}'
			`)).rows[0];
        let permissionsArray = systemAdministrator.permissions.replace(new RegExp("[\\[\\]]", "g"), "").split(",");
        if (permissionsArray.length === 1 && permissionsArray[0] === "") {
            permissionsArray = [];
        }
        const index = permissionsArray.indexOf(assignAttendancePlanPermission);
        if (index !== -1) {
            permissionsArray.splice(index, 1);
            const newPermissions = "[" + permissionsArray.join(",") + "]";
            await client.query(`
				UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
				SET permissions = $1
				WHERE "typeId" = $2
				`, [newPermissions, predefined_roles_1.PredefinedRoles.SystemAdministrator.id]);
        }
    }
}
exports.down = down;
