"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client) {
    const organizationIds = (await client.query(`SELECT id FROM "public"."organizationList"`)).rows.map((row) => row.id);
    for (const organizationId of organizationIds) {
        const smsSettings = (await client.query(`SELECT settings->'notification'->'smsSettings' FROM "${organizationId}"."organizations"`)).rows[0];
        if (smsSettings) {
            await client.query(`UPDATE "${organizationId}"."organizations"
                                SET settings = jsonb_set(settings, '{notification, smsSettings, enabled}', 'true')`);
        }
    }
}
exports.up = up;
async function down(client) {
    const organizationIds = (await client.query(`SELECT id FROM "public"."organizationList"`)).rows.map((row) => row.id);
    for (const organizationId of organizationIds) {
        const smsSettings = (await client.query(`SELECT settings->'notification'->'smsSettings' FROM "${organizationId}"."organizations"`)).rows[0];
        if (smsSettings) {
            await client.query(`UPDATE "${organizationId}"."organizations"
                                SET settings = settings #- '{notification,smsSettings,enabled}'`);
        }
    }
}
exports.down = down;
