"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client) {
    const organizationList = (await client.query(`SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"`)).rows.map((row) => row.id);
    const EYASOrgId = "968b2f68-f3b2-4674-bbaa-fc939a5fa3f5";
    if (organizationList.includes(EYASOrgId)) {
        const addingUserIdsFilterIntoCustomReps = `
        UPDATE "${EYASOrgId}"."customReports"
        SET filters = filters || '[{
                    "type":1,
                    "options":{
                        "multiSelect" : true
                    }}]'::jsonb
        WHERE NOT EXISTS (
            SELECT 1
            FROM jsonb_array_elements(filters) AS elem
            WHERE elem->>'type' = '1'
        );`;
        await client.query(addingUserIdsFilterIntoCustomReps);
    }
}
exports.up = up;
async function down(client) { }
exports.down = down;
