"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `DROP VIEW IF EXISTS "___ORGANIZATION_ID___"."vW_SearchPPermissions";`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    CREATE OR REPLACE VIEW "___ORGANIZATION_ID___"."vW_SearchPPermissions" AS
    SELECT p.id,
        p."organizationId",
        p."dynamicFormData",
        p."dynamicFormId",
        p."startDateTime",
        p."endDateTime",
        p.status,
        p."requestDateTime",
        p.note,
        p."requestUserId",
        up."userPPermissions",
        upa."userPPermissionApprovements",
        useranddeputy2."userAndDeputies",
        pt."ppermissionType",
        upa."nextApproverOrganizationUnitIds",
        upa."approvedOrganizationUnitIds",
        upa."approvementWaitingOrganizationUnitIds",
        up."userCount"
    FROM ((((("___ORGANIZATION_ID___"."ppermissions" p
        JOIN ( SELECT pt_1.id,
                COALESCE(json_agg(( SELECT x.*::record AS x
                    FROM ( SELECT pt_1.id,
                                pt_1."organizationId",
                                pt_1.name,
                                pt_1.description,
                                pt_1."isPassive",
                                pt_1."hrCanInit",
                                pt_1."personnelCanInit",
                                pt_1."isDailyScheduled",
                                pt_1."minValue",
                                pt_1."maxValue",
                                pt_1."maxValueBoundaryInterval",
                                pt_1."method",
                                pt_1."sendNotification",
                                pt_1."createdAt",
                                pt_1."updatedAt",
                                pt_1."deletedAt",
                                pt_1."needsManagerDeputy",
                                pt_1."needsUserDeputy",
                                pt_1."userMustSign",
                                pt_1.type,
                                pt_1."showRemainingCount",
                                pt_1."isUnpaidLeave",
                                pt_1."notifyHR",
                                pt_1."dynamicFormId",
                                pt_1."notifyManagers",
                                pt_1.approvements) x)) FILTER (WHERE (pt_1.id IS NOT NULL)), '[]'::json) AS "ppermissionType"
            FROM ( SELECT pt_2.id,
                        pt_2."organizationId",
                        pt_2.name,
                        pt_2.description,
                        pt_2."isPassive",
                        pt_2."hrCanInit",
                        pt_2."personnelCanInit",
                        pt_2."isDailyScheduled",
                        pt_2."minValue",
                        pt_2."maxValue",
                        pt_2."maxValueBoundaryInterval",
                        pt_2."method",
                        pt_2."sendNotification",
                        pt_2."createdAt",
                        pt_2."updatedAt",
                        pt_2."deletedAt",
                        pt_2."needsManagerDeputy",
                        pt_2."needsUserDeputy",
                        pt_2."userMustSign",
                        pt_2.type,
                        pt_2."showRemainingCount",
                        pt_2."isUnpaidLeave",
                        pt_2."notifyHR",
                        pt_2."dynamicFormId",
                        pt_2."notifyManagers",
                        COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                            FROM ( SELECT pta."rootOrganizationUnitId",
                                        pta."order") x)) FILTER (WHERE (pta.id IS NOT NULL)), '[]'::json) AS approvements
                    FROM ("___ORGANIZATION_ID___"."ppermissionTypes" pt_2
                        LEFT JOIN "___ORGANIZATION_ID___"."ppermissionTypeApprovements" pta ON ((pt_2.id = pta."ppermissionTypeId")))
                    GROUP BY pt_2.id) pt_1
            GROUP BY pt_1.id) pt ON ((pt.id = p."ppermissionTypeId")))
        LEFT JOIN ( SELECT p_1.id,
                COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                    FROM ( SELECT pa_1.id,
                                pa_1."ppermissionId",
                                pa_1.name) x)) FILTER (WHERE (pa_1.id IS NOT NULL)), '[]'::json) AS "ppermissionAttachments"
            FROM ("___ORGANIZATION_ID___"."ppermissionAttachments" pa_1
                JOIN "___ORGANIZATION_ID___"."ppermissions" p_1 ON ((p_1.id = pa_1."ppermissionId")))
            GROUP BY p_1.id) pa ON ((pa.id = p.id)))
        LEFT JOIN ( SELECT up_1."ppermissionId",
                COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                    FROM ( SELECT up_1.id,
                                up_1."userId",
                                up_1."ppermissionId",
                                up_1.note,
                                up_1.approvement,
                                up_1."signedByUser",
                                up_1."currentApprovementOrder") x)) FILTER (WHERE (up_1.id IS NOT NULL)), '[]'::json) AS "userPPermissions",
                count(*) AS "userCount"
            FROM "___ORGANIZATION_ID___"."userPPermissions" up_1
            GROUP BY up_1."ppermissionId") up ON ((p.id = up."ppermissionId")))
        LEFT JOIN ( SELECT upa_1."ppermissionId",
                COALESCE(json_agg(DISTINCT ( SELECT x.*::record AS x
                    FROM ( SELECT upa_1.id,
                                upa_1."userId",
                                upa_1."ppermissionId",
                                upa_1."order",
                                upa_1."approverUserId",
                                upa_1."approvementDate",
                                upa_1.note,
                                upa_1.status,
                                upa_1."organizationUnitId") x)) FILTER (WHERE (upa_1.id IS NOT NULL)), '[]'::json) AS "userPPermissionApprovements",
                COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                    FROM ( SELECT upa_1.id,
                                upa_1."userId",
                                upa_1."ppermissionId",
                                upa_1."order",
                                upa_1."approverUserId",
                                upa_1."approvementDate",
                                upa_1.note,
                                upa_1.status,
                                upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NULL))), '[]'::json) AS "approvementWaitingOrganizationUnitIds",
                COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                    FROM ( SELECT upa_1.id,
                                upa_1."userId",
                                upa_1."ppermissionId",
                                upa_1."order",
                                upa_1."approverUserId",
                                upa_1."approvementDate",
                                upa_1.note,
                                upa_1.status,
                                upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."approvementDate" IS NOT NULL))), '[]'::json) AS "approvedOrganizationUnitIds",
                COALESCE(json_agg(DISTINCT ( SELECT x."organizationUnitId" AS x
                    FROM ( SELECT upa_1.id,
                                upa_1."userId",
                                upa_1."ppermissionId",
                                upa_1."order",
                                upa_1."approverUserId",
                                upa_1."approvementDate",
                                upa_1.note,
                                upa_1.status,
                                upa_1."organizationUnitId") x)) FILTER (WHERE ((upa_1.id IS NOT NULL) AND (upa_1."order" = up_1."currentApprovementOrder") AND (upa_1."approverUserId" IS NULL))), '[]'::json) AS "nextApproverOrganizationUnitIds"
            FROM ("___ORGANIZATION_ID___"."userPPermissionApprovements" upa_1
                JOIN "___ORGANIZATION_ID___"."userPPermissions" up_1 ON (((up_1."ppermissionId" = upa_1."ppermissionId") AND (up_1."userId" = upa_1."userId"))))
            GROUP BY upa_1."ppermissionId") upa ON ((p.id = upa."ppermissionId")))
        LEFT JOIN ( SELECT useranddeputy."ppermissionId",
                COALESCE(json_agg(( SELECT x.*::record AS x
                    FROM ( SELECT useranddeputy."user",
                                useranddeputy."deputyUser") x)), '[]'::json) AS "userAndDeputies"
            FROM ( SELECT p_1.id AS "ppermissionId",
                        p_1."organizationId",
                        json_build_object('id', uop."userId", 'fullname', (((uop.name)::text || ' '::text) || (uop.surname)::text), 'uniqueId', uop."uniqueId") AS "user",
                            CASE
                                WHEN (uop2."userId" IS NOT NULL) THEN json_build_object('id', uop2."userId", 'fullname', (((uop2.name)::text || ' '::text) || (uop2.surname)::text), 'uniqueId', uop2."uniqueId")
                                ELSE NULL::json
                            END AS "deputyUser"
                    FROM (((((("___ORGANIZATION_ID___"."ppermissions" p_1
                        JOIN "___ORGANIZATION_ID___"."userPPermissions" up_1 ON ((up_1."ppermissionId" = p_1.id)))
                        JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON (((uo."userId" = up_1."userId") AND (uo."organizationId" = p_1."organizationId"))))
                        JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop ON ((uop."userOrganizationId" = uo.id)))
                        LEFT JOIN "___ORGANIZATION_ID___"."userOrganizationDeputies" uod ON (((uod."ppermissionId" = p_1.id) AND (uod."userOrganizationId" = uo.id))))
                        LEFT JOIN "___ORGANIZATION_ID___"."userOrganizations" uo2 ON ((uo2.id = uod."deputyUserOrganizationId")))
                        LEFT JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop2 ON ((uop2."userOrganizationId" = uo2.id)))
                    WHERE ((uo."deletedAt" IS NULL) AND (uop."deletedAt" IS NULL) AND (uo2."deletedAt" IS NULL) AND (uop2."deletedAt" IS NULL))) useranddeputy
            GROUP BY useranddeputy."ppermissionId") useranddeputy2 ON ((useranddeputy2."ppermissionId" = p.id)));

    ALTER TABLE "___ORGANIZATION_ID___"."vW_SearchPPermissions"
        OWNER TO ${dbsuperuser};

    GRANT INSERT, SELECT, UPDATE, DELETE ON TABLE "___ORGANIZATION_ID___"."vW_SearchPPermissions" TO ${dbuser};
    GRANT ALL ON TABLE "___ORGANIZATION_ID___"."vW_SearchPPermissions" TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
