"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const lodash_1 = __importDefault(require("lodash"));
async function up(client) {
    await updateOrganizationWideCredentialUsages.up(client);
    await changeRedundantAuthenticationFactors.up(client);
    await changeRedundantCredentialTypes.up(client);
    await updateUserAccessRightsTriggerFunction.up(client);
    await updateAccessControlPointTriggerFunction.up(client);
}
exports.up = up;
async function down(client) {
    await updateAccessControlPointTriggerFunction.down(client);
    await updateUserAccessRightsTriggerFunction.down(client);
    await changeRedundantCredentialTypes.down(client);
    await changeRedundantAuthenticationFactors.down(client);
    await updateOrganizationWideCredentialUsages.down(client);
}
exports.down = down;
const updateOrganizationWideCredentialUsages = {
    up: async (client) => {
        const organizationIdsDbResult = await client.query(`
            SELECT id from public."organizationList";
            `);
        for (const organizationId of organizationIdsDbResult.rows.map((m) => m.id)) {
            const organizationParamsDbResult = await client.query(`
                    SELECT "availableCredentialTypes", "credentialTypes"
                    FROM "${organizationId}"."organizations"
                    LIMIT 1;
                `);
            const newAvailableCredentialTypes = organizationParamsDbResult.rows[0].availableCredentialTypes.filter((f) => ![1, 7, 10, 11, 13, 14, 15, 17].includes(f));
            if (organizationParamsDbResult.rows[0].availableCredentialTypes.includes(17) && !newAvailableCredentialTypes.includes(16)) {
                newAvailableCredentialTypes.push(16);
            }
            const newCredentialTypeConverters = organizationParamsDbResult.rows[0].credentialTypes.filter((f) => ![1, 7, 10, 11, 13, 14, 15, 17].includes(f.type));
            if (organizationParamsDbResult.rows[0].credentialTypes.find((f) => f.type === 17) && !newCredentialTypeConverters.find((f) => f.type === 16)) {
                newCredentialTypeConverters.push({
                    dataConverterFunction: "return r;",
                    oneTimeAssignable: false,
                    type: 16,
                });
            }
            await client.query(`
                UPDATE "${organizationId}"."organizations"
                SET "availableCredentialTypes" = $2,
                    "credentialTypes" = $3
                WHERE id = $1
                `, [organizationId, JSON.stringify(newAvailableCredentialTypes), JSON.stringify(newCredentialTypeConverters)]);
            const visitorModuleSettings = (await client.query(`
                SELECT settings
                FROM "${organizationId}"."organizationVisitorModuleSettings"
                LIMIT 1;
            `)).rows[0]?.settings;
            if (visitorModuleSettings) {
                const newVisitorCredentialTypes = visitorModuleSettings.availableCredentials.availableCredentialTypes.filter((f) => ![1, 7, 10, 11, 13, 14, 15, 17].includes(f));
                if (visitorModuleSettings.availableCredentials.availableCredentialTypes.includes(17) && !newVisitorCredentialTypes.includes(16)) {
                    newVisitorCredentialTypes.push(16);
                }
                visitorModuleSettings.availableCredentials.availableCredentialTypes = newVisitorCredentialTypes;
                await client.query(`
                    UPDATE "${organizationId}"."organizationVisitorModuleSettings"
                    SET settings = $1
                    `, [JSON.stringify(visitorModuleSettings)]);
            }
        }
    },
    down: async (client) => {
    },
};
const changeRedundantCredentialTypes = {
    up: async (client) => {
        const q = `
            DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
            WHERE "type" = ANY (ARRAY[1, 7, 10, 11, 13, 14, 15]);

            -- This trigger generates change item, thus prevents credential and data change
            ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationCredentials"
            DISABLE TRIGGER before_up_in_del_user_organization_credentials;

            -- Delete duplicated MRZ credentials beforehand
            DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
            WHERE "type" = 17
            AND "data" in (
                SELECT "data" FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                WHERE "type" = 16
                AND "deletedAt" IS NULL
            );

            UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials"
            SET "type" = 16
            WHERE "type" = 17;
            
            UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials"
            SET "extensionFields" = NULL, "expiresOn" = NULL
            WHERE "type" = 16;

            -- This trigger generates change item, thus prevents credential and data change
            ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationCredentials"
            ENABLE TRIGGER before_up_in_del_user_organization_credentials;
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client) => {
    },
};
const changeRedundantAuthenticationFactors = {
    up: async (client) => {
        const organizationIdsDbResult = await client.query(`
            SELECT id from public."organizationList";
            `);
        for (const organizationId of organizationIdsDbResult.rows.map((m) => m.id)) {
            const authFactorDbResult = await client.query(`
                    SELECT id, "authenticationFactors"
                    FROM "${organizationId}"."accessControlPoints";
                `, []);
            for (const acpAuthFactors of authFactorDbResult.rows) {
                if (!acpAuthFactors || !acpAuthFactors.authenticationFactors || !acpAuthFactors.authenticationFactors.length) {
                    continue;
                }
                let isUpdated = false;
                let newAuthFactors = [];
                for (const authFactorOr of acpAuthFactors.authenticationFactors) {
                    const filteredAuthFactors = authFactorOr.and.filter((f) => ![1, 12, 13, 15].includes(f.factor));
                    if (filteredAuthFactors.length !== authFactorOr.and.length) {
                        isUpdated = true;
                    }
                    let TCIdentityIndex = filteredAuthFactors.findIndex((f) => f.factor === 17);
                    while (TCIdentityIndex > -1) {
                        filteredAuthFactors[TCIdentityIndex].factor = 16;
                        isUpdated = true;
                        if (filteredAuthFactors.length) {
                            newAuthFactors.push({ and: filteredAuthFactors });
                        }
                        TCIdentityIndex = filteredAuthFactors.findIndex((f) => f.factor === 17);
                    }
                }
                if (isUpdated) {
                    newAuthFactors = lodash_1.default.uniqWith(newAuthFactors, lodash_1.default.isEqual);
                    await client.query(`
                        UPDATE "${organizationId}"."accessControlPoints"
                        SET "authenticationFactors" = $2
                        WHERE id = $1
                        `, [acpAuthFactors.id, JSON.stringify(newAuthFactors)]);
                }
            }
        }
    },
    down: async (client) => {
    },
};
const updateUserAccessRightsTriggerFunction = {
    up: async (client) => {
        const q = `

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                transaction_id		bigint;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := txid_current();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'credentialType', (''|| CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE ("j"->'factor')::text END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'credentialType', (''|| CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE ("l"->'factor')::text END)
                                        );
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'credentialType', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar.access IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'credentialType', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'credentialType', (''|| CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE ("j"->'factor')::text END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'credentialType', (''|| CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE ("l"->'factor')::text END)
                                        );
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'credentialType', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'credentialType', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
$function$
;`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client) => {
        const q = `

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                transaction_id		bigint;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := txid_current();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar.access IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
    
$function$
;
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
};
const updateAccessControlPointTriggerFunction = {
    up: async (client) => {
        const q = `

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                    transaction_id			bigint;
                    i 						jsonb;
                    j 						jsonb;
                    l 						jsonb;
                    new_available_factors		jsonb;
                    factors_in_other_acps		jsonb;
                    old_available_factors		jsonb;
                    new_added_factors			jsonb;
                    removed_factors				jsonb;
                    factors_to_send_to_device		jsonb;
                    t1					jsonb;
                BEGIN
            
                    transaction_id := txid_current();
                    new_available_factors := '[]'::jsonb;
                    factors_in_other_acps := '[]'::jsonb;
                    old_available_factors := '[]'::jsonb;
                    new_added_factors := '[]'::jsonb;
                    removed_factors := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    
                    IF (TG_OP = 'DELETE') THEN
                    
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                    
                        IF NEW."organizationId" != OLD."organizationId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                        END IF;
        
                        IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF NEW."deviceId" != OLD."deviceId" THEN
                                RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                        END IF;
        
                        IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                            RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                        END IF;
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                new_available_factors:= new_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'credentialType', (''|| CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE ("j"->'factor')::text END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                old_available_factors:= old_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'credentialType', (''|| CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE ("j"->'factor')::text END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = NEW."deviceId"
                            AND acp."id" != NEW."id"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1:= jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'credentialType', (''|| CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE ("j"->'factor')::text END)
                                    );
                                    IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                    THEN
                                        factors_in_other_acps:= factors_in_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
        
                        -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (new_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                            LOOP
                                IF (POSITION (i::text IN old_available_factors::text) < 1)
                                THEN
                                    new_added_factors:= new_added_factors || i;
                                END IF;
                            END LOOP;
                        END IF;
        
                        -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (old_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                            LOOP
                                IF (POSITION (i::text IN new_available_factors::text) < 1)
                                THEN
                                    removed_factors:= removed_factors || i;
                                END IF;
                            END LOOP; 
                        END IF;
        
                        -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                        IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                    AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                            OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                            OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
        
                        )
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        END IF;
        
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                        THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                            LOOP
                                IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionT", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uar."accessControlPointId" = NEW."id"
                            AND uar."deletedAt" IS NULL 
                            AND uoc."deletedAt" IS NULL
                            AND uoc."organizationId" = NEW."organizationId"
                            AND uar."access" = TRUE
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'credentialType', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
                    RETURN NEW;
                END;
    $function$
;`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client) => {
        const q = `

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                    transaction_id			bigint;
                    i 						jsonb;
                    j 						jsonb;
                    l 						jsonb;
                    new_available_factors		jsonb;
                    factors_in_other_acps		jsonb;
                    old_available_factors		jsonb;
                    new_added_factors			jsonb;
                    removed_factors				jsonb;
                    factors_to_send_to_device		jsonb;
                    t1					jsonb;
                BEGIN
            
                    transaction_id := txid_current();
                    new_available_factors := '[]'::jsonb;
                    factors_in_other_acps := '[]'::jsonb;
                    old_available_factors := '[]'::jsonb;
                    new_added_factors := '[]'::jsonb;
                    removed_factors := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    
                    IF (TG_OP = 'DELETE') THEN
                    
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                    
                        IF NEW."organizationId" != OLD."organizationId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                        END IF;
        
                        IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                        THEN
                            RETURN NEW;
                        END IF;
        
                        IF NEW."deviceId" != OLD."deviceId" THEN
                                RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                        END IF;
        
                        IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                            RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                        END IF;
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                new_available_factors:= new_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                old_available_factors:= old_available_factors || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = NEW."deviceId"
                            AND acp."id" != NEW."id"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1:= jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                    IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                    THEN
                                        factors_in_other_acps:= factors_in_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
        
                        -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (new_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                            LOOP
                                IF (POSITION (i::text IN old_available_factors::text) < 1)
                                THEN
                                    new_added_factors:= new_added_factors || i;
                                END IF;
                            END LOOP;
                        END IF;
        
                        -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                        IF (jsonb_array_length (old_available_factors) > 0) THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                            LOOP
                                IF (POSITION (i::text IN new_available_factors::text) < 1)
                                THEN
                                    removed_factors:= removed_factors || i;
                                END IF;
                            END LOOP; 
                        END IF;
        
                        -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                        IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                    AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                            OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                            OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
        
                        )
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                        END IF;
        
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                        THEN
                            FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                            LOOP
                                IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionT", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uar."accessControlPointId" = NEW."id"
                            AND uar."deletedAt" IS NULL 
                            AND uoc."deletedAt" IS NULL
                            AND uoc."organizationId" = NEW."organizationId"
                            AND uar."access" = TRUE
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
                    RETURN NEW;
                END;
    $function$
;`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
};
