"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client) {
    const updateAccessRightTriggerFunction = `
-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                transaction_id		bigint;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := txid_current();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar.access IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories",
											'regionStates', T."regionStates")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories",
								(
									with aps_cte as (
										select aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
										FROM "___ORGANIZATION_ID___"."antiPassbackStates" aps
										INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp
											ON racp."regionId" = aps."regionId" AND aps."userId" = uo."userId"
										INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp 
											ON racp."accessControlPointId" = acp.id
										WHERE acp."deletedAt" IS NULL AND
											acp."deviceId" = device_id
										GROUP BY aps."userId", aps."regionId", aps."actionUtc", aps."state",aps."entranceLockExpirationUtc", aps."exitLockExpirationUtc"
									) SELECT JSON_AGG(
										json_build_object(
											'id', NULL,
											'regionId', aps_cte."regionId",
											'state', aps_cte."state",
											'entranceLockExpirationDateISO', to_char(aps_cte."entranceLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'exitLockExpirationDateISO', to_char(aps_cte."exitLockExpirationUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"'),
											'actionDateISO', to_char(aps_cte."actionUtc" at time zone 'UTC', 'YYYY-MM-DD"T"HH24:MI:SS.MS"Z"')
										)
									) from aps_cte
								) AS "regionStates"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
    
$function$
;

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
        transaction_id			bigint;
        user_organization_id	uuid;
        group_id				uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."userOrganizationId";
                group_id:= OLD."userGroupId";
                IF (OLD."deletedAt" IS NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                            JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                            FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL AND uar."access" IS TRUE
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'INSERT') THEN

                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL AND uar."access" IS TRUE
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', '[]'::json,
                            'addedUserIds',  ('["' || u."id" || '"]')::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL AND uar."access" IS TRUE
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL AND uar."access" IS TRUE
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $function$
;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, updateAccessRightTriggerFunction, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client) {
    const rollBackAccessRightTriggerFunction = `

-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
                transaction_id		bigint;
                device_id			uuid;
                organization_id		uuid;
                factors_of_acp		jsonb;
                factors_of_other_acps		jsonb;
                factors_to_send_to_device		jsonb;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                t1 						jsonb;
            
                BEGIN
                    transaction_id := txid_current();
                    factors_of_acp := '[]'::jsonb;
                    factors_of_other_acps := '[]'::jsonb;
                    factors_to_send_to_device := '[]'::jsonb;
                    IF (TG_OP = 'DELETE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        RETURN OLD;
                    ELSIF (TG_OP = 'UPDATE') THEN
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                            RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                        END IF;
            
                        IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                            (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                    JSON_BUILD_OBJECT('id', OLD."id"));
                        END IF;
                        IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                            (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar.access IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                            END IF;
                        END IF;
                    ELSIF (TG_OP = 'INSERT') THEN
                        IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                            WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                            AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION 'User access right  already exists';
                        END IF;
                        SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                        SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                        IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                        THEN
                            -- send users has access rights
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionT", "type", "data")
                            -- 1. user already has an access right for an access control point that is related with the device
                            -- Then, just send new access rights
                            SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                            json_build_object(
                                'id', NEW."id",
                                'userId', NEW."userId",
                                'accessControlPointId', NEW."accessControlPointId"
                            );
            
                            -- 1.1. find credentials those are not sent then sent new credentials
                            -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                WHERE acp."id" = NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL))
                            LOOP
                                i := i->'and';
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    factors_of_acp:= factors_of_acp || jsonb_build_object(
                                        'authenticatorType', "j"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                    );
                                END LOOP;
                            END LOOP;
            
                            -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                            FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                                FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                                INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                                WHERE acp."deletedAt" IS NULL
                                AND acp."deviceId" = device_id
                                AND acp."id" != NEW."accessControlPointId"
                                AND acp."authenticationFactors" IS NOT NULL
                                AND uar."deletedAt" IS NULL
                                AND uar."userId" = NEW."userId"
                                AND uar."access" IS TRUE))
                            LOOP
                                FOR j IN SELECT * FROM jsonb_array_elements(i)
                                LOOP
                                    j := j->'and';
                                    FOR l IN SELECT * FROM jsonb_array_elements(j)
                                    LOOP
                                        t1 := jsonb_build_object(
                                            'authenticatorType', "l"->'authenticatorType',
                                            'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                        || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                        || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                        IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                        THEN
                                            factors_of_other_acps:= factors_of_other_acps || t1;
                                        END IF;
                                    END LOOP;
                                END LOOP;
                            END LOOP;
                            
                            FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                            LOOP
                                IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                    factors_to_send_to_device:= factors_to_send_to_device || i;
                                END IF;
                            END LOOP;
                            -- add new credentials for device
                            -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                            i:= jsonb_array_length(factors_to_send_to_device);
                            IF (jsonb_array_length(factors_to_send_to_device) > 0)
                            THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 1 as "type",
                                json_build_object(
                                    'id', T."id",
                                    'userId', T."userId",
                                    'type', T."type",
                                    'data', T."data",
                                    'groupNumber', T."groupNumber",
                                    'specialData', T."specialData",
                                    'specialDataSecondary', T."specialDataSecondary",
                                    'expiresOnISO', T."expiresOn",
                                    'extensionFields', T."extensionFields"
                                ) AS "data" FROM
                                (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                    uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                                FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                                WHERE uoc."deletedAt" IS NULL
                                AND uoc."userId" = NEW."userId"
                                AND POSITION(jsonb_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                            END IF;
                            
                                -- 2. users are new for that terminal
                                -- Then send add user
                            IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                                SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionT", 5 as "type",
                                    json_build_object(
                                        'user',
                                        json_build_object(
                                            'id', T."id",
                                            'roleId', T."roleId",
                                            'publicKey', T."publicKey",
                                            'isVisitor', T."isVisitor",
                                            'isDisabled', T."isDisabled",
                                            'userGroupIds', T."userGroupIds",
                                            'organizationUnitIds', T."organizationUnitIds",
                                            'accessRights', T."accessRights",
                                            'credentials', T."credentials",
                                            'coinBalances', T."coinBalances",
                                            'forbiddances', T."forbiddances",
                                            'accessRuleHistories', T."accessRuleHistories")
                                    ) AS "data" FROM
                                (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                                (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                    OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                                (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                                (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                                (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                    'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                            WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" IS TRUE) AS "accessRights",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'type', "type",
                                                    'data', "data",
                                                    'specialData', "specialData",
                                                    'specialDataSecondary', "specialDataSecondary",
                                                    'expiresOnISO', "expiresOn",
                                                    'extensionFields', "extensionFields"
                                )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                    AND POSITION(json_build_object(
                                        'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                        'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                                (SELECT JSON_AGG(json_build_object(
                                                    'id', "id",
                                                    'regionId', "regionId",
                                                    'startDateISO', "startUtc",
                                                    'endDateISO', "endUtc",
                                                    'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                                (SELECT JSON_AGG(
                                    json_build_object(
                                                    'ruleId', arh."accessRuleId",
                                                    'count', arh."count",
                                                    'actionDateISO', arh."createdDate",
                                                    'startDateTime', (arh."options")->>'startDateTime',
                                                    'endDateTime', (arh."options")->>'endDateTime',
                                                    'weekday', (arh."options")->>'dayOfWeek'
                                )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                                INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                                INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                                AND ars."organizationId" = uo."organizationId" AND (
                                    CASE WHEN (arh."options")->>'endDateTime' IS NOT NULL AND now() at time zone 'utc' < to_timestamp((arh."options")->>'endDateTime', 'YYYY-MM-DD"T"HH24:MI:SS"Z"') THEN TRUE ELSE FALSE END
                                )) AS "accessRuleHistories"
                                FROM
                                "___ORGANIZATION_ID___"."users" AS u
                                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                                INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                                ) AS T;
                            END IF;
                        END IF;
                    END IF;
                    RETURN NEW;
                END;
    
$function$
;


-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping();

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_group_mapping()
 RETURNS trigger
 LANGUAGE plpgsql
AS $function$
    DECLARE
        transaction_id			bigint;
        user_organization_id	uuid;
        group_id				uuid;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                user_organization_id:= OLD."userOrganizationId";
                group_id:= OLD."userGroupId";
                IF (OLD."deletedAt" IS NULL) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                            JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                            FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN OLD;
            ELSIF (TG_OP = 'INSERT') THEN

                user_organization_id:= NEW."userOrganizationId";
                group_id:= NEW."userGroupId";

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userGroupId', group_id,
                        'removedUserIds', '[]'::json,
                        'addedUserIds',  ('["' || u."id" || '"]')::json
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                    INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                    WHERE uo."id" = user_organization_id
                    --GROUP BY acp."deviceId"
                ) AS T
                WHERE T."row_num" = 1;
                RETURN NEW;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF (NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', '[]'::json,
                            'addedUserIds',  ('["' || u."id" || '"]')::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                ELSIF (NEW."deletedAt" IS NOT NULL AND OLD."deletedAt" IS NULL)
                THEN
                    user_organization_id:= NEW."userOrganizationId";
                    group_id:= NEW."userGroupId";

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 11, T."data"
                    FROM
                    (
                        SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                        JSON_BUILD_OBJECT(
                            'userGroupId', group_id,
                            'removedUserIds', ('["' || u."id" || '"]')::json,
                            'addedUserIds', '[]'::json
                        ) AS "data"
                        FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                        WHERE uo."id" = user_organization_id
                        --GROUP BY acp."deviceId"
                    ) AS T
                    WHERE T."row_num" = 1;
                END IF;
                RETURN NEW;
            END IF;
        END;
    $function$
;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, rollBackAccessRightTriggerFunction, "___ORGANIZATION_ID___");
}
exports.down = down;
