"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client) {
    const organizationIds = await client.query(`
            SELECT id 
            FROM public."organizationList"
        `);
    for (const orgid of organizationIds.rows.map((m) => m.id)) {
        const mfaNotificationCheck = await client.query(`
			SELECT * FROM "${orgid}".notification
			WHERE type = 51
			`);
        if (!mfaNotificationCheck.rowCount) {
            await client.query(`
				INSERT INTO "${orgid}"."notification"(
					  id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification")
					  VALUES (gen_random_uuid(), now(), NULL, 51, NULL, NULL, true, true, false, false);

				UPDATE "${orgid}".organizations
				SET settings = jsonb_set(
					settings,
					'{notification, enabledTypes}',
					(settings->'notification'->'enabledTypes' || to_jsonb(ARRAY[51])),
					false
				)
				WHERE NOT settings->'notification'->'enabledTypes' @> '51'; 
				`);
        }
    }
    const cleanUpTemplateSchemaQuery = `
	ALTER TABLE organization.notification DISABLE TRIGGER trg_delete_scheduled_job_associated_with_notification;
	DELETE FROM organization.notification;
	DELETE FROM organization.zz_notification;
	ALTER TABLE organization.notification ENABLE TRIGGER trg_delete_scheduled_job_associated_with_notification;
	`;
    await client.query(cleanUpTemplateSchemaQuery);
}
exports.up = up;
async function down(client) { }
exports.down = down;
