"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client) {
    const organizationList = await client.query(`
            SELECT id FROM public."organizationList"
        `);
    organizationList.rows.forEach(async (org) => {
        let query = `
        INSERT INTO "${org.id}"."notification"
        (id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification")
        VALUES 
        (gen_random_uuid(), now(), NULL, 52, NULL, NULL, false, false, true, false),
        (gen_random_uuid(), now(), NULL, 53, NULL, NULL, false, false, true, false);
   

	    UPDATE "${org.id}".organizations
        SET settings = jsonb_set(
            settings,
            '{notification, enabledTypes}',
            (settings->'notification'->'enabledTypes' || to_jsonb(ARRAY[52])),
            false
        )
        WHERE NOT settings->'notification'->'enabledTypes' @> '52'; 
        `;
        const pacsModule = await client.query(`
                    SELECT id, status FROM "${org.id}"."organizationModules"
                    WHERE "module" = '3' AND "disableUtc" IS NULL AND "status" = '1';
                `);
        if (pacsModule.rows.length > 0) {
            query += `UPDATE "${org.id}".organizations
        SET settings = jsonb_set(
            settings,
            '{notification, enabledTypes}',
            (settings->'notification'->'enabledTypes' || to_jsonb(ARRAY[53])),
            false
        )
        WHERE NOT settings->'notification'->'enabledTypes' @> '53'; `;
        }
        await client.query(query);
    });
    await client.query(`
        DELETE FROM public."scheduled_job"
        WHERE type = 108;
        `);
}
exports.up = up;
async function down(client) {
    let query = `
        DELETE FROM "___ORGANIZATION_ID___"."notification"
        WHERE type IN (52, 53);

        UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = jsonb_set(
            settings,
            '{notification, enabledTypes}',
            (settings->'notification'->'enabledTypes' - 52 - 53),
            false
        )
        WHERE settings->'notification'->'enabledTypes' @> '[52, 53]';
        `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
