"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const luxon_1 = require("luxon");
async function up(client) {
    const createPartitionedEmployeeDaysTableQuery = `
    
-- DROP TABLE "___ORGANIZATION_ID___"."employee_days";
CREATE TABLE "___ORGANIZATION_ID___"."employee_days" (
	id uuid NOT NULL,
	"userId" uuid NOT NULL,
	"date" date NOT NULL,
	"organizationId" uuid NOT NULL,
	"data" jsonb NOT NULL,
	CONSTRAINT "employee_days_id_date_pkey" PRIMARY KEY (id, "date"),
	CONSTRAINT "employee_days_userId_date_organizationId_key" UNIQUE ("userId", date, "organizationId")
) PARTITION BY RANGE ("date");


-- "___ORGANIZATION_ID___"."employee_days" foreign keys

ALTER TABLE "___ORGANIZATION_ID___"."employee_days" ADD CONSTRAINT employee_days_user_id FOREIGN KEY ("userId") REFERENCES "___ORGANIZATION_ID___".users(id) ON DELETE CASCADE ON UPDATE CASCADE;

CREATE TABLE "___ORGANIZATION_ID___".employee_days_default PARTITION OF "___ORGANIZATION_ID___".employee_days DEFAULT;	
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, createPartitionedEmployeeDaysTableQuery, "___ORGANIZATION_ID___");
    const organizationIds = await client.query(`
            SELECT id 
            FROM public."organizationList"
        `);
    for (const orgid of organizationIds.rows.map((m) => m.id)) {
        const missingPartitionMonthsDbResult = await client.query(`
            SELECT DATE_TRUNC ('month', "date") AS "missingPartitionMonth", COUNT(*) AS c
            FROM "${orgid}"."employeeDays"
            GROUP BY "missingPartitionMonth"
            ORDER BY "missingPartitionMonth" ASC
        `);
        for (const row of missingPartitionMonthsDbResult.rows) {
            const missingPartitionMonth = row.missingPartitionMonth;
            const partitionToCreate = "employee_days_p" + luxon_1.DateTime.fromJSDate(missingPartitionMonth).toFormat("yyyyMM");
            let partitionStart = luxon_1.DateTime.fromJSDate(missingPartitionMonth).startOf("month").toFormat("yyyy-MM-dd");
            let partitionEnd = luxon_1.DateTime.fromJSDate(missingPartitionMonth).startOf("month").plus({ month: 1 }).toFormat("yyyy-MM-dd");
            console.log(`[partition-manager.ts] There are ${row.c} entries in "${orgid}"."${partitionToCreate}" between ${partitionStart} and ${partitionEnd}`);
            console.log(`[partition-manager.ts] Creating partition "${orgid}"."${partitionToCreate}"`);
            await client.query(`
            CREATE TABLE IF NOT EXISTS "${orgid}"."${partitionToCreate}"
            PARTITION OF "${orgid}"."employee_days"
            FOR VALUES FROM ('${partitionStart}') TO ('${partitionEnd}')
        `);
        }
        console.log(`[partition-manager.ts] All necessary partitions are created, copying data from "${orgid}"."employeeDays" to table "${orgid}"."employee_days"`);
    }
    const moveDataQuery = `
    INSERT INTO "___ORGANIZATION_ID___"."employee_days"
    SELECT * FROM "___ORGANIZATION_ID___"."employeeDays";

    DROP TABLE "___ORGANIZATION_ID___"."employeeDays" CASCADE;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, moveDataQuery, "___ORGANIZATION_ID___");
    const removeNoLongerUsedPublicNotificationInstaceTables = `
		DROP TABLE IF EXISTS public."zz_notification_instance" CASCADE;
		DROP TABLE IF EXISTS public."notification_instance" CASCADE;
		DROP FUNCTION IF EXISTS public.zz_notification_instance();
	`;
    await client.query(removeNoLongerUsedPublicNotificationInstaceTables);
}
exports.up = up;
async function down(client) {
    const dropPartitionedTableAndMoveDataToNewTableQ = `
-- DROP TABLE "___ORGANIZATION_ID___"."employeeDays";
CREATE TABLE "___ORGANIZATION_ID___"."employeeDays" (
	id uuid NOT NULL,
	"userId" uuid NOT NULL,
	"date" date NOT NULL,
	"organizationId" uuid NOT NULL,
	"data" jsonb NOT NULL,
	CONSTRAINT "employeeDays_pkey" PRIMARY KEY (id),
	CONSTRAINT "employeeDays_userId_date_organizationId_key" UNIQUE ("userId", date, "organizationId")
);


-- "___ORGANIZATION_ID___"."employee_days" foreign keys

ALTER TABLE "___ORGANIZATION_ID___"."employeeDays" ADD CONSTRAINT organization_id FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___".organizations(id) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE "___ORGANIZATION_ID___"."employeeDays" ADD CONSTRAINT user_id FOREIGN KEY ("userId") REFERENCES "___ORGANIZATION_ID___".users(id) ON DELETE CASCADE ON UPDATE CASCADE;


INSERT INTO "___ORGANIZATION_ID___"."employeeDays"
SELECT * FROM "___ORGANIZATION_ID___"."employee_days";

DROP TABLE "___ORGANIZATION_ID___"."employee_days" CASCADE;
    
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropPartitionedTableAndMoveDataToNewTableQ, "___ORGANIZATION_ID___");
}
exports.down = down;
