"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client) {
    const assignAutoShiftDbFunction = `
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".assign_auto_shift(param_user_id uuid, param_rule_id uuid, log_id uuid, start_date date, end_date date)
     RETURNS void
     LANGUAGE plpgsql
    AS $function$
        DECLARE al record;
                exclusive_lock record;
                users_to_be_assigned uuid[] := ARRAY[]::uuid[];
                users_to_be_updated uuid[] := ARRAY[]::uuid[];
        BEGIN
    
            IF ("param_rule_id" IS NOT NULL) THEN
                SELECT ARRAY_AGG(DISTINCT(uo."userId")) into users_to_be_assigned
                FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" AS asrs
                INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" AS asrsg
                    ON asrs.id = asrsg."ruleSetId"
                INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                    ON uguo."userGroupId" = asrsg."groupId"
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    ON uguo."userOrganizationId" = uo.id AND uo."isDisabled" IS FALSE
                WHERE asrs.id = "param_rule_id";
            END IF;
    
            FOR al IN
                SELECT  sq2.wp_id, logs."id" as "logId", 
                        arrsg."groupId", arrsr."regionId", logs."userId",
                        logs."actionUtc" = MIN(logs."actionUtc") OVER ( PARTITION BY logs."userId", logs."actionUtc"::date, sq2.id) as is_first,
                        sq2."useOnlyFirstAccess",
                        (logs."actionUtc"::date + membership_from_date)::timestamp with time zone as mem_start,
                        (logs."actionUtc"::date + membership_to_date)::timestamp with time zone as mem_end
                FROM
                (
                    SELECT
                        id,
                        sq.wp_id,
                        sq."useOnlyFirstAccess",
                        sq."supportMobileCheckin",
                        sq."supportManualLog",
                        sq."startDateTime",
                        sq."endDateTime",
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_from->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_from->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_from->'minutes')::integer, 0)) as from_time,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_to->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_to->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_to->'minutes')::integer, 0)) as to_time,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_membership_from->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_membership_from->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_membership_from->'minutes')::integer, 0)) as membership_from_date,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_membership_to->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_membership_to->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_membership_to->'minutes')::integer, 0)) as membership_to_date
                    FROM
                    (
                        SELECT
                            arrs.id,
                            "useOnlyFirstAccess",
                            "supportMobileCheckin",
                            "supportManualLog",
                            "startDateTime",
                            "endDateTime",
                            (rrr->>'workPlanId')::uuid as wp_id,
                            rrr->'checkRange'->'from' as _from,
                            rrr->'checkRange'->'to' as _to,
                            rrr->'membershipRange'->'from' as _membership_from,
                            rrr->'membershipRange'->'to' as _membership_to
                        FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" arrs, unnest(rules) as rrr
                        WHERE ((id = "param_rule_id" OR "param_rule_id" IS NULL) AND (arrs."deletedAt" IS NULL))
                    ) sq
                ) sq2
                INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" arrsg
                    ON arrsg."ruleSetId" = sq2.id
                LEFT JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_region" arrsr
                    ON arrsr."ruleSetId" = sq2.id
                INNER JOIN (
                    SELECT
                        alo.id,
                        (alo.log->>'o')::uuid as "userId",
                        alo."actionUtc",
                        alo.log->>'a' = '06ba5170-d827-4ced-b356-f2e99afd3971' as "isMobileCheckin",
                        alo.log->>'rm' as "logMethod",
                        (alo.log->>'ir')::boolean as "isRemote",
                        alo.log->>'cid' IS NOT NULL as "isDevice",
                        (alo.log->>'iq')::boolean as "isQrTriggered",
                        array_agg((rg->>'i')::uuid) FILTER (WHERE rg->>'i' IS NOT NULL) as regions
                    FROM "___ORGANIZATION_ID___".access_logs AS alo
                    LEFT JOIN jsonb_array_elements(COALESCE(alo.log->>'rg', '[]')::jsonb) rg
                        ON 1=1
                    WHERE   alo.log->>'d' = '1'
                            AND "start_date" < alo."actionUtc" 
                            AND (alo."actionUtc" < "end_date" OR "end_date" IS NULL) 
                            AND ( (alo.log->>'o')::uuid = "param_user_id" OR (alo.log->>'o')::uuid = ANY(users_to_be_assigned))
                    GROUP BY alo.id, alo.log->>'o', alo."actionUtc"
                ) logs
                    ON
                        sq2.from_time <= (logs."actionUtc")::time AND (logs."actionUtc")::time < sq2.to_time
                        AND ("param_user_id" IS NULL OR (logs."actionUtc" >= sq2."startDateTime" AND (logs."actionUtc" <= sq2."endDateTime" OR sq2."endDateTime" IS NULL)))
                        AND (
                            (logs."logMethod" = '5' AND sq2."supportManualLog")
                            OR (logs."logMethod" = '4' AND ( sq2."supportMobileCheckin" OR NOT logs."isMobileCheckin"))
                            OR (logs."isRemote" IS NULL AND (NOT logs."isDevice" OR arrsr."regionId" = ANY(logs.regions)))
                            OR (logs."isRemote" AND logs."isQrTriggered" AND arrsr."regionId" = ANY(logs.regions))
                        )
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    ON uo."userId" = logs."userId"
                INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                    ON uguo."userOrganizationId" = uo.id AND uguo."userGroupId" = arrsg."groupId"
                WHERE   (logs."actionUtc" <= uguo."deletedAt" OR uguo."deletedAt" IS NULL) 
                        AND logs."actionUtc" >= uguo."createdAt" 
                        AND uo."deletedAt" IS NULL
                ORDER BY logs."userId", logs."actionUtc" ASC
            LOOP 
                IF ( (log_id = al."logId" OR log_id IS NULL) AND (NOT al."useOnlyFirstAccess" OR al.is_first) )  THEN
                        SELECT * into exclusive_lock
                        FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                        WHERE al."userId" = uwp."userId" FOR UPDATE;
    
                        SELECT CASE 
                                    WHEN al."userId" = ANY(users_to_be_updated) THEN users_to_be_updated
                                    ELSE ARRAY_APPEND(users_to_be_updated, al."userId") 
                                END users into users_to_be_updated;

                        WITH uwp AS (
                            SELECT uwp.id, "workPlanId" as wp, "startDateTime", "endDateTime" 
                            FROM "___ORGANIZATION_ID___"."userWorkPlans" as uwp
                            WHERE  tstzrange("startDateTime", "endDateTime") && tstzrange(al.mem_start, al.mem_end)
                                    AND uwp."userId" = al."userId"
                        ),
                        entry_info AS (
                            SELECT *
                            FROM (
                                SELECT *, row_number() OVER (PARTITION BY id, isempty(range) ) as op
                                FROM (
                                    SELECT uwp.id, uwp.wp, tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(al.mem_start,null) as range, true as exists
                                    FROM uwp
                                    UNION ALL
                                    SELECT uwp.id, uwp.wp, tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(null,al.mem_end) as range, true as exists
                                    FROM uwp
                                    UNION ALL
                                    SELECT gen_random_uuid() as id, al.wp_id as wp, tstzrange(al.mem_start,al.mem_end) as range, false as exists
                                ) sq
                            ) sq2
                        ),delete_entry AS (
                            DELETE FROM "___ORGANIZATION_ID___"."userWorkPlans" as uwp
                            USING entry_info as ei
                            WHERE uwp.id = ei.id AND ei.exists AND ei.op = 2 AND isempty(range)
                        ), update_entry AS (
                            UPDATE "___ORGANIZATION_ID___"."userWorkPlans" as uwp
                            SET "startDateTime" = LOWER(range), "endDateTime" = UPPER(range) 
                            FROM entry_info as ei
                            WHERE uwp.id = ei.id AND ei.exists AND ei.op = 1 AND NOT isempty(range)
                        )
                        INSERT INTO "___ORGANIZATION_ID___"."userWorkPlans" as uwp(
                        id, "workPlanId", "userId", "startDateTime", "endDateTime", "createdAt")
                        SELECT gen_random_uuid(), ei.wp, al."userId", LOWER(ei.range), UPPER(ei.range), now()
                        FROM entry_info as ei
                        WHERE (ei.exists AND op = 2 AND NOT isempty(ei.range)) OR (NOT ei.exists AND NOT isempty(ei.range) AND op = 1);

                END IF;
            END LOOP;
            INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT gen_random_uuid(), u, '___ORGANIZATION_ID___', 32, start_date
                FROM unnest(users_to_be_updated) u;
            UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld
                SET "updateRequiredReason" = "updateRequiredReason" | 32, "updateRequiredRaisedAt" = now()
                WHERE eld."userId" = ANY(users_to_be_updated);
        END;
    $function$
    ;
        `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, assignAutoShiftDbFunction, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client) {
    const assignAutoShiftDbFunction = `
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".assign_auto_shift(param_user_id uuid, param_rule_id uuid, log_id uuid, start_date date, end_date date)
     RETURNS void
     LANGUAGE plpgsql
    AS $function$
        DECLARE al record;
                at_now timestamp with time zone;
                exclusive_lock record;
                users_to_be_assigned uuid[] := ARRAY[]::uuid[];
                users_to_be_updated uuid[] := ARRAY[]::uuid[];
        BEGIN
    
            IF ("param_rule_id" IS NOT NULL) THEN
                SELECT ARRAY_AGG(DISTINCT(uo."userId")) into users_to_be_assigned
                FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" AS asrs
                INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" AS asrsg
                    ON asrs.id = asrsg."ruleSetId"
                INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                    ON uguo."userGroupId" = asrsg."groupId"
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    ON uguo."userOrganizationId" = uo.id AND uo."isDisabled" IS FALSE
                WHERE asrs.id = "param_rule_id";
            END IF;
    
            FOR al IN
                SELECT  sq2.wp_id, logs."id" as "logId", 
                        arrsg."groupId", arrsr."regionId", logs."userId",
                        logs."actionUtc" = MIN(logs."actionUtc") OVER ( PARTITION BY logs."userId", logs."actionUtc"::date, sq2.id) as is_first,
                        sq2."useOnlyFirstAccess",
                        (logs."actionUtc"::date + membership_from_date)::timestamp with time zone as mem_start,
                        (logs."actionUtc"::date + membership_to_date)::timestamp with time zone as mem_end
                FROM
                (
                    SELECT
                        id,
                        sq.wp_id,
                        sq."useOnlyFirstAccess",
                        sq."supportMobileCheckin",
                        sq."supportManualLog",
                        sq."startDateTime",
                        sq."endDateTime",
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_from->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_from->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_from->'minutes')::integer, 0)) as from_time,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_to->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_to->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_to->'minutes')::integer, 0)) as to_time,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_membership_from->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_membership_from->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_membership_from->'minutes')::integer, 0)) as membership_from_date,
                        '00:00:00'::interval
                            + (INTERVAL '1 days' * COALESCE((_membership_to->'days')::integer, 0))
                            + (INTERVAL '1 hours' * COALESCE((_membership_to->'hours')::integer, 0))
                            + (INTERVAL '1 minutes' * COALESCE((_membership_to->'minutes')::integer, 0)) as membership_to_date
                    FROM
                    (
                        SELECT
                            arrs.id,
                            "useOnlyFirstAccess",
                            "supportMobileCheckin",
                            "supportManualLog",
                            "startDateTime",
                            "endDateTime",
                            (rrr->>'workPlanId')::uuid as wp_id,
                            rrr->'checkRange'->'from' as _from,
                            rrr->'checkRange'->'to' as _to,
                            rrr->'membershipRange'->'from' as _membership_from,
                            rrr->'membershipRange'->'to' as _membership_to
                        FROM "___ORGANIZATION_ID___"."auto_shift_rule_set" arrs, unnest(rules) as rrr
                        WHERE ((id = "param_rule_id" OR "param_rule_id" IS NULL) AND (arrs."deletedAt" IS NULL))
                    ) sq
                ) sq2
                INNER JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_group" arrsg
                    ON arrsg."ruleSetId" = sq2.id
                LEFT JOIN "___ORGANIZATION_ID___"."auto_shift_rule_set_region" arrsr
                    ON arrsr."ruleSetId" = sq2.id
                INNER JOIN (
                    SELECT
                        alo.id,
                        (alo.log->>'o')::uuid as "userId",
                        alo."actionUtc",
                        alo.log->>'a' = '06ba5170-d827-4ced-b356-f2e99afd3971' as "isMobileCheckin",
                        alo.log->>'rm' as "logMethod",
                        (alo.log->>'ir')::boolean as "isRemote",
                        alo.log->>'cid' IS NOT NULL as "isDevice",
                        (alo.log->>'iq')::boolean as "isQrTriggered",
                        array_agg((rg->>'i')::uuid) FILTER (WHERE rg->>'i' IS NOT NULL) as regions
                    FROM "___ORGANIZATION_ID___".access_logs AS alo
                    LEFT JOIN jsonb_array_elements(COALESCE(alo.log->>'rg', '[]')::jsonb) rg
                        ON 1=1
                    WHERE   alo.log->>'d' = '1'
                            AND "start_date" < alo."actionUtc" 
                            AND (alo."actionUtc" < "end_date" OR "end_date" IS NULL) 
                            AND ( (alo.log->>'o')::uuid = "param_user_id" OR (alo.log->>'o')::uuid = ANY(users_to_be_assigned))
                    GROUP BY alo.id, alo.log->>'o', alo."actionUtc"
                ) logs
                    ON
                        sq2.from_time <= (logs."actionUtc")::time AND (logs."actionUtc")::time < sq2.to_time
                        AND ("param_user_id" IS NULL OR (logs."actionUtc" >= sq2."startDateTime" AND (logs."actionUtc" <= sq2."endDateTime" OR sq2."endDateTime" IS NULL)))
                        AND (
                            (logs."logMethod" = '5' AND sq2."supportManualLog")
                            OR (logs."logMethod" = '4' AND ( sq2."supportMobileCheckin" OR NOT logs."isMobileCheckin"))
                            OR (logs."isRemote" IS NULL AND (NOT logs."isDevice" OR arrsr."regionId" = ANY(logs.regions)))
                            OR (logs."isRemote" AND logs."isQrTriggered" AND arrsr."regionId" = ANY(logs.regions))
                        )
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                    ON uo."userId" = logs."userId"
                INNER JOIN "___ORGANIZATION_ID___"."userGroupUserOrganizations" AS uguo
                    ON uguo."userOrganizationId" = uo.id AND uguo."userGroupId" = arrsg."groupId"
                WHERE   (logs."actionUtc" <= uguo."deletedAt" OR uguo."deletedAt" IS NULL) 
                        AND logs."actionUtc" >= uguo."createdAt" 
                        AND uo."deletedAt" IS NULL
                ORDER BY logs."userId", logs."actionUtc" ASC
            LOOP 
                IF ( (log_id = al."logId" OR log_id IS NULL) AND (NOT al."useOnlyFirstAccess" OR al.is_first) )  THEN
                        at_now :=clock_timestamp();
                        SELECT * into exclusive_lock
                        FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                        WHERE al."userId" = uwp."userId" FOR UPDATE;
    
                        SELECT CASE 
                                    WHEN al."userId" = ANY(users_to_be_updated) THEN users_to_be_updated
                                    ELSE ARRAY_APPEND(users_to_be_updated, al."userId") 
                                END users into users_to_be_updated;
                        
                        INSERT INTO "___ORGANIZATION_ID___"."userWorkPlans"
                        (id, "userId", "workPlanId", "startDateTime", "endDateTime", "createdAt")
                        SELECT gen_random_uuid(), al."userId", subbed_tbl."workPlanId", LOWER(subbed_tbl.subbed), UPPER(subbed_tbl.subbed), at_now
                        FROM (
                            SELECT uwp."workPlanId", tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(al.mem_start, null) as subbed
                            FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                            WHERE uwp."userId" = al."userId" AND tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(al.mem_start, al.mem_end)
                            UNION ALL
                            SELECT uwp."workPlanId", tstzrange(uwp."startDateTime", uwp."endDateTime") - tstzrange(null, al.mem_end) as subbed
                            FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                            WHERE uwp."userId" = al."userId" AND tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(al.mem_start, al.mem_end)
                        ) subbed_tbl
                        WHERE NOT isEmpty(subbed_tbl.subbed)
                        UNION ALL
                        SELECT gen_random_uuid(), al."userId", al.wp_id, al.mem_start, al.mem_end, at_now;
    
                        DELETE FROM  "___ORGANIZATION_ID___"."userWorkPlans"
                        WHERE "userId" = al."userId"
                        AND tstzrange("startDateTime", "endDateTime") && tstzrange(al.mem_start, al.mem_end)
                        AND "createdAt" <> at_now;
                END IF;
            END LOOP;
            INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT gen_random_uuid(), u, '___ORGANIZATION_ID___', 32, start_date
                FROM unnest(users_to_be_updated) u;
            UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld
                SET "updateRequiredReason" = "updateRequiredReason" | 32, "updateRequiredRaisedAt" = now()
                WHERE eld."userId" = ANY(users_to_be_updated);
        END;
    $function$
    ;
        `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, assignAutoShiftDbFunction, "___ORGANIZATION_ID___");
}
exports.down = down;
