"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const restapi_1 = require("../../../../lib/es/models/restapi");
const dal_utils_1 = require("../../../dal.utils");
const app_enums_1 = require("../../../../app.enums");
async function up(client) {
    let query = `

    UPDATE "___ORGANIZATION_ID___".organizations
    SET settings = jsonb_set(settings,'{multiFactorAuthenticationSettings}', '{"option":${app_enums_1.enums.MultifactorAuthenticationOption.DISABLE}}');

    ALTER TABLE "___ORGANIZATION_ID___"."userProfiles"
    ADD COLUMN "mfaSettings" jsonb;

    UPDATE "___ORGANIZATION_ID___"."userProfiles"
    SET "mfaSettings" = '{"enabledStatus":false}';

    ALTER TABLE "___ORGANIZATION_ID___"."userProfiles"
    ALTER COLUMN "mfaSettings" SET NOT NULL;

    INSERT INTO "___ORGANIZATION_ID___"."notification"(
      id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification")
      VALUES (gen_random_uuid(), now(), NULL, ${restapi_1.NotificationType.SendingVerificationToken}, NULL, NULL, true, true, false, false);

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;
        
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
    ADD CONSTRAINT notification_unsubscribe_type_check 
    CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,999}'::smallint[]));

    UPDATE "___ORGANIZATION_ID___".organizations
    SET settings = jsonb_set(
      settings,
      '{notification, enabledTypes}',
      (settings->'notification'->'enabledTypes' || to_jsonb(ARRAY[51])),
      false
    )
    WHERE NOT settings->'notification'->'enabledTypes' @> '51'; 
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client) {
    let query = `
    UPDATE "___ORGANIZATION_ID___".organizations
    SET settings = settings - 'multiFactorAuthenticationSettings';
    
    ALTER TABLE "___ORGANIZATION_ID___"."userProfiles"
    DROP COLUMN "mfaSettings";

    DELETE FROM "___ORGANIZATION_ID___"."notification"
    WHERE type = ${restapi_1.NotificationType.SendingVerificationToken};

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe DROP CONSTRAINT IF EXISTS notification_unsubscribe_type_check;

    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___".notification_unsubscribe
    ADD CONSTRAINT notification_unsubscribe_type_check 
    CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,999}'::smallint[]));

    UPDATE "___ORGANIZATION_ID___"."organizations"
    SET settings = jsonb_set(settings, '{notification,enabledTypes}', (
      SELECT jsonb_agg(elem)
      FROM jsonb_array_elements(settings->'notification'->'enabledTypes') AS elem
      WHERE elem::text::integer <> 51
    ))
    WHERE settings->'notification'->'enabledTypes' @> '51';
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
