"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const enerjisaOrgId = "cf1a899a-bb3f-4379-9b25-4c6d7a89a80f";
    const organizationList = await client.query(`
            SELECT id FROM "public"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
        `);
    const isEnerjisaSchemaExists = organizationList.rows.some((org) => org.id === enerjisaOrgId);
    if (isEnerjisaSchemaExists) {
        const userProfiles = await client.query(`
            SELECT id, "extensionFields", "userOrganizationId" FROM "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}"
        `);
        let bYakaId = "";
        let mYakaId = "";
        const bYaka = await client.query(`
            SELECT id FROM "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}" WHERE "name" = 'BYAKA';
        `);
        if (bYaka.rows.length > 0 && bYaka.rows[0].id) {
            bYakaId = bYaka.rows[0].id;
        }
        else {
            bYakaId = (await client.query(`INSERT INTO "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}" (id, "createdAt", "updatedAt", "organizationId", "name", "colorCode")
                 SELECT uuid_generate_v4(), now(), now(), '${enerjisaOrgId}', 'BYAKA', '${getRandomColor()}'
                RETURNING id;`)).rows[0].id;
        }
        const mYaka = await client.query(`
            SELECT id FROM "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}" WHERE "name" = 'MYAKA';
        `);
        if (mYaka.rows.length > 0 && mYaka.rows[0].id) {
            mYakaId = mYaka.rows[0].id;
        }
        else {
            mYakaId = (await client.query(`INSERT INTO "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroups}" (id, "createdAt", "updatedAt", "organizationId", "name", "colorCode")
                 SELECT uuid_generate_v4(), now(), now(), '${enerjisaOrgId}', 'MYAKA', '${getRandomColor()}'
                RETURNING id;`)).rows[0].id;
        }
        let insertUserGroupQ = "";
        userProfiles.rows.forEach((user) => {
            if (user.extensionFields?.org_employeetype === "BYAKA") {
                insertUserGroupQ += ` INSERT INTO "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}" (id, "createdAt", "updatedAt", "userOrganizationId", "userGroupId") 
                                    SELECT uuid_generate_v4(), now(), now(), '${user.userOrganizationId}', '${bYakaId}'
                                    ON CONFLICT ("userOrganizationId", "userGroupId") WHERE "deletedAt" IS NULL DO NOTHING;`;
            }
            else if (user.extensionFields?.org_employeetype === "MYAKA") {
                insertUserGroupQ += ` INSERT INTO "${enerjisaOrgId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}" (id, "createdAt", "updatedAt", "userOrganizationId", "userGroupId") 
                                    SELECT uuid_generate_v4(), now(), now(), '${user.userOrganizationId}', '${mYakaId}'
                                    ON CONFLICT ("userOrganizationId", "userGroupId") WHERE "deletedAt" IS NULL DO NOTHING;`;
            }
        });
        await client.query(insertUserGroupQ);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
const getRandomColor = () => {
    const letters = "0123456789ABCDEF";
    let color = "";
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
};
