"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    await client.query(`
	CREATE OR REPLACE FUNCTION public.select_pacs_recalculate_task() RETURNS TABLE("organizationId" text, "id" uuid, "userId" uuid, "startDate" date)
    LANGUAGE plpgsql
    AS $$
    DECLARE
    	var_r record;
    BEGIN
        FOR var_r IN( SELECT ol."id" FROM public."organizationList" ol )
        LOOP
            RETURN QUERY EXECUTE 'SELECT ''' || var_r.id || ''', rwq."id", rwq."userId", rwq."startDate" FROM "' || var_r.id::text || '"."recalculateWorkQueue" rwq';
        END LOOP;
    END;
    $$;`);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await client.query(`DROP FUNCTION IF EXISTS public.select_pacs_recalculate_task;`);
}
exports.down = down;
