"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
        CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".access_logs_arvento (
            id uuid NOT NULL DEFAULT gen_random_uuid(),
            "accessLogId" uuid NOT NULL,
            "actionUtc" timestamptz NOT NULL,
            "updatedAt" timestamptz NOT NULL DEFAULT now(),
            type int NOT NULL,
            "isSynchronized" boolean NOT NULL DEFAULT false,
            "accessControlPointId" uuid NOT NULL,
            data jsonb,
            CONSTRAINT access_logs_arvento_pkey PRIMARY KEY (id),
            CONSTRAINT access_logs_arvento_accesslogid_fkey FOREIGN KEY ("accessLogId", "actionUtc")
                REFERENCES "___ORGANIZATION_ID___".access_logs (id, "actionUtc") ON DELETE CASCADE
        );

        ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
            ADD COLUMN "arventoIntegrationEnabled" boolean NOT NULL DEFAULT false;

        ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
            ADD COLUMN "arventoConfiguration" jsonb;

        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".insert_into_access_logs_arvento()
        RETURNS TRIGGER AS $$
        DECLARE
            access_control_point_id uuid;
        BEGIN
            SELECT "id" INTO access_control_point_id
            FROM "___ORGANIZATION_ID___"."accessControlPoints"
            WHERE "id" = (NEW."log"->>'a')::uuid
              AND "arventoIntegrationEnabled" = true;

            IF access_control_point_id IS NOT NULL THEN
                INSERT INTO "___ORGANIZATION_ID___".access_logs_arvento (
                    "accessLogId",
                    "actionUtc",
                    "updatedAt",
                    "type",
                    "isSynchronized",
                    "accessControlPointId",
                    "data"
                )
                VALUES (
                    NEW."id",
                    NEW."actionUtc",
                    NEW."actionUtc",
                    2,
                    false,
                    access_control_point_id,
                    NULL
                );
            END IF;

            RETURN NEW;
        END;
        $$ LANGUAGE plpgsql;

        CREATE TRIGGER trigger_insert_into_access_logs_arvento
        AFTER INSERT ON "___ORGANIZATION_ID___".access_logs
        FOR EACH ROW
        EXECUTE FUNCTION "___ORGANIZATION_ID___".insert_into_access_logs_arvento();
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        DROP TRIGGER IF EXISTS trigger_insert_into_access_logs_arvento 
        ON "___ORGANIZATION_ID___".access_logs;

        DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".insert_into_access_logs_arvento();

        ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
            DROP COLUMN IF EXISTS "arventoIntegrationEnabled";

        ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
            DROP COLUMN IF EXISTS "arventoConfiguration";

        DROP TABLE IF EXISTS "___ORGANIZATION_ID___".access_logs_arvento;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
