"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const publicQuery = `
		CREATE TABLE "___ORGANIZATION_ID___"."integrationClients" (
			"id" uuid NOT NULL,
			"clientSecret" varchar(255) NOT NULL,
			"validUntil" timestamp with time zone,
			"createdAt" timestamp with time zone
		);

		ALTER TABLE "___ORGANIZATION_ID___"."integration_ops"
			ADD COLUMN IF NOT EXISTS "clientId" uuid;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, publicQuery, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const publicQuery = `
		DROP TABLE "___ORGANIZATION_ID___"."integrationClients";

		ALTER TABLE "___ORGANIZATION_ID___"."integration_ops"
		DROP COLUMN IF EXISTS "clientId";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, publicQuery, "___ORGANIZATION_ID___");
}
exports.down = down;
