"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
		CREATE TABLE "___ORGANIZATION_ID___"."check_in_tablet" (
			"id" uuid NOT NULL,
			"creationT" timestamp with time zone NOT NULL,
			name varchar(255) NULL,
			"publicKey" varchar(1024) NOT NULL UNIQUE,
			"referenceCode" varchar(15) NOT NULL UNIQUE,
			"approvementCode" varchar(15) NOT NULL UNIQUE,
			"isApproved" boolean DEFAULT FALSE,
			CONSTRAINT "check_in_tablet_pkey" PRIMARY KEY (id)
		);
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
		DROP TABLE "___ORGANIZATION_ID___"."check_in_tablet";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
